/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.LocalFileUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.collect.collector.AbstractPriorityDataCollector;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.Hyperlinks;
import ai.platon.pulsar.common.urls.UrlAware;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010*\u001a\u00020\b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\b\u0010-\u001a\u00020\u0000H\u0002J\b\u0010.\u001a\u00020/H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lai/platon/pulsar/common/collect/LocalFileHyperlinkCollector;", "Lai/platon/pulsar/common/collect/collector/AbstractPriorityDataCollector;", "Lai/platon/pulsar/common/urls/UrlAware;", "path", "Ljava/nio/file/Path;", "priority", "Lai/platon/pulsar/common/Priority13;", "(Ljava/nio/file/Path;Lai/platon/pulsar/common/Priority13;)V", "", "(Ljava/nio/file/Path;I)V", "cache", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "capacity", "getCapacity", "()I", "fileName", "", "getFileName", "()Ljava/lang/String;", "hyperlinks", "", "getHyperlinks", "()Ljava/util/List;", "isLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "loadArgs", "getLoadArgs", "setLoadArgs", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "getName", "setName", "getPath", "()Ljava/nio/file/Path;", "size", "getSize", "urlLoader", "Lai/platon/pulsar/common/collect/LocalFileUrlLoader;", "collectTo", "sink", "dump", "ensureLoaded", "hasMore", "", "pulsar-skeleton"})
public class LocalFileHyperlinkCollector
extends AbstractPriorityDataCollector<UrlAware> {
    @NotNull
    private final Path path;
    private final Logger log;
    @NotNull
    private final LocalFileUrlLoader urlLoader;
    @NotNull
    private final AtomicBoolean isLoaded;
    @NotNull
    private final List<Hyperlink> cache;
    private final int capacity;
    @NotNull
    private String name;
    @NotNull
    private final String fileName;
    @Nullable
    private String loadArgs;

    public LocalFileHyperlinkCollector(@NotNull Path path, int priority) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(priority);
        this.path = path;
        this.log = LoggerFactory.getLogger(LocalFileHyperlinkCollector.class);
        this.urlLoader = new LocalFileUrlLoader(this.path);
        this.isLoaded = new AtomicBoolean();
        List list = Collections.synchronizedList(new LinkedList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(LinkedList())");
        this.cache = list;
        this.capacity = 1000000;
        this.name = ((Object)this.path.getFileName()).toString();
        this.fileName = ((Object)this.path.getFileName()).toString();
    }

    public /* synthetic */ LocalFileHyperlinkCollector(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Priority13.NORMAL.getValue();
        }
        this(path, n);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final String getLoadArgs() {
        return this.loadArgs;
    }

    public final void setLoadArgs(@Nullable String string) {
        this.loadArgs = string;
    }

    @NotNull
    public final List<Hyperlink> getHyperlinks() {
        return this.ensureLoaded().cache;
    }

    public int getSize() {
        return this.getHyperlinks().size();
    }

    public LocalFileHyperlinkCollector(@NotNull Path path, @NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        this(path, priority.getValue());
    }

    public boolean hasMore() {
        Collection collection = this.getHyperlinks();
        boolean bl = false;
        return !collection.isEmpty();
    }

    public int collectTo(@NotNull List<UrlAware> sink) {
        int n;
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.beforeCollect();
        Hyperlink hyperlink = (Hyperlink)CollectionsKt.removeFirstOrNull(this.cache);
        if (hyperlink == null) {
            n = 0;
        } else {
            Hyperlink hyperlink2;
            Hyperlink hyperlink3 = hyperlink;
            boolean bl = false;
            boolean bl2 = false;
            Hyperlink it = hyperlink3;
            boolean bl3 = false;
            Object object = hyperlink2 = sink.add((UrlAware)it) ? hyperlink3 : null;
            if (hyperlink2 == null) {
                n = 0;
            } else {
                int n2;
                Hyperlink hyperlink4 = hyperlink2;
                bl2 = false;
                boolean bl4 = false;
                Hyperlink it2 = hyperlink4;
                boolean bl5 = false;
                n = n2 = 1;
            }
        }
        int count = n;
        return this.afterCollect(count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized List<String> dump() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getHyperlinks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hyperlink hyperlink = (Hyperlink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final LocalFileHyperlinkCollector ensureLoaded() {
        if (this.isLoaded.compareAndSet(false, true)) {
            int remainingCapacity = this.getCapacity() - this.cache.size();
            UrlTopic group = new UrlTopic("", 0, this.getPriority(), this.getCapacity());
            this.urlLoader.loadToNow((Collection)this.cache, remainingCapacity, group, (Function1)new Function1<UrlAware, Hyperlink>(this){
                final /* synthetic */ LocalFileHyperlinkCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Hyperlink invoke(@NotNull UrlAware it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String args = LoadOptions.Companion.merge(it.getArgs(), this.this$0.getLoadArgs(), VolatileConfig.Companion.getUNSAFE()).toString();
                    Hyperlink hyperlink = Hyperlinks.INSTANCE.toHyperlink(it);
                    boolean bl = false;
                    boolean bl2 = false;
                    Hyperlink it2 = hyperlink;
                    boolean bl3 = false;
                    it2.setArgs(args);
                    return hyperlink;
                }
            });
            String msg = this.loadArgs != null ? " | " + this.loadArgs + " " : "";
            this.log.info("Loaded total {} urls from file | " + msg + "{}", (Object)this.cache.size(), (Object)this.path);
        }
        return this;
    }
}

