/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.PriorityDataCollectorFormatterBase;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.ql.ResultSets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/collect/PriorityDataCollectorFormatterBase;", "T", "", "()V", "addRow", "", "c", "Lai/platon/pulsar/common/collect/collector/PriorityDataCollector;", "rs", "Lorg/h2/tools/SimpleResultSet;", "newResultSet", "pulsar-skeleton"})
public abstract class PriorityDataCollectorFormatterBase<T> {
    @NotNull
    public final SimpleResultSet newResultSet() {
        String[] stringArray = new String[]{"name", "priority", "pName", "collected", "cd/s", "collect", "c/s", "time", "size", "estSize", "firstCollect", "lastCollect", "labels"};
        SimpleResultSet simpleResultSet = ResultSets.newSimpleResultSet((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simpleResultSet, (String)"newSimpleResultSet(\n    \u2026lect\", \"labels\"\n        )");
        return simpleResultSet;
    }

    public final void addRow(@NotNull PriorityDataCollector<T> c, @NotNull SimpleResultSet rs) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        String dtFormatter = "dd HH:mm:ss";
        LocalDateTime firstCollectTime = c.getFirstCollectTime().atZone(DateTimes.INSTANCE.getZoneId()).toLocalDateTime();
        LocalDateTime lastCollectedTime = c.getLastCollectedTime().atZone(DateTimes.INSTANCE.getZoneId()).toLocalDateTime();
        Duration elapsedTime = c.getLastCollectedTime().compareTo(c.getFirstCollectTime()) > 0 ? Duration.between(c.getFirstCollectTime(), c.getLastCollectedTime()) : Duration.ZERO;
        long elapsedSeconds = RangesKt.coerceAtLeast((long)elapsedTime.getSeconds(), (long)1L);
        Priority13 priority13 = Priority13.Companion.valueOfOrNull(c.getPriority());
        String priorityName = priority13 == null ? "" : ((objectArray = priority13.name()) == null ? "" : objectArray);
        Object[] labels2 = CollectionsKt.joinToString$default((Iterable)c.getLabels(), null, null, null, (int)0, null, (Function1)addRow.labels.1.INSTANCE, (int)31, null);
        if (labels2.length() > 16) {
            objectArray = StringUtils.abbreviateMiddle((String)labels2, (String)"..", (int)16);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"abbreviateMiddle(labels, \"..\", 16)");
            labels2 = objectArray;
        }
        objectArray = new Object[13];
        objectArray[0] = c.getName();
        objectArray[1] = c.getPriority();
        objectArray[2] = priorityName;
        objectArray[3] = c.getCollectedCount();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.2f";
        Object[] objectArray2 = new Object[]{1.0 * (double)c.getCollectedCount() / (double)elapsedSeconds};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        objectArray[5] = c.getCollectCount();
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string = "%.2f";
        objectArray2 = new Object[]{1.0 * (double)c.getCollectCount() / (double)elapsedSeconds};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        Intrinsics.checkNotNullExpressionValue((Object)elapsedTime, (String)"elapsedTime");
        objectArray[7] = DateTimesKt.readable((Duration)elapsedTime);
        objectArray[8] = c.getSize();
        objectArray[9] = c.getEstimatedSize();
        Intrinsics.checkNotNullExpressionValue((Object)firstCollectTime, (String)"firstCollectTime");
        objectArray[10] = DateTimes.INSTANCE.format(firstCollectTime, dtFormatter);
        Intrinsics.checkNotNullExpressionValue((Object)lastCollectedTime, (String)"lastCollectedTime");
        objectArray[11] = DateTimes.INSTANCE.format(lastCollectedTime, dtFormatter);
        objectArray[12] = labels2;
        rs.addRow(objectArray);
    }
}

