/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.domain;

import ai.platon.pulsar.common.domain.DomainSuffix;
import ai.platon.pulsar.common.domain.DomainSuffixesReader;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainSuffixes {
    private static final Logger LOG = LoggerFactory.getLogger(DomainSuffixes.class);
    public static String DOMAIN_SUFFIXES_FILE = "domain-suffixes.xml";
    private static DomainSuffixes instance;
    private Map<String, DomainSuffix> domains = new ConcurrentHashMap<String, DomainSuffix>();

    private DomainSuffixes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainSuffixes getInstance() {
        if (instance != null) return instance;
        Class<DomainSuffixes> clazz = DomainSuffixes.class;
        synchronized (DomainSuffixes.class) {
            if (instance != null) return instance;
            instance = DomainSuffixes.load(DOMAIN_SUFFIXES_FILE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static DomainSuffixes load(String resource) {
        DomainSuffixes suffixes = null;
        LOG.info("Loading domain suffixes from resource " + resource);
        try (InputStream input = DomainSuffixes.class.getClassLoader().getResourceAsStream(resource);){
            if (input == null) {
                LOG.error("Failed to load resource " + resource);
            } else {
                suffixes = new DomainSuffixesReader().read(new DomainSuffixes(), input);
                LOG.info("Total {} known domains", (Object)suffixes.domains.size());
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
        }
        return suffixes;
    }

    void addDomainSuffix(DomainSuffix tld) {
        this.domains.put(tld.getDomain(), tld);
    }

    public boolean isDomainSuffix(String extension) {
        return this.domains.containsKey(extension);
    }

    public DomainSuffix get(String extension) {
        return this.domains.get(extension);
    }
}

