/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.files.ext;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Name;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a8\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0006\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u001a8\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"export", "Ljava/nio/file/Path;", "Lai/platon/pulsar/common/AppFiles;", "status", "Lai/platon/pulsar/persist/ProtocolStatus;", "content", "", "page", "Lai/platon/pulsar/persist/WebPage;", "", "prefix", "suffix", "group", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "doc", "Lorg/jsoup/nodes/Document;", "ident", "pulsar-skeleton"})
public final class AppFilesExtKt {
    @NotNull
    public static final Path export(@NotNull AppFiles $this$export, @NotNull ProtocolStatus status, @NotNull String content, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return AppFilesExtKt.export$default(AppFiles.INSTANCE, new StringBuilder(), status, content, page, null, 16, null);
    }

    @NotNull
    public static final Path export(@NotNull AppFiles $this$export, @NotNull StringBuilder sb, @NotNull ProtocolStatus status, @NotNull String content, @NotNull WebPage page, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String monthDay = DateTimes.INSTANCE.now("MMdd");
        String string = page.getBaseUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.baseUrl");
        FeaturedDocument document = Documents.INSTANCE.parse(content, string);
        document.absoluteLinks();
        String prettyHtml = document.getPrettyHtml();
        int length = prettyHtml.length();
        sb.setLength(0);
        sb.append(status.getMinorName()).append('/').append(monthDay);
        if (length < 2000) {
            sb.append("/a").append(length / 500 * 500);
        } else {
            sb.append("/b").append(length / 20000 * 20000);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        String fileNameIdent = string2;
        String string3 = prettyHtml;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Path path = AppFilesExtKt.export($this$export, page, byArray, fileNameIdent, suffix, "default");
        page.getMetadata().set(Name.ORIGINAL_EXPORT_PATH, ((Object)path).toString());
        page.setVar(Name.ORIGINAL_EXPORT_PATH.name(), (Object)path);
        return path;
    }

    public static /* synthetic */ Path export$default(AppFiles appFiles, StringBuilder stringBuilder, ProtocolStatus protocolStatus, String string, WebPage webPage, String string2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = ".htm";
        }
        return AppFilesExtKt.export(appFiles, stringBuilder, protocolStatus, string, webPage, string2);
    }

    @NotNull
    public static final Path export(@NotNull AppFiles $this$export, @NotNull WebPage page, @NotNull byte[] content, @NotNull String prefix, @NotNull String suffix, @NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        String string = page.getLastBrowser().name();
        Object object = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefault()");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase((Locale)object);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String browser = string3;
        object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        String filename = AppPaths.INSTANCE.fromUri((String)object, prefix, suffix);
        Path path = AppPaths.INSTANCE.getWEB_CACHE_DIR().resolve(group).resolve(browser).resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        $this$export.saveTo(content, path, true);
        return path;
    }

    public static /* synthetic */ Path export$default(AppFiles appFiles, WebPage webPage, byte[] byArray, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            string2 = ".htm";
        }
        if ((n & 0x10) != 0) {
            string3 = "default";
        }
        return AppFilesExtKt.export(appFiles, webPage, byArray, string, string2, string3);
    }

    @NotNull
    public static final Path export(@NotNull AppFiles $this$export, @NotNull WebPage page, @NotNull String prefix, @NotNull String suffix) {
        Object object;
        String string;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String string2 = page.getHeaders().getDecodedDispositionFilename();
        if (string2 == null) {
            object2 = page.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.location");
            string = AppPaths.INSTANCE.fromUri((String)object2, prefix, suffix);
        } else {
            string = string2;
        }
        String filename = string;
        Path path = AppPaths.INSTANCE.getWEB_CACHE_DIR().resolve(filename);
        Files.deleteIfExists(path);
        Object object3 = page.getContent();
        object2 = object3 == null ? null : ((ByteBuffer)object3).array();
        if (object2 == null) {
            object3 = "(empty)";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object3).getBytes(charset);
            object = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            object = object2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        AppFiles.saveTo$default((AppFiles)$this$export, (byte[])object, (Path)path, (boolean)false, (int)4, null);
        return path;
    }

    public static /* synthetic */ Path export$default(AppFiles appFiles, WebPage webPage, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = ".htm";
        }
        return AppFilesExtKt.export(appFiles, webPage, string, string2);
    }

    @NotNull
    public static final Path export(@NotNull AppFiles $this$export, @NotNull Document doc, @NotNull String ident) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        String string = doc.baseUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.baseUri()");
        String filename = AppPaths.INSTANCE.fromUri(string, "", ".htm");
        Path path = AppPaths.INSTANCE.getWEB_CACHE_DIR().resolve(ident).resolve(filename);
        String string2 = doc.outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"doc.outerHtml()");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return AppFiles.saveTo$default((AppFiles)$this$export, (String)string2, (Path)path, (boolean)false, (int)4, null);
    }

    public static /* synthetic */ Path export$default(AppFiles appFiles, Document document, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return AppFilesExtKt.export(appFiles, document, string);
    }
}

