/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.message;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.PageCategory;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00100\u001a\u00020-H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u0014\u0010$\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u001c\u0010&\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0014\u0010(\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0014\u0010*\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\bR\u0014\u0010,\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00062"}, d2={"Lai/platon/pulsar/common/message/FetchStatusFormatter;", "", "page", "Lai/platon/pulsar/persist/WebPage;", "(Lai/platon/pulsar/persist/WebPage;)V", "cash", "", "getCash", "()D", "contentPublishTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getContentPublishTime", "()Ljava/time/Instant;", "contentScore", "getContentScore", "distance", "", "getDistance", "()I", "fetchCount", "getFetchCount", "fetchInterval", "Ljava/time/Duration;", "getFetchInterval", "()Ljava/time/Duration;", "fetchTime", "getFetchTime", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "pageCategory", "Lai/platon/pulsar/persist/metadata/PageCategory;", "getPageCategory", "()Lai/platon/pulsar/persist/metadata/PageCategory;", "prevFetchTime", "getPrevFetchTime", "refChars", "getRefChars", "refContentPublishTime", "getRefContentPublishTime", "refItems", "getRefItems", "score", "getScore", "url", "", "getUrl", "()Ljava/lang/String;", "toString", "Companion", "pulsar-skeleton"})
public final class FetchStatusFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebPage page;
    @NotNull
    private static final DecimalFormat df = new DecimalFormat("0.0");

    public FetchStatusFormatter(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.page = page;
    }

    @NotNull
    public final WebPage getPage() {
        return this.page;
    }

    private final Instant getPrevFetchTime() {
        Instant instant = this.page.getPrevFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.prevFetchTime");
        return instant;
    }

    private final Instant getFetchTime() {
        Instant instant = this.page.getFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.fetchTime");
        return instant;
    }

    private final Duration getFetchInterval() {
        Duration duration = this.page.getFetchInterval();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"page.fetchInterval");
        return duration;
    }

    private final int getDistance() {
        return this.page.getDistance();
    }

    private final int getFetchCount() {
        return this.page.getFetchCount();
    }

    private final Instant getContentPublishTime() {
        return this.page.getContentPublishTime();
    }

    private final Instant getRefContentPublishTime() {
        return this.page.getRefContentPublishTime();
    }

    private final PageCategory getPageCategory() {
        PageCategory pageCategory = this.page.getPageCategory();
        Intrinsics.checkNotNullExpressionValue((Object)pageCategory, (String)"page.pageCategory");
        return pageCategory;
    }

    private final int getRefItems() {
        return this.page.getPageCounters().get((Enum)PageCounters.Ref.item);
    }

    private final int getRefChars() {
        return this.page.getPageCounters().get((Enum)PageCounters.Ref.ch);
    }

    private final double getContentScore() {
        return this.page.getContentScore();
    }

    private final double getScore() {
        return this.page.getScore();
    }

    private final double getCash() {
        return this.page.getCash();
    }

    private final String getUrl() {
        String string = this.page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        return string;
    }

    @NotNull
    public String toString() {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        String fetchTimeString = DateTimes.INSTANCE.format(this.getPrevFetchTime(), pattern) + "->" + DateTimes.INSTANCE.format(this.getFetchTime(), pattern) + "," + DurationFormatUtils.formatDuration((long)this.getFetchInterval().toMillis(), (String)"DdTH:mm:ss");
        Object object = new Object[10];
        object[0] = "DC";
        object[1] = this.getDistance() + "," + this.getFetchCount();
        object[2] = "PT";
        Instant instant = this.getContentPublishTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"contentPublishTime");
        String string = DateTimes.isoInstantFormat((Instant)instant);
        instant = this.getRefContentPublishTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"refContentPublishTime");
        object[3] = string + "," + DateTimes.isoInstantFormat((Instant)instant);
        object[4] = "C";
        object[5] = this.getRefItems() + "," + this.getRefChars();
        object[6] = "S";
        object[7] = df.format(this.getContentScore()) + "," + df.format(this.getScore()) + "," + df.format(this.getCash());
        object[8] = this.getPageCategory().symbol();
        object[9] = StringUtils.substring((String)this.getUrl(), (int)0, (int)80);
        Params params = Params.of((String)"T", (Object)fetchTimeString, (Object[])object).withKVDelimiter(":");
        object = params.formatAsLine();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"params.formatAsLine()");
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/common/message/FetchStatusFormatter$Companion;", "", "()V", "df", "Ljava/text/DecimalFormat;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

