/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.message;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.CheckState;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.crawl.common.FetchState;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Name;
import ai.platon.pulsar.persist.model.ActiveDOMStat;
import ai.platon.pulsar.persist.model.PageModel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010U\u001a\u00020\u0005H\u0002J\b\u0010V\u001a\u00020\u0005H\u0002J\b\u0010W\u001a\u00020\u0005H\u0002J\u0010\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020\u0005H\u0016RL\u0010\f\u001a@\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f \u000e*\u001e\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f0\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0014\u0010 \u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0014\u0010\"\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0016\u0010$\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u0014\u0010&\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0013R\u0014\u0010(\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0016\u0010*\u001a\n \u000e*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\n \u000e*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0013R\u0016\u0010-\u001a\u0004\u0018\u00010.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0013R\u0014\u00103\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0013R\u0014\u00105\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0013R\u0014\u00107\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0013R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0013R\u0014\u0010A\u001a\u00020B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001c\u0010E\u001a\n \u000e*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0013R\u0014\u0010G\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013R\u0014\u0010I\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0013R\u0014\u0010K\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0013R\u0014\u0010M\u001a\u00020N8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0014\u0010Q\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u0013R\u000e\u0010S\u001a\u00020TX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lai/platon/pulsar/common/message/LoadStatusFormatter;", "", "page", "Lai/platon/pulsar/persist/WebPage;", "prefix", "", "withOptions", "", "withNormUrl", "withReferer", "withSymbolicLink", "(Lai/platon/pulsar/persist/WebPage;Ljava/lang/String;ZZZZ)V", "activeDOMStatTrace", "", "kotlin.jvm.PlatformType", "Lai/platon/pulsar/persist/model/ActiveDOMStat;", "", "category", "getCategory", "()Ljava/lang/String;", "contextName", "getContextName", "failure", "getFailure", "fetchCount", "getFetchCount", "fetchReason", "getFetchReason", "fieldCount", "getFieldCount", "fieldCountFmt", "getFieldCountFmt", "fmt", "getFmt", "formattedLabel", "getFormattedLabel", "href", "getHref", "jsFmt", "getJsFmt", "jsSate", "getJsSate", "label", "location", "getLocation", "m", "Lai/platon/pulsar/persist/model/PageModel;", "getM", "()Lai/platon/pulsar/persist/model/PageModel;", "prefix0", "getPrefix0", "prefix01", "getPrefix01", "prefix02", "getPrefix02", "prefix1", "getPrefix1", "prevFetchTimeBeforeUpdate", "Ljava/time/Instant;", "prevFetchTimeDuration", "Ljava/time/Duration;", "getPrevFetchTimeDuration", "()Ljava/time/Duration;", "prevFetchTimeReport", "getPrevFetchTimeReport", "protocolStatus", "Lai/platon/pulsar/persist/ProtocolStatus;", "getProtocolStatus", "()Lai/platon/pulsar/persist/ProtocolStatus;", "proxy", "getProxy", "proxyFmt", "getProxyFmt", "responseTime", "getResponseTime", "successSymbol", "getSuccessSymbol", "symbolicLink", "Ljava/nio/file/Path;", "getSymbolicLink", "()Ljava/nio/file/Path;", "url", "getUrl", "verboseCount", "", "buildContentBytes", "buildFetchReason", "buildLocation", "readableBytes", "bytes", "", "toString", "pulsar-skeleton"})
public final class LoadStatusFormatter {
    @NotNull
    private final WebPage page;
    @NotNull
    private final String prefix;
    private final boolean withOptions;
    private final boolean withNormUrl;
    private final boolean withReferer;
    private final boolean withSymbolicLink;
    private final int verboseCount;
    @NotNull
    private final Map<String, ActiveDOMStat> activeDOMStatTrace;
    private final String label;
    @NotNull
    private final Instant prevFetchTimeBeforeUpdate;

    public LoadStatusFormatter(@NotNull WebPage page, @NotNull String prefix, boolean withOptions, boolean withNormUrl, boolean withReferer, boolean withSymbolicLink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.page = page;
        this.prefix = prefix;
        this.withOptions = withOptions;
        this.withNormUrl = withNormUrl;
        this.withReferer = withReferer;
        this.withSymbolicLink = withSymbolicLink;
        this.verboseCount = 200;
        Object object2 = this.page.getActiveDOMStatTrace();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.activeDOMStatTrace");
        this.activeDOMStatTrace = object2;
        this.label = StringUtils.abbreviateMiddle((String)WebPageExKt.getOptions(this.page).getLabel(), (String)"..", (int)20);
        Object object3 = this.page.getVar("prev_fetch_time_before_update");
        Object object4 = object2 = object3 instanceof Instant ? (Instant)object3 : null;
        if (object2 == null) {
            object3 = this.page.getPrevFetchTime();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"page.prevFetchTime");
            object = object3;
        } else {
            object = object2;
        }
        this.prevFetchTimeBeforeUpdate = object;
    }

    public /* synthetic */ LoadStatusFormatter(WebPage webPage, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        this(webPage, string, bl, bl2, bl3, bl4);
    }

    private final String getUrl() {
        String string = this.page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        return string;
    }

    private final String getHref() {
        return this.page.getHref();
    }

    private final String getLocation() {
        return this.page.getLocation();
    }

    private final String getResponseTime() {
        String string = this.page.getMetadata().get(Name.RESPONSE_TIME);
        String string2 = string == null ? "" : string;
        return string2;
    }

    private final String getProxy() {
        return this.page.getProxy();
    }

    private final ProtocolStatus getProtocolStatus() {
        ProtocolStatus protocolStatus = this.page.getProtocolStatus();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"page.protocolStatus");
        return protocolStatus;
    }

    private final PageModel getM() {
        return this.page.getPageModel();
    }

    private final String getJsSate() {
        String string;
        String prefix;
        ActiveDOMStat activeDOMStat = this.activeDOMStatTrace.get("lastStat");
        ActiveDOMStat activeDOMStat2 = activeDOMStat == null ? new ActiveDOMStat(0, 0, 0, 0, 0, 0, 63, null) : activeDOMStat;
        int ni = activeDOMStat2.component1();
        int na = activeDOMStat2.component2();
        int nnm = activeDOMStat2.component3();
        int nst = activeDOMStat2.component4();
        int w = activeDOMStat2.component5();
        int h = activeDOMStat2.component6();
        int divisor = this.page.getId() < this.verboseCount ? 10 : this.verboseCount;
        String string2 = prefix = this.page.getId() % divisor == 0 ? "i/a/nm/st/h:" : "";
        if (ni + na + nnm + nst + h != 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = prefix + "%d/%d/%d/%d/%d";
            Object[] objectArray = new Object[]{ni, na, nnm, nst, h};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        } else {
            string = "";
        }
        return string;
    }

    private final String getFetchReason() {
        return this.buildFetchReason();
    }

    private final String getPrefix01() {
        return this.page.isFetched() && this.page.getFetchCount() == 1 ? "\u26a1" : (this.page.isFetched() ? "\u27f3" : (this.page.isCached() ? "\u2615" : (this.page.isLoaded() ? "\ud83d\uddb4" : "\ud83d\udc1b")));
    }

    private final String getPrefix02() {
        return this.page.isFetched() && this.page.getFetchCount() == 1 ? "New \u26a1" : (this.page.isFetched() ? "Updated \u27f3" : (this.page.isCached() ? "Cached \u2615" : (this.page.isLoaded() ? "Loaded \ud83d\uddb4" : "Unknown \ud83d\udc1b")));
    }

    private final String getPrefix0() {
        return this.page.getId() < this.verboseCount && this.page.getId() % 10 == 0 ? this.getPrefix02() : (this.page.getId() > this.verboseCount && this.page.getId() % this.verboseCount == 0 ? this.getPrefix02() : this.getPrefix01());
    }

    private final String getPrefix1() {
        String string = this.prefix;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string2 = charSequence.length() > 0 ? string : null;
        return string2 == null ? this.getPrefix0() : string2;
    }

    private final String getSuccessSymbol() {
        return this.getProtocolStatus().isSuccess() ? "\ud83d\udcaf " : "\ud83d\udc94 ";
    }

    private final String getFormattedLabel() {
        String string = this.label;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label");
        return StringsKt.isBlank((CharSequence)string) ? "" : " | " + this.label;
    }

    private final String getCategory() {
        return this.page.getPageCategory().symbol();
    }

    private final Duration getPrevFetchTimeDuration() {
        Duration duration = Duration.between(this.prevFetchTimeBeforeUpdate, Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(prevFetchTimeBeforeUpdate, Instant.now())");
        return duration;
    }

    private final String getPrevFetchTimeReport() {
        if (this.getPrevFetchTimeDuration().toDays() > 7200L) {
            return "";
        }
        return " last fetched " + DateTimesKt.readable((Duration)this.getPrevFetchTimeDuration()) + " ago,";
    }

    private final String getFieldCount() {
        String string;
        PageModel model = this.getM();
        if (model == null) {
            string = "";
        } else if (model.getNumFields() == 0) {
            string = "";
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%d/%d/%d";
            Object[] objectArray = new Object[]{model.getNumNonBlankFields(), model.getNumNonNullFields(), model.getNumFields()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private final String getProxyFmt() {
        CharSequence charSequence = this.getProxy();
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "%s" : " | %s";
    }

    private final String getJsFmt() {
        return StringsKt.isBlank((CharSequence)this.getJsSate()) ? "%s" : " | %s";
    }

    private final String getFetchCount() {
        String string;
        if (this.page.getFetchRetries() > 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%d/%d";
            Object[] objectArray = new Object[]{this.page.getFetchRetries(), this.page.getFetchCount()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%d";
            Object[] objectArray = new Object[]{this.page.getFetchCount()};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private final String getFieldCountFmt() {
        PageModel pageModel;
        return this.getM() == null || ((pageModel = this.getM()) == null ? false : pageModel.getNumFields() == 0) ? "%s" : " | nf:%-10s";
    }

    private final String getFailure() {
        String string;
        if (this.page.getProtocolStatus().isFailed()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = " %s";
            Object[] objectArray = new Object[]{this.page.getProtocolStatus()};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            string = "";
        }
        return string;
    }

    private final Path getSymbolicLink() {
        String string = this.page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        return AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)string, null, (int)2, null);
    }

    private final String getContextName() {
        Object object;
        Object object2 = this.page.getVariables().get("privacy_context_name");
        if (object2 == null) {
            object = "";
        } else {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object3;
            boolean bl3 = false;
            String string = " | " + it;
            object = string == null ? "" : string;
        }
        return object;
    }

    private final String getFmt() {
        return "%3d. " + this.getSuccessSymbol() + this.getPrefix1() + " %s " + this.getFetchReason() + " got %d %s in %s," + this.getPrevFetchTimeReport() + " fc:" + this.getFetchCount() + this.getFailure() + this.getJsFmt() + this.getFieldCountFmt() + this.getProxyFmt() + this.getContextName() + this.getFormattedLabel() + " | %s";
    }

    @NotNull
    public String toString() {
        String string;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = this.getFmt();
        Object[] objectArray = new Object[]{this.page.getId(), this.getCategory(), this.page.getProtocolStatus().getMinorCode(), this.buildContentBytes(), DateTimes.INSTANCE.readableDuration(this.getResponseTime()), this.getJsSate(), this.getFieldCount(), (string = this.getProxy()) == null ? "" : string, this.buildLocation()};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    private final String buildFetchReason() {
        Object object;
        int n;
        CheckState state;
        Object object2 = this.page.getVariables().get("fetch_state");
        Object object3 = state = object2 instanceof CheckState ? (CheckState)object2 : null;
        int code = object3 == null ? 0 : (n = object3.getCode());
        Object object4 = FetchState.INSTANCE.toSymbol(code);
        boolean bl = false;
        boolean bl2 = false;
        String it = object4;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        CheckState checkState = object3 = !StringsKt.isBlank((CharSequence)charSequence) ? object4 : null;
        if (object3 == null) {
            object = "";
        } else {
            Object object5 = object3;
            bl2 = false;
            boolean bl5 = false;
            Object it2 = object5;
            boolean bl6 = false;
            object4 = "for " + (String)it2;
            object = object4 == null ? "" : object4;
        }
        return object;
    }

    private final String buildContentBytes() {
        Object contentBytes;
        Object object;
        boolean bl;
        String string;
        if (this.page.getLastContentLength() == 0L || this.page.getLastContentLength() == this.page.getContentLength()) {
            string = this.readableBytes(this.page.getContentLength());
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = this.readableBytes(this.page.getContentLength());
            bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = this.readableBytes(this.page.getLastContentLength());
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = contentBytes = ((Object)StringsKt.trim((CharSequence)string3)).toString() + " <- " + ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        if (this.page.getContent() == null) {
            contentBytes = "0 <- " + (String)contentBytes;
        }
        return contentBytes;
    }

    private final String readableBytes(long bytes) {
        String string;
        if (bytes == 0L) {
            string = "0";
        } else {
            String string2 = Strings.readableBytes((long)bytes, (int)7, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readableBytes(bytes, 7, false)");
            string = string2;
        }
        return string;
    }

    private final String buildLocation() {
        Object object;
        boolean doWithSymbolicLink;
        Object readableLocation;
        Object location;
        String string = this.getHref();
        String expectedLocation = string == null ? this.getUrl() : string;
        boolean redirected = this.getHref() != null && !Intrinsics.areEqual((Object)this.getHref(), (Object)this.getLocation());
        boolean normalized = this.getHref() != null && !Intrinsics.areEqual((Object)this.getHref(), (Object)this.getUrl());
        Object object2 = location = redirected ? this.getLocation() : expectedLocation;
        if (this.withOptions) {
            location = (String)location + " " + this.page.getArgs();
        }
        String readableLocation0 = redirected ? "[R] " + (String)location + " <- " + expectedLocation : location;
        Object object3 = readableLocation = normalized ? "[N] " + readableLocation0 : readableLocation0;
        if (this.withNormUrl) {
            readableLocation = (String)readableLocation + " <- " + this.getUrl();
        }
        if (this.withReferer) {
            readableLocation = (String)readableLocation + " <- " + this.page.getReferrer();
        }
        boolean bl = doWithSymbolicLink = this.page.getId() < this.verboseCount || this.withSymbolicLink;
        if (doWithSymbolicLink) {
            object = "file://" + this.getSymbolicLink() + " | " + (String)readableLocation;
        } else {
            Object object4 = readableLocation;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"readableLocation");
            object = object4;
        }
        return object;
    }
}

