/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.message;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.message.LoadStatusFormatter;
import ai.platon.pulsar.persist.WebPage;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/common/message/LoadedPagesStatusFormatter;", "", "pages", "", "Lai/platon/pulsar/persist/WebPage;", "startTime", "Ljava/time/Instant;", "withSymbolicLink", "", "(Ljava/util/Collection;Ljava/time/Instant;Z)V", "getPages", "()Ljava/util/Collection;", "getStartTime", "()Ljava/time/Instant;", "getWithSymbolicLink", "()Z", "toString", "", "pulsar-skeleton"})
public final class LoadedPagesStatusFormatter {
    @NotNull
    private final Collection<WebPage> pages;
    @NotNull
    private final Instant startTime;
    private final boolean withSymbolicLink;

    public LoadedPagesStatusFormatter(@NotNull Collection<WebPage> pages, @NotNull Instant startTime, boolean withSymbolicLink) {
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.pages = pages;
        this.startTime = startTime;
        this.withSymbolicLink = withSymbolicLink;
    }

    public /* synthetic */ LoadedPagesStatusFormatter(Collection collection, Instant instant, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(collection, instant, bl);
    }

    @NotNull
    public final Collection<WebPage> getPages() {
        return this.pages;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    public final boolean getWithSymbolicLink() {
        return this.withSymbolicLink;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Duration elapsed = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)this.startTime, null, (int)2, null);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Fetched total %d pages in %s:\n";
        Object[] objectArray = new Object[]{this.pages.size(), DateTimesKt.readable((Duration)elapsed)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message = string2;
        StringBuilder sb = new StringBuilder(message);
        Iterable $this$forEachIndexed$iv = this.pages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WebPage webPage = (WebPage)item$iv;
            int i = n;
            boolean bl3 = false;
            sb.append(i + 1).append(".\t").append(new LoadStatusFormatter((WebPage)p, null, false, false, false, this.getWithSymbolicLink(), 30, null)).append('\n');
        }
        string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

