/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.message;

import ai.platon.pulsar.common.MultiSinkWriter;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.FetchStatusFormatter;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.ParseStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.ActiveDOMUrls;
import ai.platon.pulsar.persist.model.DomStatistics;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bJ\u0016\u0010!\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0016\u0010'\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010(\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0014\u0010)\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0+J\u0014\u0010,\u001a\u00020\b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0+J\u0018\u0010/\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u00100\u001a\u00020\u000bJ\u000e\u00101\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/platon/pulsar/common/message/MiscMessageWriter;", "Lai/platon/pulsar/common/MultiSinkWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "close", "", "debugDeadOutgoingPage", "deadUrl", "", "page", "Lai/platon/pulsar/persist/WebPage;", "debugDepthUpdated", "report", "debugFetchHistory", "debugFetchLaterSeeds", "debugIllegalLastFetchTime", "debugIndexDocTime", "timeStrings", "debugLongUrls", "debugRedirects", "url", "urls", "Lai/platon/pulsar/persist/model/ActiveDOMUrls;", "debugSortScore", "getFlawParsedPageReport", "verbose", "", "reportBadModifiedTime", "reportBrokenEntity", "message", "reportDOMStatistics", "stat", "Lai/platon/pulsar/persist/model/DomStatistics;", "reportFetchSchedule", "reportFetchTimeHistory", "fetchTimeHistory", "reportFlawParsedPage", "reportForceRefetchSeeds", "reportGeneratedHosts", "hostNames", "", "reportLabeledHyperlinks", "hyperLinks", "Lai/platon/pulsar/common/urls/Hyperlink;", "reportPerformance", "elapsed", "reportRedirects", "pulsar-skeleton"})
public final class MiscMessageWriter
extends MultiSinkWriter {
    @NotNull
    private final AtomicBoolean closed;

    public MiscMessageWriter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.closed = new AtomicBoolean();
    }

    private final void reportFetchTimeHistory(String fetchTimeHistory) {
        this.write(fetchTimeHistory, "fetch-time-history.txt");
    }

    public final void debugFetchHistory(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String string = page.getFetchTimeHistory("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.getFetchTimeHistory(\"\")");
        String fetchTimeHistory = string;
        if (StringsKt.contains$default((CharSequence)fetchTimeHistory, (CharSequence)",", (boolean)false, (int)2, null)) {
            String report2 = "CST: " + page.getCrawlStatus() + "\tFTH: " + fetchTimeHistory + " | " + page.getUrl();
            this.reportFetchTimeHistory(report2);
        }
    }

    public final void debugDeadOutgoingPage(@NotNull String deadUrl, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)deadUrl, (String)"deadUrl");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String report2 = deadUrl + " <= " + page.getUrl();
        this.write(report2, "generate-sort-score.txt");
    }

    public final void reportGeneratedHosts(@NotNull Set<String> hostNames) {
        Intrinsics.checkNotNullParameter(hostNames, (String)"hostNames");
        StringBuilder report2 = new StringBuilder("# Total " + hostNames.size() + " hosts generated : \n");
        SequencesKt.joinTo$default((Sequence)SequencesKt.map((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)hostNames), (Function1)reportGeneratedHosts.1.INSTANCE)), (Function1)reportGeneratedHosts.2.INSTANCE), (Appendable)report2, (CharSequence)"\n", null, null, (int)0, null, (Function1)reportGeneratedHosts.3.INSTANCE, (int)60, null);
        String string = report2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"report.toString()");
        this.write(string, "generate-hosts.txt");
    }

    public final void reportDOMStatistics(@NotNull WebPage page, @NotNull DomStatistics stat) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s | a:%-4d i:%-4d mi:%-4d ai:%-4d ia:%-4d | %s";
        Object[] objectArray = new Object[]{page.getPageCategory().symbol(), stat.getAnchor(), stat.getImg(), stat.getMediumImg(), stat.getAnchorImg(), stat.getImgAnchor(), page.getUrl()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String report2 = string2;
        this.write(report2, "document-statistics.txt");
    }

    /*
     * WARNING - void declaration
     */
    public final void reportLabeledHyperlinks(@NotNull Set<? extends Hyperlink> hyperLinks) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(hyperLinks, (String)"hyperLinks");
        if (hyperLinks.isEmpty()) {
            return;
        }
        Iterable $this$groupBy$iv = hyperLinks;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Hyperlink it = (Hyperlink)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getLabel();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedHyperlinks = destination$iv$iv;
        Iterable $this$forEach$iv = groupedHyperlinks.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ident;
            Object element$iv$iv;
            String label = (String)element$iv;
            boolean bl = false;
            element$iv$iv = (List)groupedHyperlinks.get(label);
            if (element$iv$iv == null) continue;
            Object links2 = element$iv$iv;
            String report2 = CollectionsKt.joinToString$default((Iterable)((Iterable)links2), (CharSequence)"\n", null, null, (int)0, null, (Function1)reportLabeledHyperlinks.1.report.1.INSTANCE, (int)30, null);
            String string = label;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
            this.write(report2, "labeled-links-" + ident + ".txt");
        }
    }

    public final void debugSortScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String report2 = page.getSortScore() + "\t\t" + page.getUrl();
        this.write(report2, "generate-sort-score.txt");
    }

    public final void debugFetchLaterSeeds(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        FetchStatusFormatter pageReport = new FetchStatusFormatter(page);
        this.write(pageReport.toString(), "seeds-fetch-later.txt");
    }

    public final void debugDepthUpdated(@NotNull String report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.write(report2, "depth-updated.txt");
    }

    public final void debugIllegalLastFetchTime(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "ft: {} lft: {}, fc: {} fh: {} status: {} mk: {}";
        Object[] objectArray = new Object[]{page.getFetchTime(), page.getPrevFetchTime(), page.getFetchCount(), page.getFetchTimeHistory(""), page.getProtocolStatus(), page.getMarks()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String report2 = string2;
        this.write(report2, "illegal-last-fetch-time.txt");
    }

    public final void debugRedirects(@NotNull String url, @NotNull ActiveDOMUrls urls) {
        boolean bl;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        String location = urls.getLocation();
        if (Intrinsics.areEqual((Object)location, (Object)url) && Intrinsics.areEqual((Object)urls.getURL(), (Object)url) && Intrinsics.areEqual((Object)urls.getBaseURI(), (Object)url) && Intrinsics.areEqual((Object)urls.getDocumentURI(), (Object)url)) {
            return;
        }
        StringBuilder report2 = new StringBuilder(url);
        report2.append('\n');
        if (!Intrinsics.areEqual((Object)location, (Object)url)) {
            charSequence = report2.append("location:    ");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"report.append(\"location:    \")");
            boolean bl2 = false;
            StringBuilder stringBuilder = ((StringBuilder)charSequence).append(location);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        if (!Intrinsics.areEqual((Object)urls.getURL(), (Object)location)) {
            charSequence = report2.append("URL:         ");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"report.append(\"URL:         \")");
            String string = urls.getURL();
            bl = false;
            StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        if (!Intrinsics.areEqual((Object)urls.getBaseURI(), (Object)location)) {
            charSequence = report2.append("baseURI:     ");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"report.append(\"baseURI:     \")");
            String string = urls.getBaseURI();
            bl = false;
            StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        if (!Intrinsics.areEqual((Object)urls.getDocumentURI(), (Object)location)) {
            charSequence = report2.append("documentURI: ");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"report.append(\"documentURI: \")");
            String string = urls.getDocumentURI();
            bl = false;
            StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
        charSequence = report2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"report.toString()");
        this.write((String)charSequence, "browser-redirects.txt");
    }

    public final void reportRedirects(@NotNull String report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.write(report2, "fetch-redirects-txt");
    }

    public final void reportFlawParsedPage(@NotNull WebPage page, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String report2 = this.getFlawParsedPageReport(page, verbose);
        this.write(report2, "parse-flaw.txt");
    }

    private final String getFlawParsedPageReport(WebPage page, boolean verbose) {
        PageCounters pageCounters = page.getPageCounters();
        Intrinsics.checkNotNullExpressionValue((Object)pageCounters, (String)"page.pageCounters");
        PageCounters pageCounters2 = pageCounters;
        ParseStatus parseStatus = page.getParseStatus();
        Intrinsics.checkNotNullExpressionValue((Object)parseStatus, (String)"page.parseStatus");
        ParseStatus parseStatus2 = parseStatus;
        Object[] objectArray = new Object[]{"parseErr", pageCounters2.get((Enum)PageCounters.Self.parseErr), "extractErr", pageCounters2.get((Enum)PageCounters.Self.extractErr), "U", page.getUrl()};
        Params params = Params.of((String)"parseStatus", (Object)parseStatus2.toString(), (Object[])objectArray).withKVDelimiter(":");
        Object report2 = params.formatAsLine();
        if (verbose) {
            report2 = page.getReferrer() + " -> " + page.getUrl() + (String)report2;
            report2 = (String)report2 + "\n" + page + "\n\n";
        }
        String string = report2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"report");
        return string;
    }

    public final void reportBrokenEntity(@NotNull String url, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LocalDateTime now = LocalDateTime.now();
        this.write(now + "\t" + message + "\t" + url, "broken-entity.txt");
    }

    public final void reportPerformance(@Nullable String url, @NotNull String elapsed) {
        Intrinsics.checkNotNullParameter((Object)elapsed, (String)"elapsed");
        this.write(elapsed + " | " + url, "performance.txt");
    }

    public final void debugLongUrls(@NotNull String report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.write(report2, "urls-long.txt");
    }

    public final void debugIndexDocTime(@NotNull String timeStrings) {
        Intrinsics.checkNotNullParameter((Object)timeStrings, (String)"timeStrings");
        this.write(timeStrings, "index-doc-time.txt");
    }

    public final void reportFetchSchedule(@NotNull WebPage page, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object report2 = new FetchStatusFormatter(page).toString();
        if (verbose) {
            report2 = page.getReferrer() + " -> " + page.getUrl() + "\n" + (String)report2;
            report2 = (String)report2 + "\n" + page + "\n\n";
        }
        String prefix = verbose ? "verbose-" : "";
        String string = page.getPageCategory().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String category = string3;
        this.write((String)report2, prefix + "fetch-schedule-" + category + ".txt");
    }

    public final void reportForceRefetchSeeds(@NotNull String report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.write(report2, "force-refetch-urls.txt");
    }

    public final void reportBadModifiedTime(@NotNull String report2) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.write(report2, "bad-modified-urls.txt");
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }
}

