/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.metrics;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.chrono.TimersKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.measure.ByteUnit;
import ai.platon.pulsar.common.measure.ByteUnitConverter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.CodahaleSlf4jReporter;
import ai.platon.pulsar.common.metrics.EnumCounterReporter;
import ai.platon.pulsar.common.metrics.MetricFilters;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetSocketAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0010\n\u0002\b\u0006\u0018\u0000 E2\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0016J'\u0010=\u001a\u00020<2\u001a\u0010>\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030@0?\"\u0006\u0012\u0002\b\u00030@\u00a2\u0006\u0002\u0010AJ/\u0010=\u001a\u00020<2\u0006\u0010B\u001a\u00020\u00062\u001a\u0010>\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030@0?\"\u0006\u0012\u0002\b\u00030@\u00a2\u0006\u0002\u0010CJ\u0006\u0010D\u001a\u00020<R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\bR\u000e\u0010\"\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010#\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n \r*\u0004\u0018\u00010)0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010,\u001a\n \r*\u0004\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001fR\u0016\u0010.\u001a\u0004\u0018\u00010/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00102\u001a\n \r*\u0004\u0018\u00010303X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u00104\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000fR\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\n \r*\u0004\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lai/platon/pulsar/common/metrics/AppMetrics;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "batchSize", "", "getBatchSize", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "counterReportInterval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCounterReportInterval", "()Ljava/time/Duration;", "counterReporter", "Lai/platon/pulsar/common/metrics/EnumCounterReporter;", "csvReportInterval", "getCsvReportInterval", "dailyTimer", "Ljava/util/Timer;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "graphiteReportInterval", "getGraphiteReportInterval", "graphiteReporter", "Lcom/codahale/metrics/graphite/GraphiteReporter;", "graphiteServer", "", "getGraphiteServer", "()Ljava/lang/String;", "graphiteServerPort", "getGraphiteServerPort", "hourlyTimer", "initialDelay", "getInitialDelay", "isEnabled", "", "jobIdent", "logger", "Lorg/slf4j/Logger;", "metricRegistry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "name", "getName", "pickledGraphite", "Lcom/codahale/metrics/graphite/PickledGraphite;", "getPickledGraphite", "()Lcom/codahale/metrics/graphite/PickledGraphite;", "reportDir", "Ljava/nio/file/Path;", "slf4jReportInterval", "getSlf4jReportInterval", "slf4jReporter", "Lai/platon/pulsar/common/metrics/CodahaleSlf4jReporter;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "timeIdent", "close", "", "inc", "counters", "", "", "([Ljava/lang/Enum;)V", "count", "(I[Ljava/lang/Enum;)V", "start", "Companion", "pulsar-skeleton"})
public final class AppMetrics
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private final String timeIdent;
    private final boolean isEnabled;
    @NotNull
    private final String jobIdent;
    private final Path reportDir;
    private final String name;
    private final Duration initialDelay;
    private final Duration csvReportInterval;
    private final Duration slf4jReportInterval;
    private final Duration graphiteReportInterval;
    private final Duration counterReportInterval;
    @NotNull
    private final String graphiteServer;
    private final int graphiteServerPort;
    private final int batchSize;
    @NotNull
    private final AppMetricRegistry metricRegistry;
    private final ThreadFactory threadFactory;
    private final ScheduledExecutorService executor;
    @NotNull
    private final CodahaleSlf4jReporter slf4jReporter;
    @NotNull
    private final EnumCounterReporter counterReporter;
    @Nullable
    private GraphiteReporter graphiteReporter;
    @NotNull
    private final Timer hourlyTimer;
    @NotNull
    private final Timer dailyTimer;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    public static final String SHADOW_METRIC_SYMBOL = "._.";
    @NotNull
    private static final AppMetricRegistry defaultMetricRegistry;
    @NotNull
    private static final AppMetricRegistry reg;
    private static final Instant startTime;
    @NotNull
    private static final SystemInfo systemInfo;

    /*
     * WARNING - void declaration
     */
    public AppMetrics(@NotNull ImmutableConfig conf) {
        Unit unit;
        void $this$counterReporter_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.logger = LoggerFactory.getLogger(AppMetrics.class);
        this.timeIdent = DateTimes.INSTANCE.formatNow("MMdd");
        this.isEnabled = conf.getBoolean("metrics.enabled", false);
        this.jobIdent = conf.get("pulsar.job.name", DateTimes.INSTANCE.now("HHmm"));
        this.reportDir = AppPaths.INSTANCE.getMETRICS_DIR().resolve(this.timeIdent).resolve(this.jobIdent);
        this.name = AppContext.INSTANCE.getAPP_NAME();
        Object object = Duration.ofMinutes(3L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofMinutes(3)");
        this.initialDelay = conf.getDuration("metrics.report.initial.delay", object);
        object = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofMinutes(5)");
        this.csvReportInterval = conf.getDuration("metrics.csv.report.interval", object);
        object = Duration.ofMinutes(2L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofMinutes(2)");
        this.slf4jReportInterval = conf.getDuration("metrics.slf4j.report.interval", object);
        object = Duration.ofMinutes(2L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofMinutes(2)");
        this.graphiteReportInterval = conf.getDuration("metrics.graphite.report.interval", object);
        object = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofSeconds(30)");
        this.counterReportInterval = conf.getDuration("metrics.counter.report.interval", object);
        this.graphiteServer = conf.get("graphite.server", "crawl2");
        this.graphiteServerPort = conf.getInt("graphite.server.port", 2004);
        this.batchSize = conf.getInt("graphite.pickled.batch.size", 100);
        object = SharedMetricRegistries.getDefault();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type ai.platon.pulsar.common.metrics.AppMetricRegistry");
        }
        this.metricRegistry = (AppMetricRegistry)((Object)object);
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat("reporter-%d").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        CodahaleSlf4jReporter.Builder builder = CodahaleSlf4jReporter.Companion.forRegistry(this.metricRegistry).scheduleOn(this.executor).shutdownExecutorOnStop(true);
        object = LoggerFactory.getLogger(AppMetrics.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(AppMetrics::class.java)");
        this.slf4jReporter = builder.outputTo((Logger)object).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilters.INSTANCE.notContains(SHADOW_METRIC_SYMBOL)).build();
        object = new EnumCounterReporter(this.metricRegistry.getEnumCounterRegistry(), null, null, conf, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        AppMetrics appMetrics = this;
        boolean bl32 = false;
        Logger logger = LoggerFactory.getLogger(EnumCounterReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(EnumCounterReporter::class.java)");
        $this$counterReporter_u24lambda_u2d0.outputTo(logger);
        Unit unit2 = Unit.INSTANCE;
        appMetrics.counterReporter = object;
        AppMetrics appMetrics2 = this;
        object = this.getPickledGraphite();
        if (object == null) {
            unit = null;
        } else {
            void pickled;
            Object object3 = object;
            bl2 = false;
            boolean bl4 = false;
            Object bl32 = object3;
            appMetrics = appMetrics2;
            boolean bl5 = false;
            unit2 = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.getName()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilters.INSTANCE.notContains(SHADOW_METRIC_SYMBOL)).build((GraphiteSender)pickled);
            appMetrics2 = appMetrics;
            unit = unit2;
        }
        appMetrics2.graphiteReporter = unit;
        this.hourlyTimer = new Timer("MetricHourly", true);
        this.dailyTimer = new Timer("MetricDaily", true);
        this.closed = new AtomicBoolean();
        Files.createDirectories(this.reportDir, new FileAttribute[0]);
    }

    public final String getName() {
        return this.name;
    }

    public final Duration getInitialDelay() {
        return this.initialDelay;
    }

    public final Duration getCsvReportInterval() {
        return this.csvReportInterval;
    }

    public final Duration getSlf4jReportInterval() {
        return this.slf4jReportInterval;
    }

    public final Duration getGraphiteReportInterval() {
        return this.graphiteReportInterval;
    }

    public final Duration getCounterReportInterval() {
        return this.counterReportInterval;
    }

    @NotNull
    public final String getGraphiteServer() {
        return this.graphiteServer;
    }

    public final int getGraphiteServerPort() {
        return this.graphiteServerPort;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    private final PickledGraphite getPickledGraphite() {
        PickledGraphite pickledGraphite;
        String string;
        String string2 = this.graphiteServer;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        String string3 = string = NetUtil.testNetwork((String)it, (int)this.getGraphiteServerPort()) ? string2 : null;
        if (string == null) {
            pickledGraphite = null;
        } else {
            string2 = string;
            bl = false;
            bl2 = false;
            it = string2;
            boolean bl4 = false;
            pickledGraphite = new PickledGraphite(new InetSocketAddress(it, this.getGraphiteServerPort()), this.getBatchSize());
        }
        return pickledGraphite;
    }

    public final void inc(int count, Enum<?> ... counters) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        Enum<?>[] $this$forEach$iv = counters;
        boolean $i$f$forEach = false;
        Enum<?>[] enumArray = $this$forEach$iv;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> element$iv;
            Enum<?> it = element$iv = enumArray[i];
            boolean bl = false;
            this.metricRegistry.getEnumCounterRegistry().inc(it, count);
            Counter counter = this.metricRegistry.getEnumCounters().get(it);
            if (counter == null) continue;
            counter.inc((long)count);
        }
    }

    public final void inc(Enum<?> ... counters) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        this.inc(1, Arrays.copyOf(counters, counters.length));
    }

    public final void start() {
        if (this.isEnabled) {
            Duration delay;
            this.slf4jReporter.start(this.initialDelay.getSeconds(), this.slf4jReportInterval.getSeconds(), TimeUnit.SECONDS);
            Duration duration = this.initialDelay;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"initialDelay");
            Duration duration2 = duration;
            duration = this.counterReportInterval;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"counterReportInterval");
            this.counterReporter.start(duration2, duration);
            if (NetUtil.testNetwork((String)this.graphiteServer, (int)this.graphiteServerPort)) {
                duration = this.graphiteReporter;
                if (duration != null) {
                    duration.start(this.initialDelay.getSeconds(), this.graphiteReportInterval.getSeconds(), TimeUnit.SECONDS);
                }
                this.logger.info("GraphiteReporter is started, report interval: {}", (Object)this.graphiteReportInterval);
            }
            LocalDateTime now = LocalDateTime.now();
            Duration duration3 = delay = Duration.between(now, now.plusHours(1L).truncatedTo(ChronoUnit.HOURS));
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"delay");
            Duration duration4 = duration3;
            duration3 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofHours(1)");
            TimersKt.scheduleAtFixedRate((Timer)this.hourlyTimer, (Duration)duration4, (Duration)duration3, (Function0)start.1.INSTANCE);
            duration3 = delay = Duration.between(now, now.plusDays(1L).truncatedTo(ChronoUnit.DAYS));
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"delay");
            Duration duration5 = duration3;
            duration3 = Duration.ofDays(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofDays(1)");
            TimersKt.scheduleAtFixedRate((Timer)this.dailyTimer, (Duration)duration5, (Duration)duration3, (Function0)start.2.INSTANCE);
        }
    }

    @Override
    public void close() {
        if (this.isEnabled && this.closed.compareAndSet(false, true)) {
            this.hourlyTimer.cancel();
            this.dailyTimer.cancel();
            this.slf4jReporter.close();
            GraphiteReporter graphiteReporter = this.graphiteReporter;
            if (graphiteReporter != null) {
                graphiteReporter.close();
            }
            this.graphiteReporter = null;
            this.counterReporter.close();
        }
    }

    private static final Instant _init_$lambda-5() {
        return startTime;
    }

    private static final Duration _init_$lambda-6() {
        return Companion.getElapsedTime();
    }

    private static final String _init_$lambda-7() {
        return Strings.readableBytes((long)Companion.getAvailableMemory());
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda-9() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Companion.getFreeSpace();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = Strings.readableBytes((long)it);
            collection.add(string);
        }
        return (List)var3_3;
    }

    static {
        if (SharedMetricRegistries.tryGetDefault() == null) {
            SharedMetricRegistries.setDefault((String)"pulsar", (MetricRegistry)new AppMetricRegistry());
        }
        Object object = SharedMetricRegistries.getDefault();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type ai.platon.pulsar.common.metrics.AppMetricRegistry");
        }
        reg = defaultMetricRegistry = (AppMetricRegistry)((Object)object);
        startTime = Instant.now();
        systemInfo = new SystemInfo();
        object = new Pair[]{TuplesKt.to((Object)"startTime", AppMetrics::_init_$lambda-5), TuplesKt.to((Object)"elapsedTime", AppMetrics::_init_$lambda-6), TuplesKt.to((Object)"availableMemory", AppMetrics::_init_$lambda-7), TuplesKt.to((Object)"freeSpace", AppMetrics::_init_$lambda-9)};
        object = MapsKt.mapOf((Pair[])object);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        reg.registerAll(Companion, it);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\n \u000f*\u0004\u0018\u00010\u001d0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\fR\u0019\u0010\"\u001a\n \u000f*\u0004\u0018\u00010#0#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lai/platon/pulsar/common/metrics/AppMetrics$Companion;", "", "()V", "SHADOW_METRIC_SYMBOL", "", "availableMemory", "", "getAvailableMemory", "()J", "defaultMetricRegistry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "getDefaultMetricRegistry", "()Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "freeMemory", "getFreeMemory", "freeMemoryGiB", "", "getFreeMemoryGiB", "()D", "freeSpace", "", "getFreeSpace", "()Ljava/util/List;", "memoryInfo", "Loshi/hardware/GlobalMemory;", "getMemoryInfo", "()Loshi/hardware/GlobalMemory;", "reg", "getReg", "startTime", "Ljava/time/Instant;", "getStartTime", "()Ljava/time/Instant;", "systemInfo", "Loshi/SystemInfo;", "getSystemInfo", "()Loshi/SystemInfo;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppMetricRegistry getDefaultMetricRegistry() {
            return defaultMetricRegistry;
        }

        @NotNull
        public final AppMetricRegistry getReg() {
            return reg;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final Duration getElapsedTime() {
            return Duration.between(this.getStartTime(), Instant.now());
        }

        @NotNull
        public final SystemInfo getSystemInfo() {
            return systemInfo;
        }

        public final GlobalMemory getMemoryInfo() {
            return this.getSystemInfo().getHardware().getMemory();
        }

        public final long getFreeMemory() {
            return Runtime.getRuntime().freeMemory();
        }

        public final double getFreeMemoryGiB() {
            return ByteUnit.BYTE.toGiB((double)this.getFreeMemory());
        }

        public final long getAvailableMemory() {
            return this.getMemoryInfo().getAvailable();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Long> getFreeSpace() {
            void $this$mapTo$iv$iv;
            FileStore it;
            Iterable $this$filterTo$iv$iv;
            Iterable<FileStore> iterable = FileSystems.getDefault().getFileStores();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getDefault().fileStores");
            Iterable<FileStore> $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable<FileStore> iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FileStore)element$iv$iv;
                boolean bl = false;
                if (!(ByteUnitConverter.INSTANCE.convert(it.getTotalSpace(), "G") > 20.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FileStore)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Long l = it.getUnallocatedSpace();
                collection.add(l);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

