/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110-J\u0015\u0010.\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u000300H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0086\u0002J#\u00102\u001a\u00020\u0011\"\u000e\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3002\u0006\u0010/\u001a\u0002H3\u00a2\u0006\u0002\u00104J$\u00102\u001a\u00020\u0011\"\u000e\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3002\f\u00105\u001a\b\u0012\u0004\u0012\u0002H30'J\u0012\u00106\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u000300J\u001a\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u000300J$\u00109\u001a\u00020\u0004\"\u000e\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3002\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H300J\u000e\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=J\u001e\u0010;\u001a\u00020\u00042\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040?2\u0006\u0010<\u001a\u00020=J3\u0010@\u001a\u00020A2\u001a\u0010B\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003000C\"\u0006\u0012\u0002\b\u0003002\b\b\u0002\u0010D\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010EJ\u001e\u0010@\u001a\u00020A2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\b\b\u0002\u0010D\u001a\u00020\u0011H\u0007J\u0010\u0010@\u001a\u00020A2\u0006\u00101\u001a\u00020\u0011H\u0002J;\u0010@\u001a\u00020A2\u0006\u00108\u001a\u00020\u00112\u001a\u0010B\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003000C\"\u0006\u0012\u0002\b\u0003002\b\b\u0002\u0010D\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010FJ&\u0010@\u001a\u00020A2\u0006\u00108\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\b\b\u0002\u0010D\u001a\u00020\u0011H\u0007J\u0018\u0010@\u001a\u00020A2\u0006\u00101\u001a\u00020\u00112\u0006\u0010D\u001a\u00020\u0011H\u0002J\u0014\u0010G\u001a\u00020A2\n\u0010H\u001a\u00020I\"\u00020\u0011H\u0002J$\u0010J\u001a\u00020\u0011\"\u000e\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3002\f\u00105\u001a\b\u0012\u0004\u0012\u0002H30'J$\u0010J\u001a\u00020\u0011\"\u000e\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3002\f\u00105\u001a\b\u0012\u0004\u0012\u0002H30KJ\u0006\u0010L\u001a\u00020AJ\u001a\u0010M\u001a\u00020A2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010D\u001a\u00020\u0011J\"\u0010M\u001a\u00020A2\u0006\u00108\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010D\u001a\u00020\u0011J\u0018\u0010M\u001a\u00020A2\u0006\u00101\u001a\u00020\u00112\u0006\u0010D\u001a\u00020\u0011H\u0002J\u0010\u0010N\u001a\u00020=2\u0006\u00101\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u00020\u00110&0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006P"}, d2={"Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "", "()V", "DELIMITER", "", "getDELIMITER", "()Ljava/lang/String;", "setDELIMITER", "(Ljava/lang/String;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "setLOG", "(Lorg/slf4j/Logger;)V", "MAX_COUNTERS", "", "getMAX_COUNTERS", "()I", "setMAX_COUNTERS", "(I)V", "MAX_COUNTERS_IN_GROUP", "getMAX_COUNTERS_IN_GROUP", "setMAX_COUNTERS_IN_GROUP", "MAX_GROUPS", "getMAX_GROUPS", "setMAX_GROUPS", "counterGroupSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "counterNames", "Ljava/util/ArrayList;", "counterSequence", "globalCounters", "id", "getId", "nativeCounters", "registeredClasses", "Lorg/apache/commons/lang3/tuple/Pair;", "Ljava/lang/Class;", "registeredCounters", "", "getRegisteredCounters", "()Ljava/util/List;", "asMap", "", "get", "counter", "", "index", "getGroup", "T", "(Ljava/lang/Enum;)I", "counterClass", "getIndex", "getIndexUnchecked", "group", "getName", "e", "getStatus", "verbose", "", "names", "", "inc", "", "counters", "", "value", "([Ljava/lang/Enum;I)V", "(I[Ljava/lang/Enum;I)V", "incAll", "indexes", "", "register", "Lkotlin/reflect/KClass;", "reset", "setValue", "validate", "Companion", "pulsar-skeleton"})
public final class EnumCounterRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Logger LOG = LoggerFactory.getLogger(EnumCounterRegistry.class);
    private int MAX_GROUPS = 100;
    private int MAX_COUNTERS_IN_GROUP = 1000;
    private int MAX_COUNTERS = this.MAX_GROUPS * this.MAX_COUNTERS_IN_GROUP;
    @NotNull
    private String DELIMITER = "'";
    @NotNull
    private final AtomicInteger counterGroupSequence = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger counterSequence = new AtomicInteger(0);
    @NotNull
    private final ArrayList<org.apache.commons.lang3.tuple.Pair<Class<?>, Integer>> registeredClasses = new ArrayList();
    @NotNull
    private final ArrayList<String> counterNames = new ArrayList(this.MAX_COUNTERS);
    @NotNull
    private final ArrayList<AtomicInteger> globalCounters = new ArrayList(this.MAX_COUNTERS);
    @NotNull
    private final ArrayList<AtomicInteger> nativeCounters = new ArrayList(this.MAX_COUNTERS);
    private final int id;
    @NotNull
    private static final EnumCounterRegistry DEFAULT = new EnumCounterRegistry();

    public EnumCounterRegistry() {
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.MAX_COUNTERS - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.counterNames.add("");
            this.globalCounters.add(new AtomicInteger(0));
            this.nativeCounters.add(new AtomicInteger(0));
        }
        this.id = this.counterSequence.incrementAndGet();
    }

    public final Logger getLOG() {
        return this.LOG;
    }

    public final void setLOG(Logger logger) {
        this.LOG = logger;
    }

    public final int getMAX_GROUPS() {
        return this.MAX_GROUPS;
    }

    public final void setMAX_GROUPS(int n) {
        this.MAX_GROUPS = n;
    }

    public final int getMAX_COUNTERS_IN_GROUP() {
        return this.MAX_COUNTERS_IN_GROUP;
    }

    public final void setMAX_COUNTERS_IN_GROUP(int n) {
        this.MAX_COUNTERS_IN_GROUP = n;
    }

    public final int getMAX_COUNTERS() {
        return this.MAX_COUNTERS;
    }

    public final void setMAX_COUNTERS(int n) {
        this.MAX_COUNTERS = n;
    }

    @NotNull
    public final String getDELIMITER() {
        return this.DELIMITER;
    }

    public final void setDELIMITER(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.DELIMITER = string;
    }

    public final synchronized <T extends Enum<T>> int register(@NotNull Class<T> counterClass) {
        Intrinsics.checkNotNullParameter(counterClass, (String)"counterClass");
        int groupId = this.getGroup(counterClass);
        if (groupId > 0) {
            return groupId;
        }
        groupId = this.counterGroupSequence.incrementAndGet();
        this.registeredClasses.add(org.apache.commons.lang3.tuple.Pair.of(counterClass, (Object)groupId));
        T[] TArray = counterClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"counterClass.enumConstants");
        for (Enum e : (Enum[])TArray) {
            int counterIndex = groupId * this.MAX_COUNTERS_IN_GROUP + e.ordinal();
            String counterName = groupId + this.DELIMITER + e.name();
            this.counterNames.set(counterIndex, counterName);
            this.globalCounters.set(counterIndex, new AtomicInteger(0));
            this.nativeCounters.set(counterIndex, new AtomicInteger(0));
        }
        return groupId;
    }

    public final synchronized <T extends Enum<T>> int register(@NotNull KClass<T> counterClass) {
        Intrinsics.checkNotNullParameter(counterClass, (String)"counterClass");
        return this.register(JvmClassMappingKt.getJavaClass(counterClass));
    }

    public final <T extends Enum<T>> int getGroup(@NotNull T counter) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        return this.getGroup(counter.getClass());
    }

    public final <T extends Enum<T>> int getGroup(@NotNull Class<T> counterClass) {
        int n;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(counterClass, (String)"counterClass");
            Iterable $this$firstOrNull$iv = this.registeredClasses;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                org.apache.commons.lang3.tuple.Pair it = (org.apache.commons.lang3.tuple.Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), counterClass)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        org.apache.commons.lang3.tuple.Pair entry = v0;
        if (entry == null) {
            n = -1;
        } else {
            Object object = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.value");
            n = ((Number)object).intValue();
        }
        return n;
    }

    @NotNull
    public final <T extends Enum<T>> String getName(@NotNull Enum<T> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        int groupId = this.getGroup(e.getClass());
        return groupId + this.DELIMITER + e.name();
    }

    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Class<?>> getRegisteredCounters() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.registeredClasses;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            org.apache.commons.lang3.tuple.Pair it = (org.apache.commons.lang3.tuple.Pair)element$iv$iv;
            boolean bl2 = false;
            if ((Class)it.getKey() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Class it$iv$iv = clazz;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void reset() {
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.MAX_COUNTERS - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int $noName_0 = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.counterNames.add("");
            this.globalCounters.add(new AtomicInteger(0));
            this.nativeCounters.add(new AtomicInteger(0));
        }
    }

    @JvmOverloads
    public final void inc(@NotNull Enum<?> counter, int value) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        this.inc(this.getIndex(counter), value);
    }

    public static /* synthetic */ void inc$default(EnumCounterRegistry enumCounterRegistry, Enum enum_, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        enumCounterRegistry.inc(enum_, n);
    }

    @JvmOverloads
    public final void inc(@NotNull Enum<?>[] counters, int value) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        Enum<?>[] $this$forEach$iv = counters;
        boolean $i$f$forEach = false;
        Enum<?>[] enumArray = $this$forEach$iv;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> element$iv;
            Enum<?> it = element$iv = enumArray[i];
            boolean bl = false;
            this.inc(it, value);
        }
    }

    public static /* synthetic */ void inc$default(EnumCounterRegistry enumCounterRegistry, Enum[] enumArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        enumCounterRegistry.inc(enumArray, n);
    }

    @JvmOverloads
    public final void inc(int group, @NotNull Enum<?> counter, int value) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        this.inc(this.getIndexUnchecked(group, counter), value);
    }

    public static /* synthetic */ void inc$default(EnumCounterRegistry enumCounterRegistry, int n, Enum enum_, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        enumCounterRegistry.inc(n, enum_, n2);
    }

    @JvmOverloads
    public final void inc(int group, @NotNull Enum<?>[] counters, int value) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        Enum<?>[] $this$forEach$iv = counters;
        boolean $i$f$forEach = false;
        Enum<?>[] enumArray = $this$forEach$iv;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> element$iv;
            Enum<?> it = element$iv = enumArray[i];
            boolean bl = false;
            this.inc(group, it, value);
        }
    }

    public static /* synthetic */ void inc$default(EnumCounterRegistry enumCounterRegistry, int n, Enum[] enumArray, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        enumCounterRegistry.inc(n, enumArray, n2);
    }

    public final void setValue(@NotNull Enum<?> counter, int value) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        this.setValue(this.getIndex(counter), value);
    }

    public final void setValue(int group, @NotNull Enum<?> counter, int value) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        this.setValue(this.getIndexUnchecked(group, counter), value);
    }

    public final int getIndexUnchecked(int group, @NotNull Enum<?> counter) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        return group * this.MAX_COUNTERS_IN_GROUP + counter.ordinal();
    }

    public final int getIndex(@NotNull Enum<?> counter) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            Iterable $this$firstOrNull$iv = this.registeredClasses;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                org.apache.commons.lang3.tuple.Pair it = (org.apache.commons.lang3.tuple.Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), counter.getClass())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        org.apache.commons.lang3.tuple.Pair entry = v0;
        if (entry == null) {
            this.LOG.warn("Counter does not registered : " + counter.getClass().getName());
            return -1;
        }
        Object object = entry.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.value");
        return this.getIndexUnchecked(((Number)object).intValue(), counter);
    }

    public final int get(int index) {
        return !this.validate(index) ? 0 : this.nativeCounters.get(index).get();
    }

    public final int get(@NotNull Enum<?> counter) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        return this.get(this.getIndex(counter));
    }

    @NotNull
    public final String getStatus(@NotNull Set<String> names, boolean verbose) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.MAX_COUNTERS - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int value;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            CharSequence charSequence = this.counterNames.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"counterNames[i]");
            String name = charSequence;
            charSequence = name;
            boolean bl2 = false;
            if (!(charSequence.length() > 0) || !names.isEmpty() && !names.contains(name) || (value = this.nativeCounters.get(i).get()) == 0) continue;
            if (!verbose) {
                String string = StringUtils.substringAfter((String)name, (String)this.getDELIMITER());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringAfter(name, DELIMITER)");
                name = string;
            }
            sb.append(", ").append(name).append(":").append(value);
        }
        sb.delete(0, ", ".length());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getStatus(boolean verbose) {
        boolean bl = false;
        return this.getStatus(new HashSet(), verbose);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> asMap() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = (Iterable)new IntRange(0, this.MAX_COUNTERS - 1);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator).nextInt();
            Map map2 = destination$iv$iv;
            int i = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.counterNames.get(i), (Object)this.nativeCounters.get(i).get());
            boolean bl2 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final void inc(int index) {
        if (!this.validate(index)) {
            return;
        }
        this.globalCounters.get(index).incrementAndGet();
        this.nativeCounters.get(index).incrementAndGet();
    }

    private final void inc(int index, int value) {
        if (!this.validate(index)) {
            this.LOG.warn("Failed to increase unknown counter at position " + index);
            return;
        }
        this.globalCounters.get(index).addAndGet(value);
        this.nativeCounters.get(index).addAndGet(value);
    }

    private final void incAll(int ... indexes) {
        for (int index : indexes) {
            this.inc(index);
        }
    }

    private final void setValue(int index, int value) {
        if (!this.validate(index)) {
            return;
        }
        this.globalCounters.get(index).set(value);
        this.nativeCounters.get(index).set(value);
    }

    private final boolean validate(int index) {
        if (index < 0 || index >= this.nativeCounters.size()) {
            this.LOG.error("Counter index out of range #" + index);
            return false;
        }
        return true;
    }

    @JvmOverloads
    public final void inc(@NotNull Enum<?> counter) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        EnumCounterRegistry.inc$default(this, counter, 0, 2, null);
    }

    @JvmOverloads
    public final void inc(Enum<?> ... counters) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        EnumCounterRegistry.inc$default(this, counters, 0, 2, null);
    }

    @JvmOverloads
    public final void inc(int group, @NotNull Enum<?> counter) {
        Intrinsics.checkNotNullParameter(counter, (String)"counter");
        EnumCounterRegistry.inc$default(this, group, counter, 0, 4, null);
    }

    @JvmOverloads
    public final void inc(int group, Enum<?> ... counters) {
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        EnumCounterRegistry.inc$default(this, group, counters, 0, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u00020\b\"\u000e\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\u0006\u0010\u000b\u001a\u0002H\t\u00a2\u0006\u0002\u0010\fJ$\u0010\u0007\u001a\u00020\b\"\u000e\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eJ$\u0010\u000f\u001a\u00020\b\"\u000e\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/common/metrics/EnumCounterRegistry$Companion;", "", "()V", "DEFAULT", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "getDEFAULT", "()Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "getGroup", "", "T", "", "counter", "(Ljava/lang/Enum;)I", "counterClass", "Ljava/lang/Class;", "register", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumCounterRegistry getDEFAULT() {
            return DEFAULT;
        }

        public final <T extends Enum<T>> int register(@NotNull Class<T> counterClass) {
            Intrinsics.checkNotNullParameter(counterClass, (String)"counterClass");
            return this.getDEFAULT().register(counterClass);
        }

        public final <T extends Enum<T>> int getGroup(@NotNull Class<T> counterClass) {
            Intrinsics.checkNotNullParameter(counterClass, (String)"counterClass");
            return this.getDEFAULT().getGroup(counterClass);
        }

        public final <T extends Enum<T>> int getGroup(@NotNull T counter) {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            return this.getDEFAULT().getGroup(counter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

