/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.metrics;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.StringsKt;
import ai.platon.pulsar.common.concurrent.ScheduledMonitor;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.common.metrics.EnumCounterReporter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/common/metrics/EnumCounterReporter;", "Lai/platon/pulsar/common/concurrent/ScheduledMonitor;", "counter", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "initialDelay", "Ljava/time/Duration;", "watchInterval", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/metrics/EnumCounterRegistry;Ljava/time/Duration;Ljava/time/Duration;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "jobName", "", "getJobName", "()Ljava/lang/String;", "lastStatus", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "tick", "Ljava/util/concurrent/atomic/AtomicInteger;", "init", "", "outputTo", "watch", "pulsar-skeleton"})
public final class EnumCounterReporter
extends ScheduledMonitor {
    @NotNull
    private final EnumCounterRegistry counter;
    @NotNull
    private final ImmutableConfig conf;
    private Logger log;
    @NotNull
    private String lastStatus;
    @NotNull
    private final AtomicInteger tick;

    public EnumCounterReporter(@NotNull EnumCounterRegistry counter, @NotNull Duration initialDelay, @NotNull Duration watchInterval, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)watchInterval, (String)"watchInterval");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(initialDelay, watchInterval, null, false, 12, null);
        this.counter = counter;
        this.conf = conf;
        this.log = LoggerFactory.getLogger(EnumCounterReporter.class);
        this.lastStatus = "";
        this.tick = new AtomicInteger();
    }

    public /* synthetic */ EnumCounterReporter(EnumCounterRegistry enumCounterRegistry, Duration duration, Duration duration2, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Duration duration3;
        if ((n & 2) != 0) {
            duration3 = Duration.ofMinutes(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(3)");
            duration = duration3;
        }
        if ((n & 4) != 0) {
            duration3 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(30)");
            duration2 = duration3;
        }
        this(enumCounterRegistry, duration, duration2, immutableConfig);
    }

    private final String getJobName() {
        return this.conf.get("pulsar.job.name", "UNNAMED JOB");
    }

    public final void outputTo(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public void watch() {
        if (!AppContext.INSTANCE.isActive()) {
            this.close();
            return;
        }
        if (this.tick.getAndIncrement() == 0) {
            this.init();
        }
        String status = this.counter.getStatus(true);
        CharSequence charSequence = status;
        boolean bl = false;
        if (charSequence.length() > 0 && !Intrinsics.areEqual((Object)status, (Object)this.lastStatus)) {
            this.log.info(status);
            this.lastStatus = status;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void init() {
        void $this$mapTo$iv$iv;
        this.log.info("Counter reporter is started [ " + DateTimes.now() + " ] [ " + this.getJobName() + " ]");
        Iterable $this$map$iv = this.counter.getRegisteredCounters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Class clazz = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = StringsKt.readableClassName$default((Object)it, (int)0, (int)0, (int)6, null);
            collection.add(string);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"All registered counters : ", null, (int)0, null, (Function1)init.2.INSTANCE, (int)28, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        this.log.info(it);
    }
}

