/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.metrics;

import ai.platon.pulsar.common.metrics.CommonCounter;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.persist.CrawlStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/common/metrics/EnumCounterUtils;", "", "()V", "increaseMDays", "", "days", "", "enumCounterRegistry", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "increaseMDepth", "depth", "", "increaseRDays", "increaseRDepth", "counter", "updateStatusCounter", "crawlStatus", "Lai/platon/pulsar/persist/CrawlStatus;", "pulsar-skeleton"})
public final class EnumCounterUtils {
    @NotNull
    public static final EnumCounterUtils INSTANCE = new EnumCounterUtils();

    private EnumCounterUtils() {
    }

    public final void increaseMDays(long days, @NotNull EnumCounterRegistry enumCounterRegistry) {
        CommonCounter commonCounter;
        Intrinsics.checkNotNullParameter((Object)enumCounterRegistry, (String)"enumCounterRegistry");
        int n = (int)days;
        switch (n) {
            case 0: {
                commonCounter = CommonCounter.mDay0;
                break;
            }
            case 1: {
                commonCounter = CommonCounter.mDay1;
                break;
            }
            case 2: {
                commonCounter = CommonCounter.mDay2;
                break;
            }
            case 3: {
                commonCounter = CommonCounter.mDay3;
                break;
            }
            case 4: {
                commonCounter = CommonCounter.mDay4;
                break;
            }
            case 5: {
                commonCounter = CommonCounter.mDay5;
                break;
            }
            case 6: {
                commonCounter = CommonCounter.mDay6;
                break;
            }
            case 7: {
                commonCounter = CommonCounter.mDay7;
                break;
            }
            default: {
                commonCounter = CommonCounter.mDayN;
            }
        }
        CommonCounter counter = commonCounter;
        EnumCounterRegistry.inc$default(enumCounterRegistry, counter, 0, 2, null);
    }

    public final void increaseRDays(long days, @NotNull EnumCounterRegistry enumCounterRegistry) {
        CommonCounter commonCounter;
        Intrinsics.checkNotNullParameter((Object)enumCounterRegistry, (String)"enumCounterRegistry");
        int n = (int)days;
        switch (n) {
            case 0: {
                commonCounter = CommonCounter.rDay0;
                break;
            }
            case 1: {
                commonCounter = CommonCounter.rDay1;
                break;
            }
            case 2: {
                commonCounter = CommonCounter.rDay2;
                break;
            }
            case 3: {
                commonCounter = CommonCounter.rDay3;
                break;
            }
            case 4: {
                commonCounter = CommonCounter.rDay4;
                break;
            }
            case 5: {
                commonCounter = CommonCounter.rDay5;
                break;
            }
            case 6: {
                commonCounter = CommonCounter.rDay6;
                break;
            }
            case 7: {
                commonCounter = CommonCounter.rDay7;
                break;
            }
            default: {
                commonCounter = CommonCounter.rDayN;
            }
        }
        CommonCounter counter = commonCounter;
        EnumCounterRegistry.inc$default(enumCounterRegistry, counter, 0, 2, null);
    }

    public final void increaseMDepth(int depth, @NotNull EnumCounterRegistry enumCounterRegistry) {
        CommonCounter commonCounter;
        Intrinsics.checkNotNullParameter((Object)enumCounterRegistry, (String)"enumCounterRegistry");
        int n = depth;
        switch (n) {
            case 0: {
                commonCounter = CommonCounter.mDepth0;
                break;
            }
            case 1: {
                commonCounter = CommonCounter.mDepth1;
                break;
            }
            case 2: {
                commonCounter = CommonCounter.mDepth2;
                break;
            }
            case 3: {
                commonCounter = CommonCounter.mDepth3;
                break;
            }
            default: {
                commonCounter = CommonCounter.mDepthN;
            }
        }
        CommonCounter counter = commonCounter;
        EnumCounterRegistry.inc$default(enumCounterRegistry, counter, 0, 2, null);
    }

    public final void increaseRDepth(int depth, @NotNull EnumCounterRegistry counter) {
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        int n = depth;
        switch (n) {
            case 0: {
                EnumCounterRegistry.inc$default(counter, CommonCounter.rDepth0, 0, 2, null);
                break;
            }
            case 1: {
                EnumCounterRegistry.inc$default(counter, CommonCounter.rDepth1, 0, 2, null);
                break;
            }
            case 2: {
                EnumCounterRegistry.inc$default(counter, CommonCounter.rDepth2, 0, 2, null);
                break;
            }
            case 3: {
                EnumCounterRegistry.inc$default(counter, CommonCounter.rDepth3, 0, 2, null);
                break;
            }
            default: {
                EnumCounterRegistry.inc$default(counter, CommonCounter.rDepthN, 0, 2, null);
            }
        }
    }

    public final void updateStatusCounter(@NotNull CrawlStatus crawlStatus, @NotNull EnumCounterRegistry counter) {
        Intrinsics.checkNotNullParameter((Object)crawlStatus, (String)"crawlStatus");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        byte by = (byte)crawlStatus.getCode();
        if (by == 2) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stFetched, 0, 2, null);
        } else if (by == 4) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stRedirTemp, 0, 2, null);
        } else if (by == 5) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stRedirPerm, 0, 2, null);
        } else if (by == 38) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stNotModified, 0, 2, null);
        } else if (by == 34) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stRetry, 0, 2, null);
        } else if (by == 1) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stUnfetched, 0, 2, null);
        } else if (by == 3) {
            EnumCounterRegistry.inc$default(counter, CommonCounter.stGone, 0, 2, null);
        }
    }
}

