/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/common/metrics/MultiMetric;", "", "counter", "Lcom/codahale/metrics/Counter;", "dailyCounter", "hourlyCounter", "meter", "Lcom/codahale/metrics/Meter;", "(Lcom/codahale/metrics/Counter;Lcom/codahale/metrics/Counter;Lcom/codahale/metrics/Counter;Lcom/codahale/metrics/Meter;)V", "getCounter", "()Lcom/codahale/metrics/Counter;", "getDailyCounter", "getHourlyCounter", "getMeter", "()Lcom/codahale/metrics/Meter;", "inc", "", "n", "", "", "mark", "reset", "pulsar-skeleton"})
public final class MultiMetric {
    @NotNull
    private final Counter counter;
    @NotNull
    private final Counter dailyCounter;
    @NotNull
    private final Counter hourlyCounter;
    @NotNull
    private final Meter meter;

    public MultiMetric(@NotNull Counter counter, @NotNull Counter dailyCounter, @NotNull Counter hourlyCounter, @NotNull Meter meter) {
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter((Object)dailyCounter, (String)"dailyCounter");
        Intrinsics.checkNotNullParameter((Object)hourlyCounter, (String)"hourlyCounter");
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        this.counter = counter;
        this.dailyCounter = dailyCounter;
        this.hourlyCounter = hourlyCounter;
        this.meter = meter;
    }

    @NotNull
    public final Counter getCounter() {
        return this.counter;
    }

    @NotNull
    public final Counter getDailyCounter() {
        return this.dailyCounter;
    }

    @NotNull
    public final Counter getHourlyCounter() {
        return this.hourlyCounter;
    }

    @NotNull
    public final Meter getMeter() {
        return this.meter;
    }

    public final void mark() {
        this.counter.inc();
        this.dailyCounter.inc();
        this.hourlyCounter.inc();
        this.meter.mark();
    }

    public final void inc(long n) {
        this.counter.inc(n);
        this.dailyCounter.inc(n);
        this.hourlyCounter.inc(n);
        this.meter.mark(n);
    }

    public final void inc(int n) {
        this.inc((long)n);
    }

    public final void reset() {
        this.inc(-this.counter.getCount());
    }
}

