/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.options.CommonOptions;
import ai.platon.pulsar.persist.metadata.FetchMode;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Parameters(commandDescription="The most important switches for fetch jobs.", commandNames={"FetchJob"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010B\u001a\u00020CR\u001e\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR&\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010\rR \u0010!\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000b\"\u0004\b#\u0010\rR\u001e\u0010$\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010*\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001e\u0010-\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010'\"\u0004\b/\u0010)R\u001e\u00100\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001b\"\u0004\b2\u0010\u001dR\u001e\u00103\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001b\"\u0004\b5\u0010\u001dR\u001e\u00106\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010'\"\u0004\b8\u0010)R\u001e\u00109\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001b\"\u0004\b;\u0010\u001dR\u001e\u0010<\u001a\u00020%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010'\"\u0004\b>\u0010)R \u0010?\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u000b\"\u0004\bA\u0010\r\u00a8\u0006E"}, d2={"Lai/platon/pulsar/common/options/FetchOptions;", "Lai/platon/pulsar/common/options/CommonOptions;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "argv", "", "", "([Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "batchId", "getBatchId", "()Ljava/lang/String;", "setBatchId", "(Ljava/lang/String;)V", "crawlId", "getCrawlId", "setCrawlId", "fetchMode", "Lai/platon/pulsar/persist/metadata/FetchMode;", "kotlin.jvm.PlatformType", "getFetchMode", "()Lai/platon/pulsar/persist/metadata/FetchMode;", "setFetchMode", "(Lai/platon/pulsar/persist/metadata/FetchMode;)V", "index", "", "getIndex", "()Z", "setIndex", "(Z)V", "indexerCollection", "getIndexerCollection", "setIndexerCollection", "indexerUrl", "getIndexerUrl", "setIndexerUrl", "limit", "", "getLimit", "()I", "setLimit", "(I)V", "numPoolThreads", "getNumPoolThreads", "setNumPoolThreads", "numReduceTasks", "getNumReduceTasks", "setNumReduceTasks", "parse", "getParse", "setParse", "resume", "getResume", "setResume", "round", "getRound", "setRound", "strictDf", "getStrictDf", "setStrictDf", "verbose", "getVerbose", "setVerbose", "zkHostString", "getZkHostString", "setZkHostString", "toParams", "Lai/platon/pulsar/common/config/Params;", "Companion", "pulsar-skeleton"})
public final class FetchOptions
extends CommonOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Parameter(names={"-crawlId"}, description="The id to prefix the schemas to operate on")
    @NotNull
    private String crawlId;
    @Parameter(names={"-batchId"}, description="If not specified, use last generated batch id.")
    @NotNull
    private String batchId;
    @Parameter(names={"-round"}, description="The crawl round")
    private int round;
    @Parameter(names={"-fetchMode"}, description="Fetch mode")
    private FetchMode fetchMode;
    @Parameter(names={"-strictDf"}, description="If true, crawl the web using strict depth-first strategy")
    private boolean strictDf;
    @Parameter(names={"-reducerTasks"}, description="Number of reducers")
    private int numReduceTasks;
    @Parameter(names={"-queueThreads"}, description="Number of fetcher threads per queue")
    private int numPoolThreads;
    @Parameter(names={"-resume"}, description="Resume interrupted job")
    private boolean resume;
    @Parameter(names={"-parse"}, description="Parse the web page when it's fetched")
    private boolean parse;
    @Parameter(names={"-limit"}, description="Task limit")
    private int limit;
    @Parameter(names={"-index"}, description="Active indexer")
    private boolean index;
    @Parameter(names={"-indexer"}, description="Indexer full url or collection only,  for example, http://localhost:8983/solr/collection or collection")
    @Nullable
    private String indexerUrl;
    @Parameter(names={"-collection"}, description="Index server side collection name")
    @Nullable
    private String indexerCollection;
    @Parameter(names={"-zk"}, description="Zookeeper host string")
    @Nullable
    private String zkHostString;
    @Parameter(names={"-verbose"}, description="More logs")
    private int verbose;
    @NotNull
    private static final String defaultBatchId = AppFiles.INSTANCE.readBatchIdOrDefault("all");

    public FetchOptions(@NotNull String[] argv, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(argv);
        this.crawlId = conf.get("storage.crawl.id", "");
        this.batchId = conf.get("pulsar.batch.name", defaultBatchId);
        this.round = 1;
        this.fetchMode = (FetchMode)conf.getEnum("fetch.fetch.mode", (Enum)FetchMode.BROWSER);
        this.numReduceTasks = conf.isDistributedFs() ? conf.getInt("mapreduce.job.reduces", 2) : 1;
        this.numPoolThreads = conf.getInt("fetch.threads.per.pool", 10);
        this.limit = Integer.MAX_VALUE;
    }

    @NotNull
    public final String getCrawlId() {
        return this.crawlId;
    }

    public final void setCrawlId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.crawlId = string;
    }

    @NotNull
    public final String getBatchId() {
        return this.batchId;
    }

    public final void setBatchId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.batchId = string;
    }

    public final int getRound() {
        return this.round;
    }

    public final void setRound(int n) {
        this.round = n;
    }

    public final FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public final void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    public final boolean getStrictDf() {
        return this.strictDf;
    }

    public final void setStrictDf(boolean bl) {
        this.strictDf = bl;
    }

    public final int getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public final void setNumReduceTasks(int n) {
        this.numReduceTasks = n;
    }

    public final int getNumPoolThreads() {
        return this.numPoolThreads;
    }

    public final void setNumPoolThreads(int n) {
        this.numPoolThreads = n;
    }

    public final boolean getResume() {
        return this.resume;
    }

    public final void setResume(boolean bl) {
        this.resume = bl;
    }

    public final boolean getParse() {
        return this.parse;
    }

    public final void setParse(boolean bl) {
        this.parse = bl;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public final boolean getIndex() {
        return this.index;
    }

    public final void setIndex(boolean bl) {
        this.index = bl;
    }

    @Nullable
    public final String getIndexerUrl() {
        return this.indexerUrl;
    }

    public final void setIndexerUrl(@Nullable String string) {
        this.indexerUrl = string;
    }

    @Nullable
    public final String getIndexerCollection() {
        return this.indexerCollection;
    }

    public final void setIndexerCollection(@Nullable String string) {
        this.indexerCollection = string;
    }

    @Nullable
    public final String getZkHostString() {
        return this.zkHostString;
    }

    public final void setZkHostString(@Nullable String string) {
        this.zkHostString = string;
    }

    public final int getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(int n) {
        this.verbose = n;
    }

    public FetchOptions(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new String[0], conf);
    }

    @NotNull
    public final Params toParams() {
        Object[] objectArray = new Object[]{"-crawlId", this.crawlId, "-batchId", this.batchId, "-fetchMode", this.fetchMode, "-strictDf", this.strictDf, "-reducerTasks", this.numReduceTasks, "-queueThreads", this.numPoolThreads, "-resume", this.resume, "-parse", this.parse, "-limit", this.limit, "-index", this.index, "-indexerUrl", this.indexerUrl, "-zk", this.zkHostString, "-collection", this.indexerCollection};
        Params params = Params.of((String)"-round", (Object)this.round, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                Puls\u2026dexerCollection\n        )");
        return params;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/options/FetchOptions$Companion;", "", "()V", "defaultBatchId", "", "getDefaultBatchId", "()Ljava/lang/String;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBatchId() {
            return defaultBatchId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

