/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.options.CommonOptions;
import com.beust.jcommander.Parameter;
import java.time.Duration;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u00104\u001a\u00020\u0007H\u0002J\u0006\u00105\u001a\u000206R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001e\u0010(\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R\u001e\u0010+\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R\u001e\u0010.\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001c\"\u0004\b0\u0010\u001eR\u001e\u00101\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001c\"\u0004\b3\u0010\u001e\u00a8\u00067"}, d2={"Lai/platon/pulsar/common/options/GenerateOptions;", "Lai/platon/pulsar/common/options/CommonOptions;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "argv", "", "", "([Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "adddays", "", "getAdddays", "()J", "setAdddays", "(J)V", "batchId", "getBatchId", "()Ljava/lang/String;", "setBatchId", "(Ljava/lang/String;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "crawlId", "getCrawlId", "setCrawlId", "limit", "", "getLimit", "()I", "setLimit", "(I)V", "noFilter", "", "getNoFilter", "()Z", "setNoFilter", "(Z)V", "noNormalizer", "getNoNormalizer", "setNoNormalizer", "reGenerate", "getReGenerate", "setReGenerate", "reGenerateSeeds", "getReGenerateSeeds", "setReGenerateSeeds", "round", "getRound", "setRound", "topN", "getTopN", "setTopN", "generateBatchId", "toParams", "Lai/platon/pulsar/common/config/Params;", "pulsar-skeleton"})
public final class GenerateOptions
extends CommonOptions {
    @NotNull
    private final ImmutableConfig conf;
    @Parameter(names={"-crawlId"}, description="The crawl id, (default : \"storage.crawl.id\").")
    @NotNull
    private String crawlId;
    @Parameter(names={"-batchId"}, description="The batch id")
    @NotNull
    private String batchId;
    @Parameter(names={"-round"}, description="The crawl round")
    private int round;
    @Parameter(names={"-reGen"}, description="Re generate pages")
    private boolean reGenerate;
    @Parameter(names={"-reSeeds"}, description="Re-generate all seeds")
    private boolean reGenerateSeeds;
    @Parameter(names={"-topN"}, description="Number of top URLs to be selected")
    private int topN;
    @Parameter(names={"-noNorm"}, description="Activate the normalizer plugin to normalize the url")
    private boolean noNormalizer;
    @Parameter(names={"-noFilter"}, description="Activate the filter plugin to filter the url")
    private boolean noFilter;
    @Parameter(names={"-adddays"}, description="Adds numDays to the current time to facilitate crawling urls already. Fetched sooner then default.")
    private long adddays;
    @Parameter(names={"-limit"}, description="task limit")
    private int limit;

    public GenerateOptions(@NotNull String[] argv, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(argv);
        this.conf = conf;
        this.crawlId = this.conf.get("storage.crawl.id", "");
        this.batchId = this.generateBatchId();
        this.round = 1;
        this.topN = Integer.MAX_VALUE;
        this.limit = Integer.MAX_VALUE;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final String getCrawlId() {
        return this.crawlId;
    }

    public final void setCrawlId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.crawlId = string;
    }

    @NotNull
    public final String getBatchId() {
        return this.batchId;
    }

    public final void setBatchId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.batchId = string;
    }

    public final int getRound() {
        return this.round;
    }

    public final void setRound(int n) {
        this.round = n;
    }

    public final boolean getReGenerate() {
        return this.reGenerate;
    }

    public final void setReGenerate(boolean bl) {
        this.reGenerate = bl;
    }

    public final boolean getReGenerateSeeds() {
        return this.reGenerateSeeds;
    }

    public final void setReGenerateSeeds(boolean bl) {
        this.reGenerateSeeds = bl;
    }

    public final int getTopN() {
        return this.topN;
    }

    public final void setTopN(int n) {
        this.topN = n;
    }

    public final boolean getNoNormalizer() {
        return this.noNormalizer;
    }

    public final void setNoNormalizer(boolean bl) {
        this.noNormalizer = bl;
    }

    public final boolean getNoFilter() {
        return this.noFilter;
    }

    public final void setNoFilter(boolean bl) {
        this.noFilter = bl;
    }

    public final long getAdddays() {
        return this.adddays;
    }

    public final void setAdddays(long l) {
        this.adddays = l;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public GenerateOptions(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new String[0], conf);
    }

    @NotNull
    public final Params toParams() {
        Object[] objectArray = new Object[]{"-batchId", this.batchId, "-topN", this.topN, "-reGen", this.reGenerate, "-reGenSeeds", this.reGenerateSeeds, "-curTime", System.currentTimeMillis() + Duration.ofDays(this.adddays).toMillis(), "-noNorm", this.noNormalizer, "-noFilter", this.noFilter};
        Params params = Params.of((String)"-crawlId", (Object)this.crawlId, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                Puls\u2026ILTER, noFilter\n        )");
        return params;
    }

    private final String generateBatchId() {
        int n = new Random().nextInt();
        boolean bl = false;
        return System.currentTimeMillis() / (long)1000 + "-" + Math.abs(n);
    }
}

