/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.options.CommonOptions;
import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016R\u001e\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lai/platon/pulsar/common/options/InjectOptions;", "Lai/platon/pulsar/common/options/CommonOptions;", "argv", "", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "([Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "crawlId", "getCrawlId", "()Ljava/lang/String;", "setCrawlId", "(Ljava/lang/String;)V", "limit", "", "getLimit", "()I", "setLimit", "(I)V", "seeds", "", "getSeeds", "()Ljava/util/List;", "setSeeds", "(Ljava/util/List;)V", "slashed", "", "getSlashed", "()Z", "setSlashed", "(Z)V", "getParams", "Lai/platon/pulsar/common/config/Params;", "pulsar-skeleton"})
public final class InjectOptions
extends CommonOptions {
    @Parameter(description="<seeds> \nSeed urls. You can use {@code @FILE} syntax to read from file.")
    @NotNull
    private List<String> seeds;
    @Parameter(names={"-slashed"}, description="An url can be in multiple lines in seed file if slashed is true")
    private boolean slashed;
    @Parameter(names={"-crawlId"}, description="The crawl id, (default : \"storage.crawl.id\").")
    @NotNull
    private String crawlId;
    @Parameter(names={"-limit"}, description="task limit")
    private int limit;

    public InjectOptions(@NotNull String[] argv, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(argv);
        this.setExpandAtSign(false);
        this.setAcceptUnknownOptions(false);
        this.seeds = new ArrayList();
        this.crawlId = conf.get("storage.crawl.id", "");
        this.limit = 0x3FFFFFFF;
    }

    @NotNull
    public final List<String> getSeeds() {
        return this.seeds;
    }

    public final void setSeeds(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.seeds = list;
    }

    public final boolean getSlashed() {
        return this.slashed;
    }

    public final void setSlashed(boolean bl) {
        this.slashed = bl;
    }

    @NotNull
    public final String getCrawlId() {
        return this.crawlId;
    }

    public final void setCrawlId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.crawlId = string;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"-seeds", this.seeds.isEmpty() ? "" : this.seeds.get(0), "-limit", this.limit};
        Params params = Params.of((String)"-crawlId", (Object)this.crawlId, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                Puls\u2026RG_LIMIT, limit\n        )");
        return params;
    }
}

