/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.options.PulsarOptions;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.gora.generated.GHypeLink;
import com.beust.jcommander.Parameter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 G2\u00020\u0001:\u0001GB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001d\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\f\u00105\u001a\b\u0012\u0004\u0012\u00020706J\f\u00108\u001a\b\u0012\u0004\u0012\u00020906J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000406J\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u000209J\u000e\u0010<\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u0004J\u0016\u0010<\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u0004J\b\u0010@\u001a\u00020AH\u0016J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00040CJ\u0010\u0010D\u001a\u00020E2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010F\u001a\u00020\u0004H\u0016R\u001e\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0005R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001e\u0010\u001b\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001e\u0010!\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0010\"\u0004\b(\u0010\u0005R\u001e\u0010)\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0010\"\u0004\b+\u0010\u0005R\u001e\u0010,\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0010\"\u0004\b.\u0010\u0005R\u001e\u0010/\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0010\"\u0004\b1\u0010\u0005R\u001e\u00102\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0010\"\u0004\b4\u0010\u0005\u00a8\u0006H"}, d2={"Lai/platon/pulsar/common/options/LinkOptions;", "Lai/platon/pulsar/common/options/PulsarOptions;", "()V", "args", "", "(Ljava/lang/String;)V", "", "([Ljava/lang/String;)V", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "([Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "", "(Ljava/util/Map;)V", "anchorRegex", "getAnchorRegex", "()Ljava/lang/String;", "setAnchorRegex", "logLevel", "", "getLogLevel", "()I", "setLogLevel", "(I)V", "maxAnchorLength", "getMaxAnchorLength", "setMaxAnchorLength", "maxUrlLength", "getMaxUrlLength", "setMaxUrlLength", "minAnchorLength", "getMinAnchorLength", "setMinAnchorLength", "minUrlLength", "getMinUrlLength", "setMinUrlLength", "report", "", "restrictCss", "getRestrictCss", "setRestrictCss", "urlContains", "getUrlContains", "setUrlContains", "urlPostfix", "getUrlPostfix", "setUrlPostfix", "urlPrefix", "getUrlPrefix", "setUrlPrefix", "urlRegex", "getUrlRegex", "setUrlRegex", "asGHypeLinkPredicate", "Ljava/util/function/Predicate;", "Lai/platon/pulsar/persist/gora/generated/GHypeLink;", "asPredicate", "Lai/platon/pulsar/persist/HyperlinkPersistable;", "asUrlPredicate", "build", "filter", "l", "url", "anchor", "getParams", "Lai/platon/pulsar/common/config/Params;", "getReport", "", "init", "", "toString", "Companion", "pulsar-skeleton"})
public final class LinkOptions
extends PulsarOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Parameter(names={"-css", "--restrict-css"}, description="Path to the DOM to follow links")
    @NotNull
    private String restrictCss;
    @Parameter(names={"-amin", "--anchor-min-length"}, description="Anchor min length")
    private int minAnchorLength;
    @Parameter(names={"-amax", "--anchor-max-length"}, description="Anchor max length")
    private int maxAnchorLength;
    @Parameter(names={"-areg", "--anchor-regex"}, description="Anchor regex")
    @NotNull
    private String anchorRegex;
    @Parameter(names={"-umin", "--url-min-length"}, description="Min url length")
    private int minUrlLength;
    @Parameter(names={"-umax", "--url-max-length"}, description="Max url length")
    private int maxUrlLength;
    @Parameter(names={"-upre", "--url-prefix"}, description="Url prefix")
    @NotNull
    private String urlPrefix;
    @Parameter(names={"-ucon", "--url-contains"}, description="Url contains")
    @NotNull
    private String urlContains;
    @Parameter(names={"-upos", "--url-postfix"}, description="Url postfix")
    @NotNull
    private String urlPostfix;
    @Parameter(names={"-ureg", "--url-regex"}, description="Url regex")
    @NotNull
    private String urlRegex;
    @Parameter(names={"-log", "--log-level"}, description="Log level")
    private int logLevel;
    @NotNull
    private final List<String> report;
    @NotNull
    public static final String DEFAULT_SEED_ARGS = "-amin 2 -amax 4 -umin 23 -umax 45";
    @NotNull
    private static final LinkOptions DEFAULT_SEED_OPTIONS = Companion.parse("-amin 2 -amax 4 -umin 23 -umax 45");
    @NotNull
    private static final LinkOptions DEFAULT = new LinkOptions();

    @NotNull
    public final String getRestrictCss() {
        return this.restrictCss;
    }

    public final void setRestrictCss(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.restrictCss = string;
    }

    public final int getMinAnchorLength() {
        return this.minAnchorLength;
    }

    public final void setMinAnchorLength(int n) {
        this.minAnchorLength = n;
    }

    public final int getMaxAnchorLength() {
        return this.maxAnchorLength;
    }

    public final void setMaxAnchorLength(int n) {
        this.maxAnchorLength = n;
    }

    @NotNull
    public final String getAnchorRegex() {
        return this.anchorRegex;
    }

    public final void setAnchorRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.anchorRegex = string;
    }

    public final int getMinUrlLength() {
        return this.minUrlLength;
    }

    public final void setMinUrlLength(int n) {
        this.minUrlLength = n;
    }

    public final int getMaxUrlLength() {
        return this.maxUrlLength;
    }

    public final void setMaxUrlLength(int n) {
        this.maxUrlLength = n;
    }

    @NotNull
    public final String getUrlPrefix() {
        return this.urlPrefix;
    }

    public final void setUrlPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.urlPrefix = string;
    }

    @NotNull
    public final String getUrlContains() {
        return this.urlContains;
    }

    public final void setUrlContains(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.urlContains = string;
    }

    @NotNull
    public final String getUrlPostfix() {
        return this.urlPostfix;
    }

    public final void setUrlPostfix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.urlPostfix = string;
    }

    @NotNull
    public final String getUrlRegex() {
        return this.urlRegex;
    }

    public final void setUrlRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.urlRegex = string;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(int n) {
        this.logLevel = n;
    }

    public LinkOptions() {
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
    }

    public LinkOptions(@NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(args);
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
    }

    public LinkOptions(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(args);
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
    }

    public LinkOptions(@NotNull String args, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(args);
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
        this.init(conf);
    }

    public LinkOptions(@NotNull String[] args, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(args);
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
        this.init(conf);
    }

    public LinkOptions(@NotNull Map<String, String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        super(args);
        this.restrictCss = "body";
        this.minAnchorLength = 5;
        this.maxAnchorLength = 50;
        this.anchorRegex = ".+";
        this.minUrlLength = 23;
        this.maxUrlLength = 150;
        this.urlPrefix = "";
        this.urlContains = "";
        this.urlPostfix = "";
        this.urlRegex = ".+";
        this.report = new LinkedList();
    }

    private final void init(ImmutableConfig conf) {
        this.minAnchorLength = conf.getUint("parse.min.anchor.length", 8);
        this.maxAnchorLength = conf.getUint("parse.max.anchor.length", 40);
    }

    public final int filter(@NotNull HyperlinkPersistable l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        String string = l.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"l.url");
        String string2 = string;
        string = l.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"l.text");
        return this.filter(string2, string);
    }

    public final int filter(@NotNull String url, @NotNull String anchor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (anchor.length() < this.minAnchorLength || anchor.length() > this.maxAnchorLength) {
            return 100;
        }
        CharSequence charSequence = this.anchorRegex;
        boolean bl = false;
        if (charSequence.length() > 0 && !Intrinsics.areEqual((Object)".+", (Object)this.anchorRegex)) {
            charSequence = anchor;
            String string = this.anchorRegex;
            boolean bl2 = false;
            string = new Regex(string);
            bl2 = false;
            if (!string.matches(charSequence)) {
                return 101;
            }
        }
        return this.filter(url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int filter(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url.length() < this.minUrlLength) return 200;
        if (url.length() > this.maxUrlLength) {
            return 200;
        }
        CharSequence charSequence = this.urlPrefix;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((String)url, (String)this.urlPrefix, (boolean)false, (int)2, null)) {
            return 210;
        }
        charSequence = this.urlPostfix;
        bl = false;
        if (charSequence.length() > 0 && !StringsKt.endsWith$default((String)url, (String)this.urlPostfix, (boolean)false, (int)2, null)) {
            return 211;
        }
        charSequence = this.urlContains;
        bl = false;
        if (charSequence.length() > 0 && !StringsKt.contains$default((CharSequence)url, (CharSequence)this.urlContains, (boolean)false, (int)2, null)) {
            return 212;
        }
        charSequence = this.urlRegex;
        bl = false;
        if (charSequence.length() <= 0) return 0;
        boolean bl2 = true;
        if (!bl2) return 0;
        charSequence = url;
        String string = this.urlRegex;
        boolean bl3 = false;
        string = new Regex(string);
        bl3 = false;
        if (string.matches(charSequence)) return 0;
        return 213;
    }

    @NotNull
    public final Predicate<String> asUrlPredicate() {
        this.report.clear();
        return arg_0 -> LinkOptions.asUrlPredicate$lambda-0(this, arg_0);
    }

    @NotNull
    public final Predicate<HyperlinkPersistable> asPredicate() {
        this.report.clear();
        return arg_0 -> LinkOptions.asPredicate$lambda-1(this, arg_0);
    }

    @NotNull
    public final Predicate<GHypeLink> asGHypeLinkPredicate() {
        this.report.clear();
        return arg_0 -> LinkOptions.asGHypeLinkPredicate$lambda-2(this, arg_0);
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"-amin", this.minAnchorLength, "-amax", this.maxAnchorLength, "-areg", this.anchorRegex, "-umin", this.minUrlLength, "-umax", this.maxUrlLength, "-upre", this.urlPrefix, "-ucon", this.urlContains, "-upos", this.urlPostfix, "-ureg", this.urlRegex};
        Params params = Params.of((String)"-css", (Object)this.restrictCss, (Object[])objectArray).filter(LinkOptions::getParams$lambda-3).filter(LinkOptions::getParams$lambda-4);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"-cs\u2026toString().isNotEmpty() }");
        return params;
    }

    @NotNull
    public final String build() {
        String string = this.getParams().withKVDelimiter(" ").formatAsLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.withKVDelimiter(\" \").formatAsLine()");
        return string;
    }

    @NotNull
    public final List<String> getReport() {
        return this.report;
    }

    @Override
    @NotNull
    public String toString() {
        return this.build();
    }

    private static final boolean asUrlPredicate$lambda-0(LinkOptions this$0, String url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int r = this$0.filter(url);
        if (this$0.getLogLevel() > 0) {
            this$0.report.add(r + " <- " + url);
        }
        return r == 0;
    }

    private static final boolean asPredicate$lambda-1(LinkOptions this$0, HyperlinkPersistable l) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        String string = l.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"l.url");
        String string2 = string;
        string = l.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"l.text");
        int r = this$0.filter(string2, string);
        if (this$0.getLogLevel() > 0) {
            this$0.report.add(r + " <- " + l.getUrl() + "\t" + l.getText());
        }
        return r == 0;
    }

    private static final boolean asGHypeLinkPredicate$lambda-2(LinkOptions this$0, GHypeLink l) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        int r = this$0.filter(((Object)l.getUrl()).toString(), ((Object)l.getAnchor()).toString());
        if (this$0.getLogLevel() > 0) {
            this$0.report.add(r + " <- " + l.getUrl() + "\t" + l.getAnchor());
        }
        return r == 0;
    }

    private static final boolean getParams$lambda-3(Pair it) {
        return it.getValue() != null;
    }

    private static final boolean getParams$lambda-4(Pair it) {
        CharSequence charSequence = it.getValue().toString();
        boolean bl = false;
        return charSequence.length() > 0;
    }

    @JvmStatic
    @NotNull
    public static final LinkOptions parse(@NotNull String args, @NotNull ImmutableConfig conf) {
        return Companion.parse(args, conf);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/common/options/LinkOptions$Companion;", "", "()V", "DEFAULT", "Lai/platon/pulsar/common/options/LinkOptions;", "getDEFAULT", "()Lai/platon/pulsar/common/options/LinkOptions;", "DEFAULT_SEED_ARGS", "", "DEFAULT_SEED_OPTIONS", "getDEFAULT_SEED_OPTIONS", "parse", "args", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinkOptions getDEFAULT_SEED_OPTIONS() {
            return DEFAULT_SEED_OPTIONS;
        }

        @NotNull
        public final LinkOptions getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final LinkOptions parse(@NotNull String args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            LinkOptions options = new LinkOptions(args);
            options.parse();
            return options;
        }

        @JvmStatic
        @NotNull
        public final LinkOptions parse(@NotNull String args, @NotNull ImmutableConfig conf) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            LinkOptions options = new LinkOptions(args, conf);
            options.parse();
            return options;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

