/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.options.OptionUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\b\u0016\u0018\u0000 @2\u00020\u0001:\u0001@B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\bB\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010,\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0\t\"\u00020+\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020-H\u0002J\u0013\u00101\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\fH\u0016J\b\u00106\u001a\u00020-H\u0016J\u0016\u00106\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020+07H\u0014J\u001f\u00108\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0\t\"\u00020+\u00a2\u0006\u0002\u0010/J\u0014\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007H\u0016J\u0013\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010;\u001a\u00020\u0004H\u0016J\u0014\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040=H\u0016J\b\u0010>\u001a\u00020\u0004H\u0016J\b\u0010?\u001a\u00020-H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R\u001a\u0010\u001c\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u001a\u0010\u001e\u001a\u00020\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lai/platon/pulsar/common/options/PulsarOptions;", "Lai/platon/pulsar/common/config/Parameterized;", "()V", "args", "", "(Ljava/lang/String;)V", "argv", "", "(Ljava/util/Map;)V", "", "([Ljava/lang/String;)V", "acceptUnknownOptions", "", "getAcceptUnknownOptions", "()Z", "setAcceptUnknownOptions", "(Z)V", "allowParameterOverwriting", "getAllowParameterOverwriting", "setAllowParameterOverwriting", "getArgs", "()Ljava/lang/String;", "getArgv", "()[Ljava/lang/String;", "[Ljava/lang/String;", "expandAtSign", "getExpandAtSign", "setExpandAtSign", "isHelp", "setHelp", "jc", "Lcom/beust/jcommander/JCommander;", "getJc", "()Lcom/beust/jcommander/JCommander;", "setJc", "(Lcom/beust/jcommander/JCommander;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "registeredObjects", "", "", "addObjects", "", "objects", "([Ljava/lang/Object;)V", "doParse", "equals", "other", "hashCode", "", "parse", "parseOrExit", "", "setObjects", "toArgsMap", "toArgv", "toCmdLine", "toMutableArgsMap", "", "toString", "usage", "Companion", "pulsar-skeleton"})
public class PulsarOptions
implements Parameterized {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] argv;
    private final Logger logger;
    private boolean expandAtSign;
    private boolean acceptUnknownOptions;
    private boolean allowParameterOverwriting;
    @NotNull
    private final Set<Object> registeredObjects;
    protected JCommander jc;
    private boolean isHelp;
    @NotNull
    public static final String DEFAULT_DELIMETER = " ";
    private static final Pattern CMD_SPLIT_PATTERN = Pattern.compile("\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|\\S+");

    public PulsarOptions(@NotNull String[] argv) {
        Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
        this.argv = argv;
        this.logger = LoggerFactory.getLogger(PulsarOptions.class);
        Companion.normalize(this.argv);
        this.expandAtSign = true;
        this.acceptUnknownOptions = true;
        this.allowParameterOverwriting = true;
        this.registeredObjects = new HashSet();
        Object[] objectArray = new Object[]{this};
        this.addObjects(objectArray);
    }

    @NotNull
    public final String[] getArgv() {
        return this.argv;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public final boolean getExpandAtSign() {
        return this.expandAtSign;
    }

    public final void setExpandAtSign(boolean bl) {
        this.expandAtSign = bl;
    }

    public final boolean getAcceptUnknownOptions() {
        return this.acceptUnknownOptions;
    }

    public final void setAcceptUnknownOptions(boolean bl) {
        this.acceptUnknownOptions = bl;
    }

    public final boolean getAllowParameterOverwriting() {
        return this.allowParameterOverwriting;
    }

    public final void setAllowParameterOverwriting(boolean bl) {
        this.allowParameterOverwriting = bl;
    }

    @NotNull
    public final String getArgs() {
        return ArraysKt.joinToString$default((Object[])this.argv, (CharSequence)DEFAULT_DELIMETER, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    protected final JCommander getJc() {
        JCommander jCommander = this.jc;
        if (jCommander != null) {
            return jCommander;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jc");
        return null;
    }

    protected final void setJc(@NotNull JCommander jCommander) {
        Intrinsics.checkNotNullParameter((Object)jCommander, (String)"<set-?>");
        this.jc = jCommander;
    }

    public boolean isHelp() {
        return this.isHelp;
    }

    public void setHelp(boolean bl) {
        this.isHelp = bl;
    }

    public PulsarOptions() {
        this(new String[0]);
    }

    public PulsarOptions(@NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = args;
        boolean bl = false;
        this(Companion.split(((Object)StringsKt.trim((CharSequence)string)).toString()));
    }

    public PulsarOptions(@NotNull Map<String, String> argv) {
        Intrinsics.checkNotNullParameter(argv, (String)"argv");
        this(CollectionsKt.joinToString$default((Iterable)argv.entrySet(), (CharSequence)DEFAULT_DELIMETER, null, null, (int)0, null, (Function1)1.INSTANCE, (int)30, null));
    }

    public final void setObjects(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.registeredObjects.clear();
        Object[] objectArray = new Object[]{objects};
        this.addObjects(objectArray);
    }

    public final void addObjects(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ArraysKt.toCollection((Object[])objects, (Collection)this.registeredObjects);
    }

    public boolean parse() {
        try {
            this.doParse();
        }
        catch (Throwable e) {
            this.logger.warn("Failed to parse \n" + this.getArgs(), e);
            return false;
        }
        return true;
    }

    public void parseOrExit() {
        boolean bl = false;
        this.parseOrExit(new LinkedHashSet());
    }

    protected void parseOrExit(@NotNull Set<? extends Object> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        try {
            Object[] objectArray = new Object[]{objects};
            this.addObjects(objectArray);
            this.doParse();
            if (this.isHelp()) {
                this.getJc().usage();
                int n = 0;
                boolean bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        catch (ParameterException e) {
            String string = e.toString();
            boolean bl = false;
            System.out.println((Object)string);
            int n = 0;
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void doParse() {
        this.registeredObjects.add(this);
        String[] stringArray = JCommander.newBuilder().acceptUnknownOptions(this.acceptUnknownOptions).allowParameterOverwriting(this.allowParameterOverwriting).expandAtSign(Boolean.valueOf(this.expandAtSign)).build();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"newBuilder()\n           \u2026ign(expandAtSign).build()");
        this.setJc((JCommander)stringArray);
        Iterable $this$forEach$iv = this.registeredObjects;
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv.iterator();
        while (stringArray2.hasNext()) {
            Object element$iv;
            Object it = element$iv = stringArray2.next();
            boolean bl = false;
            this.getJc().addObject(it);
        }
        stringArray = this.argv;
        boolean bl = false;
        stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            stringArray = this.argv;
            this.getJc().parse(Arrays.copyOf(stringArray, stringArray.length));
        }
    }

    public void usage() {
        this.getJc().usage();
    }

    @NotNull
    public String toCmdLine() {
        CharSequence charSequence = this.getParams().withKVDelimiter(DEFAULT_DELIMETER).formatAsLine();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"params.withKVDelimiter(\" \").formatAsLine()");
        charSequence = charSequence;
        String string = "\\s+";
        boolean bl = false;
        string = new Regex(string);
        String string2 = DEFAULT_DELIMETER;
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    @NotNull
    public Map<String, String> toArgsMap() {
        Map map2 = this.getParams().asStringMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"params.asStringMap()");
        return map2;
    }

    @NotNull
    public Map<String, String> toMutableArgsMap() {
        Map map2 = this.getParams().asStringMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"params.asStringMap()");
        return map2;
    }

    @NotNull
    public String[] toArgv() {
        CharSequence charSequence = this.getParams().withKVDelimiter(DEFAULT_DELIMETER).formatAsLine();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"params.withKVDelimiter(\" \").formatAsLine()");
        charSequence = charSequence;
        String string = "\\s+";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    public int hashCode() {
        return this.getArgs().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PulsarOptions && Intrinsics.areEqual((Object)this.getArgs(), (Object)((PulsarOptions)other).getArgs());
    }

    @NotNull
    public String toString() {
        return this.getArgs();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\tH\u0007J\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/common/options/PulsarOptions$Companion;", "", "()V", "CMD_SPLIT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getCMD_SPLIT_PATTERN", "()Ljava/util/regex/Pattern;", "DEFAULT_DELIMETER", "", "normalize", "", "argv", "", "([Ljava/lang/String;)V", "args", "seps", "split", "(Ljava/lang/String;)[Ljava/lang/String;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getCMD_SPLIT_PATTERN() {
            return CMD_SPLIT_PATTERN;
        }

        @JvmOverloads
        @NotNull
        public final String normalize(@NotNull String args, @NotNull String seps) {
            String args1;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)seps, (String)"seps");
            String string = args1 = StringUtils.replaceChars((String)args, (String)seps, (String)StringUtils.repeat((char)' ', (int)seps.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"args1");
            string = args1 = OptionUtils.INSTANCE.arity0ToArity1(string, "-cacheContent");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"args1");
            string = args1 = OptionUtils.INSTANCE.arity0ToArity1(string, "-storeContent");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"args1");
            return string;
        }

        public static /* synthetic */ String normalize$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = ",";
            }
            return companion.normalize(string, string2);
        }

        public final void normalize(@NotNull String[] argv) {
            Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
            int n = 0;
            int n2 = argv.length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    argv[i] = StringsKt.replace$default((String)StringsKt.replace$default((String)argv[i], (String)"%", (String)PulsarOptions.DEFAULT_DELIMETER, (boolean)false, (int)4, null), (String)"%20", (String)PulsarOptions.DEFAULT_DELIMETER, (boolean)false, (int)4, null);
                } while (n <= n2);
            }
        }

        @NotNull
        public final String[] split(@NotNull String args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Matcher matcher = this.getCMD_SPLIT_PATTERN().matcher(ai.platon.pulsar.common.options.PulsarOptions$Companion.normalize$default(this, args, null, 2, null));
            matcher.reset();
            ArrayList<String> result = new ArrayList<String>();
            while (matcher.find()) {
                result.add(matcher.group(0));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }

        @JvmOverloads
        @NotNull
        public final String normalize(@NotNull String args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return ai.platon.pulsar.common.options.PulsarOptions$Companion.normalize$default(this, args, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

