/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.context;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.context.PulsarContext;
import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.pulsar.context.support.AbstractPulsarContext;
import ai.platon.pulsar.context.support.BasicPulsarContext;
import ai.platon.pulsar.context.support.ClassPathXmlPulsarContext;
import ai.platon.pulsar.context.support.StaticPulsarContext;
import ai.platon.pulsar.session.PulsarSession;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\rH\u0007R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/context/PulsarContexts;", "", "()V", "<set-?>", "Lai/platon/pulsar/context/PulsarContext;", "activeContext", "getActiveContext", "()Lai/platon/pulsar/context/PulsarContext;", "contexts", "", "logger", "Lorg/slf4j/Logger;", "await", "", "create", "context", "contextLocation", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "createSession", "Lai/platon/pulsar/session/PulsarSession;", "shutdown", "pulsar-skeleton"})
public final class PulsarContexts {
    @NotNull
    public static final PulsarContexts INSTANCE = new PulsarContexts();
    @NotNull
    private static final Logger logger = LogsKt.getLogger((Object)INSTANCE);
    @NotNull
    private static final Set<PulsarContext> contexts;
    @Nullable
    private static PulsarContext activeContext;

    private PulsarContexts() {
    }

    @Nullable
    public final PulsarContext getActiveContext() {
        return activeContext;
    }

    @JvmStatic
    @NotNull
    public static final synchronized PulsarContext create() {
        if (activeContext == null) {
            activeContext = PulsarContexts.create(new StaticPulsarContext(null, 1, null));
        }
        PulsarContext pulsarContext = activeContext;
        Intrinsics.checkNotNull((Object)pulsarContext);
        return pulsarContext;
    }

    @JvmStatic
    @NotNull
    public static final synchronized PulsarContext create(@NotNull PulsarContext context) {
        AbstractApplicationContext abstractApplicationContext;
        AbstractPulsarContext abstractPulsarContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PulsarContext activated = activeContext;
        if (activated != null && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(activated.getClass()), (Object)Reflection.getOrCreateKotlinClass(context.getClass()))) {
            logger.info("Context is already activated | {}", (Object)Reflection.getOrCreateKotlinClass(activated.getClass()));
            return activated;
        }
        contexts.add(context);
        activeContext = context;
        AbstractPulsarContext abstractPulsarContext2 = abstractPulsarContext = context instanceof AbstractPulsarContext ? (AbstractPulsarContext)context : null;
        if (abstractPulsarContext != null && (abstractApplicationContext = abstractPulsarContext.getApplicationContext()) != null) {
            abstractApplicationContext.registerShutdownHook();
        }
        context.registerShutdownHook();
        logger.info("Active context | {}", (Object)CollectionsKt.joinToString$default((Iterable)contexts, null, null, null, (int)0, null, (Function1)create.1.INSTANCE, (int)31, null));
        return context;
    }

    @JvmStatic
    @NotNull
    public static final synchronized PulsarContext create(@NotNull String contextLocation) {
        Intrinsics.checkNotNullParameter((Object)contextLocation, (String)"contextLocation");
        return PulsarContexts.create(new ClassPathXmlPulsarContext(contextLocation));
    }

    @JvmStatic
    @NotNull
    public static final synchronized PulsarContext create(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return PulsarContexts.create(new BasicPulsarContext((AbstractApplicationContext)applicationContext));
    }

    @JvmStatic
    @NotNull
    public static final synchronized PulsarSession createSession() {
        return INSTANCE.create().createSession();
    }

    @JvmStatic
    public static final void await() {
        PulsarContext pulsarContext = activeContext;
        if (pulsarContext != null) {
            pulsarContext.await();
        }
    }

    @JvmStatic
    public static final synchronized void shutdown() {
        Iterable $this$forEach$iv = contexts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PulsarContext it = (PulsarContext)element$iv;
            boolean bl = false;
            it.close();
        }
        activeContext = null;
    }

    static {
        boolean bl = false;
        contexts = new LinkedHashSet();
    }
}

