/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Runtimes;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.chrono.TimersKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.measure.ByteUnitConverter;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.MultiMetric;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.component.LoadComponent;
import ai.platon.pulsar.crawl.component.ParseComponent;
import ai.platon.pulsar.crawl.fetch.UrlStat;
import ai.platon.pulsar.crawl.parse.html.JsoupParser;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.PageCategory;
import ai.platon.pulsar.persist.model.ActiveDOMStat;
import ai.platon.pulsar.session.AbstractPulsarSession;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.google.common.collect.ConcurrentHashMultiset;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.NetworkIF;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00a9\u00012\u00020\u00012\u00020\u0002:\u0002\u00a9\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u0010\u0010\u008a\u0001\u001a\u00020K2\u0007\u0010\u008b\u0001\u001a\u00020\u0010J\n\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\t\u0010\u008e\u0001\u001a\u00020\u0010H\u0002J\u0010\u0010\u008f\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\u0010\u0010\u0091\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\u0010\u0010\u0092\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\u0010\u0010\u0093\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\n\u0010\u0094\u0001\u001a\u00030\u0089\u0001H\u0002J\b\u0010\u0095\u0001\u001a\u00030\u0089\u0001J\u0011\u0010\u0095\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0096\u0001\u001a\u00020KJ\n\u0010\u0097\u0001\u001a\u00030\u0089\u0001H\u0002J\n\u0010\u0098\u0001\u001a\u00030\u0089\u0001H\u0002J\n\u0010\u0099\u0001\u001a\u00030\u0089\u0001H\u0002J\b\u0010\u009a\u0001\u001a\u00030\u0089\u0001J\n\u0010\u009b\u0001\u001a\u00030\u0089\u0001H\u0002J\u0011\u0010\u009c\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\u0018\u0010\u009d\u0001\u001a\u00030\u0089\u00012\u000e\u0010\u009e\u0001\u001a\t\u0012\u0004\u0012\u00020\u00100\u009f\u0001J\u001b\u0010\u00a0\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u00102\t\b\u0002\u0010\u00a1\u0001\u001a\u00020KJ\u0011\u0010\u00a2\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\u0012\u0010\u00a3\u0001\u001a\u00030\u0089\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001J\u0011\u0010\u00a6\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\n\u0010\u00a7\u0001\u001a\u00030\u0089\u0001H\u0002J\n\u0010\u00a8\u0001\u001a\u00030\u0089\u0001H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R5\u0010\"\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00100\u0010 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00100\u0010\u0018\u00010#0#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0012R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010+R\u0011\u00102\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010/R\u0019\u00104\u001a\n \u0019*\u0004\u0018\u00010505\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001b\u0010<\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b=\u0010\u0016R.\u0010B\u001a\n \u0019*\u0004\u0018\u00010A0A2\u000e\u0010@\u001a\n \u0019*\u0004\u0018\u00010A0A@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010F\u001a\n \u0019*\u0004\u0018\u00010A0A2\u000e\u0010@\u001a\n \u0019*\u0004\u0018\u00010A0A@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010DR\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020K\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u000e\u0010N\u001a\u00020KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010O\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010+R\u0011\u0010Q\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\rR\u0011\u0010S\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010+R\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0012R\u0011\u0010W\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u0016R\u0011\u0010Y\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u0016R\u0011\u0010[\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u0016R\u0011\u0010]\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010;R\u0011\u0010_\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010;R\u0011\u0010a\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010;R\u0011\u0010c\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010;R\u0011\u0010e\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010;R\u0011\u0010g\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\rR\u0011\u0010i\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\rR\u0011\u0010k\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010+R\u0011\u0010m\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bn\u0010\u0016R\u000e\u0010o\u001a\u00020pX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010q\u001a\u0004\u0018\u00010rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010s\u001a\n \u0019*\u0004\u0018\u00010A0A\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010DR\u0011\u0010u\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010+R\u0011\u0010w\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\bx\u0010/R\u000e\u0010y\u001a\u00020zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010{\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\u0012R\u001b\u0010}\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b~\u0010\u0016\"\u0005\b\u007f\u0010\u0080\u0001R\u0019\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0082\u0001\u0010\u0012R\"\u0010\u0083\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0005\u0012\u00030\u0085\u00010\u0084\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001\u00a8\u0006\u00aa\u0001"}, d2={"Lai/platon/pulsar/crawl/CoreMetrics;", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "contentPersists", "Lai/platon/pulsar/common/metrics/MultiMetric;", "getContentPersists", "()Lai/platon/pulsar/common/metrics/MultiMetric;", "deadUrls", "Ljava/util/concurrent/ConcurrentSkipListSet;", "", "getDeadUrls", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "elapsedSeconds", "", "getElapsedSeconds", "()J", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "enableReporter", "", "getEnableReporter", "()Z", "setEnableReporter", "(Z)V", "failedHosts", "Lcom/google/common/collect/ConcurrentHashMultiset;", "getFailedHosts", "()Lcom/google/common/collect/ConcurrentHashMultiset;", "failedUrls", "getFailedUrls", "fetchTasks", "Lcom/codahale/metrics/Meter;", "getFetchTasks", "()Lcom/codahale/metrics/Meter;", "fetchTasksPerSecond", "", "getFetchTasksPerSecond", "()F", "finishedFetchTasks", "getFinishedFetchTasks", "finishedFetchTasksPerSecond", "getFinishedFetchTasksPerSecond", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "getGroupMode", "()Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "histogramContentBytes", "Lcom/codahale/metrics/Histogram;", "getHistogramContentBytes", "()Lcom/codahale/metrics/Histogram;", "initNetworkIFsRecvBytes", "getInitNetworkIFsRecvBytes", "initNetworkIFsRecvBytes$delegate", "Lkotlin/Lazy;", "<set-?>", "Ljava/time/Instant;", "lastReportTime", "getLastReportTime", "()Ljava/time/Instant;", "lastSystemInfoRefreshTime", "lastTaskTime", "getLastTaskTime", "logger", "Lorg/slf4j/Logger;", "maxHostFailureEvents", "", "getMaxHostFailureEvents", "()I", "maxUrlLength", "meterContentBytes", "getMeterContentBytes", "meterContentMBytes", "getMeterContentMBytes", "meterTotalNetworkIFsRecvMBytes", "getMeterTotalNetworkIFsRecvMBytes", "movedUrls", "getMovedUrls", "networkIFsRecvBytes", "getNetworkIFsRecvBytes", "networkIFsRecvBytesPerPage", "getNetworkIFsRecvBytesPerPage", "networkIFsRecvBytesPerSecond", "getNetworkIFsRecvBytesPerSecond", "pageAnchors", "getPageAnchors", "pageHeights", "getPageHeights", "pageImages", "getPageImages", "pageNumbers", "getPageNumbers", "pageSmallTexts", "getPageSmallTexts", "persistContentMBytes", "getPersistContentMBytes", "persists", "getPersists", "proxies", "getProxies", "realTimeNetworkIFsRecvBytes", "getRealTimeNetworkIFsRecvBytes", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "reportTimer", "Ljava/util/Timer;", "startTime", "getStartTime", "successFetchTasks", "getSuccessFetchTasks", "successFetchTasksPerSecond", "getSuccessFetchTasksPerSecond", "systemInfo", "Loshi/SystemInfo;", "timeoutUrls", "getTimeoutUrls", "totalNetworkIFsRecvBytes", "getTotalNetworkIFsRecvBytes", "setTotalNetworkIFsRecvBytes", "(J)V", "unreachableHosts", "getUnreachableHosts", "urlStatistics", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/crawl/fetch/UrlStat;", "getUrlStatistics", "()Ljava/util/concurrent/ConcurrentHashMap;", "close", "", "countHostTasks", "host", "getParams", "Lai/platon/pulsar/common/config/Params;", "getSuccessReport", "isFailed", "url", "isReachable", "isTimeout", "isUnreachable", "logAvailableHosts", "markFetchTaskStart", "size", "reportSuccessTasks", "reportWhenHighThroughput", "reportWhenLowThroughput", "start", "startReporter", "trackFailedUrl", "trackFailedUrls", "urls", "", "trackHostUnreachable", "occurrences", "trackMoved", "trackSuccess", "page", "Lai/platon/pulsar/persist/WebPage;", "trackTimeout", "updateSystemInfo", "updateSystemInfo0", "Companion", "pulsar-skeleton"})
public final class CoreMetrics
implements Parameterized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MiscMessageWriter messageWriter;
    @NotNull
    private final Logger logger;
    private final URLUtil.GroupMode groupMode;
    private final int maxHostFailureEvents;
    @NotNull
    private final SystemInfo systemInfo;
    private int maxUrlLength;
    private final Instant startTime;
    @NotNull
    private final ConcurrentHashMap<String, UrlStat> urlStatistics;
    @NotNull
    private final ConcurrentSkipListSet<String> unreachableHosts;
    @NotNull
    private final ConcurrentSkipListSet<String> timeoutUrls;
    @NotNull
    private final ConcurrentSkipListSet<String> movedUrls;
    @NotNull
    private final ConcurrentSkipListSet<String> failedUrls;
    @NotNull
    private final ConcurrentSkipListSet<String> deadUrls;
    private final ConcurrentHashMultiset<String> failedHosts;
    @NotNull
    private final AppMetricRegistry registry;
    @NotNull
    private final Meter meterTotalNetworkIFsRecvMBytes;
    @NotNull
    private final Meter fetchTasks;
    @NotNull
    private final Meter successFetchTasks;
    @NotNull
    private final Meter finishedFetchTasks;
    @NotNull
    private final Meter proxies;
    @NotNull
    private final MultiMetric persists;
    @NotNull
    private final MultiMetric contentPersists;
    @NotNull
    private final MultiMetric meterContentMBytes;
    @NotNull
    private final MultiMetric persistContentMBytes;
    @NotNull
    private final Meter meterContentBytes;
    @NotNull
    private final Histogram histogramContentBytes;
    @NotNull
    private final Histogram pageImages;
    @NotNull
    private final Histogram pageAnchors;
    @NotNull
    private final Histogram pageNumbers;
    @NotNull
    private final Histogram pageSmallTexts;
    @NotNull
    private final Histogram pageHeights;
    @NotNull
    private final Lazy initNetworkIFsRecvBytes$delegate;
    private volatile long totalNetworkIFsRecvBytes;
    private boolean enableReporter;
    private Instant lastTaskTime;
    private Instant lastReportTime;
    private long lastSystemInfoRefreshTime;
    @Nullable
    private Timer reportTimer;
    @NotNull
    private final AtomicBoolean closed;
    private static int runningChromeProcesses;
    private static long usedMemory;

    public CoreMetrics(@NotNull MiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)messageWriter), (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.messageWriter = messageWriter;
        Logger logger = LoggerFactory.getLogger(CoreMetrics.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.groupMode = (URLUtil.GroupMode)conf.getEnum("partition.url.mode", (Enum)URLUtil.GroupMode.BY_HOST);
        this.maxHostFailureEvents = conf.getInt("fetch.max.host.failures", 20);
        this.systemInfo = new SystemInfo();
        this.maxUrlLength = conf.getInt("parse.max.url.length", 1024);
        this.startTime = Instant.now();
        this.urlStatistics = new ConcurrentHashMap();
        this.unreachableHosts = new ConcurrentSkipListSet();
        this.timeoutUrls = new ConcurrentSkipListSet();
        this.movedUrls = new ConcurrentSkipListSet();
        this.failedUrls = new ConcurrentSkipListSet();
        this.deadUrls = new ConcurrentSkipListSet();
        this.failedHosts = ConcurrentHashMultiset.create();
        this.registry = AppMetrics.Companion.getReg();
        this.meterTotalNetworkIFsRecvMBytes = this.registry.meter(this, "totalNetworkIFsRecvMBytes");
        this.fetchTasks = this.registry.meter(this, "fetchTasks");
        this.successFetchTasks = this.registry.meter(this, "successFetchTasks");
        this.finishedFetchTasks = this.registry.meter(this, "finishedFetchTasks");
        this.proxies = this.registry.meter(this, "proxies");
        this.persists = this.registry.multiMetric(this, "persists");
        this.contentPersists = this.registry.multiMetric(this, "contentPersists");
        this.meterContentMBytes = this.registry.multiMetric(this, "contentBytes");
        this.persistContentMBytes = this.registry.multiMetric(this, "persistContentMBytes");
        this.meterContentBytes = this.registry.meter(this, "contentBytes");
        this.histogramContentBytes = this.registry.histogram(this, "contentBytes");
        this.pageImages = this.registry.histogram(this, "pageImages");
        this.pageAnchors = this.registry.histogram(this, "pageAnchors");
        this.pageNumbers = this.registry.histogram(this, "pageNumbers");
        this.pageSmallTexts = this.registry.histogram(this, "pageSmallTexts");
        this.pageHeights = this.registry.histogram(this, "pageHeights");
        this.initNetworkIFsRecvBytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ CoreMetrics this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getRealTimeNetworkIFsRecvBytes();
            }
        }));
        this.enableReporter = true;
        this.lastTaskTime = Instant.EPOCH;
        this.lastReportTime = Instant.EPOCH;
        this.closed = new AtomicBoolean();
        boolean bl2 = false;
        try {
            object = Result.Companion;
            boolean bl3 = false;
            List<String> list = Files.readAllLines(AppPaths.INSTANCE.getPATH_UNREACHABLE_HOSTS());
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(PATH_UNREACHABLE_HOSTS)");
            ConcurrentSkipListSet concurrentSkipListSet = (ConcurrentSkipListSet)CollectionsKt.toCollection((Iterable)list, (Collection)this.getUnreachableHosts());
            boolean bl4 = false;
            object = Result.constructor-impl((Object)concurrentSkipListSet);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            this.logger.warn("[Unexpected]", it);
        }
        this.getParams().withLogger(this.logger).info(true);
    }

    public final URLUtil.GroupMode getGroupMode() {
        return this.groupMode;
    }

    public final int getMaxHostFailureEvents() {
        return this.maxHostFailureEvents;
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    public final long getElapsedSeconds() {
        return RangesKt.coerceAtLeast((long)this.getElapsedTime().getSeconds(), (long)1L);
    }

    @NotNull
    public final ConcurrentHashMap<String, UrlStat> getUrlStatistics() {
        return this.urlStatistics;
    }

    @NotNull
    public final ConcurrentSkipListSet<String> getUnreachableHosts() {
        return this.unreachableHosts;
    }

    @NotNull
    public final ConcurrentSkipListSet<String> getTimeoutUrls() {
        return this.timeoutUrls;
    }

    @NotNull
    public final ConcurrentSkipListSet<String> getMovedUrls() {
        return this.movedUrls;
    }

    @NotNull
    public final ConcurrentSkipListSet<String> getFailedUrls() {
        return this.failedUrls;
    }

    @NotNull
    public final ConcurrentSkipListSet<String> getDeadUrls() {
        return this.deadUrls;
    }

    public final ConcurrentHashMultiset<String> getFailedHosts() {
        return this.failedHosts;
    }

    @NotNull
    public final Meter getMeterTotalNetworkIFsRecvMBytes() {
        return this.meterTotalNetworkIFsRecvMBytes;
    }

    @NotNull
    public final Meter getFetchTasks() {
        return this.fetchTasks;
    }

    @NotNull
    public final Meter getSuccessFetchTasks() {
        return this.successFetchTasks;
    }

    @NotNull
    public final Meter getFinishedFetchTasks() {
        return this.finishedFetchTasks;
    }

    @NotNull
    public final Meter getProxies() {
        return this.proxies;
    }

    @NotNull
    public final MultiMetric getPersists() {
        return this.persists;
    }

    @NotNull
    public final MultiMetric getContentPersists() {
        return this.contentPersists;
    }

    @NotNull
    public final MultiMetric getMeterContentMBytes() {
        return this.meterContentMBytes;
    }

    @NotNull
    public final MultiMetric getPersistContentMBytes() {
        return this.persistContentMBytes;
    }

    @NotNull
    public final Meter getMeterContentBytes() {
        return this.meterContentBytes;
    }

    @NotNull
    public final Histogram getHistogramContentBytes() {
        return this.histogramContentBytes;
    }

    @NotNull
    public final Histogram getPageImages() {
        return this.pageImages;
    }

    @NotNull
    public final Histogram getPageAnchors() {
        return this.pageAnchors;
    }

    @NotNull
    public final Histogram getPageNumbers() {
        return this.pageNumbers;
    }

    @NotNull
    public final Histogram getPageSmallTexts() {
        return this.pageSmallTexts;
    }

    @NotNull
    public final Histogram getPageHeights() {
        return this.pageHeights;
    }

    /*
     * WARNING - void declaration
     */
    public final long getRealTimeNetworkIFsRecvBytes() {
        Iterable iterable = this.systemInfo.getHardware().getNetworkIFs();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"systemInfo.hardware.networkIFs");
        iterable = iterable;
        boolean bl = false;
        int n = 0;
        for (Object e : iterable) {
            void it;
            NetworkIF networkIF = (NetworkIF)e;
            int n2 = n;
            boolean bl2 = false;
            int n3 = (int)it.getBytesRecv();
            n = n2 + n3;
        }
        return RangesKt.coerceAtLeast((long)n, (long)0L);
    }

    public final long getInitNetworkIFsRecvBytes() {
        Lazy lazy = this.initNetworkIFsRecvBytes$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getTotalNetworkIFsRecvBytes() {
        return this.totalNetworkIFsRecvBytes;
    }

    public final void setTotalNetworkIFsRecvBytes(long l) {
        this.totalNetworkIFsRecvBytes = l;
    }

    public final long getNetworkIFsRecvBytes() {
        return RangesKt.coerceAtLeast((long)(this.totalNetworkIFsRecvBytes - this.getInitNetworkIFsRecvBytes()), (long)0L);
    }

    public final long getNetworkIFsRecvBytesPerSecond() {
        return this.getNetworkIFsRecvBytes() / this.getElapsedSeconds();
    }

    public final long getNetworkIFsRecvBytesPerPage() {
        return this.getNetworkIFsRecvBytes() / this.successFetchTasks.getCount();
    }

    public final float getFetchTasksPerSecond() {
        return (float)this.fetchTasks.getCount() / (float)this.getElapsedSeconds();
    }

    public final float getFinishedFetchTasksPerSecond() {
        return (float)this.finishedFetchTasks.getCount() / (float)this.getElapsedSeconds();
    }

    public final float getSuccessFetchTasksPerSecond() {
        return (float)this.successFetchTasks.getCount() / (float)this.getElapsedSeconds();
    }

    public final boolean getEnableReporter() {
        return this.enableReporter;
    }

    public final void setEnableReporter(boolean bl) {
        this.enableReporter = bl;
    }

    public final Instant getLastTaskTime() {
        return this.lastTaskTime;
    }

    public final Instant getLastReportTime() {
        return this.lastReportTime;
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"timeoutUrls", this.timeoutUrls.size(), "failedUrls", this.failedUrls.size(), "deadUrls", this.deadUrls.size()};
        Params params = Params.of((String)"maxUrlLength", (Object)this.maxUrlLength, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"maxUrlL\u2026, deadUrls.size\n        )");
        return params;
    }

    public final void start() {
        if (this.enableReporter) {
            this.startReporter();
        }
    }

    public final boolean isReachable(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return !this.isUnreachable(url);
    }

    public final boolean isUnreachable(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLUtil.GroupMode groupMode = this.groupMode;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)groupMode), (String)"groupMode");
        String string = URLUtil.INSTANCE.getHost(url, groupMode);
        if (string == null) {
            return true;
        }
        String host = string;
        return this.unreachableHosts.contains(host);
    }

    public final boolean isFailed(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.failedUrls.contains(url);
    }

    public final void trackFailedUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.failedUrls.add(url);
    }

    public final void trackFailedUrls(@NotNull Collection<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.failedUrls.addAll(urls);
    }

    public final boolean isTimeout(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.timeoutUrls.contains(url);
    }

    public final void markFetchTaskStart() {
        this.markFetchTaskStart(1);
    }

    public final void markFetchTaskStart(int size) {
        this.lastTaskTime = Instant.now();
        this.fetchTasks.mark((long)size);
    }

    public final void trackSuccess(@NotNull WebPage page) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String url = string;
        URLUtil.GroupMode groupMode = this.groupMode;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)groupMode), (String)"groupMode");
        String string2 = URLUtil.INSTANCE.getHost(url, groupMode);
        if (string2 == null) {
            throw new MalformedURLException(url);
        }
        String host = string2;
        this.unreachableHosts.remove(host);
        this.failedHosts.remove((Object)host);
        this.successFetchTasks.mark();
        this.finishedFetchTasks.mark();
        if (this.finishedFetchTasks.getCount() % (long)30 == 0L) {
            this.updateSystemInfo();
        }
        long bytes = page.getContentLength();
        this.histogramContentBytes.update(bytes);
        this.meterContentBytes.mark(bytes);
        this.meterContentMBytes.inc((long)ByteUnitConverter.INSTANCE.convert(bytes, "M"));
        ActiveDOMStat activeDOMStat = (ActiveDOMStat)page.getActiveDOMStatTrace().get("lastStat");
        if (activeDOMStat != null) {
            object = activeDOMStat;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$trackSuccess_u24lambda_u2d3 = object;
            boolean bl3 = false;
            this.getPageAnchors().update($this$trackSuccess_u24lambda_u2d3.getNa());
            this.getPageImages().update($this$trackSuccess_u24lambda_u2d3.getNi());
            this.getPageNumbers().update($this$trackSuccess_u24lambda_u2d3.getNnm());
            this.getPageSmallTexts().update($this$trackSuccess_u24lambda_u2d3.getNst());
            this.getPageHeights().update($this$trackSuccess_u24lambda_u2d3.getH());
        }
        object = this.urlStatistics.computeIfAbsent(host, CoreMetrics::trackSuccess$lambda-4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"urlStatistics.computeIfA\u2026ent(host) { UrlStat(it) }");
        UrlStat urlStats = (UrlStat)object;
        object = urlStats;
        ((UrlStat)object).setUrls(((UrlStat)object).getUrls() + 1);
        ((UrlStat)object).getUrls();
        object = urlStats;
        ((UrlStat)object).setPageViews(((UrlStat)object).getPageViews() + 1);
        ((UrlStat)object).getPageViews();
        Object object2 = page.getPageCategory();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.pageCategory");
        PageCategory pageCategory = object2;
        if (pageCategory.isIndex()) {
            object2 = urlStats;
            ((UrlStat)object2).setIndexUrls(((UrlStat)object2).getIndexUrls() + 1);
            ((UrlStat)object2).getIndexUrls();
        } else if (pageCategory.isDetail()) {
            object2 = urlStats;
            ((UrlStat)object2).setDetailUrls(((UrlStat)object2).getDetailUrls() + 1);
            ((UrlStat)object2).getDetailUrls();
        } else if (pageCategory.isMedia()) {
            object2 = urlStats;
            ((UrlStat)object2).setMediaUrls(((UrlStat)object2).getMediaUrls() + 1);
            ((UrlStat)object2).getMediaUrls();
        } else if (pageCategory.isSearch()) {
            object2 = urlStats;
            ((UrlStat)object2).setSearchUrls(((UrlStat)object2).getSearchUrls() + 1);
            ((UrlStat)object2).getSearchUrls();
        } else if (pageCategory.isBBS()) {
            object2 = urlStats;
            ((UrlStat)object2).setBbsUrls(((UrlStat)object2).getBbsUrls() + 1);
            ((UrlStat)object2).getBbsUrls();
        } else if (pageCategory.isTieBa()) {
            object2 = urlStats;
            ((UrlStat)object2).setTiebaUrls(((UrlStat)object2).getTiebaUrls() + 1);
            ((UrlStat)object2).getTiebaUrls();
        } else if (pageCategory.isBlog()) {
            object2 = urlStats;
            ((UrlStat)object2).setBlogUrls(((UrlStat)object2).getBlogUrls() + 1);
            ((UrlStat)object2).getBlogUrls();
        } else if (pageCategory.isUnknown()) {
            object2 = urlStats;
            ((UrlStat)object2).setUnknownUrls(((UrlStat)object2).getUnknownUrls() + 1);
            ((UrlStat)object2).getUnknownUrls();
        }
        int depth = page.getDistance();
        if (depth == 1) {
            UrlStat urlStat = urlStats;
            urlStat.setUrlsFromSeed(urlStat.getUrlsFromSeed() + 1);
            urlStat.getUrlsFromSeed();
        }
        if (url.length() > this.maxUrlLength) {
            UrlStat urlStat = urlStats;
            urlStat.setUrlsTooLong(urlStat.getUrlsTooLong() + 1);
            urlStat.getUrlsTooLong();
            this.messageWriter.debugLongUrls(url);
        }
        Map map2 = this.urlStatistics;
        boolean bl = false;
        map2.put(host, urlStats);
        if ((double)this.getFinishedFetchTasksPerSecond() > 0.5) {
            this.reportSuccessTasks();
        }
    }

    public final void trackTimeout(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.timeoutUrls.add(url);
    }

    public final void trackMoved(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.movedUrls.add(url);
    }

    public final boolean trackHostUnreachable(@NotNull String url, int occurrences) {
        String host;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Object object = this.groupMode;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupMode");
                host = URLUtil.INSTANCE.getHost(url, (URLUtil.GroupMode)((Object)object));
                if (host == null) break block6;
                object = host;
                boolean bl = false;
                if (!(object.length() == 0)) break block7;
            }
            this.logger.warn("Malformed url identified as gone | <{}>", (Object)url);
            return false;
        }
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)"amazon.com", (boolean)false, (int)2, null)) {
            return false;
        }
        if (this.unreachableHosts.contains(host)) {
            return false;
        }
        this.failedHosts.add((Object)host, occurrences);
        int failures = this.failedHosts.count((Object)host);
        if (failures > this.maxHostFailureEvents) {
            this.unreachableHosts.add(host);
            this.logger.info("Host unreachable | {} failures | {}", (Object)failures, (Object)host);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean trackHostUnreachable$default(CoreMetrics coreMetrics, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return coreMetrics.trackHostUnreachable(string, n);
    }

    public final int countHostTasks(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        int failedTasks = this.failedHosts.count((Object)host);
        UrlStat urlStat = this.urlStatistics.get(host);
        if (urlStat == null) {
            return failedTasks;
        }
        UrlStat urlStat2 = urlStat;
        int numUrls = urlStat2.component2();
        return numUrls + failedTasks;
    }

    private final String getSuccessReport() {
        if (this.successFetchTasks.getCount() == 0L) {
            return "";
        }
        long seconds = RangesKt.coerceAtLeast((long)this.getElapsedSeconds(), (long)1L);
        long count = RangesKt.coerceAtLeast((long)this.successFetchTasks.getCount(), (long)1L);
        long bytes = this.meterContentBytes.getCount();
        String proxyFmt = this.proxies.getCount() > 0L ? " using %s proxies" : "";
        String format = "Fetched %d pages in %s(%.2f pages/s) successfully" + proxyFmt + " | content: %s, %s/s, %s/p";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[11];
        objectArray[0] = count;
        Duration duration = this.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"elapsedTime");
        objectArray[1] = DateTimesKt.readable((Duration)duration);
        objectArray[2] = this.successFetchTasks.getMeanRate();
        objectArray[3] = this.proxies.getCount();
        objectArray[4] = Strings.readableBytes((long)bytes);
        objectArray[5] = Strings.readableBytes((long)(bytes / seconds));
        objectArray[6] = Strings.readableBytes((long)(bytes / count));
        objectArray[7] = Strings.readableBytes((long)this.getNetworkIFsRecvBytes());
        objectArray[8] = Strings.readableBytes((long)this.getNetworkIFsRecvBytesPerSecond());
        objectArray[9] = Strings.readableBytes((long)this.getNetworkIFsRecvBytesPerPage());
        objectArray[10] = Strings.readableBytes((long)this.totalNetworkIFsRecvBytes);
        boolean bl = false;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        return string;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object object = this.reportTimer;
            if (object != null) {
                ((Timer)object).cancel();
            }
            this.reportTimer = null;
            if (this.successFetchTasks.getCount() > 0L) {
                this.logger.info(this.getSuccessReport());
            }
            if (this.fetchTasks.getCount() > 0L) {
                this.logAvailableHosts();
            }
            object = this.unreachableHosts;
            boolean bl = false;
            if (!object.isEmpty()) {
                this.logger.debug("There are " + this.unreachableHosts.size() + " unreachable hosts");
                AppFiles.INSTANCE.logUnreachableHosts((Collection)this.unreachableHosts);
            }
        }
    }

    private final void updateSystemInfo() {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                this.updateSystemInfo0();
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("[Unexpected]", it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSystemInfo0() throws Exception {
        int n;
        long currentTimeMillis = System.currentTimeMillis();
        if (Duration.ofMillis(currentTimeMillis - this.lastSystemInfoRefreshTime).getSeconds() < 60L) {
            return;
        }
        this.lastSystemInfoRefreshTime = currentTimeMillis;
        Iterable iterable = this.systemInfo.getHardware().getNetworkIFs();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"systemInfo.hardware.networkIFs");
        iterable = iterable;
        CoreMetrics coreMetrics = this;
        boolean bl = false;
        int n2 = 0;
        for (Object e : iterable) {
            void it;
            NetworkIF networkIF = (NetworkIF)e;
            n = n2;
            boolean bl2 = false;
            int n3 = (int)it.getBytesRecv();
            n2 = n + n3;
        }
        n = n2;
        coreMetrics.totalNetworkIFsRecvBytes = RangesKt.coerceAtLeast((long)n, (long)this.totalNetworkIFsRecvBytes);
        this.meterTotalNetworkIFsRecvMBytes.mark(this.totalNetworkIFsRecvBytes / (long)1024 / (long)1024);
        runningChromeProcesses = Runtimes.INSTANCE.countSystemProcess("chrome");
        usedMemory = this.systemInfo.getHardware().getMemory().getTotal() - this.systemInfo.getHardware().getMemory().getAvailable();
    }

    private final void startReporter() {
        if (this.reportTimer == null) {
            this.reportTimer = new Timer("CoreMetrics", true);
            Duration delay = Duration.ofMinutes(1L);
            Timer timer = this.reportTimer;
            if (timer != null) {
                Intrinsics.checkNotNullExpressionValue((Object)delay, (String)"delay");
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
                TimersKt.scheduleAtFixedRate((Timer)timer, (Duration)delay, (Duration)duration, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ CoreMetrics this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        CoreMetrics.access$reportSuccessTasks(this.this$0);
                    }
                }));
            }
        }
    }

    private final void reportSuccessTasks() {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (this.successFetchTasks.getCount() == 0L) {
            return;
        }
        Instant now = Instant.now();
        if (Duration.between(this.lastReportTime, now).getSeconds() < 60L) {
            return;
        }
        this.lastReportTime = Instant.now();
        if ((double)this.getFinishedFetchTasksPerSecond() > 0.5) {
            this.reportWhenHighThroughput();
        } else {
            this.reportWhenLowThroughput();
        }
    }

    private final void reportWhenLowThroughput() {
        Instant now = Instant.now();
        if (Duration.between(this.lastTaskTime, now).getSeconds() > 480L) {
            return;
        }
        this.logger.info(this.getSuccessReport());
    }

    private final void reportWhenHighThroughput() {
        long i = this.finishedFetchTasks.getCount();
        float a = this.getSuccessFetchTasksPerSecond() * (float)60;
        int period = 10 + (int)(i < 100L ? a / (float)3 : (i < 10000L ? a : a * (float)2 + (float)((long)60 * (i % (long)3 - 1L))));
        if (i % (long)period == 0L) {
            this.logger.info(this.getSuccessReport());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logAvailableHosts() {
        void $this$mapTo$iv$iv;
        StringBuilder report2 = new StringBuilder("Total " + this.urlStatistics.size() + " available hosts");
        report2.append('\n');
        Collection<UrlStat> collection = this.urlStatistics.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"urlStatistics.values");
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)collection);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void $dstr$hostName$urls$indexUrls$detailUrls;
            UrlStat urlStat = (UrlStat)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String hostName = $dstr$hostName$urls$indexUrls$detailUrls.component1();
            int urls = $dstr$hostName$urls$indexUrls$detailUrls.component2();
            int indexUrls = $dstr$hostName$urls$indexUrls$detailUrls.component3();
            int detailUrls = $dstr$hostName$urls$indexUrls$detailUrls.component4();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%40s -> %-15s %-15s %-15s";
            Object[] objectArray = new Object[]{hostName, "total : " + urls, "index : " + indexUrls, "detail : " + detailUrls};
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            collection2.add(string);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)report2, (CharSequence)"\n", null, null, (int)0, null, (Function1)logAvailableHosts.2.INSTANCE, (int)60, null);
        this.logger.info(report2.toString());
    }

    private static final UrlStat trackSuccess$lambda-4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new UrlStat(it, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8190, null);
    }

    private static final String _init_$lambda-9() {
        return AppContext.INSTANCE.getAPP_VERSION();
    }

    private static final Integer _init_$lambda-10() {
        return runningChromeProcesses;
    }

    private static final String _init_$lambda-11() {
        return Strings.readableBytes((long)usedMemory);
    }

    private static final AtomicLong _init_$lambda-12() {
        return AbstractPulsarSession.Companion.getPageCacheHits();
    }

    private static final Double _init_$lambda-13() {
        return 1.0 * (double)AbstractPulsarSession.Companion.getPageCacheHits().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final AtomicLong _init_$lambda-14() {
        return AbstractPulsarSession.Companion.getDocumentCacheHits();
    }

    private static final Double _init_$lambda-15() {
        return 1.0 * (double)AbstractPulsarSession.Companion.getDocumentCacheHits().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final Integer _init_$lambda-16() {
        return ParseComponent.Companion.getNumParses().get();
    }

    private static final Double _init_$lambda-17() {
        return 1.0 * (double)ParseComponent.Companion.getNumParses().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final Integer _init_$lambda-18() {
        return JsoupParser.Companion.getNumJsoupParses().get();
    }

    private static final Double _init_$lambda-19() {
        return 1.0 * (double)JsoupParser.Companion.getNumJsoupParses().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final AtomicLong _init_$lambda-20() {
        return LoadComponent.Companion.getPageCacheHits();
    }

    private static final Double _init_$lambda-21() {
        return 1.0 * (double)LoadComponent.Companion.getPageCacheHits().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final AtomicLong _init_$lambda-22() {
        return LoadComponent.Companion.getDbGetCount();
    }

    private static final Double _init_$lambda-23() {
        return 1.0 * (double)LoadComponent.Companion.getDbGetCount().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final AtomicLong _init_$lambda-24() {
        return WebDb.Companion.getDbGetCount();
    }

    private static final Double _init_$lambda-25() {
        return 1.0 * (double)WebDb.Companion.getDbGetCount().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final Long _init_$lambda-26() {
        return WebDb.Companion.getDbGetAveMillis();
    }

    private static final AtomicLong _init_$lambda-27() {
        return WebDb.Companion.getDbPutCount();
    }

    private static final Double _init_$lambda-28() {
        return 1.0 * (double)WebDb.Companion.getDbPutCount().get() / (double)DateTimes.INSTANCE.elapsedSeconds();
    }

    private static final Long _init_$lambda-29() {
        return WebDb.Companion.getDbPutAveMillis();
    }

    public static final /* synthetic */ void access$reportSuccessTasks(CoreMetrics $this) {
        $this.reportSuccessTasks();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", CoreMetrics::_init_$lambda-9), TuplesKt.to((Object)"runningChromeProcesses", CoreMetrics::_init_$lambda-10), TuplesKt.to((Object)"usedMemory", CoreMetrics::_init_$lambda-11), TuplesKt.to((Object)"pulsarSessionPageCacheHits", CoreMetrics::_init_$lambda-12), TuplesKt.to((Object)"pulsarSessionPageCacheHits/s", CoreMetrics::_init_$lambda-13), TuplesKt.to((Object)"pulsarSessionDocumentCacheHits", CoreMetrics::_init_$lambda-14), TuplesKt.to((Object)"pulsarSessionDocumentCacheHits/s", CoreMetrics::_init_$lambda-15), TuplesKt.to((Object)"parses", CoreMetrics::_init_$lambda-16), TuplesKt.to((Object)"parses/s", CoreMetrics::_init_$lambda-17), TuplesKt.to((Object)"jsoupParses", CoreMetrics::_init_$lambda-18), TuplesKt.to((Object)"jsoupParses/s", CoreMetrics::_init_$lambda-19), TuplesKt.to((Object)"loadCompPageCacheHits", CoreMetrics::_init_$lambda-20), TuplesKt.to((Object)"loadCompPageCacheHits/s", CoreMetrics::_init_$lambda-21), TuplesKt.to((Object)"loadCompDbGets", CoreMetrics::_init_$lambda-22), TuplesKt.to((Object)"loadCompDbGets/s", CoreMetrics::_init_$lambda-23), TuplesKt.to((Object)"dbGets", CoreMetrics::_init_$lambda-24), TuplesKt.to((Object)"dbGets/s", CoreMetrics::_init_$lambda-25), TuplesKt.to((Object)"dbGetAveMillis", CoreMetrics::_init_$lambda-26), TuplesKt.to((Object)"dbPuts", CoreMetrics::_init_$lambda-27), TuplesKt.to((Object)"dbPuts/s", CoreMetrics::_init_$lambda-28), TuplesKt.to((Object)"dbPutAveMillis", CoreMetrics::_init_$lambda-29)};
        Map $this$forEach$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            AppMetrics.Companion.getReg().register(Companion, (String)it.getKey(), (Metric)it.getValue());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/crawl/CoreMetrics$Companion;", "", "()V", "runningChromeProcesses", "", "getRunningChromeProcesses", "()I", "setRunningChromeProcesses", "(I)V", "usedMemory", "", "getUsedMemory", "()J", "setUsedMemory", "(J)V", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRunningChromeProcesses() {
            return runningChromeProcesses;
        }

        public final void setRunningChromeProcesses(int n) {
            runningChromeProcesses = n;
        }

        public final long getUsedMemory() {
            return usedMemory;
        }

        public final void setUsedMemory(long l) {
            usedMemory = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

