/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.common;

import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\t\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\u0011\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/crawl/common/FetchingCache;", "", "()V", "fetchingUrls", "Ljava/util/concurrent/ConcurrentSkipListSet;", "", "add", "", "url", "addAll", "urls", "", "clear", "contains", "", "isFetching", "remove", "removeAll", "pulsar-skeleton"})
public final class FetchingCache {
    @NotNull
    private final ConcurrentSkipListSet<String> fetchingUrls = new ConcurrentSkipListSet();

    public final boolean isFetching(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.fetchingUrls.contains(url);
    }

    public final void add(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.fetchingUrls.add(url);
    }

    public final void addAll(@NotNull Iterable<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        CollectionsKt.addAll((Collection)this.fetchingUrls, urls);
    }

    public final void remove(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.fetchingUrls.remove(url);
    }

    public final void removeAll(@NotNull Iterable<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        CollectionsKt.removeAll((Collection)this.fetchingUrls, urls);
    }

    public final void clear() {
        this.fetchingUrls.clear();
    }

    public final boolean contains(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.fetchingUrls.contains(url);
    }
}

