/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.common;

import ai.platon.pulsar.common.collect.ConcurrentUrlPool;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.common.FetchingCache;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0016\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\bj\u0002`\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lai/platon/pulsar/crawl/common/GlobalCache;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "documentCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/pulsar/dom/FeaturedDocument;", "Lai/platon/pulsar/crawl/common/DocumentCatch;", "getDocumentCache", "()Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "documentCacheCapacity", "", "fetchingCache", "Lai/platon/pulsar/crawl/common/FetchingCache;", "getFetchingCache", "()Lai/platon/pulsar/crawl/common/FetchingCache;", "pageCache", "Lai/platon/pulsar/persist/WebPage;", "Lai/platon/pulsar/crawl/common/PageCatch;", "getPageCache", "pageCacheCapacity", "urlPool", "Lai/platon/pulsar/common/collect/UrlPool;", "getUrlPool", "()Lai/platon/pulsar/common/collect/UrlPool;", "setUrlPool", "(Lai/platon/pulsar/common/collect/UrlPool;)V", "clearCaches", "", "clearPDCaches", "putPDCache", "page", "document", "removePDCache", "url", "resetCaches", "pulsar-skeleton"})
public class GlobalCache {
    @NotNull
    private final ImmutableConfig conf;
    private final int pageCacheCapacity;
    private final int documentCacheCapacity;
    @NotNull
    private UrlPool urlPool;
    @NotNull
    private final FetchingCache fetchingCache;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, WebPage> pageCache;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, FeaturedDocument> documentCache;

    /*
     * WARNING - void declaration
     */
    public GlobalCache(@NotNull ImmutableConfig conf) {
        void $this$urlPool_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.pageCacheCapacity = this.conf.getUint("global.page.cache.size", 200);
        this.documentCacheCapacity = this.conf.getUint("global.document.cache.size", 200);
        ConcurrentUrlPool concurrentUrlPool = new ConcurrentUrlPool(this.conf);
        boolean bl = false;
        boolean bl2 = false;
        ConcurrentUrlPool concurrentUrlPool2 = concurrentUrlPool;
        GlobalCache globalCache = this;
        boolean bl3 = false;
        $this$urlPool_u24lambda_u2d0.initialize();
        Unit unit = Unit.INSTANCE;
        globalCache.urlPool = (UrlPool)concurrentUrlPool;
        this.fetchingCache = new FetchingCache();
        this.pageCache = new ConcurrentExpiringLRUCache(null, this.pageCacheCapacity, 1, null);
        this.documentCache = new ConcurrentExpiringLRUCache(null, this.documentCacheCapacity, 1, null);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public UrlPool getUrlPool() {
        return this.urlPool;
    }

    public void setUrlPool(@NotNull UrlPool urlPool) {
        Intrinsics.checkNotNullParameter((Object)urlPool, (String)"<set-?>");
        this.urlPool = urlPool;
    }

    @NotNull
    public FetchingCache getFetchingCache() {
        return this.fetchingCache;
    }

    @NotNull
    public ConcurrentExpiringLRUCache<String, WebPage> getPageCache() {
        return this.pageCache;
    }

    @NotNull
    public ConcurrentExpiringLRUCache<String, FeaturedDocument> getDocumentCache() {
        return this.documentCache;
    }

    /*
     * WARNING - void declaration
     */
    public final void resetCaches() {
        void $this$resetCaches_u24lambda_u2d1;
        this.getFetchingCache().clear();
        this.getPageCache().clear();
        this.getDocumentCache().clear();
        ConcurrentUrlPool concurrentUrlPool = new ConcurrentUrlPool(this.conf);
        boolean bl = false;
        boolean bl2 = false;
        ConcurrentUrlPool concurrentUrlPool2 = concurrentUrlPool;
        GlobalCache globalCache = this;
        boolean bl3 = false;
        $this$resetCaches_u24lambda_u2d1.initialize();
        Unit unit = Unit.INSTANCE;
        globalCache.setUrlPool((UrlPool)concurrentUrlPool);
    }

    public final void clearCaches() {
        this.getFetchingCache().clear();
        this.getPageCache().clear();
        this.getDocumentCache().clear();
        this.getUrlPool().clear();
    }

    public final void clearPDCaches() {
        this.getPageCache().clear();
        this.getDocumentCache().clear();
    }

    public final void putPDCache(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String url = string;
        ConcurrentExpiringLRUCache.putDatum$default(this.getPageCache(), (Object)url, (Object)page, (long)0L, (int)4, null);
        ConcurrentExpiringLRUCache.putDatum$default(this.getDocumentCache(), (Object)url, (Object)document, (long)0L, (int)4, null);
    }

    public final void removePDCache(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.getPageCache().remove((Object)url);
        this.getDocumentCache().remove((Object)url);
    }
}

