/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.common;

import ai.platon.pulsar.common.domain.DomainSuffix;
import ai.platon.pulsar.common.domain.DomainSuffixes;
import ai.platon.pulsar.common.urls.UrlUtils;
import java.net.IDN;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u000f\u001a\u00020\tJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u001c\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010J\u001a\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\tJ\u0014\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0007J\u0014\u0010#\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lai/platon/pulsar/crawl/common/URLUtil;", "", "()V", "IP_REGEX", "Lkotlin/text/Regex;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "chooseRepr", "", "src", "dst", "temp", "", "getDomainName", "url", "Ljava/net/URL;", "defaultDomain", "getDomainSuffix", "Lai/platon/pulsar/common/domain/DomainSuffix;", "tlds", "Lai/platon/pulsar/common/domain/DomainSuffixes;", "getHost", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "defaultHost", "getHostBatches", "", "getHostName", "defaultValue", "getQuery", "isSameDomainName", "url1", "url2", "toASCII", "toUNICODE", "GroupMode", "pulsar-skeleton"})
public final class URLUtil {
    @NotNull
    public static final URLUtil INSTANCE = new URLUtil();
    private static final Logger logger = LoggerFactory.getLogger(URLUtil.class);
    @NotNull
    private static final Regex IP_REGEX = new Regex("(\\d{1,3}\\.){3}(\\d{1,3})");

    private URLUtil() {
    }

    @Nullable
    public final String getHost(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL uRL = UrlUtils.getURLOrNull((String)url);
        if (uRL == null) {
            return null;
        }
        URL u = uRL;
        return this.getHost(u, GroupMode.BY_HOST);
    }

    @Nullable
    public final String getHost(@NotNull String url, @NotNull GroupMode groupMode) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
        URL uRL = UrlUtils.getURLOrNull((String)url);
        if (uRL == null) {
            return null;
        }
        URL u = uRL;
        return this.getHost(u, groupMode);
    }

    @NotNull
    public final String getHost(@NotNull String url, @NotNull String defaultHost, @NotNull GroupMode groupMode) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)defaultHost, (String)"defaultHost");
        Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
        CharSequence charSequence = this.getHost(url, groupMode);
        if (charSequence == null) {
            return defaultHost;
        }
        String host = charSequence;
        charSequence = host;
        boolean bl = false;
        return charSequence.length() == 0 ? defaultHost : host;
    }

    @NotNull
    public final String getHost(@NotNull URL url, @NotNull String defaultHost, @NotNull GroupMode groupMode) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)defaultHost, (String)"defaultHost");
        Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
        CharSequence charSequence = this.getHost(url, groupMode);
        if (charSequence == null) {
            return defaultHost;
        }
        String host = charSequence;
        charSequence = host;
        boolean bl = false;
        return charSequence.length() == 0 ? defaultHost : host;
    }

    @Nullable
    public final String getHost(@NotNull URL url, @NotNull GroupMode groupMode) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
        String host = null;
        if (groupMode == GroupMode.BY_IP) {
            String string;
            try {
                InetAddress addr = InetAddress.getByName(url.getHost());
                string = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.warn("Unable to resolve: " + url.getHost() + ", skipping.");
                return "";
            }
            host = string;
        } else if (groupMode == GroupMode.BY_DOMAIN) {
            host = this.getDomainName(url);
            if (host == null) {
                logger.warn("Unknown domain for url: " + url + ", using URL string as key");
                host = url.toExternalForm();
            }
        } else {
            host = url.getHost();
            if (host == null) {
                logger.warn("Unknown host for url: " + url + ", using URL string as key");
                host = url.toExternalForm();
            }
        }
        return host;
    }

    @NotNull
    public final String getDomainName(@NotNull URL url) {
        String host;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DomainSuffixes tlds = DomainSuffixes.getInstance();
        String string = host = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        if (StringsKt.endsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) {
            string = host;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
            int n = 0;
            int n2 = host.length() - 1;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            host = string2;
        }
        string = host;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        if (IP_REGEX.matches((CharSequence)string)) {
            string = host;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
            return string;
        }
        int index = 0;
        String candidate = host;
        while (index >= 0) {
            String subCandidate;
            String string3 = candidate;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"candidate");
            index = StringsKt.indexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string4 = candidate;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"candidate");
            int n = index + 1;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            if (tlds.isDomainSuffix(subCandidate)) {
                string4 = candidate;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"candidate");
                return string4;
            }
            candidate = subCandidate;
        }
        String string5 = candidate;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"candidate");
        return string5;
    }

    @Nullable
    public final String getDomainName(@NotNull String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getDomainName(new URL(url));
    }

    @NotNull
    public final String getDomainName(@NotNull String url, @NotNull String defaultDomain) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)defaultDomain, (String)"defaultDomain");
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            String string = INSTANCE.getDomainName(url);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        String string = (String)(Result.isFailure-impl((Object)companion) ? null : companion);
        return string == null ? defaultDomain : string;
    }

    public final boolean isSameDomainName(@NotNull URL url1, @NotNull URL url2) {
        Intrinsics.checkNotNullParameter((Object)url1, (String)"url1");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url2");
        return StringsKt.equals((String)this.getDomainName(url1), (String)this.getDomainName(url2), (boolean)true);
    }

    public final boolean isSameDomainName(@Nullable String url1, @Nullable String url2) throws MalformedURLException {
        return this.isSameDomainName(new URL(url1), new URL(url2));
    }

    @Nullable
    public final DomainSuffix getDomainSuffix(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DomainSuffixes domainSuffixes = DomainSuffixes.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)domainSuffixes, (String)"getInstance()");
        return this.getDomainSuffix(domainSuffixes, url);
    }

    @Nullable
    public final DomainSuffix getDomainSuffix(@NotNull DomainSuffixes tlds, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)tlds, (String)"tlds");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
        if (IP_REGEX.matches((CharSequence)host)) {
            return null;
        }
        int index = 0;
        String candidate = host;
        while (index >= 0) {
            String subCandidate;
            String string = candidate;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"candidate");
            index = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string2 = candidate;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"candidate");
            int n = index + 1;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            DomainSuffix d = tlds.get(subCandidate);
            if (d != null) {
                return d;
            }
            candidate = subCandidate;
        }
        return null;
    }

    @Nullable
    public final DomainSuffix getDomainSuffix(@NotNull DomainSuffixes tlds, @Nullable String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)tlds, (String)"tlds");
        return this.getDomainSuffix(tlds, new URL(url));
    }

    @NotNull
    public final List<String> getHostBatches(@NotNull URL url) {
        List list;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
        if (IP_REGEX.matches((CharSequence)host)) {
            list = CollectionsKt.listOf((Object)host);
        } else {
            String[] stringArray = new String[]{"."};
            list = StringsKt.split$default((CharSequence)host, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        return list;
    }

    @NotNull
    public final List<String> getHostBatches(@NotNull String url) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getHostBatches(new URL(url));
    }

    @JvmStatic
    @NotNull
    public static final String chooseRepr(@NotNull String src, @NotNull String dst, boolean temp) {
        String string;
        boolean destRoot;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        URL srcUrl = null;
        URL dstUrl = null;
        try {
            srcUrl = new URL(src);
            dstUrl = new URL(dst);
        }
        catch (MalformedURLException e) {
            return dst;
        }
        String srcDomain = INSTANCE.getDomainName(srcUrl);
        String dstDomain = INSTANCE.getDomainName(dstUrl);
        String srcHost = srcUrl.getHost();
        String dstHost = dstUrl.getHost();
        String srcFile = srcUrl.getFile();
        String dstFile = dstUrl.getFile();
        boolean srcRoot = Intrinsics.areEqual((Object)srcFile, (Object)"/") || srcFile.length() == 0;
        boolean bl = destRoot = Intrinsics.areEqual((Object)dstFile, (Object)"/") || dstFile.length() == 0;
        if (!Intrinsics.areEqual((Object)srcDomain, (Object)dstDomain)) {
            return dst;
        }
        if (!temp) {
            string = srcRoot ? src : dst;
        } else if (srcRoot && !destRoot) {
            string = src;
        } else if (!srcRoot && destRoot) {
            string = dst;
        } else if (!srcRoot && !destRoot && Intrinsics.areEqual((Object)srcHost, (Object)dstHost)) {
            Intrinsics.checkNotNullExpressionValue((Object)srcFile, (String)"srcFile");
            String[] stringArray = new String[]{"/"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)srcFile, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int numSrcPaths = stringArray2.length;
            Intrinsics.checkNotNullExpressionValue((Object)dstFile, (String)"dstFile");
            String[] $i$f$toTypedArray22 = new String[]{"/"};
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)dstFile, (String[])$i$f$toTypedArray22, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int numDstPaths = stringArray3.length;
            if (numSrcPaths != numDstPaths) {
                string = numDstPaths < numSrcPaths ? dst : src;
            } else {
                int srcPathLength = srcFile.length();
                int dstPathLength = dstFile.length();
                string = dstPathLength < srcPathLength ? dst : src;
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)srcHost, (String)"srcHost");
            String[] numDstPaths = new String[]{"\\."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)srcHost, (String[])numDstPaths, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray32 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int numSrcSubs = stringArray.length;
            Intrinsics.checkNotNullExpressionValue((Object)dstHost, (String)"dstHost");
            String[] $i$f$toTypedArray32 = new String[]{"\\."};
            Collection $this$toTypedArray$iv3 = StringsKt.split$default((CharSequence)dstHost, (String[])$i$f$toTypedArray32, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv3 = $this$toTypedArray$iv3;
            String[] stringArray4 = thisCollection$iv3.toArray(new String[0]);
            if (stringArray4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int numDstSubs = stringArray4.length;
            string = numDstSubs < numSrcSubs ? dst : src;
        }
        return string;
    }

    @Nullable
    public final String getHostName(@Nullable String url) {
        String string;
        try {
            string = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URL(url).host");
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            string = string2;
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String getHostName(@Nullable String url, @NotNull String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            string = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URL(url).host");
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            string = string2;
        }
        catch (MalformedURLException e) {
            string = defaultValue;
        }
        return string;
    }

    @Nullable
    public final String getQuery(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String url2 = url;
        try {
            string = url2;
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            url2 = string2;
            String queryStr = new URL(url2).getQuery();
            string = queryStr != null ? StringsKt.replace$default((String)url2, (String)("?" + queryStr), (String)"", (boolean)false, (int)4, null) : url2;
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String toASCII(@Nullable String url) {
        String string;
        try {
            String host;
            URL u;
            block5: {
                block4: {
                    u = new URL(url);
                    host = u.getHost();
                    if (host == null) break block4;
                    CharSequence charSequence = host;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block5;
                }
                return url;
            }
            URI p = new URI(u.getProtocol(), u.getUserInfo(), IDN.toASCII(host), u.getPort(), u.getPath(), u.getQuery(), u.getRef());
            string = p.toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String toUNICODE(@Nullable String url) {
        String string;
        try {
            String host;
            URL u;
            block9: {
                block8: {
                    u = new URL(url);
                    host = u.getHost();
                    if (host == null) break block8;
                    CharSequence charSequence = host;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block9;
                }
                return url;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(u.getProtocol());
            sb.append("://");
            if (u.getUserInfo() != null) {
                sb.append(u.getUserInfo());
                sb.append('@');
            }
            sb.append(IDN.toUnicode(host));
            if (u.getPort() != -1) {
                sb.append(':');
                sb.append(u.getPort());
            }
            sb.append(u.getFile());
            if (u.getRef() != null) {
                sb.append('#');
                sb.append(u.getRef());
            }
            string = sb.toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "", "(Ljava/lang/String;I)V", "BY_IP", "BY_DOMAIN", "BY_HOST", "pulsar-skeleton"})
    public static final class GroupMode
    extends Enum<GroupMode> {
        public static final /* enum */ GroupMode BY_IP = new GroupMode();
        public static final /* enum */ GroupMode BY_DOMAIN = new GroupMode();
        public static final /* enum */ GroupMode BY_HOST = new GroupMode();
        private static final /* synthetic */ GroupMode[] $VALUES;

        public static GroupMode[] values() {
            return (GroupMode[])$VALUES.clone();
        }

        public static GroupMode valueOf(String value) {
            return Enum.valueOf(GroupMode.class, value);
        }

        static {
            $VALUES = groupModeArray = new GroupMode[]{GroupMode.BY_IP, GroupMode.BY_DOMAIN, GroupMode.BY_HOST};
        }
    }
}

