/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.common;

import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.WebPageExt;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00030\u00030\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0003J\u001c\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0014\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eJ\u001c\u0010 \u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0014\u0010 \u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015J \u0010%\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J&\u0010(\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/platon/pulsar/crawl/common/WeakPageIndexer;", "", "homeUrl", "", "webDb", "Lai/platon/pulsar/persist/WebDb;", "(Ljava/lang/CharSequence;Lai/platon/pulsar/persist/WebDb;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "home", "Lai/platon/pulsar/persist/WebPage;", "getHome", "()Lai/platon/pulsar/persist/WebPage;", "", "temporaryDeleteAllPage", "", "commit", "", "get", "pageNo", "", "getAll", "", "getIndex", "pageTitle", "index", "url", "indexAll", "urls", "", "remove", "removeAll", "takeAll", "", "takeN", "n", "update", "newHyperlinks", "Lai/platon/pulsar/persist/HyperlinkPersistable;", "updateAll", "pulsar-skeleton"})
public final class WeakPageIndexer {
    @NotNull
    private final WebDb webDb;
    private final Logger LOG;
    @NotNull
    private final String homeUrl;
    private final boolean temporaryDeleteAllPage;

    public WeakPageIndexer(@NotNull CharSequence homeUrl, @NotNull WebDb webDb) {
        Intrinsics.checkNotNullParameter((Object)homeUrl, (String)"homeUrl");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        this.webDb = webDb;
        this.LOG = LoggerFactory.getLogger(WeakPageIndexer.class);
        this.homeUrl = ((Object)homeUrl).toString();
        this.temporaryDeleteAllPage = true;
    }

    @NotNull
    public final WebPage home() {
        return this.getHome();
    }

    @NotNull
    public final WebPage get(int pageNo) {
        return this.getIndex(pageNo);
    }

    public final void index(@NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object[] objectArray = new CharSequence[]{url};
        this.indexAll(1, CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public final void indexAll(@NotNull Iterable<? extends CharSequence> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.indexAll(1, urls);
    }

    public final void indexAll(int pageNo, @NotNull Iterable<? extends CharSequence> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.updateAll(pageNo, urls, false);
    }

    @NotNull
    public final Set<CharSequence> getAll(int pageNo) {
        return this.get(pageNo).getVividLinks().keySet();
    }

    @NotNull
    public final synchronized Set<CharSequence> takeN(int pageNo, int n) {
        int n1 = n;
        WebPage page = this.get(pageNo);
        boolean bl = false;
        Set urls = new LinkedHashSet();
        Iterator it = page.getVividLinks().entrySet().iterator();
        while (true) {
            int n2 = n1;
            n1 = n2 + -1;
            if (n2 <= 0 || !it.hasNext()) break;
            urls.add(it.next().getKey());
            it.remove();
        }
        Collection collection = urls;
        boolean bl2 = false;
        if (!collection.isEmpty() && this.LOG.isDebugEnabled()) {
            this.LOG.debug("Taken {} urls from page {}", (Object)urls.size(), (Object)page.getUrl());
        }
        WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
        this.webDb.flush();
        return urls;
    }

    @NotNull
    public final synchronized Set<CharSequence> takeAll(int pageNo) {
        return this.takeN(pageNo, Integer.MAX_VALUE);
    }

    public final void remove(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.remove(1, url);
    }

    public final void removeAll(@NotNull Iterable<? extends CharSequence> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.removeAll(1, urls);
    }

    public final void remove(int pageNo, @NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object[] objectArray = new CharSequence[]{url};
        this.updateAll(pageNo, CollectionsKt.arrayListOf((Object[])objectArray), true);
    }

    public final void removeAll(int pageNo, @NotNull Iterable<? extends CharSequence> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.updateAll(pageNo, urls, true);
    }

    public final void commit() {
        this.webDb.flush();
    }

    private final void update(int pageNo, HyperlinkPersistable newHyperlinks, boolean remove) {
        Object[] objectArray = new CharSequence[]{newHyperlinks.getUrl()};
        ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList<CharSequence>(newHyperlinks.url)");
        this.updateAll(pageNo, arrayList, remove);
    }

    private final synchronized void updateAll(int pageNo, Iterable<? extends CharSequence> urls, boolean remove) {
        Logger logger;
        Logger logger2;
        boolean $i$f$forEach;
        Iterable<? extends CharSequence> $this$forEach$iv;
        if (!urls.iterator().hasNext()) {
            return;
        }
        WebPage indexPage = this.getIndex(pageNo);
        WebPageExt indexPageExt = new WebPageExt(indexPage);
        Map vividLinks = indexPage.getVividLinks();
        if (remove) {
            $this$forEach$iv = urls;
            $i$f$forEach = false;
            logger2 = $this$forEach$iv.iterator();
            while (logger2.hasNext()) {
                CharSequence element$iv;
                CharSequence it = element$iv = logger2.next();
                boolean bl = false;
                vividLinks.remove(it);
            }
        } else {
            $this$forEach$iv = urls;
            $i$f$forEach = false;
            logger2 = $this$forEach$iv.iterator();
            while (logger2.hasNext()) {
                CharSequence element$iv;
                CharSequence it = element$iv = logger2.next();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)vividLinks, (String)"vividLinks");
                Map map2 = vividLinks;
                String string = "";
                boolean bl2 = false;
                map2.put(it, string);
            }
        }
        String message = "Total " + vividLinks.size() + " indexed links";
        indexPageExt.setTextCascaded(message);
        logger2 = this.LOG;
        boolean bl = false;
        boolean bl3 = false;
        Logger it = logger2;
        boolean bl4 = false;
        Object object = logger = it.isTraceEnabled() ? logger2 : null;
        if (logger != null) {
            logger.trace(message + ", indexed in " + indexPage.getUrl());
        }
        WebDb.put$default((WebDb)this.webDb, (WebPage)indexPage, (boolean)false, (int)2, null);
    }

    private final synchronized WebPage getHome() {
        WebPage home = WebDb.get$default((WebDb)this.webDb, (String)this.homeUrl, (boolean)false, null, (int)6, null);
        if (home.isNil()) {
            WebPage webPage = WebPage.newInternalPage((String)this.homeUrl, (String)"Web Page Index Home");
            Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"newInternalPage(homeUrl, \"Web Page Index Home\")");
            home = webPage;
            this.LOG.debug("Creating weak index home: " + this.homeUrl);
        }
        WebDb.put$default((WebDb)this.webDb, (WebPage)home, (boolean)false, (int)2, null);
        return home;
    }

    private final WebPage getIndex(int pageNo) {
        return this.getIndex(pageNo, "Web Page Index " + pageNo);
    }

    private final synchronized WebPage getIndex(int pageNo, String pageTitle) {
        String url = this.homeUrl + "/" + pageNo;
        Object indexPage = WebDb.get$default((WebDb)this.webDb, (String)url, (boolean)false, null, (int)6, null);
        if (this.temporaryDeleteAllPage) {
            WebDb.delete$default((WebDb)this.webDb, (String)url, (boolean)false, (int)2, null);
            this.webDb.flush();
            WebPage webPage = WebPage.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"NIL");
            indexPage = webPage;
        }
        if (indexPage.isNil()) {
            WebPage home = this.getHome();
            Map map2 = home.getVividLinks();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"home.vividLinks");
            String string = "";
            boolean bl = false;
            map2.put(url, string);
            WebDb.put$default((WebDb)this.webDb, (WebPage)home, (boolean)false, (int)2, null);
            map2 = WebPage.newInternalPage((String)url, (String)pageTitle);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"newInternalPage(url, pageTitle)");
            indexPage = map2;
            WebDb.put$default((WebDb)this.webDb, (WebPage)indexPage, (boolean)false, (int)2, null);
        }
        return indexPage;
    }
}

