/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.common.url;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.options.OptionUtils;
import ai.platon.pulsar.common.urls.StatefulUrl;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005BO\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\u0002H\u0096\u0002J\u0013\u0010R\u001a\u00020(2\b\u0010Q\u001a\u0004\u0018\u00010SH\u0096\u0002J\b\u0010T\u001a\u00020\nH\u0016J\b\u0010U\u001a\u00020\u0007H\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u001a\u0010\"\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010)R\u0014\u0010*\u001a\u00020(X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0014\u0010+\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u001a\u0010.\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0011\"\u0004\b0\u0010\u0013R\u001a\u00101\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001f\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00107\"\u0004\b;\u00109R\u001a\u0010\u000e\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00107\"\u0004\b=\u00109R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0011\"\u0004\b?\u0010\u0013R\u001c\u0010@\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0011\"\u0004\bB\u0010\u0013R\u001a\u0010C\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00107\"\u0004\bE\u00109R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0011\"\u0004\bG\u0010\u0013R\u0014\u0010H\u001a\u00020I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0016\u0010L\u001a\u0004\u0018\u00010I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010KR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0011\"\u0004\bO\u0010\u0013\u00a8\u0006V"}, d2={"Lai/platon/pulsar/crawl/common/url/CompletableHyperlink;", "T", "Lai/platon/pulsar/common/urls/UrlAware;", "", "Lai/platon/pulsar/common/urls/StatefulUrl;", "Ljava/util/concurrent/CompletableFuture;", "url", "", "text", "order", "", "referer", "args", "href", "priority", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "authToken", "getAuthToken", "setAuthToken", "configuredUrl", "getConfiguredUrl", "country", "getCountry", "setCountry", "createdAt", "Ljava/time/Instant;", "getCreatedAt", "()Ljava/time/Instant;", "deadline", "getDeadline", "district", "getDistrict", "setDistrict", "getHref", "setHref", "isNil", "", "()Z", "isPersistable", "isStandard", "label", "getLabel", "lang", "getLang", "setLang", "modifiedAt", "getModifiedAt", "setModifiedAt", "(Ljava/time/Instant;)V", "nMaxRetry", "getNMaxRetry", "()I", "setNMaxRetry", "(I)V", "getOrder", "setOrder", "getPriority", "setPriority", "getReferer", "setReferer", "remoteAddr", "getRemoteAddr", "setRemoteAddr", "status", "getStatus", "setStatus", "getText", "setText", "toURL", "Ljava/net/URL;", "getToURL", "()Ljava/net/URL;", "toURLOrNull", "getToURLOrNull", "getUrl", "setUrl", "compareTo", "other", "equals", "", "hashCode", "toString", "pulsar-skeleton"})
public class CompletableHyperlink<T>
extends CompletableFuture<T>
implements UrlAware,
Comparable<UrlAware>,
StatefulUrl {
    @NotNull
    private String url;
    @NotNull
    private String text;
    private int order;
    @Nullable
    private String referer;
    @Nullable
    private String args;
    @Nullable
    private String href;
    private int priority;
    private final boolean isPersistable;
    @NotNull
    private String lang;
    @NotNull
    private String country;
    @NotNull
    private String district;
    private int nMaxRetry;
    @Nullable
    private String authToken;
    @Nullable
    private String remoteAddr;
    private int status;
    @NotNull
    private Instant modifiedAt;
    @NotNull
    private final Instant createdAt;

    public CompletableHyperlink(@NotNull String url, @NotNull String text, int order, @Nullable String referer, @Nullable String args, @Nullable String href, int priority) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.url = url;
        this.text = text;
        this.order = order;
        this.referer = referer;
        this.args = args;
        this.href = href;
        this.priority = priority;
        this.lang = "*";
        this.country = "*";
        this.district = "*";
        this.nMaxRetry = 3;
        this.status = 201;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.modifiedAt = instant;
        instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.createdAt = instant;
    }

    public /* synthetic */ CompletableHyperlink(String string, String string2, int n, String string3, String string4, String string5, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            string2 = "";
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            string4 = null;
        }
        if ((n3 & 0x20) != 0) {
            string5 = null;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        this(string, string2, n, string3, string4, string5, n2);
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int n) {
        this.order = n;
    }

    @Nullable
    public String getReferer() {
        return this.referer;
    }

    public void setReferer(@Nullable String string) {
        this.referer = string;
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @Nullable
    public String getHref() {
        return this.href;
    }

    public void setHref(@Nullable String string) {
        this.href = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    @NotNull
    public String getConfiguredUrl() {
        return UrlUtils.INSTANCE.mergeUrlArgs(this.getUrl(), this.getArgs());
    }

    public boolean isStandard() {
        return UrlUtils.isValidUrl((String)this.getUrl());
    }

    @NotNull
    public URL getToURL() throws MalformedURLException {
        return new URL(this.getUrl());
    }

    @Nullable
    public URL getToURLOrNull() {
        return UrlUtils.getURLOrNull((String)this.getUrl());
    }

    public boolean isNil() {
        return Intrinsics.areEqual((Object)this.getUrl(), (Object)"http://internal.pulsar.platon.ai/nil");
    }

    public boolean isPersistable() {
        return this.isPersistable;
    }

    @NotNull
    public String getLabel() {
        Object[] objectArray = new String[]{"-l", "-label", "--label"};
        String string = OptionUtils.INSTANCE.findOption(this.getArgs(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        return string == null ? "" : string;
    }

    @NotNull
    public String getLang() {
        return this.lang;
    }

    public void setLang(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lang = string;
    }

    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @NotNull
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.district = string;
    }

    public int getNMaxRetry() {
        return this.nMaxRetry;
    }

    public void setNMaxRetry(int n) {
        this.nMaxRetry = n;
    }

    @NotNull
    public Instant getDeadline() {
        Object object;
        Object object2 = new String[]{"-deadTime", "--dead-time"};
        Object object3 = OptionUtils.INSTANCE.findOption(this.getArgs(), (Iterable)CollectionsKt.listOf((Object[])object2));
        Object deadTime = object3 == null ? "" : object3;
        object3 = DateTimes.parseBestInstantOrNull((String)deadTime);
        if (object3 == null) {
            object2 = DateTimes.INSTANCE.getDoomsday();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DateTimes.doomsday");
            object = object2;
        } else {
            object = object3;
        }
        return object;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String string) {
        this.authToken = string;
    }

    @Nullable
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(@Nullable String string) {
        this.remoteAddr = string;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    @NotNull
    public Instant getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.modifiedAt = instant;
    }

    @NotNull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        Object object = other;
        return object instanceof String ? Intrinsics.areEqual((Object)this.getUrl(), (Object)other) : (object instanceof URL ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((URL)other).toString()) : (object instanceof UrlAware ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((UrlAware)other).getUrl()) : false));
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Override
    public int compareTo(@NotNull UrlAware other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getUrl().compareTo(other.getUrl());
    }

    @Override
    @NotNull
    public String toString() {
        return this.getUrl();
    }

    @NotNull
    public Instant getDeadTime() {
        return UrlAware.DefaultImpls.getDeadTime((UrlAware)this);
    }
}

