/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.FetchEntry;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.component.BatchFetchComponent$manualParallelFetchAll$1$invokeSuspend$;
import ai.platon.pulsar.crawl.component.FetchComponent;
import ai.platon.pulsar.crawl.protocol.Protocol;
import ai.platon.pulsar.crawl.protocol.ProtocolFactory;
import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.FetchMode;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001bH\u0002J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J,\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J,\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lai/platon/pulsar/crawl/component/BatchFetchComponent;", "Lai/platon/pulsar/crawl/component/FetchComponent;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "protocolFactory", "Lai/platon/pulsar/crawl/protocol/ProtocolFactory;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/crawl/CoreMetrics;Lai/platon/pulsar/crawl/protocol/ProtocolFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "fetchAll", "", "Lai/platon/pulsar/persist/WebPage;", "urls", "", "", "options", "Lai/platon/pulsar/common/options/LoadOptions;", "fetchAllInternal", "getProtocolOutput", "protocol", "Lai/platon/pulsar/crawl/protocol/Protocol;", "response", "Lai/platon/pulsar/crawl/protocol/Response;", "page", "manualParallelFetchAll", "optimizeBatchSize", "parallelFetchAll", "parallelFetchAll0", "parallelFetchAllGroupedBySchema", "protocolParallelFetchAll", "pulsar-skeleton"})
public final class BatchFetchComponent
extends FetchComponent {
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    private final Logger logger;

    public BatchFetchComponent(@NotNull WebDb webDb, @NotNull GlobalCacheFactory globalCacheFactory, @Nullable CoreMetrics coreMetrics, @NotNull ProtocolFactory protocolFactory, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)protocolFactory, (String)"protocolFactory");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        super(coreMetrics, protocolFactory, immutableConfig);
        this.webDb = webDb;
        this.globalCacheFactory = globalCacheFactory;
        this.logger = LoggerFactory.getLogger(BatchFetchComponent.class);
    }

    public /* synthetic */ BatchFetchComponent(WebDb webDb, GlobalCacheFactory globalCacheFactory, CoreMetrics coreMetrics, ProtocolFactory protocolFactory, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coreMetrics = null;
        }
        this(webDb, globalCacheFactory, coreMetrics, protocolFactory, immutableConfig);
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    public BatchFetchComponent(@NotNull WebDb webDb, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this(webDb, new GlobalCacheFactory(immutableConfig), null, new ProtocolFactory(immutableConfig), immutableConfig);
    }

    @NotNull
    public final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    public final Collection<WebPage> fetchAll(@NotNull Iterable<String> urls, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.fetchAllInternal(urls, options);
    }

    @NotNull
    public final Collection<WebPage> parallelFetchAll(@NotNull Iterable<String> urls, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Protocol protocol = this.getProtocolFactory().getProtocol(options.getFetchMode());
        if (protocol == null) {
            return this.parallelFetchAllGroupedBySchema(urls, options);
        }
        Protocol protocol2 = protocol;
        return this.parallelFetchAll0(urls, protocol2, options);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<WebPage> parallelFetchAllGroupedBySchema(@NotNull Iterable<String> urls, @NotNull LoadOptions options) {
        Map groupedUrls;
        Object key$iv$iv22;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List pages = new ArrayList();
        Iterable $this$groupBy$iv = this.optimizeBatchSize(urls, options);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            key$iv$iv22 = StringsKt.substringBefore$default((String)it, (String)"://", null, (int)2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv22);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv22, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = groupedUrls = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$gUrls = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry bl4 = $dstr$key$gUrls;
            boolean key$iv$iv22 = false;
            String key = (String)bl4.getKey();
            key$iv$iv22 = $dstr$key$gUrls;
            boolean bl5 = false;
            List gUrls = (List)key$iv$iv22.getValue();
            Protocol protocol = this.getProtocolFactory().getProtocol(key);
            if (protocol != null) {
                pages.addAll(this.parallelFetchAll0(gUrls, protocol, options));
                continue;
            }
            CoreMetrics coreMetrics = this.getCoreMetrics();
            if (coreMetrics == null) continue;
            coreMetrics.trackFailedUrls(gUrls);
        }
        return pages;
    }

    private final Collection<WebPage> fetchAllInternal(Iterable<String> urls, LoadOptions options) {
        return this.parallelFetchAll(urls, options);
    }

    private final Collection<WebPage> parallelFetchAll0(Iterable<String> urls, Protocol protocol, LoadOptions options) {
        Collection<String> optimizedUrls = this.optimizeBatchSize(urls, options);
        return protocol.getSupportParallel() ? this.protocolParallelFetchAll((Iterable<String>)optimizedUrls, protocol, options) : this.manualParallelFetchAll((Iterable<String>)optimizedUrls, options);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<WebPage> protocolParallelFetchAll(Iterable<String> urls, Protocol protocol, LoadOptions options) {
        WebPage webPage;
        Response it;
        Collection collection;
        void $this$mapTo$iv$iv222;
        CoreMetrics coreMetrics = this.getCoreMetrics();
        if (coreMetrics != null) {
            coreMetrics.markFetchTaskStart(Iterables.size(urls));
        }
        Iterable $this$map$iv = urls;
        boolean $i$f$map = false;
        List list = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            webPage = new FetchEntry((String)((Object)it), options, null, 4, null).getPage();
            collection.add(webPage);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        boolean $this$mapTo$iv$iv222 = false;
        List it2 = $this$map$iv;
        boolean bl = false;
        $this$map$iv = protocol.getResponses(it2, options.getConf());
        $i$f$map = false;
        Iterable $this$mapTo$iv$iv222 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            it = (Response)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            webPage = this.getProtocolOutput(protocol, it, it.getPage());
            collection.add(webPage);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<WebPage> manualParallelFetchAll(Iterable<String> urls, LoadOptions options) {
        int size = Iterables.size(urls);
        CoreMetrics coreMetrics = this.getCoreMetrics();
        if (coreMetrics != null) {
            coreMetrics.markFetchTaskStart(size);
        }
        return (Collection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends WebPage>>, Object>(urls, this, options, null){
            int label;
            final /* synthetic */ Iterable<String> $urls;
            final /* synthetic */ BatchFetchComponent this$0;
            final /* synthetic */ LoadOptions $options;
            {
                this.$urls = $urls;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow = FlowKt.asFlow(this.$urls);
                        BatchFetchComponent batchFetchComponent = this.this$0;
                        LoadOptions loadOptions = this.$options;
                        boolean $i$f$map = false;
                        void $this$unsafeTransform$iv$iv = $this$map$iv;
                        boolean $i$f$unsafeTransform = false;
                        boolean $i$f$unsafeFlow = false;
                        boolean bl = false;
                        this.label = 1;
                        Object object3 = FlowKt.toList((Flow)((Flow)new Flow<WebPage>((Flow)$this$unsafeTransform$iv$iv, batchFetchComponent, loadOptions){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            final /* synthetic */ BatchFetchComponent this$0;
                            final /* synthetic */ LoadOptions $options$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow;
                                this.this$0 = batchFetchComponent;
                                this.$options$inlined = loadOptions;
                            }

                            @Nullable
                            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u2d0 = collector;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u2d0, this.this$0, this.$options$inlined){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    final /* synthetic */ BatchFetchComponent this$0;
                                    final /* synthetic */ LoadOptions $options$inlined;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                        this.this$0 = batchFetchComponent;
                                        this.$options$inlined = loadOptions;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                        if (!(var2_2 instanceof manualParallelFetchAll$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = var2_2;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, var2_2){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                final /* synthetic */ manualParallelFetchAll$1$invokeSuspend$$inlined$map$1$2 this$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = $continuation;
                                                var7_7 = value;
                                                $this$map_u24lambda_u2d4 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                var10_11 = $this$map_u24lambda_u2d4;
                                                var11_12 = (Continuation)$continuation;
                                                it = (String)value;
                                                $i$a$-map-BatchFetchComponent$manualParallelFetchAll$1$1 = false;
                                                $continuation.label = 1;
                                                v0 = var10_11.emit((Object)this.this$0.fetch(it, this.$options$inlined), (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                ** GOTO lbl29
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl29:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }), (List)new ArrayList<E>(), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<WebPage>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final WebPage getProtocolOutput(Protocol protocol, Response response2, WebPage page) {
        protocol.setResponse(response2);
        return this.processProtocolOutput(page, protocol.getProtocolOutput(page));
    }

    private final Collection<String> optimizeBatchSize(Iterable<String> urls, LoadOptions options) {
        return urls instanceof Collection ? this.optimizeBatchSize((Collection)urls, options) : this.optimizeBatchSize(CollectionsKt.toList(urls), options);
    }

    private final Collection<String> optimizeBatchSize(Collection<String> urls, LoadOptions options) {
        VolatileConfig conf = options.getConf();
        int parallelLevel = conf.getUint("fetch.concurrency", AppContext.INSTANCE.getNCPU());
        if (urls.size() <= parallelLevel) {
            return urls;
        }
        List eagerTasks = new ArrayList(parallelLevel);
        List lazyTasks = new ArrayList(RangesKt.coerceAtLeast((int)0, (int)(urls.size() - parallelLevel)));
        Object object = urls.iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            String url = (String)object.next();
            if (i < parallelLevel) {
                eagerTasks.add(url);
                continue;
            }
            lazyTasks.add(url);
        }
        object = lazyTasks;
        n = 0;
        if (!object.isEmpty()) {
            NormUrl normUrl;
            NormUrl it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            FetchMode mode = options.getFetchMode();
            Iterable $this$map$iv = lazyTasks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                normUrl = new NormUrl((String)((Object)it), options, null, null, 12, null);
                collection.add(normUrl);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (NormUrl)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                normUrl = new Hyperlink(it.getSpec(), null, 0, null, it.getArgs(), null, 46, null);
                collection.add(normUrl);
            }
            List links2 = (List)destination$iv$iv;
            this.getGlobalCache().getUrlPool().getNormalCache().getNReentrantQueue().addAll(links2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Committed {} lazy tasks in mode {}", (Object)lazyTasks.size(), (Object)mode);
            }
        }
        return eagerTasks;
    }
}

