/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.LoadEvent;
import ai.platon.pulsar.crawl.common.FetchEntry;
import ai.platon.pulsar.crawl.component.FetchComponent;
import ai.platon.pulsar.crawl.event.WebPageEventHandler;
import ai.platon.pulsar.crawl.protocol.Protocol;
import ai.platon.pulsar.crawl.protocol.ProtocolFactory;
import ai.platon.pulsar.crawl.protocol.ProtocolNotFound;
import ai.platon.pulsar.crawl.protocol.ProtocolOutput;
import ai.platon.pulsar.crawl.protocol.http.ProtocolStatusTranslator;
import ai.platon.pulsar.persist.CrawlMarks;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import ai.platon.pulsar.persist.metadata.OpenPageCategory;
import ai.platon.pulsar.persist.model.ActiveDOMStatTrace;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B!\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u0016\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\u000e\u0010$\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nJ\u0010\u0010(\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0004J\u0019\u0010)\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0084@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J \u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\nH\u0002J\u0018\u00102\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n2\u0006\u00103\u001a\u000204H\u0004J*\u00105\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u0002092\u0006\u0010-\u001a\u00020.H\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lai/platon/pulsar/crawl/component/FetchComponent;", "Ljava/lang/AutoCloseable;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "protocolFactory", "Lai/platon/pulsar/crawl/protocol/ProtocolFactory;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/CoreMetrics;Lai/platon/pulsar/crawl/protocol/ProtocolFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "abnormalPage", "Lai/platon/pulsar/persist/WebPage;", "getAbnormalPage", "()Lai/platon/pulsar/persist/WebPage;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getCoreMetrics", "()Lai/platon/pulsar/crawl/CoreMetrics;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger$1", "getProtocolFactory", "()Lai/platon/pulsar/crawl/protocol/ProtocolFactory;", "tracer", "close", "", "fetch", "url", "", "options", "Lai/platon/pulsar/common/options/LoadOptions;", "fetchContent", "fetchEntry", "Lai/platon/pulsar/crawl/common/FetchEntry;", "page", "fetchContent0", "fetchContentDeferred", "(Lai/platon/pulsar/persist/WebPage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchContentDeferred0", "logMetrics", "crawlStatus", "Lai/platon/pulsar/persist/CrawlStatus;", "metrics", "onFetched", "onWillFetch", "processProtocolOutput", "output", "Lai/platon/pulsar/crawl/protocol/ProtocolOutput;", "updateFetchedPage", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "protocolStatus", "Lai/platon/pulsar/persist/ProtocolStatus;", "Companion", "pulsar-skeleton"})
public class FetchComponent
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CoreMetrics coreMetrics;
    @NotNull
    private final ProtocolFactory protocolFactory;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger$1;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final AtomicBoolean closed;
    private static final Logger logger = LoggerFactory.getLogger(FetchComponent.class);

    /*
     * WARNING - void declaration
     */
    public FetchComponent(@Nullable CoreMetrics coreMetrics, @NotNull ProtocolFactory protocolFactory, @NotNull ImmutableConfig immutableConfig) {
        void it;
        Intrinsics.checkNotNullParameter((Object)protocolFactory, (String)"protocolFactory");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.coreMetrics = coreMetrics;
        this.protocolFactory = protocolFactory;
        this.immutableConfig = immutableConfig;
        Logger logger = this.logger$1 = LoggerFactory.getLogger(FetchComponent.class);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = logger;
        FetchComponent fetchComponent = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        fetchComponent.tracer = bl4 ? logger : null;
        this.closed = new AtomicBoolean();
    }

    public /* synthetic */ FetchComponent(CoreMetrics coreMetrics, ProtocolFactory protocolFactory, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coreMetrics = null;
        }
        this(coreMetrics, protocolFactory, immutableConfig);
    }

    @Nullable
    public final CoreMetrics getCoreMetrics() {
        return this.coreMetrics;
    }

    @NotNull
    public final ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    private final WebPage getAbnormalPage() {
        WebPage webPage = WebPage.NIL;
        boolean bl = false;
        boolean bl2 = false;
        WebPage it = webPage;
        boolean bl3 = false;
        return !this.isActive() ? webPage : null;
    }

    @NotNull
    public final WebPage fetch(@NotNull String url) {
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebPage webPage2 = this.getAbnormalPage();
        if (webPage2 == null) {
            WebPage webPage3 = WebPage.newWebPage((String)url, (VolatileConfig)this.immutableConfig.toVolatileConfig());
            Intrinsics.checkNotNullExpressionValue((Object)webPage3, (String)"newWebPage(url, immutabl\u2026onfig.toVolatileConfig())");
            webPage = this.fetchContent(webPage3);
        } else {
            webPage = webPage2;
        }
        return webPage;
    }

    @NotNull
    public final WebPage fetch(@NotNull String url, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WebPage webPage = this.getAbnormalPage();
        return webPage == null ? this.fetchContent0(new FetchEntry(url, options, null, 4, null)) : webPage;
    }

    @NotNull
    public final WebPage fetchContent(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        WebPage webPage = this.getAbnormalPage();
        return webPage == null ? this.fetchContent0(new FetchEntry(page, WebPageExKt.getOptions(page))) : webPage;
    }

    @NotNull
    public final WebPage fetchContent(@NotNull FetchEntry fetchEntry) {
        Intrinsics.checkNotNullParameter((Object)fetchEntry, (String)"fetchEntry");
        WebPage webPage = this.getAbnormalPage();
        return webPage == null ? this.fetchContent0(fetchEntry) : webPage;
    }

    @Nullable
    public final Object fetchContentDeferred(@NotNull WebPage page, @NotNull Continuation<? super WebPage> $completion) {
        WebPage webPage = this.getAbnormalPage();
        if (webPage == null) {
            return this.fetchContentDeferred0(page, $completion);
        }
        return webPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final WebPage fetchContent0(@NotNull FetchEntry fetchEntry) {
        Intrinsics.checkNotNullParameter((Object)fetchEntry, (String)"fetchEntry");
        WebPage page = fetchEntry.getPage();
        boolean bl = page.isNotInternal();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Internal page " + page.getUrl();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CoreMetrics coreMetrics = this.coreMetrics;
        if (coreMetrics != null) {
            coreMetrics.markFetchTaskStart();
        }
        this.onWillFetch(page);
        try {
            Protocol protocol = this.protocolFactory.getProtocol(page);
            coreMetrics = this.processProtocolOutput(page, protocol.getProtocolOutput(page));
        }
        catch (ProtocolNotFound e) {
            this.logger$1.warn(e.getMessage());
            WebPage webPage = page;
            boolean bl5 = false;
            boolean bl6 = false;
            WebPage it = webPage;
            boolean bl7 = false;
            ProtocolStatus protocolStatus = ProtocolStatus.STATUS_PROTO_NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"STATUS_PROTO_NOT_FOUND");
            Companion.updateStatus(it, protocolStatus, CrawlStatus.STATUS_UNFETCHED);
            coreMetrics = webPage;
        }
        finally {
            this.onFetched(page);
        }
        return coreMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    protected final Object fetchContentDeferred0(@NotNull WebPage var1_1, @NotNull Continuation<? super WebPage> var2_2) {
        if (!(var2_2 instanceof fetchContentDeferred0.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ FetchComponent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetchContentDeferred0(null, (Continuation<? super WebPage>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.onWillFetch(page);
                var3_6 = this.getCoreMetrics();
                if (var3_6 != null) {
                    var3_6.markFetchTaskStart();
                }
                protocol = this.getProtocolFactory().getProtocol(page);
                var12_7 = page;
                var11_8 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = page;
                $continuation.L$2 = var11_8;
                $continuation.L$3 = var12_7;
                $continuation.label = 1;
                v0 = protocol.getProtocolOutputDeferred(page, (Continuation<? super ProtocolOutput>)$continuation);
                ** if (v0 != var16_5) goto lbl29
lbl28:
                // 1 sources

                return var16_5;
lbl29:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                var12_7 = (WebPage)$continuation.L$3;
                var11_8 = (FetchComponent)$continuation.L$2;
                page = (WebPage)$continuation.L$1;
                this = (FetchComponent)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    var13_9 = v0;
                    var3_6 = var11_8.processProtocolOutput(var12_7, (ProtocolOutput)var13_9);
                    this.onFetched(page);
                }
                catch (ProtocolNotFound e) {
                    this.logger$1.warn(e.getMessage());
                    var5_12 = page;
                    var6_13 = false;
                    var7_14 = false;
                    it = var5_12;
                    $i$a$-also-FetchComponent$fetchContentDeferred0$2 = false;
                    var10_17 = ProtocolStatus.STATUS_PROTO_NOT_FOUND;
                    Intrinsics.checkNotNullExpressionValue((Object)var10_17, (String)"STATUS_PROTO_NOT_FOUND");
                    FetchComponent.Companion.updateStatus((WebPage)it, var10_17, CrawlStatus.STATUS_UNFETCHED);
                    var3_6 = var5_12;
                }
            }
            {
                finally {
                    this.onFetched(page);
                }
            }
            return var3_6;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void onWillFetch(WebPage page) {
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (webPageEventHandler = loadEvent.getOnWillFetch()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            this.logger$1.warn("Failed to invoke onWillFetch | " + page.getConfiguredUrl(), e);
        }
    }

    private final void onFetched(WebPage page) {
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (webPageEventHandler = loadEvent.getOnFetched()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            this.logger$1.warn("Failed to invoke onFetched | " + page.getConfiguredUrl(), e);
        }
    }

    @NotNull
    protected final WebPage processProtocolOutput(@NotNull WebPage page, @NotNull ProtocolOutput output) {
        CrawlStatus crawlStatus;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ProtocolStatus protocolStatus = output.getProtocolStatus();
        if (protocolStatus.isCanceled()) {
            return page;
        }
        PageDatum pageDatum = output.getPageDatum();
        if (pageDatum == null) {
            this.logger$1.warn("No content | {}", (Object)page.getConfiguredUrl());
        }
        page.setFetched(true);
        page.getHeaders().putAll(output.getHeaders().asMultimap());
        Object object = crawlStatus = ProtocolStatusTranslator.INSTANCE.translateToCrawlStatus(protocolStatus, page);
        if ((Intrinsics.areEqual((Object)object, (Object)CrawlStatus.Companion.getSTATUS_FETCHED()) ? true : Intrinsics.areEqual((Object)object, (Object)CrawlStatus.Companion.getSTATUS_REDIR_TEMP())) ? true : Intrinsics.areEqual((Object)object, (Object)CrawlStatus.Companion.getSTATUS_REDIR_PERM())) {
            this.updateFetchedPage(page, pageDatum, protocolStatus, crawlStatus);
        } else {
            this.updateFetchedPage(page, null, protocolStatus, crawlStatus);
        }
        object = this.coreMetrics;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.logMetrics(crawlStatus, page, (CoreMetrics)it);
        }
        return page;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    private final WebPage updateFetchedPage(WebPage page, PageDatum pageDatum, ProtocolStatus protocolStatus, CrawlStatus crawlStatus) {
        Companion.updateStatus(page, protocolStatus, crawlStatus);
        PageDatum pageDatum2 = pageDatum;
        if (pageDatum2 != null) {
            HtmlIntegrity it;
            boolean bl;
            boolean bl2;
            HtmlIntegrity htmlIntegrity;
            HtmlIntegrity htmlIntegrity2;
            PageDatum pageDatum3 = pageDatum2;
            boolean bl3 = false;
            boolean bl4 = false;
            PageDatum it2 = pageDatum3;
            boolean bl5 = false;
            page.setLocation(it2.getLocation());
            ProxyEntry proxyEntry = it2.getProxyEntry();
            page.setProxy(proxyEntry == null ? null : proxyEntry.getOutIp());
            ActiveDOMStatTrace ms = it2.getActiveDOMStatTrace();
            if (ms != null) {
                page.setActiveDOMStatus(ms.getStatus());
                htmlIntegrity2 = new HtmlIntegrity[]{TuplesKt.to((Object)"initStat", (Object)ms.getInitStat()), TuplesKt.to((Object)"initD", (Object)ms.getInitD()), TuplesKt.to((Object)"lastStat", (Object)ms.getLastStat()), TuplesKt.to((Object)"lastD", (Object)ms.getLastD())};
                page.setActiveDOMStatTrace(MapsKt.mapOf((Pair[])htmlIntegrity2));
            }
            if ((htmlIntegrity2 = it2.getPageCategory()) != null) {
                htmlIntegrity = htmlIntegrity2;
                bl2 = false;
                bl = false;
                it = htmlIntegrity;
                boolean bl6 = false;
                page.setPageCategory((OpenPageCategory)it);
            }
            htmlIntegrity2 = it2.getHtmlIntegrity();
            if (htmlIntegrity2 != null) {
                htmlIntegrity = htmlIntegrity2;
                bl2 = false;
                bl = false;
                it = htmlIntegrity;
                boolean bl7 = false;
                page.setHtmlIntegrity(it);
            }
            htmlIntegrity2 = it2.getLastBrowser();
            if (htmlIntegrity2 != null) {
                htmlIntegrity = htmlIntegrity2;
                bl2 = false;
                bl = false;
                it = htmlIntegrity;
                boolean bl8 = false;
                page.setLastBrowser((BrowserType)it);
            }
            if (protocolStatus.isSuccess()) {
                ai.platon.pulsar.crawl.component.FetchComponent$Companion.updateContent$default(Companion, page, it2, null, 4, null);
            }
        }
        Companion.updateMarks(page);
        return page;
    }

    private final void logMetrics(CrawlStatus crawlStatus, WebPage page, CoreMetrics metrics) {
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String url = string;
        string = crawlStatus;
        if (Intrinsics.areEqual((Object)string, (Object)CrawlStatus.Companion.getSTATUS_REDIR_PERM()) ? true : Intrinsics.areEqual((Object)string, (Object)CrawlStatus.Companion.getSTATUS_REDIR_TEMP())) {
            metrics.trackMoved(url);
        } else if (Intrinsics.areEqual((Object)string, (Object)CrawlStatus.Companion.getSTATUS_GONE())) {
            CoreMetrics.trackHostUnreachable$default(metrics, url, 0, 2, null);
        }
        if (crawlStatus.isFetched()) {
            metrics.trackSuccess(page);
        } else if (crawlStatus.isFailed()) {
            metrics.trackFailedUrl(url);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/crawl/component/FetchComponent$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "updateContent", "", "page", "Lai/platon/pulsar/persist/WebPage;", "pageDatum", "Lai/platon/pulsar/persist/PageDatum;", "contentTypeHint", "", "updateMarks", "updateStatus", "protocolStatus", "Lai/platon/pulsar/persist/ProtocolStatus;", "crawlStatus", "Lai/platon/pulsar/persist/CrawlStatus;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateStatus(@NotNull WebPage page, @NotNull ProtocolStatus protocolStatus, @NotNull CrawlStatus crawlStatus) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)protocolStatus, (String)"protocolStatus");
            Intrinsics.checkNotNullParameter((Object)crawlStatus, (String)"crawlStatus");
            page.setCrawlStatus(crawlStatus);
            page.setProtocolStatus(protocolStatus);
            page.updateFetchCount();
        }

        public final void updateMarks(@NotNull WebPage page) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            CrawlMarks marks = page.getMarks();
            marks.putIfNotNull(Mark.FETCH, marks.get(Mark.GENERATE));
        }

        public final void updateContent(@NotNull WebPage page, @NotNull PageDatum pageDatum, @Nullable String contentTypeHint) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)pageDatum, (String)"pageDatum");
            String contentType = contentTypeHint;
            page.setContent(pageDatum.getContent());
            if (contentType != null) {
                pageDatum.setContentType(contentType);
            } else {
                contentType = pageDatum.getContentType();
            }
            if (contentType != null) {
                page.setContentType(contentType);
            } else {
                logger.warn("Failed to determine content type!");
            }
        }

        public static /* synthetic */ void updateContent$default(Companion companion, WebPage webPage, PageDatum pageDatum, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            companion.updateContent(webPage, pageDatum, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

