/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.FSUtils;
import ai.platon.pulsar.common.LocalFSUtils;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.crawl.common.JobInitialized;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.filter.ChainedUrlNormalizer;
import ai.platon.pulsar.crawl.filter.CrawlFilter;
import ai.platon.pulsar.crawl.filter.CrawlFilters;
import ai.platon.pulsar.crawl.filter.CrawlUrlFilters;
import ai.platon.pulsar.crawl.schedule.FetchSchedule;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.FetchMode;
import ai.platon.pulsar.persist.metadata.Mark;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 S2\u00020\u00012\u00020\u0002:\u0001SB=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020\u0019H\u0002J\b\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u00020!H\u0002J\u0010\u0010N\u001a\u00020K2\u0006\u0010O\u001a\u00020\u0010H\u0016J*\u0010P\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00190Q2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010R\u001a\u00020\u00192\u0006\u0010D\u001a\u00020ER\u0019\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\n \u0014*\u0004\u0018\u00010707X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006T"}, d2={"Lai/platon/pulsar/crawl/component/GenerateComponent;", "Lai/platon/pulsar/common/config/Parameterized;", "Lai/platon/pulsar/crawl/common/JobInitialized;", "crawlFilters", "Lai/platon/pulsar/crawl/filter/CrawlFilters;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "urlFilters", "Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;", "urlNormalizers", "Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;", "fetchSchedule", "Lai/platon/pulsar/crawl/schedule/FetchSchedule;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/filter/CrawlFilters;Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;Lai/platon/pulsar/crawl/schedule/FetchSchedule;Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "bannedUrls", "", "", "batchId", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlFilters", "()Lai/platon/pulsar/crawl/filter/CrawlFilters;", "crawlId", "enumCounters", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "fetchMode", "Lai/platon/pulsar/persist/metadata/FetchMode;", "getFetchSchedule", "()Lai/platon/pulsar/crawl/schedule/FetchSchedule;", "filter", "", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "keyRange", "", "[Ljava/lang/String;", "lastGeneratedRows", "", "lowGeneratedRows", "lowGeneratedRowsRate", "", "maxDistance", "getMessageWriter", "()Lai/platon/pulsar/common/message/MiscMessageWriter;", "normalise", "pseudoCurrTime", "Ljava/time/Instant;", "reGenerate", "reGenerateSeeds", "startTime", "topN", "unreachableHosts", "getUrlFilters", "()Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;", "getUrlNormalizers", "()Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "checkFetchSchedule", "page", "Lai/platon/pulsar/persist/WebPage;", "checkHost", "url", "getParams", "Lai/platon/pulsar/common/config/Params;", "increaseMDaysLater", "", "days", "enumCounterRegistry", "setup", "jobConf", "shouldFetch", "Lkotlin/Pair;", "reversedUrl", "Companion", "pulsar-skeleton"})
public final class GenerateComponent
implements Parameterized,
JobInitialized {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrawlFilters crawlFilters;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final CrawlUrlFilters urlFilters;
    @NotNull
    private final ChainedUrlNormalizer urlNormalizers;
    @NotNull
    private final FetchSchedule fetchSchedule;
    @NotNull
    private final MiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger LOG;
    @NotNull
    private final EnumCounterRegistry enumCounters;
    private final Instant startTime;
    @NotNull
    private final Set<String> unreachableHosts;
    @NotNull
    private final Set<String> bannedUrls;
    @NotNull
    private final String[] keyRange;
    private String crawlId;
    private String batchId;
    private FetchMode fetchMode;
    private URLUtil.GroupMode groupMode;
    private boolean reGenerate;
    private boolean reGenerateSeeds;
    private boolean filter;
    private boolean normalise;
    private int maxDistance;
    private Instant pseudoCurrTime;
    private int topN;
    private float lowGeneratedRowsRate;
    private int lastGeneratedRows;
    private int lowGeneratedRows;

    public GenerateComponent(@NotNull CrawlFilters crawlFilters, @NotNull WebDb webDb, @NotNull CrawlUrlFilters urlFilters, @NotNull ChainedUrlNormalizer urlNormalizers, @NotNull FetchSchedule fetchSchedule, @NotNull MiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)crawlFilters, (String)"crawlFilters");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)urlFilters, (String)"urlFilters");
        Intrinsics.checkNotNullParameter((Object)urlNormalizers, (String)"urlNormalizers");
        Intrinsics.checkNotNullParameter((Object)fetchSchedule, (String)"fetchSchedule");
        Intrinsics.checkNotNullParameter((Object)((Object)messageWriter), (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.crawlFilters = crawlFilters;
        this.webDb = webDb;
        this.urlFilters = urlFilters;
        this.urlNormalizers = urlNormalizers;
        this.fetchSchedule = fetchSchedule;
        this.messageWriter = messageWriter;
        this.conf = conf;
        this.LOG = LoggerFactory.getLogger(GenerateComponent.class);
        this.enumCounters = AppMetrics.Companion.getReg().getEnumCounterRegistry();
        this.startTime = Instant.now();
        this.unreachableHosts = new HashSet();
        this.bannedUrls = new HashSet();
        this.keyRange = this.crawlFilters.getMaxReversedKeyRange();
        this.filter = true;
        this.normalise = true;
        this.maxDistance = -1;
        this.topN = -1;
        this.lowGeneratedRowsRate = 0.8f;
        this.lastGeneratedRows = -1;
        this.lowGeneratedRows = -1;
        Object object = new Path[]{AppPaths.INSTANCE.getPATH_BANNED_URLS(), AppPaths.INSTANCE.getPATH_UNREACHABLE_HOSTS()};
        Path[] $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        Path[] pathArray = $this$forEach$iv;
        int n = pathArray.length;
        for (int i = 0; i < n; ++i) {
            Path path;
            Path element$iv;
            Path it = element$iv = pathArray[i];
            boolean bl = false;
            Path path2 = it;
            boolean bl2 = false;
            boolean bl3 = false;
            Path it2 = path2;
            boolean bl4 = false;
            Path path3 = path = !Files.exists(it2, new LinkOption[0]) ? path2 : null;
            if (path == null) continue;
            path2 = path;
            bl2 = false;
            bl3 = false;
            it2 = path2;
            boolean bl5 = false;
            Files.createFile(it2, new FileAttribute[0]);
        }
        object = FSUtils.readAllLinesSilent((Path)AppPaths.INSTANCE.getPATH_BANNED_URLS(), (ImmutableConfig)this.conf);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readAllLinesSilent(PATH_BANNED_URLS, conf)");
        this.bannedUrls.addAll((Collection)object);
        object = LocalFSUtils.readAllLinesSilent((Path)AppPaths.INSTANCE.getPATH_UNREACHABLE_HOSTS());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readAllLinesSilent(PATH_UNREACHABLE_HOSTS)");
        this.unreachableHosts.addAll((Collection)object);
    }

    @NotNull
    public final CrawlFilters getCrawlFilters() {
        return this.crawlFilters;
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final CrawlUrlFilters getUrlFilters() {
        return this.urlFilters;
    }

    @NotNull
    public final ChainedUrlNormalizer getUrlNormalizers() {
        return this.urlNormalizers;
    }

    @NotNull
    public final FetchSchedule getFetchSchedule() {
        return this.fetchSchedule;
    }

    @NotNull
    public final MiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final Logger getLOG() {
        return this.LOG;
    }

    @Override
    public void setup(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        this.crawlId = jobConf.get("storage.crawl.id", "");
        this.batchId = jobConf.get("pulsar.batch.name", "all");
        Object object = jobConf.getEnum("fetch.fetch.mode", (Enum)FetchMode.BROWSER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobConf.getEnum(Capabili\u2026_MODE, FetchMode.BROWSER)");
        this.fetchMode = (FetchMode)object;
        object = jobConf.getEnum("fetch.queue.mode", (Enum)URLUtil.GroupMode.BY_HOST);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobConf.getEnum(Capabili\u2026_MODE, GroupMode.BY_HOST)");
        this.groupMode = (URLUtil.GroupMode)((Object)object);
        this.reGenerate = jobConf.getBoolean("generate.regenerate", false);
        this.reGenerateSeeds = jobConf.getBoolean("generate.regenerate.seeds", false);
        this.filter = jobConf.getBoolean("generate.filter", true);
        this.normalise = jobConf.getBoolean("generate.normalise", true);
        this.maxDistance = jobConf.getUint("crawl.max.distance", 10000);
        Instant instant = this.startTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"startTime");
        object = jobConf.getInstant("generate.curr.time", instant);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobConf.getInstant(Capab\u2026RATE_CUR_TIME, startTime)");
        this.pseudoCurrTime = object;
        this.topN = jobConf.getInt("generate.topN", -1);
        this.lastGeneratedRows = jobConf.getInt("generate.last.generated.rows", -1);
        this.lowGeneratedRowsRate = 0.8f;
        this.lowGeneratedRows = (int)(this.lowGeneratedRowsRate * (float)this.topN);
    }

    @NotNull
    public Params getParams() {
        Instant instant;
        Object object;
        Object object2;
        FetchMode fetchMode;
        Object[] objectArray;
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])new Object[0]);
        Params[] paramsArray = new Params[1];
        Object[] objectArray2 = this.crawlId;
        if (objectArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"crawlId");
            objectArray = null;
        } else {
            objectArray = objectArray2;
        }
        objectArray2 = new Object[40];
        objectArray2[0] = "fetchMode";
        Object object3 = this.fetchMode;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fetchMode");
            fetchMode = null;
        } else {
            fetchMode = object3;
        }
        objectArray2[1] = fetchMode;
        objectArray2[2] = "batchId";
        object3 = this.batchId;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"batchId");
            object2 = null;
        } else {
            object2 = object3;
        }
        objectArray2[3] = object2;
        objectArray2[4] = "groupMode";
        object3 = this.groupMode;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"groupMode");
            object = null;
        } else {
            object = object3;
        }
        objectArray2[5] = object;
        objectArray2[6] = "filter";
        objectArray2[7] = this.filter;
        objectArray2[8] = "normalise";
        objectArray2[9] = this.normalise;
        objectArray2[10] = "maxDistance";
        objectArray2[11] = this.maxDistance;
        objectArray2[12] = "reGenerate";
        objectArray2[13] = this.reGenerate;
        objectArray2[14] = "reGenerateSeeds";
        objectArray2[15] = this.reGenerateSeeds;
        objectArray2[16] = "pseudoCurrTime";
        Instant instant2 = this.pseudoCurrTime;
        if (instant2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pseudoCurrTime");
            instant = null;
        } else {
            instant = instant2;
        }
        object3 = instant.truncatedTo(ChronoUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"pseudoCurrTime.truncatedTo(ChronoUnit.SECONDS)");
        objectArray2[17] = DateTimes.INSTANCE.format((Instant)object3);
        objectArray2[18] = "topN";
        objectArray2[19] = this.topN;
        objectArray2[20] = "lastGeneratedRows";
        objectArray2[21] = this.lastGeneratedRows;
        objectArray2[22] = "lowGeneratedRowsRate";
        objectArray2[23] = Float.valueOf(this.lowGeneratedRowsRate);
        objectArray2[24] = "lowGeneratedRows";
        objectArray2[25] = this.lowGeneratedRows;
        objectArray2[26] = "fetchSchedule";
        objectArray2[27] = this.fetchSchedule.getClass().getName();
        objectArray2[28] = "urlNormalizers";
        objectArray2[29] = this.urlNormalizers;
        objectArray2[30] = "urlFilters";
        objectArray2[31] = this.urlFilters;
        objectArray2[32] = "crawlFilters";
        objectArray2[33] = this.crawlFilters;
        objectArray2[34] = "keyRange";
        objectArray2[35] = this.keyRange[0] + " - " + this.keyRange[1];
        objectArray2[36] = "unreachableHostsPath";
        objectArray2[37] = AppPaths.INSTANCE.getPATH_UNREACHABLE_HOSTS();
        objectArray2[38] = "unreachableHosts";
        objectArray2[39] = this.unreachableHosts.size();
        paramsArray[0] = Params.of((String)"crawlId", (Object)objectArray, (Object[])objectArray2);
        Params params2 = params.merge(paramsArray);
        Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"of(\"className\", this.jav\u2026s.size\n                ))");
        return params2;
    }

    @NotNull
    public final Pair<Boolean, String> shouldFetch(@NotNull String url, @NotNull String reversedUrl, @NotNull WebPage page) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String u = url;
        if (this.reGenerateSeeds && page.isSeed()) {
            return TuplesKt.to((Object)true, (Object)"+reGenerateSeeds");
        }
        if (!this.checkFetchSchedule(page)) {
            return TuplesKt.to((Object)false, (Object)"-FetchSchedule");
        }
        if (!this.checkHost(u)) {
            return TuplesKt.to((Object)false, (Object)"-Host");
        }
        if (this.bannedUrls.contains(u)) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mBanned, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-Banned");
        }
        Iterable iterable = this.unreachableHosts;
        Object object2 = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.url");
        String string = object2;
        object2 = this.groupMode;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"groupMode");
            object = null;
        } else {
            object = object2;
        }
        if (CollectionsKt.contains((Iterable)iterable, (Object)URLUtil.INSTANCE.getHost(string, (URLUtil.GroupMode)((Object)object)))) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mHostGone, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-unreachableHost");
        }
        if (page.hasMark(Mark.GENERATE)) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mGenerated, 0, 2, null);
            if (!this.reGenerate) {
                long days = Duration.between(page.getGenerateTime(), this.startTime).toDays();
                if (days == 1L) {
                    return TuplesKt.to((Object)false, (Object)"-1days");
                }
                if (days > 3L) {
                    return TuplesKt.to((Object)false, (Object)"-TooOld");
                }
            }
        }
        int distanceBias = 0;
        if (page.getDistance() > this.maxDistance + distanceBias) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mTooDeep, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-Distance");
        }
        if (!CrawlFilter.Companion.keyGreaterEqual(reversedUrl, this.keyRange[0])) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mBeforeStart, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-BeforeStart");
        }
        if (!CrawlFilter.Companion.keyLessEqual(reversedUrl, this.keyRange[1])) {
            return TuplesKt.to((Object)false, (Object)"-AfterEnd");
        }
        if (!this.crawlFilters.testKeyRangeSatisfied(reversedUrl)) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mNotInRange, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-KeyOutOfRange");
        }
        String u2 = u;
        if (this.normalise) {
            u2 = this.urlNormalizers.normalize(u, "generate_host_count");
        }
        if (u2 == null) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mNotNormal, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-notNormal");
        }
        if (this.filter && this.urlFilters.filter(u2) == null) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mUrlFiltered, 0, 2, null);
            return TuplesKt.to((Object)false, (Object)"-UrlFiltered");
        }
        return TuplesKt.to((Object)true, (Object)"+Pass");
    }

    private final boolean checkFetchSchedule(WebPage page) {
        Instant instant;
        Instant instant2;
        Instant instant3 = this.pseudoCurrTime;
        if (instant3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pseudoCurrTime");
            instant2 = null;
        } else {
            instant2 = instant3;
        }
        if (this.fetchSchedule.shouldFetch(page, instant2)) {
            return true;
        }
        if (page.hasMark(Mark.INACTIVE)) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mInactive, 0, 2, null);
        }
        Instant instant4 = page.getFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"page.fetchTime");
        Instant fetchTime = instant4;
        Instant instant5 = this.pseudoCurrTime;
        if (instant5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pseudoCurrTime");
            instant = null;
        } else {
            instant = instant5;
        }
        long hours = ChronoUnit.HOURS.between(instant, fetchTime);
        if (hours <= 6L && 0 < this.lastGeneratedRows && this.lastGeneratedRows < this.lowGeneratedRows) {
            Instant instant6;
            Temporal temporal = page.getPrevFetchTime();
            Instant instant7 = this.pseudoCurrTime;
            if (instant7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pseudoCurrTime");
                instant6 = null;
            } else {
                instant6 = instant7;
            }
            long fetchInterval = ChronoUnit.HOURS.between(temporal, instant6);
            if (fetchInterval > 6L) {
                EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mAhead, 0, 2, null);
                if (page.isSeed()) {
                    EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mSeedAhead, 0, 2, null);
                }
                return true;
            }
        }
        if (hours <= 720L) {
            this.increaseMDaysLater((int)hours / 24, this.enumCounters);
            if (page.isSeed()) {
                EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mSeedLater, 0, 2, null);
            }
        }
        return false;
    }

    private final boolean checkHost(String url) {
        String host;
        block7: {
            block6: {
                URLUtil.GroupMode groupMode;
                Object object = this.groupMode;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"groupMode");
                    groupMode = null;
                } else {
                    groupMode = object;
                }
                host = URLUtil.INSTANCE.getHost(url, groupMode);
                if (host == null) break block6;
                object = host;
                boolean bl = false;
                if (!(object.length() == 0)) break block7;
            }
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mUrlMalformed, 0, 2, null);
            return false;
        }
        if (this.unreachableHosts.contains(host)) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.mHostGone, 0, 2, null);
            return false;
        }
        return true;
    }

    private final void increaseMDaysLater(int days, EnumCounterRegistry enumCounterRegistry) {
        Companion.Counter counter;
        int n = days;
        switch (n) {
            case 0: {
                counter = Companion.Counter.mLater0;
                break;
            }
            case 1: {
                counter = Companion.Counter.mLater1;
                break;
            }
            case 2: {
                counter = Companion.Counter.mLater2;
                break;
            }
            case 3: {
                counter = Companion.Counter.mLater3;
                break;
            }
            case 4: {
                counter = Companion.Counter.mLater4;
                break;
            }
            case 5: {
                counter = Companion.Counter.mLater5;
                break;
            }
            case 6: {
                counter = Companion.Counter.mLater6;
                break;
            }
            case 7: {
                counter = Companion.Counter.mLater7;
                break;
            }
            default: {
                counter = Companion.Counter.mLaterN;
            }
        }
        Companion.Counter counter2 = counter;
        EnumCounterRegistry.inc$default(enumCounterRegistry, counter2, 0, 2, null);
        EnumCounterRegistry.inc$default(enumCounterRegistry, Companion.Counter.mLater, 0, 2, null);
    }

    static {
        AppMetricRegistry.register$default(AppMetrics.Companion.getReg(), Companion.Counter.class, null, false, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/platon/pulsar/crawl/component/GenerateComponent$Companion;", "", "()V", "Counter", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b \b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006!"}, d2={"Lai/platon/pulsar/crawl/component/GenerateComponent$Companion$Counter;", "", "(Ljava/lang/String;I)V", "mSeeds", "mBanned", "mHostGone", "lastGenerated", "mBeforeStart", "mNotInRange", "mUrlMalformed", "mNotNormal", "mUrlFiltered", "mUrlOldDate", "tieba", "bbs", "news", "blog", "mGenerated", "mTooDeep", "mLater", "mLater0", "mLater1", "mLater2", "mLater3", "mLater4", "mLater5", "mLater6", "mLater7", "mLaterN", "mAhead", "mSeedAhead", "mSeedLater", "mInactive", "pulsar-skeleton"})
        public static final class Counter
        extends Enum<Counter> {
            public static final /* enum */ Counter mSeeds = new Counter();
            public static final /* enum */ Counter mBanned = new Counter();
            public static final /* enum */ Counter mHostGone = new Counter();
            public static final /* enum */ Counter lastGenerated = new Counter();
            public static final /* enum */ Counter mBeforeStart = new Counter();
            public static final /* enum */ Counter mNotInRange = new Counter();
            public static final /* enum */ Counter mUrlMalformed = new Counter();
            public static final /* enum */ Counter mNotNormal = new Counter();
            public static final /* enum */ Counter mUrlFiltered = new Counter();
            public static final /* enum */ Counter mUrlOldDate = new Counter();
            public static final /* enum */ Counter tieba = new Counter();
            public static final /* enum */ Counter bbs = new Counter();
            public static final /* enum */ Counter news = new Counter();
            public static final /* enum */ Counter blog = new Counter();
            public static final /* enum */ Counter mGenerated = new Counter();
            public static final /* enum */ Counter mTooDeep = new Counter();
            public static final /* enum */ Counter mLater = new Counter();
            public static final /* enum */ Counter mLater0 = new Counter();
            public static final /* enum */ Counter mLater1 = new Counter();
            public static final /* enum */ Counter mLater2 = new Counter();
            public static final /* enum */ Counter mLater3 = new Counter();
            public static final /* enum */ Counter mLater4 = new Counter();
            public static final /* enum */ Counter mLater5 = new Counter();
            public static final /* enum */ Counter mLater6 = new Counter();
            public static final /* enum */ Counter mLater7 = new Counter();
            public static final /* enum */ Counter mLaterN = new Counter();
            public static final /* enum */ Counter mAhead = new Counter();
            public static final /* enum */ Counter mSeedAhead = new Counter();
            public static final /* enum */ Counter mSeedLater = new Counter();
            public static final /* enum */ Counter mInactive = new Counter();
            private static final /* synthetic */ Counter[] $VALUES;

            public static Counter[] values() {
                return (Counter[])$VALUES.clone();
            }

            public static Counter valueOf(String value) {
                return Enum.valueOf(Counter.class, value);
            }

            static {
                $VALUES = counterArray = new Counter[]{Counter.mSeeds, Counter.mBanned, Counter.mHostGone, Counter.lastGenerated, Counter.mBeforeStart, Counter.mNotInRange, Counter.mUrlMalformed, Counter.mNotNormal, Counter.mUrlFiltered, Counter.mUrlOldDate, Counter.tieba, Counter.bbs, Counter.news, Counter.blog, Counter.mGenerated, Counter.mTooDeep, Counter.mLater, Counter.mLater0, Counter.mLater1, Counter.mLater2, Counter.mLater3, Counter.mLater4, Counter.mLater5, Counter.mLater6, Counter.mLater7, Counter.mLaterN, Counter.mAhead, Counter.mSeedAhead, Counter.mSeedLater, Counter.mInactive};
            }
        }
    }
}

