/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexWriters;
import ai.platon.pulsar.crawl.index.IndexingFilters;
import ai.platon.pulsar.persist.WebPage;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lai/platon/pulsar/crawl/component/IndexComponent;", "", "indexingFilters", "Lai/platon/pulsar/crawl/index/IndexingFilters;", "indexWriters", "Lai/platon/pulsar/crawl/index/IndexWriters;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/index/IndexingFilters;Lai/platon/pulsar/crawl/index/IndexWriters;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getIndexWriters", "()Lai/platon/pulsar/crawl/index/IndexWriters;", "setIndexWriters", "(Lai/platon/pulsar/crawl/index/IndexWriters;)V", "indexWritersAreOpen", "", "getIndexingFilters", "()Lai/platon/pulsar/crawl/index/IndexingFilters;", "setIndexingFilters", "(Lai/platon/pulsar/crawl/index/IndexingFilters;)V", "commit", "", "index", "Lai/platon/pulsar/crawl/index/IndexDocument;", "page", "Lai/platon/pulsar/persist/WebPage;", "open", "indexerUrl", "", "Companion", "pulsar-skeleton"})
public final class IndexComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private IndexingFilters indexingFilters;
    @NotNull
    private IndexWriters indexWriters;
    @NotNull
    private ImmutableConfig conf;
    private boolean indexWritersAreOpen;
    private static final Logger LOG = LoggerFactory.getLogger(IndexComponent.class);

    public IndexComponent(@NotNull IndexingFilters indexingFilters, @NotNull IndexWriters indexWriters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)indexingFilters, (String)"indexingFilters");
        Intrinsics.checkNotNullParameter((Object)indexWriters, (String)"indexWriters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.indexingFilters = indexingFilters;
        this.indexWriters = indexWriters;
        this.conf = conf;
    }

    @NotNull
    public final IndexingFilters getIndexingFilters() {
        return this.indexingFilters;
    }

    public final void setIndexingFilters(@NotNull IndexingFilters indexingFilters) {
        Intrinsics.checkNotNullParameter((Object)indexingFilters, (String)"<set-?>");
        this.indexingFilters = indexingFilters;
    }

    @NotNull
    public final IndexWriters getIndexWriters() {
        return this.indexWriters;
    }

    public final void setIndexWriters(@NotNull IndexWriters indexWriters) {
        Intrinsics.checkNotNullParameter((Object)indexWriters, (String)"<set-?>");
        this.indexWriters = indexWriters;
    }

    public final void open() {
        if (!this.indexWritersAreOpen) {
            this.indexWriters.open();
            this.indexWritersAreOpen = true;
        }
    }

    public final void open(@NotNull String indexerUrl) {
        Intrinsics.checkNotNullParameter((Object)indexerUrl, (String)"indexerUrl");
        if (!this.indexWritersAreOpen) {
            this.indexWriters.open(indexerUrl);
            this.indexWritersAreOpen = true;
        }
    }

    @Nullable
    public final IndexDocument index(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String string = page.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.key");
        IndexDocument indexDocument = new IndexDocument(string);
        string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        IndexDocument doc = this.indexingFilters.filter(indexDocument, string, page);
        if (doc != null) {
            this.indexWriters.write(doc);
        }
        page.putIndexTimeHistory(Instant.now());
        return doc;
    }

    public final void commit() {
        this.indexWriters.commit();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/component/IndexComponent$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

