/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.crawl.common.WeakPageIndexer;
import ai.platon.pulsar.crawl.inject.SeedBuilder;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019J\u001a\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 J%\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0&\"\u00020 \u00a2\u0006\u0002\u0010'J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)J\u0006\u0010*\u001a\u00020 J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 J%\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0&\"\u00020 \u00a2\u0006\u0002\u0010'J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190)2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lai/platon/pulsar/crawl/component/InjectComponent;", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "seedBuilder", "Lai/platon/pulsar/crawl/inject/SeedBuilder;", "(Lai/platon/pulsar/crawl/inject/SeedBuilder;Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "seedIndexer", "Lai/platon/pulsar/crawl/common/WeakPageIndexer;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "close", "", "commit", "getParams", "Lai/platon/pulsar/common/config/Params;", "inject", "Lai/platon/pulsar/persist/WebPage;", "normUrl", "Lai/platon/pulsar/common/urls/NormUrl;", "", "page", "urlArgs", "Lkotlin/Pair;", "", "url", "args", "injectAll", "", "configuredUrls", "", "([Ljava/lang/String;)Ljava/util/List;", "pages", "", "report", "unInject", "unInjectAll", "urls", "Companion", "pulsar-skeleton"})
public final class InjectComponent
implements Parameterized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeedBuilder seedBuilder;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final WeakPageIndexer seedIndexer;
    @NotNull
    private final AtomicBoolean closed;
    private static final Logger LOG = LoggerFactory.getLogger(InjectComponent.class);

    public InjectComponent(@NotNull SeedBuilder seedBuilder, @NotNull WebDb webDb, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)seedBuilder, (String)"seedBuilder");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.seedBuilder = seedBuilder;
        this.webDb = webDb;
        this.conf = conf;
        this.seedIndexer = new WeakPageIndexer("http://internal.pulsar.platon.ai/seeds", this.webDb);
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public InjectComponent(@NotNull WebDb webDb, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new SeedBuilder(conf), webDb, conf);
    }

    @NotNull
    public Params getParams() {
        return this.seedBuilder.getParams();
    }

    @NotNull
    public final WebPage inject(@NotNull Pair<String, String> urlArgs) {
        Intrinsics.checkNotNullParameter(urlArgs, (String)"urlArgs");
        return this.inject((String)urlArgs.getFirst(), (String)urlArgs.getSecond());
    }

    @NotNull
    public final WebPage inject(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        return this.inject(normUrl.getSpec(), normUrl.getArgs());
    }

    @NotNull
    public final WebPage inject(@NotNull String url, @NotNull String args) {
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        WebPage page = WebDb.get$default((WebDb)this.webDb, (String)url, (boolean)false, null, (int)4, null);
        if (page.isNil()) {
            page = this.seedBuilder.create(url, args);
            if (page.isSeed()) {
                WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
                String string = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
                this.seedIndexer.index(string);
            }
            return page;
        }
        page.setArgs(args);
        if (this.inject(page)) {
            webPage = page;
        } else {
            WebPage webPage2 = WebPage.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)webPage2, (String)"NIL");
            webPage = webPage2;
        }
        return webPage;
    }

    public final boolean inject(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        boolean success = this.seedBuilder.makeSeed(page);
        if (success) {
            WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            this.seedIndexer.index(string);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WebPage> injectAll(String ... configuredUrls) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuredUrls, (String)"configuredUrls");
        String[] $this$map$iv = configuredUrls;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WebPage webPage = this.inject((Pair<String, String>)UrlUtils.splitUrlArgs((String)it));
            collection.add(webPage);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WebPage> injectAll(@NotNull Collection<WebPage> pages) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WebPage it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Iterable $this$onEach$iv = pages;
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            WebPage it2 = (WebPage)element$iv;
            boolean bl4 = false;
            this.inject(it2);
        }
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WebPage)element$iv$iv;
            boolean bl5 = false;
            if (!it.isSeed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List injectedPages = (List)destination$iv$iv;
        $this$filter$iv = injectedPages;
        WeakPageIndexer weakPageIndexer = this.seedIndexer;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WebPage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            String string = it.getUrl();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        weakPageIndexer.indexAll((Iterable<? extends CharSequence>)collection);
        LOG.info("Injected " + injectedPages.size() + " seeds out of " + pages.size() + " pages");
        return injectedPages;
    }

    @NotNull
    public final WebPage unInject(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebPage page = WebDb.get$default((WebDb)this.webDb, (String)url, (boolean)false, null, (int)6, null);
        if (page.isSeed()) {
            this.unInject(page);
        }
        return page;
    }

    @NotNull
    public final WebPage unInject(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (!page.isSeed()) {
            return page;
        }
        page.unmarkSeed();
        page.getMarks().remove(Mark.INJECT);
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        this.seedIndexer.remove(string);
        WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WebPage> unInjectAll(String ... urls) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        String[] $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_13 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_13).length;
        for (int i = 0; i < n; ++i) {
            WebPage webPage;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_13[i];
            boolean bl = false;
            void it2 = element$iv$iv;
            boolean bl2 = false;
            if (WebDb.getOrNull$default((WebDb)this.getWebDb(), (String)it2, (boolean)false, null, (int)6, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            WebPage it$iv$iv = webPage;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WebPage)element$iv$iv;
            boolean bl = false;
            if (!it.isSeed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        $this$filterTo$iv$iv = $this$onEach$iv;
        boolean destination$iv$iv2 = false;
        $i$f$filterTo = false;
        Iterable $this$apply$iv = $this$filterTo$iv$iv;
        boolean bl = false;
        for (Object element$iv : $this$apply$iv) {
            WebPage it3 = (WebPage)element$iv;
            boolean bl6 = false;
            this.unInject(it3);
        }
        List pages = (List)$this$filterTo$iv$iv;
        LOG.debug("UnInjected " + pages.size() + " urls");
        $this$onEach$iv = pages;
        WeakPageIndexer weakPageIndexer = this.seedIndexer;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WebPage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            String string = it.getUrl();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        weakPageIndexer.removeAll((Iterable<? extends CharSequence>)collection);
        return pages;
    }

    @NotNull
    public final Collection<WebPage> unInjectAll(@NotNull Collection<WebPage> pages) {
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Iterable $this$forEach$iv = pages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPage it = (WebPage)element$iv;
            boolean bl = false;
            this.unInject(it);
        }
        return pages;
    }

    @NotNull
    public final String report() {
        WebPage seedHome = WebDb.get$default((WebDb)this.webDb, (String)"http://internal.pulsar.platon.ai/seeds/1", (boolean)false, null, (int)6, null);
        if (seedHome.isNil()) {
            int count = seedHome.getLiveLinks().size();
            return "Total " + count + " seeds in store " + this.webDb.getSchemaName();
        }
        return "No home page";
    }

    public final void commit() {
        this.webDb.flush();
        this.seedIndexer.commit();
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.commit();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/component/InjectComponent$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

