/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.AppStatusTracker;
import ai.platon.pulsar.common.CheckState;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.measure.ByteUnitConverter;
import ai.platon.pulsar.common.message.LoadStatusFormatter;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.LoadEvent;
import ai.platon.pulsar.crawl.common.FetchEntry;
import ai.platon.pulsar.crawl.common.FetchState;
import ai.platon.pulsar.crawl.common.FetchingCache;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.common.url.CompletableHyperlink;
import ai.platon.pulsar.crawl.common.url.CompletableListenableHyperlink;
import ai.platon.pulsar.crawl.common.url.HyperlinksKt;
import ai.platon.pulsar.crawl.component.BatchFetchComponent;
import ai.platon.pulsar.crawl.component.LoadComponent;
import ai.platon.pulsar.crawl.component.ParseComponent;
import ai.platon.pulsar.crawl.component.UpdateComponent;
import ai.platon.pulsar.crawl.event.UrlEventHandler;
import ai.platon.pulsar.crawl.event.WebPageEventHandler;
import ai.platon.pulsar.crawl.parse.ParseResult;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import ai.platon.pulsar.persist.model.ActiveDOMStat;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 |2\u00020\u0001:\u0001|BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002J*\u0010F\u001a\u00020B2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010H2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001d0KH\u0002J\u0018\u0010L\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010M\u001a\u00020BH\u0016J\u0010\u0010N\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0012H\u0002J\u0010\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u0018\u0010R\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J!\u0010S\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ\u0018\u0010U\u001a\u00020B2\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u0012H\u0002J!\u0010V\u001a\u00020B2\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\u00020Y2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EJ\u0006\u0010Z\u001a\u00020BJ\u0012\u0010[\u001a\u0004\u0018\u00010\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u0018\u0010\\\u001a\u00020Y2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002J\"\u0010]\u001a\u00020Y2\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u00122\b\u0010^\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010_\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QJ\u0016\u0010_\u001a\u00020\u00122\u0006\u0010`\u001a\u00020a2\u0006\u0010D\u001a\u00020EJ\u0010\u0010b\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u0018\u0010c\u001a\u00020\u00122\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u0012H\u0002J\u001a\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00120e2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020Q0gJ \u0010h\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120i0e2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020Q0gJ\u0014\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00120i2\u0006\u0010P\u001a\u00020QJ\u0019\u0010k\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u0019\u0010m\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ!\u0010n\u001a\u00020\u00122\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010WJ\u000e\u0010o\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QJ\u0019\u0010p\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u0018\u0010q\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u0018\u0010r\u001a\u00020B2\u0006\u0010P\u001a\u00020Q2\u0006\u0010C\u001a\u00020\u0012H\u0002J\u001a\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010u\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010v\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010w\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0012H\u0002J*\u0010x\u001a\u00020B2\b\u0010y\u001a\u0004\u0018\u00010H2\b\u0010z\u001a\u0004\u0018\u00010H2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001d0KH\u0002J\u0018\u0010{\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020EH\u0002R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cj\u0002`\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010.R\u0016\u0010/\u001a\n 1*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u00104\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cj\u0002`58F\u00a2\u0006\u0006\u001a\u0004\b6\u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\n 1*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u000100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006}"}, d2={"Lai/platon/pulsar/crawl/component/LoadComponent;", "Ljava/lang/AutoCloseable;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "fetchComponent", "Lai/platon/pulsar/crawl/component/BatchFetchComponent;", "parseComponent", "Lai/platon/pulsar/crawl/component/ParseComponent;", "updateComponent", "Lai/platon/pulsar/crawl/component/UpdateComponent;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "statusTracker", "Lai/platon/pulsar/common/AppStatusTracker;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/crawl/component/BatchFetchComponent;Lai/platon/pulsar/crawl/component/ParseComponent;Lai/platon/pulsar/crawl/component/UpdateComponent;Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/common/AppStatusTracker;)V", "abnormalPage", "Lai/platon/pulsar/persist/WebPage;", "getAbnormalPage", "()Lai/platon/pulsar/persist/WebPage;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "getCoreMetrics", "()Lai/platon/pulsar/crawl/CoreMetrics;", "documentCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/pulsar/dom/FeaturedDocument;", "Lai/platon/pulsar/crawl/common/DocumentCatch;", "getDocumentCache", "()Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "getFetchComponent", "()Lai/platon/pulsar/crawl/component/BatchFetchComponent;", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numWrite", "", "pageCache", "Lai/platon/pulsar/crawl/common/PageCatch;", "getPageCache", "getParseComponent", "()Lai/platon/pulsar/crawl/component/ParseComponent;", "getStatusTracker", "()Lai/platon/pulsar/common/AppStatusTracker;", "taskLogger", "tracer", "getUpdateComponent", "()Lai/platon/pulsar/crawl/component/UpdateComponent;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "afterFetch", "", "page", "options", "Lai/platon/pulsar/common/options/LoadOptions;", "assertSame", "a", "", "b", "lazyMessage", "Lkotlin/Function0;", "beforeFetch", "close", "collectPersistMetrics", "createPageShell", "normUrl", "Lai/platon/pulsar/common/urls/NormUrl;", "fetchContent", "fetchContentDeferred", "(Lai/platon/pulsar/persist/WebPage;Lai/platon/pulsar/common/urls/NormUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchContentIfNecessary", "fetchContentIfNecessaryDeferred", "(Lai/platon/pulsar/common/urls/NormUrl;Lai/platon/pulsar/persist/WebPage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchState", "Lai/platon/pulsar/common/CheckState;", "flush", "getCachedPageOrNull", "getFetchStateForExistPage", "initFetchState", "loadedPage", "load", "url", "Ljava/net/URL;", "load0", "load1", "loadAll", "", "normUrls", "", "loadAllAsync", "Ljava/util/concurrent/CompletableFuture;", "loadAsync", "loadDeferred", "(Lai/platon/pulsar/common/urls/NormUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadDeferred0", "loadDeferred1", "loadWithRetry", "loadWithRetryDeferred", "onLoaded", "onWillLoad", "parse", "Lai/platon/pulsar/crawl/parse/ParseResult;", "persist", "processPageContent", "report", "shouldBe", "expected", "actual", "update", "Companion", "pulsar-skeleton"})
public final class LoadComponent
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final BatchFetchComponent fetchComponent;
    @NotNull
    private final ParseComponent parseComponent;
    @NotNull
    private final UpdateComponent updateComponent;
    @NotNull
    private final ImmutableConfig immutableConfig;
    @Nullable
    private final AppStatusTracker statusTracker;
    private final Logger logger;
    private final Logger taskLogger;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final AtomicBoolean closed;
    private volatile int numWrite;
    @NotNull
    private static final String VAR_REFRESH = "refresh";
    @NotNull
    private static final AtomicLong pageCacheHits = new AtomicLong();
    @NotNull
    private static final AtomicLong dbGetCount = new AtomicLong();

    /*
     * WARNING - void declaration
     */
    public LoadComponent(@NotNull WebDb webDb, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull BatchFetchComponent fetchComponent, @NotNull ParseComponent parseComponent, @NotNull UpdateComponent updateComponent, @NotNull ImmutableConfig immutableConfig, @Nullable AppStatusTracker statusTracker) {
        void it;
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)fetchComponent, (String)"fetchComponent");
        Intrinsics.checkNotNullParameter((Object)parseComponent, (String)"parseComponent");
        Intrinsics.checkNotNullParameter((Object)updateComponent, (String)"updateComponent");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.webDb = webDb;
        this.globalCacheFactory = globalCacheFactory;
        this.fetchComponent = fetchComponent;
        this.parseComponent = parseComponent;
        this.updateComponent = updateComponent;
        this.immutableConfig = immutableConfig;
        this.statusTracker = statusTracker;
        this.logger = LoggerFactory.getLogger(LoadComponent.class);
        this.taskLogger = LoggerFactory.getLogger((String)(LoadComponent.class.getName() + ".Task"));
        Logger logger = this.logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = logger;
        LoadComponent loadComponent = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        loadComponent.tracer = bl4 ? logger : null;
        this.closed = new AtomicBoolean();
    }

    public /* synthetic */ LoadComponent(WebDb webDb, GlobalCacheFactory globalCacheFactory, BatchFetchComponent batchFetchComponent, ParseComponent parseComponent, UpdateComponent updateComponent, ImmutableConfig immutableConfig, AppStatusTracker appStatusTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            appStatusTracker = null;
        }
        this(webDb, globalCacheFactory, batchFetchComponent, parseComponent, updateComponent, immutableConfig, appStatusTracker);
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    public final BatchFetchComponent getFetchComponent() {
        return this.fetchComponent;
    }

    @NotNull
    public final ParseComponent getParseComponent() {
        return this.parseComponent;
    }

    @NotNull
    public final UpdateComponent getUpdateComponent() {
        return this.updateComponent;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    @Nullable
    public final AppStatusTracker getStatusTracker() {
        return this.statusTracker;
    }

    @NotNull
    public final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    public final ConcurrentExpiringLRUCache<String, WebPage> getPageCache() {
        return this.getGlobalCache().getPageCache();
    }

    @NotNull
    public final ConcurrentExpiringLRUCache<String, FeaturedDocument> getDocumentCache() {
        return this.getGlobalCache().getDocumentCache();
    }

    private final CoreMetrics getCoreMetrics() {
        return this.fetchComponent.getCoreMetrics();
    }

    private final boolean isActive() {
        return !this.closed.get();
    }

    private final WebPage getAbnormalPage() {
        WebPage webPage = WebPage.NIL;
        boolean bl = false;
        boolean bl2 = false;
        WebPage it = webPage;
        boolean bl3 = false;
        return !this.isActive() ? webPage : null;
    }

    @NotNull
    public final CheckState fetchState(@NotNull WebPage page, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ProtocolStatus protocolStatus = page.getProtocolStatus();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"page.protocolStatus");
        ProtocolStatus protocolStatus2 = protocolStatus;
        return this.closed.get() ? new CheckState(0, "closed", null, 4, null) : (page.isNil() ? new CheckState(1, "nil", null, 4, null) : (page.isInternal() ? new CheckState(0, "internal", null, 4, null) : (protocolStatus2.isNotFetched() ? new CheckState(1, "not fetched", null, 4, null) : (protocolStatus2.isTempMoved() ? new CheckState(300, "temp moved", null, 4, null) : this.getFetchStateForExistPage(page, options)))));
    }

    @NotNull
    public final WebPage load(@NotNull URL url, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WebPage webPage = this.getAbnormalPage();
        return webPage == null ? this.loadWithRetry(new NormUrl(url, options, null, null, 12, null)) : webPage;
    }

    @NotNull
    public final WebPage load(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        WebPage webPage = this.getAbnormalPage();
        return webPage == null ? this.loadWithRetry(normUrl) : webPage;
    }

    @Nullable
    public final Object loadDeferred(@NotNull NormUrl normUrl, @NotNull Continuation<? super WebPage> $completion) {
        WebPage webPage = this.getAbnormalPage();
        if (webPage == null) {
            return this.loadWithRetryDeferred(normUrl, $completion);
        }
        return webPage;
    }

    @NotNull
    public final WebPage loadWithRetry(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        if (normUrl.isNil()) {
            WebPage webPage = WebPage.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"NIL");
            return webPage;
        }
        WebPage page = this.load0(normUrl);
        int n = normUrl.getOptions().getNJitRetry();
        while (page.getProtocolStatus().isRetry()) {
            int n2 = n;
            n = n2 + -1;
            if (n2 <= 0) break;
            page = this.load0(normUrl);
        }
        return page;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadWithRetryDeferred(@NotNull NormUrl var1_1, @NotNull Continuation<? super WebPage> var2_2) {
        if (!(var2_2 instanceof loadWithRetryDeferred.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LoadComponent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadWithRetryDeferred(null, (Continuation<? super WebPage>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (normUrl.isNil()) {
                    var3_6 = WebPage.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"NIL");
                    return var3_6;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = normUrl;
                $continuation.label = 1;
                v0 = this.loadDeferred0(normUrl, (Continuation<? super WebPage>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                normUrl = (NormUrl)$continuation.L$1;
                this = (LoadComponent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                page = (WebPage)v0;
                n = normUrl.getOptions().getNJitRetry();
lbl30:
                // 2 sources

                while (page.getProtocolStatus().isRetry()) {
                    var5_9 = n;
                    n = var5_9 + -1;
                    if (var5_9 <= 0) break block0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = normUrl;
                    $continuation.I$0 = n;
                    $continuation.label = 2;
                    v1 = this.loadDeferred0(normUrl, (Continuation<? super WebPage>)$continuation);
                    if (v1 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl49
                }
                break;
            }
            case 2: {
                n = $continuation.I$0;
                normUrl = (NormUrl)$continuation.L$1;
                this = (LoadComponent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                page = (WebPage)v1;
                ** GOTO lbl30
            }
        }
        return page;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WebPage> loadAll(@NotNull Iterable<? extends NormUrl> normUrls) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(normUrls, (String)"normUrls");
        if (!normUrls.iterator().hasNext()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        Iterable<? extends NormUrl> iterable = normUrls;
        LoadComponent loadComponent = this;
        boolean $i$f$filter22 = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NormUrl it = (NormUrl)element$iv$iv;
            boolean bl = false;
            if (!(!it.isNil())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        List<CompletableFuture<WebPage>> futures = loadComponent.loadAllAsync(list);
        this.logger.info("Waiting for {} completable links | @{}", (Object)futures.size(), (Object)((Object)futures).hashCode());
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        if (completableFutureArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        CompletableFuture[] $i$f$filter22 = completableFutureArray;
        CompletableFuture<Void> future = CompletableFuture.allOf(Arrays.copyOf($i$f$filter22, $i$f$filter22.length));
        future.join();
        Iterable $this$mapNotNull$iv = futures;
        boolean $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WebPage webPage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CompletableFuture it = (CompletableFuture)element$iv$iv;
            boolean bl2 = false;
            Object t = it.get();
            boolean bl3 = false;
            boolean bl4 = false;
            WebPage it2 = (WebPage)t;
            boolean bl5 = false;
            if ((WebPage)(it2.isNotNil() ? t : null) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            WebPage it$iv$iv = webPage;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List pages = (List)destination$iv$iv2;
        objectArray = new Object[]{pages.size(), futures.size(), ((Object)futures).hashCode()};
        this.logger.info("Finished {}/{} pages | @{}", objectArray);
        return pages;
    }

    @NotNull
    public final CompletableFuture<WebPage> loadAsync(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        CompletableListenableHyperlink<WebPage> link = HyperlinksKt.toCompletableListenableHyperlink(normUrl);
        this.getGlobalCache().getUrlPool().add((UrlAware)link);
        return link;
    }

    @NotNull
    public final List<CompletableFuture<WebPage>> loadAllAsync(@NotNull Iterable<? extends NormUrl> normUrls) {
        Intrinsics.checkNotNullParameter(normUrls, (String)"normUrls");
        if (!normUrls.iterator().hasNext()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        List linkFutures2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(normUrls), (Function1)loadAllAsync.linkFutures.1.INSTANCE), (Function1)loadAllAsync.linkFutures.2.INSTANCE), (Function1)loadAllAsync.linkFutures.3.INSTANCE));
        this.getGlobalCache().getUrlPool().addAll((Iterable)linkFutures2);
        return linkFutures2;
    }

    private final WebPage load0(NormUrl normUrl) {
        WebPage page = this.createPageShell(normUrl);
        return this.load1(normUrl, page);
    }

    private final WebPage load1(NormUrl normUrl, WebPage page) {
        this.onWillLoad(normUrl, page);
        this.fetchContentIfNecessary(normUrl, page);
        this.onLoaded(page, normUrl);
        return page;
    }

    private final Object loadDeferred0(NormUrl normUrl, Continuation<? super WebPage> $completion) {
        WebPage page = this.createPageShell(normUrl);
        return this.loadDeferred1(normUrl, page, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadDeferred1(NormUrl var1_1, WebPage var2_2, Continuation<? super WebPage> var3_3) {
        if (!(var3_3 instanceof loadDeferred1.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ LoadComponent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LoadComponent.access$loadDeferred1(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.onWillLoad(normUrl, page);
                $continuation.L$0 = this;
                $continuation.L$1 = normUrl;
                $continuation.L$2 = page;
                $continuation.label = 1;
                v0 = this.fetchContentIfNecessaryDeferred(normUrl, page, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                page = (WebPage)$continuation.L$2;
                normUrl = (NormUrl)$continuation.L$1;
                this = (LoadComponent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                this.onLoaded(page, normUrl);
                return page;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void fetchContentIfNecessary(NormUrl normUrl, WebPage page) {
        if (page.removeVar(VAR_REFRESH) != null) {
            this.fetchContent(page, normUrl);
        }
    }

    private final Object fetchContentIfNecessaryDeferred(NormUrl normUrl, WebPage page, Continuation<? super Unit> $completion) {
        if (page.removeVar(VAR_REFRESH) != null) {
            Object object = this.fetchContentDeferred(page, normUrl, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final WebPage createPageShell(NormUrl normUrl) {
        WebPage cachedPage = this.getCachedPageOrNull(normUrl);
        WebPage page = FetchEntry.Companion.createPageShell(normUrl);
        if (cachedPage != null) {
            pageCacheHits.incrementAndGet();
            page.setCached(true);
            page.unsafeCloneGPage(cachedPage);
            page.clearPersistContent();
            page.setTmpContent(cachedPage.getContent());
            page.unbox().clearDirty();
            boolean bl = !page.isFetched();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = page.isNotInternal();
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else {
            WebPage loadedPage = WebDb.getOrNull$default((WebDb)this.webDb, (String)normUrl.getSpec(), (boolean)false, null, (int)6, null);
            dbGetCount.incrementAndGet();
            if (loadedPage != null) {
                FetchEntry.Companion.initWebPage$default(FetchEntry.Companion, loadedPage, normUrl.getOptions(), normUrl.getHrefSpec(), null, 8, null);
                page = loadedPage;
            }
            this.initFetchState(normUrl, page, loadedPage);
        }
        return page;
    }

    private final CheckState initFetchState(NormUrl normUrl, WebPage page, WebPage loadedPage) {
        LoadOptions options = normUrl.getOptions();
        CheckState state = loadedPage == null ? new CheckState(1, "nil 1", null, 4, null) : (loadedPage.isNil() ? new CheckState(1, "nil 2", null, 4, null) : (loadedPage.isInternal() ? new CheckState(0, "internal 1", null, 4, null) : this.fetchState(page, options)));
        page.setVar("fetch_state", (Object)state);
        boolean refresh = FetchState.INSTANCE.getRefreshCodes().contains(state.getCode());
        if (refresh) {
            page.setVar(VAR_REFRESH, (Object)state);
        }
        return state;
    }

    private final void onWillLoad(NormUrl normUrl, WebPage page) {
        LoadOptions options = normUrl.getOptions();
        this.shouldBe(options.getConf(), page.getConf(), (Function0<String>)((Function0)new Function0<String>(options, page){
            final /* synthetic */ LoadOptions $options;
            final /* synthetic */ WebPage $page;
            {
                this.$options = $options;
                this.$page = $page;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Conf should be the same \n" + this.$options.getConf() + " \n" + this.$page.getConf();
            }
        }));
        try {
            UrlEventHandler urlEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (urlEventHandler = loadEvent.getOnWillLoad()) != null) {
                String string = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
                urlEventHandler.invoke(string);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Failed to invoke beforeLoad | " + page.getConfiguredUrl(), e);
        }
    }

    private final void onLoaded(WebPage page, NormUrl normUrl) {
        LoadOptions options = normUrl.getOptions();
        Object object = page.getProtocolStatus();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.protocolStatus");
        ProtocolStatus status = object;
        if (!page.isCached()) {
            // empty if block
        }
        if (!options.getReadonly()) {
            if (page.isFetched() && page.getProtocolStatus().isSuccess()) {
                ConcurrentExpiringLRUCache<String, FeaturedDocument> concurrentExpiringLRUCache = this.getDocumentCache();
                object = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
                concurrentExpiringLRUCache.remove(object);
            }
            ConcurrentExpiringLRUCache<String, WebPage> concurrentExpiringLRUCache = this.getPageCache();
            object = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
            ConcurrentExpiringLRUCache.putDatum$default(concurrentExpiringLRUCache, (Object)object, (Object)page, (long)0L, (int)4, null);
        }
        if (!page.isCached()) {
            this.report(page);
        }
        if (options.getParse()) {
            this.parse(page, normUrl.getOptions());
        }
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent;
            if (normUrl.getDetail() instanceof CompletableHyperlink) {
                WebPageEventHandler webPageEventHandler2;
                object = WebPageExKt.getLoadEvent(page);
                boolean bl = object == null ? false : ((webPageEventHandler2 = object.getOnLoaded()) == null ? false : webPageEventHandler2.isNotEmpty());
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "A completable link must have a onLoaded handler";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            if ((loadEvent = WebPageExKt.getLoadEvent(page)) != null && (webPageEventHandler = loadEvent.getOnLoaded()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Failed to invoke onLoaded | " + page.getConfiguredUrl(), e);
        }
        if (options.getPersist() && !status.isCanceled() && !options.getReadonly()) {
            this.persist(page, options);
        }
    }

    private final ParseResult parse(WebPage page, LoadOptions options) {
        ParseComponent parseComponent;
        ParseComponent parseComponent2 = this.parseComponent;
        boolean bl = false;
        boolean bl2 = false;
        ParseComponent it = parseComponent2;
        boolean bl3 = false;
        ParseComponent parseComponent3 = parseComponent = options.getParse() ? parseComponent2 : null;
        if (parseComponent == null) {
            return null;
        }
        ParseComponent parser = parseComponent;
        ParseResult parseResult = parser.parse(page, options.getReparseLinks(), options.getNoFilter());
        parseComponent2 = this.tracer;
        if (parseComponent2 != null) {
            parseComponent2.trace("ParseResult: {} ParseReport: {}", (Object)parseResult, parser.getTraceInfo());
        }
        return parseResult;
    }

    private final void processPageContent(WebPage page, NormUrl normUrl) {
        LoadOptions options = normUrl.getOptions();
        if (page.getProtocolStatus().isSuccess() && page.getContent() == null) {
            this.shouldBe(false, page.isFetched(), (Function0<String>)((Function0)new Function0<String>(page){
                final /* synthetic */ WebPage $page;
                {
                    this.$page = $page;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Page should not be fetched | " + this.$page.getConfiguredUrl();
                }
            }));
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            WebPage contentPage = this.webDb.getOrNull(string, GWebPage.Field.CONTENT);
            if (contentPage != null) {
                page.setContent(contentPage.getContent());
                page.unbox().clearDirty(GWebPage.Field.CONTENT.getIndex());
            }
        }
        this.shouldBe(options.getConf(), page.getConf(), (Function0<String>)((Function0)new Function0<String>(options, page){
            final /* synthetic */ LoadOptions $options;
            final /* synthetic */ WebPage $page;
            {
                this.$options = $options;
                this.$page = $page;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Conf should be the same \n" + this.$options.getConf() + " \n" + this.$page.getConf();
            }
        }));
    }

    private final void report(WebPage page) {
        if (this.taskLogger.isInfoEnabled()) {
            boolean verbose = this.taskLogger.isDebugEnabled();
            String report2 = new LoadStatusFormatter(page, null, true, false, false, verbose, 26, null).toString();
            this.taskLogger.info(report2);
        }
    }

    private final WebPage getCachedPageOrNull(NormUrl normUrl) {
        NormUrl normUrl2 = normUrl;
        String url = normUrl2.component1();
        LoadOptions options = normUrl2.component2();
        if (options.getRefresh()) {
            return null;
        }
        Instant now = Instant.now();
        ConcurrentExpiringLRUCache<String, WebPage> concurrentExpiringLRUCache = this.getPageCache();
        Comparable<Duration> comparable = options.getExpires();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"options.expires");
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        WebPage cachedPage = (WebPage)concurrentExpiringLRUCache.getDatum((Object)url, comparable, now);
        if (cachedPage != null) {
            comparable = cachedPage.getPrevFetchTime();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"cachedPage.prevFetchTime");
            if (!options.isExpired((Instant)comparable)) {
                return cachedPage;
            }
        }
        return null;
    }

    private final void beforeFetch(WebPage page, LoadOptions options) {
        page.setVar("prev_fetch_time_before_update", (Object)page.getPrevFetchTime());
        FetchingCache fetchingCache = this.getGlobalCache().getFetchingCache();
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        fetchingCache.add(string);
        Logger logger = this.logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger it = logger;
        boolean bl3 = false;
        Object object = string = it.isDebugEnabled() ? logger : null;
        if (string != null) {
            string.debug("Loading url | {} {}", (Object)page.getUrl(), (Object)page.getArgs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fetchContent(WebPage page, NormUrl normUrl) {
        try {
            this.beforeFetch(page, normUrl.getOptions());
            boolean bl = Intrinsics.areEqual((Object)page.getConf(), (Object)normUrl.getOptions().getConf());
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.fetchComponent.fetchContent(page);
        }
        finally {
            this.afterFetch(page, normUrl.getOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object fetchContentDeferred(WebPage var1_1, NormUrl var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof fetchContentDeferred.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ LoadComponent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LoadComponent.access$fetchContentDeferred(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.beforeFetch(page, normUrl.getOptions());
                $continuation.L$0 = this;
                $continuation.L$1 = page;
                $continuation.L$2 = normUrl;
                $continuation.label = 1;
                v0 = this.getFetchComponent().fetchContentDeferred(page, (Continuation<? super WebPage>)$continuation);
                ** if (v0 != var7_6) goto lbl22
lbl21:
                // 1 sources

                return var7_6;
lbl22:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                normUrl = (NormUrl)$continuation.L$2;
                page = (WebPage)$continuation.L$1;
                this = (LoadComponent)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var4_7) {
                    throw var4_7;
                }
                finally {
                    this.afterFetch(page, normUrl.getOptions());
                }
lbl37:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void afterFetch(WebPage page, LoadOptions options) {
        this.update(page, options);
        FetchingCache fetchingCache = this.getGlobalCache().getFetchingCache();
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        fetchingCache.remove(string);
    }

    private final CheckState getFetchStateForExistPage(WebPage page, LoadOptions options) {
        MiscMessageWriter miscMessageWriter;
        CrawlStatus crawlStatus = page.getCrawlStatus();
        Intrinsics.checkNotNullExpressionValue((Object)crawlStatus, (String)"page.crawlStatus");
        CrawlStatus crawlStatus2 = crawlStatus;
        ProtocolStatus protocolStatus = page.getProtocolStatus();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"page.protocolStatus");
        ProtocolStatus protocolStatus2 = protocolStatus;
        if (options.getRefresh()) {
            page.setFetchRetries(0);
            return new CheckState(6, VAR_REFRESH, null, 4, null);
        }
        boolean ignoreFailure = options.getIgnoreFailure();
        if (protocolStatus2.isRetry()) {
            return new CheckState(301, "retry", null, 4, null);
        }
        if (protocolStatus2.isFailed() && !ignoreFailure) {
            return new CheckState(0, "failed", null, 4, null);
        }
        Instant now = Instant.now();
        Object object = page.getPrevFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.prevFetchTime");
        Instant prevFetchTime = object;
        if (prevFetchTime.isBefore(AppConstants.TCP_IP_STANDARDIZED_TIME) && (object = this.statusTracker) != null && (miscMessageWriter = ((AppStatusTracker)object).getMessageWriter()) != null) {
            miscMessageWriter.debugIllegalLastFetchTime(page);
        }
        if (options.isExpired(prevFetchTime)) {
            return new CheckState(2, "expired 1", null, 4, null);
        }
        Duration duration = Duration.between(page.getFetchTime(), now);
        long days = duration.toDays();
        if (duration.toMillis() > 0L && days < 3L) {
            return new CheckState(5, "scheduled", null, 4, null);
        }
        if (page.getPersistedContentLength() == 0L) {
            // empty if block
        }
        if (page.getPersistedContentLength() < (long)options.getRequireSize()) {
            return new CheckState(10, "small content", null, 4, null);
        }
        Map map2 = page.getActiveDOMStatTrace();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"page.activeDOMStatTrace");
        Map domStats = map2;
        ActiveDOMStat activeDOMStat = (ActiveDOMStat)domStats.get("lastStat");
        map2 = activeDOMStat == null ? new ActiveDOMStat(0, 0, 0, 0, 0, 0, 63, null) : activeDOMStat;
        int ni = map2.component1();
        int na = map2.component2();
        if (ni < options.getRequireImages()) {
            return new CheckState(11, "miss image", null, 4, null);
        }
        if (na < options.getRequireAnchors()) {
            return new CheckState(11, "miss anchor", null, 4, null);
        }
        return new CheckState(0, "unknown", null, 4, null);
    }

    private final void update(WebPage page, LoadOptions options) {
        if (page.isInternal()) {
            return;
        }
        if (!page.isFetched() || page.getProtocolStatus().isCanceled()) {
            return;
        }
        this.updateComponent.updateFetchSchedule(page);
        boolean bl = page.isFetched();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void persist(WebPage page, LoadOptions options) {
        if (!options.getStoreContent() && page.getContent() != null) {
            page.clearPersistContent();
        }
        if (page.isCached()) {
            page.unbox().clearDirty(GWebPage.Field.CONTENT.getIndex());
            boolean bl = !page.unbox().isContentDirty();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
        LoadComponent loadComponent = this;
        ++loadComponent.numWrite;
        int cfr_ignored_0 = loadComponent.numWrite;
        this.collectPersistMetrics(page);
        if (this.numWrite < 200) {
            this.flush();
        } else if (!options.getLazyFlush() || this.numWrite % 20 == 0) {
            this.flush();
        }
    }

    private final void collectPersistMetrics(WebPage page) {
        Logger logger;
        CoreMetrics metrics = this.getCoreMetrics();
        if (metrics != null) {
            int n;
            byte[] byArray;
            int bytes;
            metrics.getPersists().mark();
            ByteBuffer byteBuffer = page.getContent();
            int n2 = byteBuffer == null ? 0 : (bytes = (byArray = byteBuffer.array()) == null ? 0 : (n = byArray.length));
            if (bytes > 0) {
                metrics.getContentPersists().mark();
                metrics.getPersistContentMBytes().inc((long)ByteUnitConverter.INSTANCE.convert(bytes, "M"));
            }
        }
        if ((logger = this.tracer) != null) {
            logger.trace("Persisted {} | {}", (Object)Strings.readableBytes((long)page.getContentLength()), (Object)page.getUrl());
        }
    }

    public final void flush() {
        this.webDb.flush();
    }

    @Override
    public void close() {
        this.closed.compareAndSet(false, true);
    }

    private final void assertSame(Object a, Object b, Function0<String> lazyMessage) {
        boolean bl = a == b;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalArgumentException(object.toString());
        }
    }

    private final void shouldBe(Object expected, Object actual, Function0<String> lazyMessage) {
        if (!Intrinsics.areEqual((Object)actual, (Object)expected)) {
            this.logger.warn((String)lazyMessage.invoke());
        }
    }

    public static final /* synthetic */ Object access$loadDeferred0(LoadComponent $this, NormUrl normUrl, Continuation $completion) {
        return $this.loadDeferred0(normUrl, (Continuation<? super WebPage>)$completion);
    }

    public static final /* synthetic */ Object access$loadDeferred1(LoadComponent $this, NormUrl normUrl, WebPage page, Continuation $completion) {
        return $this.loadDeferred1(normUrl, page, (Continuation<? super WebPage>)$completion);
    }

    public static final /* synthetic */ Object access$fetchContentIfNecessaryDeferred(LoadComponent $this, NormUrl normUrl, WebPage page, Continuation $completion) {
        return $this.fetchContentIfNecessaryDeferred(normUrl, page, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$fetchContentDeferred(LoadComponent $this, WebPage page, NormUrl normUrl, Continuation $completion) {
        return $this.fetchContentDeferred(page, normUrl, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/crawl/component/LoadComponent$Companion;", "", "()V", "VAR_REFRESH", "", "dbGetCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getDbGetCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "pageCacheHits", "getPageCacheHits", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getPageCacheHits() {
            return pageCacheHits;
        }

        @NotNull
        public final AtomicLong getDbGetCount() {
            return dbGetCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

