/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.component.ParseComponent;
import ai.platon.pulsar.crawl.filter.CrawlFilters;
import ai.platon.pulsar.crawl.parse.PageParser;
import ai.platon.pulsar.crawl.parse.ParseResult;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Name;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010%J\"\u0010&\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lai/platon/pulsar/crawl/component/ParseComponent;", "", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "crawlFilters", "Lai/platon/pulsar/crawl/filter/CrawlFilters;", "pageParser", "Lai/platon/pulsar/crawl/parse/PageParser;", "(Lai/platon/pulsar/crawl/filter/CrawlFilters;Lai/platon/pulsar/crawl/parse/PageParser;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlFilters", "()Lai/platon/pulsar/crawl/filter/CrawlFilters;", "getGlobalCacheFactory", "()Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPageParser", "()Lai/platon/pulsar/crawl/parse/PageParser;", "traceInfo", "Ljava/util/concurrent/ConcurrentHashMap;", "", "afterParse", "", "page", "Lai/platon/pulsar/persist/WebPage;", "result", "Lai/platon/pulsar/crawl/parse/ParseResult;", "beforeParse", "reparseLinks", "", "noLinkFilter", "getTraceInfo", "", "parse", "Companion", "pulsar-skeleton"})
public final class ParseComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrawlFilters crawlFilters;
    @NotNull
    private final PageParser pageParser;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    @Nullable
    private ConcurrentHashMap<String, Object> traceInfo;
    @NotNull
    private static final AtomicInteger numParses = new AtomicInteger();
    @NotNull
    private static final AtomicInteger numParsed = new AtomicInteger();

    public ParseComponent(@NotNull CrawlFilters crawlFilters, @NotNull PageParser pageParser, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)crawlFilters, (String)"crawlFilters");
        Intrinsics.checkNotNullParameter((Object)pageParser, (String)"pageParser");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.crawlFilters = crawlFilters;
        this.pageParser = pageParser;
        this.globalCacheFactory = globalCacheFactory;
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(ParseComponent.class);
    }

    @NotNull
    public final CrawlFilters getCrawlFilters() {
        return this.crawlFilters;
    }

    @NotNull
    public final PageParser getPageParser() {
        return this.pageParser;
    }

    @NotNull
    public final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public ParseComponent(@NotNull GlobalCacheFactory globalCacheFactory, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new CrawlFilters(conf), new PageParser(conf), globalCacheFactory, conf);
    }

    @NotNull
    public final ParseResult parse(@NotNull WebPage page, boolean reparseLinks, boolean noLinkFilter) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.beforeParse(page, reparseLinks, noLinkFilter);
        ParseResult parseResult = this.pageParser.parse(page);
        boolean bl = false;
        boolean bl2 = false;
        ParseResult it = parseResult;
        boolean bl3 = false;
        this.afterParse(page, it);
        return parseResult;
    }

    public static /* synthetic */ ParseResult parse$default(ParseComponent parseComponent, WebPage webPage, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return parseComponent.parse(webPage, bl, bl2);
    }

    private final void beforeParse(WebPage page, boolean reparseLinks, boolean noLinkFilter) {
        ConcurrentHashMap<String, Object> concurrentHashMap;
        numParses.incrementAndGet();
        if (reparseLinks) {
            page.getVariables().set(Name.FORCE_FOLLOW, (Object)"y");
            page.getVariables().set(Name.REPARSE_LINKS, (Object)"y");
            page.getVariables().set(Name.PARSE_LINK_FILTER_DEBUG_LEVEL, (Object)1);
        }
        if (noLinkFilter) {
            page.getVariables().set(Name.PARSE_NO_LINK_FILTER, (Object)"y");
        }
        if ((concurrentHashMap = this.traceInfo) != null) {
            concurrentHashMap.clear();
        }
    }

    private final void afterParse(WebPage page, ParseResult result) {
        page.getVariables().remove(Name.REPARSE_LINKS);
        page.getVariables().remove(Name.FORCE_FOLLOW);
        page.getVariables().remove(Name.PARSE_LINK_FILTER_DEBUG_LEVEL);
        page.getVariables().remove(Name.PARSE_NO_LINK_FILTER);
        FeaturedDocument document = result.getDocument();
        if (document != null) {
            ConcurrentExpiringLRUCache<String, FeaturedDocument> concurrentExpiringLRUCache = this.globalCacheFactory.getGlobalCache().getDocumentCache();
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            ConcurrentExpiringLRUCache.putDatum$default(concurrentExpiringLRUCache, (Object)string, (Object)document, (long)0L, (int)4, null);
        }
        numParsed.incrementAndGet();
    }

    @NotNull
    public final Map<String, Object> getTraceInfo() {
        Map map2;
        ConcurrentHashMap<String, Object> concurrentHashMap;
        if (this.traceInfo == null) {
            this.traceInfo = new ConcurrentHashMap();
        }
        if ((concurrentHashMap = this.traceInfo) != null) {
            ConcurrentHashMap<String, Object> concurrentHashMap2 = concurrentHashMap;
            boolean bl = false;
            boolean bl2 = false;
            ConcurrentHashMap<String, Object> it = concurrentHashMap2;
            boolean bl3 = false;
            it.clear();
            Map map3 = it;
            String string = "linkFilterReport";
            String string2 = CollectionsKt.joinToString$default((Iterable)this.getPageParser().getLinkFilter().getFilterReport(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getTraceInfo.1.1.INSTANCE, (int)30, null);
            boolean bl4 = false;
            map3.put(string, string2);
        }
        concurrentHashMap = this.traceInfo;
        if (concurrentHashMap == null) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        } else {
            map2 = concurrentHashMap;
        }
        return map2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/crawl/component/ParseComponent$Companion;", "", "()V", "numParsed", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumParsed", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numParses", "getNumParses", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getNumParses() {
            return numParses;
        }

        @NotNull
        public final AtomicInteger getNumParsed() {
            return numParsed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

