/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.crawl.filter.CrawlFilter;
import ai.platon.pulsar.crawl.schedule.DefaultFetchSchedule;
import ai.platon.pulsar.crawl.schedule.FetchSchedule;
import ai.platon.pulsar.crawl.schedule.ModifyInfo;
import ai.platon.pulsar.crawl.scoring.ScoringFilters;
import ai.platon.pulsar.crawl.signature.SignatureComparator;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.WebPageExt;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020\"2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020$0+2\u0006\u0010#\u001a\u00020$J\u0016\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020$J\u001c\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020$0+J\u000e\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u001e\u00101\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010#\u001a\u00020$R\u0019\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00066"}, d2={"Lai/platon/pulsar/crawl/component/UpdateComponent;", "Lai/platon/pulsar/common/config/Parameterized;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "fetchSchedule", "Lai/platon/pulsar/crawl/schedule/FetchSchedule;", "scoringFilters", "Lai/platon/pulsar/crawl/scoring/ScoringFilters;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/crawl/schedule/FetchSchedule;Lai/platon/pulsar/crawl/scoring/ScoringFilters;Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "enumCounters", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "getFetchSchedule", "()Lai/platon/pulsar/crawl/schedule/FetchSchedule;", "getMessageWriter", "()Lai/platon/pulsar/common/message/MiscMessageWriter;", "getScoringFilters", "()Lai/platon/pulsar/crawl/scoring/ScoringFilters;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "getParams", "Lai/platon/pulsar/common/config/Params;", "handleBadModified", "", "page", "Lai/platon/pulsar/persist/WebPage;", "handleModifiedTime", "Lai/platon/pulsar/crawl/schedule/ModifyInfo;", "crawlStatus", "Lai/platon/pulsar/persist/CrawlStatus;", "updateByIncomingPages", "incomingPages", "", "updateByOutgoingPage", "outgoingPage", "updateByOutgoingPages", "outgoingPages", "updateFetchSchedule", "updatePageCounters", "lastPageCounters", "Lai/platon/pulsar/persist/PageCounters;", "pageCounters", "Companion", "pulsar-skeleton"})
public final class UpdateComponent
implements Parameterized {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final FetchSchedule fetchSchedule;
    @Nullable
    private final ScoringFilters scoringFilters;
    @Nullable
    private final MiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger LOG;
    @NotNull
    private final EnumCounterRegistry enumCounters;

    public UpdateComponent(@NotNull WebDb webDb, @NotNull FetchSchedule fetchSchedule, @Nullable ScoringFilters scoringFilters, @Nullable MiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)fetchSchedule, (String)"fetchSchedule");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.webDb = webDb;
        this.fetchSchedule = fetchSchedule;
        this.scoringFilters = scoringFilters;
        this.messageWriter = messageWriter;
        this.conf = conf;
        this.LOG = LoggerFactory.getLogger(UpdateComponent.class);
        this.enumCounters = AppMetrics.Companion.getReg().getEnumCounterRegistry();
    }

    public /* synthetic */ UpdateComponent(WebDb webDb, FetchSchedule fetchSchedule, ScoringFilters scoringFilters, MiscMessageWriter miscMessageWriter, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            scoringFilters = null;
        }
        if ((n & 8) != 0) {
            miscMessageWriter = null;
        }
        this(webDb, fetchSchedule, scoringFilters, miscMessageWriter, immutableConfig);
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final FetchSchedule getFetchSchedule() {
        return this.fetchSchedule;
    }

    @Nullable
    public final ScoringFilters getScoringFilters() {
        return this.scoringFilters;
    }

    @Nullable
    public final MiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final Logger getLOG() {
        return this.LOG;
    }

    public UpdateComponent(@NotNull WebDb webDb, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(webDb, new DefaultFetchSchedule(conf, null, 2, null), null, null, conf);
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"fetchSchedule", this.fetchSchedule.getClass().getSimpleName()};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"classNa\u2026lass.simpleName\n        )");
        return params;
    }

    public final void updateByOutgoingPage(@NotNull WebPage page, @NotNull WebPage outgoingPage) {
        Object object;
        PageCounters pageCounters;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                Intrinsics.checkNotNullParameter((Object)outgoingPage, (String)"outgoingPage");
                WebPageExt pageExt = new WebPageExt(page);
                Object object2 = page.getPageCounters();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.pageCounters");
                pageCounters = object2;
                pageCounters.increase((Enum)PageCounters.Ref.page);
                object2 = outgoingPage.getContentPublishTime();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outgoingPage.contentPublishTime");
                pageExt.updateRefContentPublishTime((Instant)object2);
                if (outgoingPage.getPageCategory().isDetail()) break block6;
                object2 = outgoingPage.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outgoingPage.url");
                if (!CrawlFilter.Companion.guessPageCategory((String)object2).isDetail()) break block7;
            }
            pageCounters.increase((Enum)PageCounters.Ref.ch, outgoingPage.getContentTextLen());
            pageCounters.increase((Enum)PageCounters.Ref.item);
        }
        PageCounters pageCounters2 = outgoingPage.getPageCounters();
        Intrinsics.checkNotNullExpressionValue((Object)pageCounters2, (String)"outgoingPage.pageCounters");
        PageCounters outgoingPageCounters = pageCounters2;
        int missingFields = outgoingPageCounters.get((Enum)PageCounters.Self.missingFields);
        int brokenSubEntity = outgoingPageCounters.get((Enum)PageCounters.Self.brokenSubEntity);
        pageCounters.increase((Enum)PageCounters.Ref.missingFields, missingFields);
        pageCounters.increase((Enum)PageCounters.Ref.brokenEntity, missingFields > 0 ? 1 : 0);
        pageCounters.increase((Enum)PageCounters.Ref.brokenSubEntity, brokenSubEntity);
        if (outgoingPage.getProtocolStatus().isFailed()) {
            page.getDeadLinks().add(outgoingPage.getUrl());
            object = this.messageWriter;
            if (object != null) {
                String string = outgoingPage.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outgoingPage.url");
                ((MiscMessageWriter)((Object)object)).debugDeadOutgoingPage(string, page);
            }
        }
        if ((object = this.scoringFilters) != null) {
            ((ScoringFilters)object).updateContentScore(page);
        }
    }

    public final void updateByOutgoingPages(@NotNull WebPage page, @NotNull Collection<WebPage> outgoingPages) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter(outgoingPages, (String)"outgoingPages");
        PageCounters lastPageCounters = page.getPageCounters().clone();
        Iterable $this$forEach$iv = outgoingPages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPage it = (WebPage)element$iv;
            boolean bl = false;
            this.updateByOutgoingPage(page, it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)lastPageCounters, (String)"lastPageCounters");
        PageCounters pageCounters = page.getPageCounters();
        Intrinsics.checkNotNullExpressionValue((Object)pageCounters, (String)"page.pageCounters");
        this.updatePageCounters(lastPageCounters, pageCounters, page);
    }

    public final void updatePageCounters(@NotNull PageCounters lastPageCounters, @NotNull PageCounters pageCounters, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)lastPageCounters, (String)"lastPageCounters");
        Intrinsics.checkNotNullParameter((Object)pageCounters, (String)"pageCounters");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        int lastMissingFields = lastPageCounters.get((Enum)PageCounters.Ref.missingFields);
        int lastBrokenEntity = lastPageCounters.get((Enum)PageCounters.Ref.brokenEntity);
        int lastBrokenSubEntity = lastPageCounters.get((Enum)PageCounters.Ref.brokenSubEntity);
        int missingFieldsLastRound = pageCounters.get((Enum)PageCounters.Ref.missingFields) - lastMissingFields;
        int brokenEntityLastRound = pageCounters.get((Enum)PageCounters.Ref.brokenEntity) - lastBrokenEntity;
        int brokenSubEntityLastRound = pageCounters.get((Enum)PageCounters.Ref.brokenSubEntity) - lastBrokenSubEntity;
        pageCounters.set((Enum)PageCounters.Ref.missingFieldsLastRound, missingFieldsLastRound);
        pageCounters.set((Enum)PageCounters.Ref.brokenEntityLastRound, brokenEntityLastRound);
        pageCounters.set((Enum)PageCounters.Ref.brokenSubEntityLastRound, brokenSubEntityLastRound);
        if (missingFieldsLastRound != 0 || brokenEntityLastRound != 0 || brokenSubEntityLastRound != 0) {
            Object object = new Object[]{"brokenEntity", brokenEntityLastRound, "brokenSubEntity", brokenSubEntityLastRound};
            String message = Params.of((String)"missingFields", (Object)missingFieldsLastRound, (Object[])object).formatAsLine();
            object = this.messageWriter;
            if (object != null) {
                String string = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                object.reportBrokenEntity(string, message);
            }
            this.LOG.warn(message);
        }
    }

    public final void updateByIncomingPages(@NotNull Collection<WebPage> incomingPages, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter(incomingPages, (String)"incomingPages");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        int smallestDepth = page.getDistance();
        WebPage shallowestPage = null;
        for (WebPage incomingPage : incomingPages) {
            if (incomingPage.getDistance() + 1 >= smallestDepth) continue;
            smallestDepth = incomingPage.getDistance() + 1;
            shallowestPage = incomingPage;
        }
        if (shallowestPage != null) {
            page.setReferrer(shallowestPage.getUrl());
            page.setArgs(shallowestPage.getArgs());
            page.setDistance(shallowestPage.getDistance() + 1);
        }
    }

    public final void updateFetchSchedule(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getMarks().isInactive()) {
            return;
        }
        CrawlStatus crawlStatus = page.getCrawlStatus();
        Intrinsics.checkNotNullExpressionValue((Object)crawlStatus, (String)"page.crawlStatus");
        CrawlStatus crawlStatus2 = crawlStatus;
        ModifyInfo m = this.handleModifiedTime(page, crawlStatus2);
        byte by = (byte)crawlStatus2.getCode();
        if (((by == 2 ? true : by == 4) ? true : by == 5) ? true : by == 38) {
            Instant now = Instant.now();
            boolean bl = Duration.between(m.getFetchTime(), now).getSeconds() < 1L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The actual fetch time should be very close to now. Now: " + now + " FetchTime: " + m.getFetchTime();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.fetchSchedule.setFetchSchedule(page, m);
        } else if (by == 34) {
            this.fetchSchedule.setPageRetrySchedule(page, m.getPrevFetchTime(), m.getPrevModifiedTime(), m.getFetchTime());
        } else if (by == 3) {
            this.fetchSchedule.setPageGoneSchedule(page, m.getPrevFetchTime(), m.getPrevModifiedTime(), m.getFetchTime());
        }
    }

    private final ModifyInfo handleModifiedTime(WebPage page, CrawlStatus crawlStatus) {
        WebPageExt pageExt = new WebPageExt(page);
        Instant instant = page.getFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.fetchTime");
        Instant prevFetchTime = instant;
        Instant fetchTime = Instant.now();
        Instant instant2 = page.getPrevModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"page.prevModifiedTime");
        Instant prevModifiedTime = instant2;
        Instant instant3 = page.getModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"page.modifiedTime");
        Instant modifiedTime = instant3;
        Instant newModifiedTime = pageExt.sniffModifiedTime();
        int modified = 0;
        if (crawlStatus.getCode() == 38) {
            modified = 2;
        }
        ByteBuffer prevSig = page.getPrevSignature();
        ByteBuffer signature = page.getSignature();
        if (prevSig != null && signature != null) {
            int n = modified = SignatureComparator.compare(prevSig, signature) != 0 ? 1 : 2;
        }
        if (newModifiedTime.isAfter(modifiedTime)) {
            prevModifiedTime = modifiedTime;
            modifiedTime = newModifiedTime;
        }
        if (modifiedTime.isBefore(AppConstants.TCP_IP_STANDARDIZED_TIME)) {
            this.handleBadModified(page);
        }
        Intrinsics.checkNotNullExpressionValue((Object)fetchTime, (String)"fetchTime");
        return new ModifyInfo(fetchTime, prevFetchTime, prevModifiedTime, modifiedTime, modified);
    }

    private final void handleBadModified(WebPage page) {
        EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.rBadModTime, 0, 2, null);
        MiscMessageWriter miscMessageWriter = this.messageWriter;
        if (miscMessageWriter != null) {
            Object[] objectArray = new Object[]{"FT", page.getFetchTime(), "PMT", page.getPrevModifiedTime(), "MT", page.getModifiedTime(), "HMT", page.getHeaders().getLastModified(), "U", page.getUrl()};
            String string = Params.of((String)"PFT", (Object)page.getPrevFetchTime(), (Object[])objectArray).formatAsLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"of(\n            \"PFT\", p\u2026\n        ).formatAsLine()");
            miscMessageWriter.reportBadModifiedTime(string);
        }
    }

    static {
        AppMetricRegistry.register$default(AppMetrics.Companion.getReg(), Companion.Counter.class, null, false, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/platon/pulsar/crawl/component/UpdateComponent$Companion;", "", "()V", "Counter", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/crawl/component/UpdateComponent$Companion$Counter;", "", "(Ljava/lang/String;I)V", "rCreated", "rNewDetail", "rPassed", "rLoaded", "rNotExist", "rDepthUp", "rUpdated", "rTotalUpdates", "rBadModTime", "pulsar-skeleton"})
        public static final class Counter
        extends Enum<Counter> {
            public static final /* enum */ Counter rCreated = new Counter();
            public static final /* enum */ Counter rNewDetail = new Counter();
            public static final /* enum */ Counter rPassed = new Counter();
            public static final /* enum */ Counter rLoaded = new Counter();
            public static final /* enum */ Counter rNotExist = new Counter();
            public static final /* enum */ Counter rDepthUp = new Counter();
            public static final /* enum */ Counter rUpdated = new Counter();
            public static final /* enum */ Counter rTotalUpdates = new Counter();
            public static final /* enum */ Counter rBadModTime = new Counter();
            private static final /* synthetic */ Counter[] $VALUES;

            public static Counter[] values() {
                return (Counter[])$VALUES.clone();
            }

            public static Counter valueOf(String value) {
                return Enum.valueOf(Counter.class, value);
            }

            static {
                $VALUES = counterArray = new Counter[]{Counter.rCreated, Counter.rNewDetail, Counter.rPassed, Counter.rLoaded, Counter.rNotExist, Counter.rDepthUp, Counter.rUpdated, Counter.rTotalUpdates, Counter.rBadModTime};
            }
        }
    }
}

