/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.component;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.db.DbQuery;
import ai.platon.pulsar.persist.gora.db.DbQueryResult;
import ai.platon.pulsar.persist.model.WebPageFormatter;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0006\u0010\u001b\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/platon/pulsar/crawl/component/WebDbComponent;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "webDb", "Lai/platon/pulsar/persist/WebDb;", "(Lai/platon/pulsar/persist/WebDb;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "close", "", "delete", "", "url", "", "flush", "get", "Lai/platon/pulsar/persist/WebPage;", "put", "page", "query", "Lai/platon/pulsar/persist/gora/db/DbQueryResult;", "Lai/platon/pulsar/persist/gora/db/DbQuery;", "scan", "startUrl", "endUrl", "truncate", "Companion", "pulsar-skeleton"})
public final class WebDbComponent
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final AtomicBoolean isClosed;
    private static final Logger LOG = LoggerFactory.getLogger(WebDbComponent.class);

    public WebDbComponent(@NotNull WebDb webDb, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.webDb = webDb;
        this.conf = conf;
        this.isClosed = new AtomicBoolean();
    }

    public WebDbComponent(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new WebDb(conf), conf);
    }

    public final void put(@NotNull String url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
    }

    public final void put(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        WebDb.put$default((WebDb)this.webDb, (WebPage)page, (boolean)false, (int)2, null);
    }

    public final void flush() {
        this.webDb.flush();
    }

    @NotNull
    public final WebPage get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return WebDb.get$default((WebDb)this.webDb, (String)url, (boolean)false, null, (int)6, null);
    }

    public final boolean delete(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return WebDb.delete$default((WebDb)this.webDb, (String)url, (boolean)false, (int)2, null);
    }

    public final boolean truncate() {
        return WebDb.truncate$default((WebDb)this.webDb, (boolean)false, (int)1, null);
    }

    @NotNull
    public final DbQueryResult scan(@NotNull String startUrl, @NotNull String endUrl) {
        Intrinsics.checkNotNullParameter((Object)startUrl, (String)"startUrl");
        Intrinsics.checkNotNullParameter((Object)endUrl, (String)"endUrl");
        DbQueryResult result = new DbQueryResult();
        String string = this.conf.get("storage.crawl.id");
        String crawlId = string == null ? "" : string;
        DbQuery query = new DbQuery(crawlId, "all", startUrl, endUrl);
        Object[] objectArray = new Object[]{"endUrl", endUrl};
        Params.of((String)"startUrl", (Object)startUrl, (Object[])objectArray).withLogger(LOG).debug(true);
        Iterator iterator = this.webDb.query(query);
        while (iterator.hasNext()) {
            result.addValue(new WebPageFormatter((WebPage)iterator.next()).toMap((Set)query.getFields()));
        }
        return result;
    }

    @NotNull
    public final DbQueryResult query(@NotNull DbQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        DbQueryResult result = new DbQueryResult();
        Iterator iterator = this.webDb.query(query);
        while (iterator.hasNext()) {
            result.addValue(new WebPageFormatter((WebPage)iterator.next()).toMap((Set)query.getFields()));
        }
        return result;
    }

    @Override
    public void close() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.webDb.close();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/component/WebDbComponent$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

