/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch;

import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.protocol.ForwardingResponse;
import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u0086\u0002J\t\u0010 \u001a\u00020\u0005H\u0086\u0002J\u000b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0086\u0002J\u0010\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0007J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lai/platon/pulsar/crawl/fetch/FetchResult;", "", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "response", "Lai/platon/pulsar/crawl/protocol/Response;", "exception", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lai/platon/pulsar/crawl/protocol/Response;Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "setException", "(Ljava/lang/Throwable;)V", "isCrawlRetry", "", "()Z", "isPrivacyRetry", "isSmall", "isSuccess", "getResponse", "()Lai/platon/pulsar/crawl/protocol/Response;", "setResponse", "(Lai/platon/pulsar/crawl/protocol/Response;)V", "status", "Lai/platon/pulsar/persist/ProtocolStatus;", "getStatus", "()Lai/platon/pulsar/persist/ProtocolStatus;", "getTask", "()Lai/platon/pulsar/crawl/fetch/FetchTask;", "canceled", "", "component1", "component2", "component3", "failed", "t", "retry", "retryScope", "Lai/platon/pulsar/persist/RetryScope;", "Companion", "pulsar-skeleton"})
public final class FetchResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FetchTask task;
    @NotNull
    private Response response;
    @Nullable
    private Throwable exception;

    public FetchResult(@NotNull FetchTask task, @NotNull Response response2, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.task = task;
        this.response = response2;
        this.exception = exception;
    }

    public /* synthetic */ FetchResult(FetchTask fetchTask, Response response2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(fetchTask, response2, throwable);
    }

    @NotNull
    public final FetchTask getTask() {
        return this.task;
    }

    @NotNull
    public final Response getResponse() {
        return this.response;
    }

    public final void setResponse(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"<set-?>");
        this.response = response2;
    }

    @Nullable
    public final Throwable getException() {
        return this.exception;
    }

    public final void setException(@Nullable Throwable throwable) {
        this.exception = throwable;
    }

    @NotNull
    public final FetchTask component1() {
        return this.task;
    }

    @NotNull
    public final Response component2() {
        return this.response;
    }

    @Nullable
    public final Throwable component3() {
        return this.exception;
    }

    @NotNull
    public final ProtocolStatus getStatus() {
        return this.response.getProtocolStatus();
    }

    public final boolean isSuccess() {
        return this.getStatus().isSuccess();
    }

    public final boolean isPrivacyRetry() {
        return this.getStatus().isRetry(RetryScope.PRIVACY);
    }

    public final boolean isCrawlRetry() {
        return this.getStatus().isRetry(RetryScope.CRAWL);
    }

    public final boolean isSmall() {
        return Intrinsics.areEqual(this.getStatus().getArgs().get("rrs"), (Object)HtmlIntegrity.TOO_SMALL.toString());
    }

    public final void canceled() {
        this.response = ForwardingResponse.Companion.canceled(this.task.getPage());
    }

    public final void retry(@NotNull RetryScope retryScope) {
        Intrinsics.checkNotNullParameter((Object)retryScope, (String)"retryScope");
        this.response = ForwardingResponse.Companion.retry(this.task.getPage(), retryScope);
    }

    public final void failed(@Nullable Throwable t) {
        this.response = ForwardingResponse.Companion.failed(this.task.getPage(), t);
        this.exception = t;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\n\u001a\u00060\u000bj\u0002`\fJ\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\n\u001a\u00060\u000bj\u0002`\fJ\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/crawl/fetch/FetchResult$Companion;", "", "()V", "canceled", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "crawlRetry", "delay", "Ljava/time/Duration;", "reason", "Ljava/lang/Exception;", "Lkotlin/Exception;", "failed", "e", "", "privacyRetry", "retry", "retryScope", "Lai/platon/pulsar/persist/RetryScope;", "unchanged", "unfetched", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FetchResult unchanged(@NotNull FetchTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return new FetchResult(task, ForwardingResponse.Companion.unchanged(task.getPage()), null, 4, null);
        }

        @NotNull
        public final FetchResult unfetched(@NotNull FetchTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return new FetchResult(task, ForwardingResponse.Companion.unfetched(task.getPage()), null, 4, null);
        }

        @NotNull
        public final FetchResult canceled(@NotNull FetchTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return new FetchResult(task, ForwardingResponse.Companion.canceled(task.getPage()), null, 4, null);
        }

        @NotNull
        public final FetchResult retry(@NotNull FetchTask task, @NotNull RetryScope retryScope) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)retryScope, (String)"retryScope");
            return new FetchResult(task, ForwardingResponse.Companion.retry(task.getPage(), retryScope), null, 4, null);
        }

        @NotNull
        public final FetchResult privacyRetry(@NotNull FetchTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return this.retry(task, RetryScope.PRIVACY);
        }

        @NotNull
        public final FetchResult privacyRetry(@NotNull FetchTask task, @NotNull Exception reason) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new FetchResult(task, ForwardingResponse.Companion.privacyRetry(task.getPage(), reason), null, 4, null);
        }

        @NotNull
        public final FetchResult crawlRetry(@NotNull FetchTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return new FetchResult(task, ForwardingResponse.Companion.crawlRetry(task.getPage()), null, 4, null);
        }

        @NotNull
        public final FetchResult crawlRetry(@NotNull FetchTask task, @NotNull Duration delay) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
            FetchResult fetchResult = new FetchResult(task, ForwardingResponse.Companion.crawlRetry(task.getPage()), null, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            FetchResult it = fetchResult;
            boolean bl3 = false;
            task.getPage().setRetryDelay(delay);
            return fetchResult;
        }

        @NotNull
        public final FetchResult crawlRetry(@NotNull FetchTask task, @NotNull Exception reason) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new FetchResult(task, ForwardingResponse.Companion.crawlRetry(task.getPage(), reason), null, 4, null);
        }

        @NotNull
        public final FetchResult failed(@NotNull FetchTask task, @Nullable Throwable e) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            return new FetchResult(task, ForwardingResponse.Companion.failed(task.getPage(), e), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

