/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch;

import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.fetch.BatchStat;
import ai.platon.pulsar.persist.WebPage;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 N2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002NOBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020\u0000J\u0011\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010F\u001a\u00020BJ\u0013\u0010G\u001a\u00020'2\b\u0010E\u001a\u0004\u0018\u00010HH\u0096\u0002J\b\u0010I\u001a\u00020\u0003H\u0016J\u0006\u0010J\u001a\u00020BJ\u0006\u0010K\u001a\u00020BJ\u0006\u0010L\u001a\u00020BJ\b\u0010M\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0019\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0011R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0011\u0010)\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010,R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0011R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001f\u00106\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u0001080807\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010 R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006P"}, d2={"Lai/platon/pulsar/crawl/fetch/FetchTask;", "", "batchId", "", "priority", "page", "Lai/platon/pulsar/persist/WebPage;", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "batchSize", "batchTaskId", "batchStat", "Lai/platon/pulsar/crawl/fetch/BatchStat;", "id", "nRetries", "(IILai/platon/pulsar/persist/WebPage;Lai/platon/pulsar/common/browser/Fingerprint;IILai/platon/pulsar/crawl/fetch/BatchStat;II)V", "getBatchId", "()I", "getBatchSize", "getBatchStat", "()Lai/platon/pulsar/crawl/fetch/BatchStat;", "setBatchStat", "(Lai/platon/pulsar/crawl/fetch/BatchStat;)V", "getBatchTaskId", "createdTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getCreatedTime", "()Ljava/time/Instant;", "domain", "", "getDomain", "()Ljava/lang/String;", "getFingerprint", "()Lai/platon/pulsar/common/browser/Fingerprint;", "href", "getHref", "getId", "isCanceled", "", "()Z", "isWorking", "getNRetries", "setNRetries", "(I)V", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "getPriority", "proxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getProxyEntry", "()Lai/platon/pulsar/common/proxy/ProxyEntry;", "setProxyEntry", "(Lai/platon/pulsar/common/proxy/ProxyEntry;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/crawl/fetch/FetchTask$State;", "getState", "()Ljava/util/concurrent/atomic/AtomicReference;", "url", "getUrl", "volatileConfig", "Lai/platon/pulsar/common/config/VolatileConfig;", "getVolatileConfig", "()Lai/platon/pulsar/common/config/VolatileConfig;", "cancel", "", "clone", "compareTo", "other", "done", "equals", "", "hashCode", "markReady", "reset", "startWork", "toString", "Companion", "State", "pulsar-skeleton"})
public final class FetchTask
implements Comparable<FetchTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int batchId;
    private final int priority;
    @NotNull
    private final WebPage page;
    @NotNull
    private final Fingerprint fingerprint;
    private final int batchSize;
    private final int batchTaskId;
    @Nullable
    private BatchStat batchStat;
    private final int id;
    private int nRetries;
    @NotNull
    private final AtomicReference<State> state;
    @Nullable
    private ProxyEntry proxyEntry;
    private final Instant createdTime;
    @NotNull
    private static final Fingerprint DEFAULT_FINGERPRINT = new Fingerprint(BrowserType.PULSAR_CHROME, null, null, null, null, 30, null);
    @NotNull
    private static final FetchTask NIL;
    @NotNull
    private static final AtomicInteger instanceSequencer;

    public FetchTask(int batchId, int priority, @NotNull WebPage page, @NotNull Fingerprint fingerprint, int batchSize, int batchTaskId, @Nullable BatchStat batchStat, int id, int nRetries) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.batchId = batchId;
        this.priority = priority;
        this.page = page;
        this.fingerprint = fingerprint;
        this.batchSize = batchSize;
        this.batchTaskId = batchTaskId;
        this.batchStat = batchStat;
        this.id = id;
        this.nRetries = nRetries;
        this.state = new AtomicReference<State>(State.NOT_READY);
        this.createdTime = Instant.now();
    }

    public /* synthetic */ FetchTask(int n, int n2, WebPage webPage, Fingerprint fingerprint, int n3, int n4, BatchStat batchStat, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x10) != 0) {
            n3 = 1;
        }
        if ((n7 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x40) != 0) {
            batchStat = null;
        }
        if ((n7 & 0x80) != 0) {
            n5 = instanceSequencer.incrementAndGet();
        }
        if ((n7 & 0x100) != 0) {
            n6 = 0;
        }
        this(n, n2, webPage, fingerprint, n3, n4, batchStat, n5, n6);
    }

    public final int getBatchId() {
        return this.batchId;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final WebPage getPage() {
        return this.page;
    }

    @NotNull
    public final Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final int getBatchTaskId() {
        return this.batchTaskId;
    }

    @Nullable
    public final BatchStat getBatchStat() {
        return this.batchStat;
    }

    public final void setBatchStat(@Nullable BatchStat batchStat) {
        this.batchStat = batchStat;
    }

    public final int getId() {
        return this.id;
    }

    public final int getNRetries() {
        return this.nRetries;
    }

    public final void setNRetries(int n) {
        this.nRetries = n;
    }

    @NotNull
    public final AtomicReference<State> getState() {
        return this.state;
    }

    @Nullable
    public final ProxyEntry getProxyEntry() {
        return this.proxyEntry;
    }

    public final void setProxyEntry(@Nullable ProxyEntry proxyEntry) {
        this.proxyEntry = proxyEntry;
    }

    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final String getUrl() {
        String string = this.page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        return string;
    }

    @Nullable
    public final String getHref() {
        return this.page.getHref();
    }

    @NotNull
    public final VolatileConfig getVolatileConfig() {
        VolatileConfig volatileConfig = this.page.getConf();
        Intrinsics.checkNotNullExpressionValue((Object)volatileConfig, (String)"page.conf");
        return volatileConfig;
    }

    @Nullable
    public final String getDomain() {
        return URLUtil.INSTANCE.getDomainName(this.getUrl());
    }

    public final boolean isCanceled() {
        return this.state.get() == State.CANCELED;
    }

    public final boolean isWorking() {
        return this.state.get() == State.WORKING;
    }

    public final void markReady() {
        this.state.set(State.READY);
    }

    public final void startWork() {
        this.state.set(State.WORKING);
    }

    public final void cancel() {
        this.state.set(State.CANCELED);
    }

    public final void done() {
        this.state.set(State.DONE);
    }

    public final void reset() {
        this.batchStat = null;
        this.proxyEntry = null;
        this.state.set(State.NOT_READY);
    }

    @NotNull
    public final FetchTask clone() {
        int n = this.batchId;
        int n2 = this.batchTaskId;
        int n3 = this.batchSize;
        int n4 = this.priority;
        WebPage webPage = this.page;
        Fingerprint fingerprint = this.fingerprint;
        int n5 = this.nRetries;
        return new FetchTask(n, n4, webPage, fingerprint, n3, n2, null, 0, n5, 192, null);
    }

    @Override
    public int compareTo(@NotNull FetchTask other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.id, (int)other.id);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FetchTask && this.id == ((FetchTask)other).id;
    }

    public int hashCode() {
        return this.id;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.id);
    }

    static {
        WebPage webPage = WebPage.NIL;
        Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"NIL");
        NIL = new FetchTask(0, 0, webPage, DEFAULT_FINGERPRINT, 0, 0, null, 0, 0, 368, null);
        instanceSequencer = new AtomicInteger();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/fetch/FetchTask$State;", "", "(Ljava/lang/String;I)V", "NOT_READY", "READY", "WORKING", "CANCELED", "DONE", "pulsar-skeleton"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_READY = new State();
        public static final /* enum */ State READY = new State();
        public static final /* enum */ State WORKING = new State();
        public static final /* enum */ State CANCELED = new State();
        public static final /* enum */ State DONE = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_READY, State.READY, State.WORKING, State.CANCELED, State.DONE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/crawl/fetch/FetchTask$Companion;", "", "()V", "DEFAULT_FINGERPRINT", "Lai/platon/pulsar/common/browser/Fingerprint;", "getDEFAULT_FINGERPRINT", "()Lai/platon/pulsar/common/browser/Fingerprint;", "NIL", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "getNIL", "()Lai/platon/pulsar/crawl/fetch/FetchTask;", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstanceSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "create", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Fingerprint getDEFAULT_FINGERPRINT() {
            return DEFAULT_FINGERPRINT;
        }

        @NotNull
        public final FetchTask getNIL() {
            return NIL;
        }

        @NotNull
        public final AtomicInteger getInstanceSequencer() {
            return instanceSequencer;
        }

        @NotNull
        public final FetchTask create(@NotNull String url, @NotNull VolatileConfig conf) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            WebPage webPage = WebPage.newWebPage((String)url, (VolatileConfig)conf);
            Intrinsics.checkNotNullExpressionValue((Object)webPage, (String)"newWebPage(url, conf)");
            WebPage page = webPage;
            int priority = conf.getUint("browser.web.driver.priority", 0);
            BrowserType browserType = (BrowserType)conf.getEnum("browser.type", (Enum)BrowserType.PULSAR_CHROME);
            Intrinsics.checkNotNullExpressionValue((Object)browserType, (String)"browserType");
            Fingerprint fingerprint = new Fingerprint(browserType, null, null, null, null, 30, null);
            return new FetchTask(0, priority, page, fingerprint, 0, 0, null, 0, 0, 496, null);
        }

        @NotNull
        public final FetchTask create(@NotNull WebPage page) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            VolatileConfig volatileConfig = page.getConf();
            Intrinsics.checkNotNullExpressionValue((Object)volatileConfig, (String)"page.conf");
            VolatileConfig conf = volatileConfig;
            int priority = conf.getUint("browser.web.driver.priority", 0);
            BrowserType browserType = (BrowserType)conf.getEnum("browser.type", (Enum)BrowserType.PULSAR_CHROME);
            Intrinsics.checkNotNullExpressionValue((Object)browserType, (String)"browserType");
            Fingerprint fingerprint = new Fingerprint(browserType, null, null, null, null, 30, null);
            return new FetchTask(0, priority, page, fingerprint, 0, 0, null, 0, 0, 496, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

