/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ReducerContext;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.fetch.batch.FetchMonitor;
import ai.platon.pulsar.crawl.fetch.batch.IFetchEntry;
import ai.platon.pulsar.crawl.fetch.batch.TaskMonitor;
import ai.platon.pulsar.crawl.fetch.batch.TaskScheduler;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.hadoop.io.IntWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u00019BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012 \u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0011\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0000H\u0096\u0002J\b\u00100\u001a\u00020-H\u0002J\b\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u000203H\u0016J \u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020*2\u0006\u00106\u001a\u00020\u001dH\u0002J\u0011\u00107\u001a\u00020-H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u0015*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0016\u0010$\u001a\n \u0015*\u0004\u0018\u00010%0%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006:"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FeedLoop;", "", "Lai/platon/pulsar/common/config/Parameterized;", "Ljava/lang/AutoCloseable;", "fetchMonitor", "Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor;", "taskScheduler", "Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "tasksMonitor", "Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;", "context", "Lai/platon/pulsar/common/ReducerContext;", "Lorg/apache/hadoop/io/IntWritable;", "Lai/platon/pulsar/crawl/fetch/batch/IFetchEntry;", "", "Lai/platon/pulsar/persist/gora/generated/GWebPage;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor;Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;Lai/platon/pulsar/common/ReducerContext;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkInterval", "Ljava/time/Duration;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentIter", "", "fetchConcurrency", "", "fetchJobTimeout", "id", "initBatchSize", "isActive", "", "()Z", "jobDeadline", "Ljava/time/Instant;", "maxActiveTabs", "numPrivacyContexts", "totalFeed", "adjustFeedBatchSize", "", "batchSize", "close", "", "compareTo", "other", "discardAll", "doStart", "getParams", "Lai/platon/pulsar/common/config/Params;", "report", "round", "feedInRound", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "pulsar-skeleton"})
public final class FeedLoop
implements Comparable<FeedLoop>,
Parameterized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FetchMonitor fetchMonitor;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final TaskMonitor tasksMonitor;
    @NotNull
    private final ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger LOG;
    private final int id;
    private final Duration checkInterval;
    private final int numPrivacyContexts;
    private final int maxActiveTabs;
    private final int fetchConcurrency;
    private final Duration fetchJobTimeout;
    private Instant jobDeadline;
    private int initBatchSize;
    @NotNull
    private final AtomicBoolean closed;
    private Iterator<? extends IFetchEntry> currentIter;
    private int totalFeed;
    @NotNull
    private static final AtomicInteger instanceSequence = new AtomicInteger();

    public FeedLoop(@NotNull FetchMonitor fetchMonitor, @NotNull TaskScheduler taskScheduler, @NotNull TaskMonitor tasksMonitor, @NotNull ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)fetchMonitor, (String)"fetchMonitor");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)tasksMonitor, (String)"tasksMonitor");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.fetchMonitor = fetchMonitor;
        this.taskScheduler = taskScheduler;
        this.tasksMonitor = tasksMonitor;
        this.context = context;
        this.conf = conf;
        this.LOG = LoggerFactory.getLogger(FeedLoop.class);
        this.id = instanceSequence.incrementAndGet();
        this.checkInterval = Duration.ofSeconds(2L);
        this.numPrivacyContexts = this.conf.getInt("privacy.context.number", 2);
        this.maxActiveTabs = this.conf.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
        this.fetchConcurrency = this.numPrivacyContexts * this.maxActiveTabs;
        Duration duration = Duration.ofDays(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(2)");
        this.fetchJobTimeout = this.conf.getDuration("fetch.job.timeout", duration);
        this.jobDeadline = Instant.now().plus(this.fetchJobTimeout);
        this.initBatchSize = this.conf.getUint("fetch.feeder.init.batch.size", this.fetchConcurrency);
        this.closed = new AtomicBoolean(false);
        this.LOG.info(this.getParams().format());
    }

    public final boolean isActive() {
        return !this.closed.get();
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"fetchConcurrency", this.fetchConcurrency, "initBatchSize", this.initBatchSize, "id", this.id};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026       \"id\", id\n        )");
        return params;
    }

    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FeedLoop this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FeedLoop.access$doStart(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doStart() {
        Object object;
        Iterator<? extends IFetchEntry> iterator;
        this.fetchMonitor.registerFeedThread(this);
        float batchSize = this.initBatchSize;
        int round = 0;
        try {
            boolean hasMore = this.context.nextKey();
            if (hasMore) {
                this.currentIter = this.context.getValues().iterator();
            }
            while (this.isActive() && Instant.now().compareTo(this.jobDeadline) < 0 && hasMore) {
                ++round;
                int feedInRound = 0;
                while ((float)feedInRound < batchSize) {
                    Object object2;
                    Object object3;
                    Iterator<? extends IFetchEntry> iterator2;
                    iterator = this.currentIter;
                    if (iterator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentIter");
                        iterator2 = null;
                    } else {
                        iterator2 = iterator;
                    }
                    if (!iterator2.hasNext() || !hasMore) break;
                    object = this.currentIter;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentIter");
                        object3 = null;
                    } else {
                        object3 = object;
                    }
                    IFetchEntry entry = (IFetchEntry)object3.next();
                    Object object4 = entry.getPage();
                    if (object4 == null) continue;
                    WebPage page = object4;
                    this.tasksMonitor.produce(this.context.getJobId(), page);
                    object4 = this;
                    ++((FeedLoop)object4).totalFeed;
                    int cfr_ignored_0 = ((FeedLoop)object4).totalFeed;
                    ++feedInRound;
                    object4 = this.currentIter;
                    if (object4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentIter");
                        object2 = null;
                    } else {
                        object2 = object4;
                    }
                    if (object2.hasNext() || !(hasMore = this.context.nextKey())) continue;
                    this.currentIter = this.context.getValues().iterator();
                }
                if (round % 5 == 0 && this.LOG.isInfoEnabled()) {
                    this.report(round, batchSize, feedInRound);
                }
                try {
                    Thread.sleep(this.checkInterval.toMillis());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                batchSize = this.adjustFeedBatchSize(batchSize);
            }
            this.discardAll();
            this.tasksMonitor.setFeederCompleted();
        }
        catch (Throwable e) {
            this.LOG.error("Feeder error reading input, record " + this.totalFeed, e);
        }
        finally {
            this.fetchMonitor.unregisterFeedThread(this);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = round;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        iterator = "%.2f";
        object = new Object[]{Float.valueOf(batchSize)};
        boolean bl = false;
        Object object5 = object;
        Intrinsics.checkNotNullExpressionValue((Object)String.format((String)((Object)iterator), Arrays.copyOf(object5, ((Object)object5).length)), (String)"java.lang.String.format(format, *args)");
        objectArray[2] = this.totalFeed;
        this.LOG.info("Feeder finished. Feed {} rounds, last feed batch size : {}, feed total {} records", objectArray);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    private final void report(int round, float batchSize, int feedInRound) {
        Integer n = round;
        Object[] objectArray = new Object[14];
        objectArray[0] = "batchSize";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.2f";
        Object[] objectArray2 = new Object[]{Float.valueOf(batchSize)};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
        objectArray[2] = "feedInRound";
        objectArray[3] = feedInRound;
        objectArray[4] = "totalFeed";
        objectArray[5] = this.totalFeed;
        objectArray[6] = "readyTasks";
        objectArray[7] = this.tasksMonitor.getNumReadyTasks();
        objectArray[8] = "pendingTasks";
        objectArray[9] = this.tasksMonitor.getNumPendingTasks();
        objectArray[10] = "finishedTasks";
        objectArray[11] = this.tasksMonitor.getNumFinishedTasks();
        objectArray[12] = "fetchConcurrency";
        objectArray[13] = this.fetchConcurrency;
        Params.of((String)"Feed round", (Object)n, (Object[])objectArray).withLogger(this.LOG).info(true);
    }

    private final float adjustFeedBatchSize(float batchSize) {
        float size = batchSize;
        int readyTasks = this.tasksMonitor.getNumReadyTasks().get();
        if (size <= 1.0f) {
            size = 1.0f;
        }
        size = readyTasks <= this.fetchConcurrency ? (size += size * 0.2f) : (readyTasks <= 2 * this.fetchConcurrency ? (size -= size * 0.2f) : 0.0f);
        return size;
    }

    private final void discardAll() throws IOException, InterruptedException {
        block0: while (this.context.nextKey()) {
            this.currentIter = this.context.getValues().iterator();
            while (true) {
                Iterator<? extends IFetchEntry> iterator;
                Iterator<? extends IFetchEntry> iterator2;
                Iterator<? extends IFetchEntry> iterator3;
                if ((iterator3 = this.currentIter) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentIter");
                    iterator2 = null;
                } else {
                    iterator2 = iterator3;
                }
                if (!iterator2.hasNext()) continue block0;
                iterator3 = this.currentIter;
                if (iterator3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentIter");
                    iterator = null;
                } else {
                    iterator = iterator3;
                }
                iterator.next();
            }
        }
    }

    @Override
    public int compareTo(@NotNull FeedLoop other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.id - other.id;
    }

    public static final /* synthetic */ void access$doStart(FeedLoop $this) {
        $this.doStart();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FeedLoop$Companion;", "", "()V", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

