/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.ReducerContext;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.message.LoadStatusFormatter;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.CommonCounter;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.crawl.component.FetchComponent;
import ai.platon.pulsar.crawl.component.ParseComponent;
import ai.platon.pulsar.crawl.fetch.batch.FetchLoop;
import ai.platon.pulsar.crawl.fetch.batch.FetchMonitor;
import ai.platon.pulsar.crawl.fetch.batch.IFetchEntry;
import ai.platon.pulsar.crawl.fetch.batch.JobFetchTask;
import ai.platon.pulsar.crawl.fetch.batch.TaskScheduler;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.hadoop.io.IntWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 G2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001GBO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012 \u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u00102\u001a\u000203H\u0016J\u0011\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0000H\u0096\u0002J\u0013\u00106\u001a\u00020&2\b\u00105\u001a\u0004\u0018\u000107H\u0096\u0002J\u0019\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020\u001dH\u0002J\b\u0010>\u001a\u00020\u001dH\u0016J\n\u0010?\u001a\u0004\u0018\u00010:H\u0002J\u0011\u0010@\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020\u000fH\u0016J\u0018\u0010C\u001a\u0002032\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH\u0002R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0016\u0010(\u001a\n  *\u0004\u0018\u00010)0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u000e\u0010/\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006H"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FetchLoop;", "Ljava/lang/AutoCloseable;", "", "fetchMonitor", "Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor;", "fetchComponent", "Lai/platon/pulsar/crawl/component/FetchComponent;", "parseComponent", "Lai/platon/pulsar/crawl/component/ParseComponent;", "taskScheduler", "Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "context", "Lai/platon/pulsar/common/ReducerContext;", "Lorg/apache/hadoop/io/IntWritable;", "Lai/platon/pulsar/crawl/fetch/batch/IFetchEntry;", "", "Lai/platon/pulsar/persist/gora/generated/GWebPage;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor;Lai/platon/pulsar/crawl/component/FetchComponent;Lai/platon/pulsar/crawl/component/ParseComponent;Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;Lai/platon/pulsar/common/ReducerContext;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "availableMemory", "", "getAvailableMemory", "()J", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enumCounters", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "fetchConcurrency", "", "fetchTaskTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "id", "getId", "()I", "instanceRequiredMemory", "isAppActive", "", "()Z", "log", "Lorg/slf4j/Logger;", "loopConfig", "Lai/platon/pulsar/common/config/VolatileConfig;", "maxActiveTabs", "memoryRemaining", "getMemoryRemaining", "numPrivacyContexts", "systemInfo", "Loshi/SystemInfo;", "close", "", "compareTo", "other", "equals", "", "fetch", "task", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "(Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleMemoryShortage", "j", "hashCode", "schedule", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "write", "key", "page", "Lai/platon/pulsar/persist/WebPage;", "Companion", "pulsar-skeleton"})
public final class FetchLoop
implements AutoCloseable,
Comparable<FetchLoop> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FetchMonitor fetchMonitor;
    @NotNull
    private final FetchComponent fetchComponent;
    @NotNull
    private final ParseComponent parseComponent;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context;
    @NotNull
    private final ImmutableConfig immutableConfig;
    @NotNull
    private final EnumCounterRegistry enumCounters;
    private final int id;
    private final Logger log;
    @NotNull
    private final VolatileConfig loopConfig;
    @NotNull
    private final AtomicBoolean closed;
    private final int numPrivacyContexts;
    private final int maxActiveTabs;
    private final int fetchConcurrency;
    @NotNull
    private final SystemInfo systemInfo;
    private final long instanceRequiredMemory;
    private final Duration fetchTaskTimeout;
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();
    @NotNull
    private static final ArrayBlockingQueue<JobFetchTask> pendingTasks = new ArrayBlockingQueue(1000);
    @NotNull
    private static final AtomicInteger numRunningTasks = new AtomicInteger();
    @NotNull
    private static final AtomicBoolean illegalState = new AtomicBoolean();

    public FetchLoop(@NotNull FetchMonitor fetchMonitor, @NotNull FetchComponent fetchComponent, @NotNull ParseComponent parseComponent, @NotNull TaskScheduler taskScheduler, @NotNull ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)fetchMonitor, (String)"fetchMonitor");
        Intrinsics.checkNotNullParameter((Object)fetchComponent, (String)"fetchComponent");
        Intrinsics.checkNotNullParameter((Object)parseComponent, (String)"parseComponent");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.fetchMonitor = fetchMonitor;
        this.fetchComponent = fetchComponent;
        this.parseComponent = parseComponent;
        this.taskScheduler = taskScheduler;
        this.context = context;
        this.immutableConfig = immutableConfig;
        this.enumCounters = AppMetrics.Companion.getReg().getEnumCounterRegistry();
        this.id = instanceSequencer.incrementAndGet();
        this.log = LoggerFactory.getLogger(FetchLoop.class);
        this.loopConfig = this.immutableConfig.toVolatileConfig();
        this.closed = new AtomicBoolean(false);
        this.numPrivacyContexts = this.immutableConfig.getInt("privacy.context.number", 2);
        this.maxActiveTabs = this.immutableConfig.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
        this.fetchConcurrency = this.numPrivacyContexts * this.maxActiveTabs;
        this.systemInfo = new SystemInfo();
        this.instanceRequiredMemory = 524288000L;
        this.fetchTaskTimeout = Duration.ofMinutes(5L);
    }

    public final int getId() {
        return this.id;
    }

    private final boolean isAppActive() {
        return !this.fetchMonitor.isMissionComplete() && !this.closed.get() && !illegalState.get();
    }

    private final long getAvailableMemory() {
        return this.systemInfo.getHardware().getMemory().getAvailable();
    }

    private final long getMemoryRemaining() {
        return this.getAvailableMemory() - this.instanceRequiredMemory;
    }

    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> $completion) {
        FetchLoop loop = this;
        Object object = SupervisorKt.supervisorScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, loop, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FetchLoop this$0;
            final /* synthetic */ FetchLoop $loop;
            {
                this.this$0 = $receiver;
                this.$loop = $loop;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block11: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$supervisorScope = (CoroutineScope)this.L$0;
                            FetchLoop.access$getFetchMonitor$p(this.this$0).registerFetchLoop(this.$loop);
                            j = 0;
lbl8:
                            // 2 sources

                            while (FetchLoop.access$isAppActive(this.this$0)) {
                                this.L$0 = $this$supervisorScope;
                                this.I$0 = ++j;
                                this.label = 1;
                                v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl22
                            }
                            break block11;
                        }
                        case 1: {
                            j = this.I$0;
                            $this$supervisorScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 4 sources

                            while (FetchLoop.access$isAppActive(this.this$0) && FetchLoop.Companion.getNumRunningTasks().get() > FetchLoop.access$getFetchConcurrency$p(this.this$0)) {
                                this.L$0 = $this$supervisorScope;
                                this.I$0 = j;
                                this.label = 2;
                                v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                if (v1 != var4_2) continue;
                                return var4_2;
                            }
                            break;
                        }
                        case 2: {
                            j = this.I$0;
                            $this$supervisorScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl22
                        }
                    }
                    while (FetchLoop.access$isAppActive(this.this$0) && FetchLoop.access$getMemoryRemaining(this.this$0) < 0L) {
                        if (j % 20 == 0) {
                            FetchLoop.access$handleMemoryShortage(this.this$0, j);
                        }
                        this.L$0 = $this$supervisorScope;
                        this.I$0 = j;
                        this.label = 3;
                        v2 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                        if (v2 != var4_2) continue;
                        return var4_2;
                    }
                    {
                        break;
                        case 3: {
                            j = this.I$0;
                            $this$supervisorScope = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break;
                        }
                    }
                    FetchLoop.Companion.getNumRunningTasks().incrementAndGet();
                    BuildersKt.launch$default((CoroutineScope)$this$supervisorScope, (CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)new CoroutineName("w")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        final /* synthetic */ FetchLoop this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Exception decompiling
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SIMPLE_IF_ELSE]
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                             *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    ** GOTO lbl8
                }
                FetchLoop.access$getFetchMonitor$p(this.this$0).unregisterFetchLoop(this.$loop);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Fetch loop #{} is closed", (Object)this.id);
        }
    }

    @Override
    public int compareTo(@NotNull FetchLoop other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.id - other.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FetchLoop && this.id == ((FetchLoop)other).id;
    }

    @NotNull
    public String toString() {
        return "#" + this.id;
    }

    private final JobFetchTask schedule() {
        Logger logger;
        JobFetchTask fetchTask = pendingTasks.poll();
        if (fetchTask != null) {
            return fetchTask;
        }
        fetchTask = this.taskScheduler.schedule();
        Object object = this.log;
        boolean bl = false;
        boolean bl2 = false;
        Logger it = object;
        boolean bl3 = false;
        Object object2 = logger = it.isTraceEnabled() ? object : null;
        if (logger != null) {
            object = fetchTask;
            logger.trace("Scheduled task from pool {} | {}", (Object)(object == null ? null : ((JobFetchTask)object).getPoolId()), (Object)fetchTask);
        }
        return fetchTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object fetch(JobFetchTask var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof fetch.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FetchLoop this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FetchLoop.access$fetch(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.isAppActive()) {
                    this.taskScheduler.finish(task.getPoolId(), task.getItemId());
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = task;
                $continuation.label = 1;
                v0 = this.fetchComponent.fetchContentDeferred(task.getPage(), (Continuation<? super WebPage>)$continuation);
                ** if (v0 != var8_5) goto lbl25
lbl24:
                // 1 sources

                return var8_5;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                task = (JobFetchTask)$continuation.L$1;
                this = (FetchLoop)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                var4_6 = (WebPage)v0;
                ** GOTO lbl41
                {
                    catch (Throwable var5_8) {
                        throw var5_8;
                    }
                }
                finally {
                    this.taskScheduler.finish(task.getPoolId(), task.getItemId());
                }
lbl41:
                // 1 sources

                page = var4_6;
                if (page.isInternal()) {
                    this.log.warn("Fetch task is an internal page | {}", (Object)task.getUrlString());
                    return Unit.INSTANCE;
                }
                isCanceled = page.getProtocolStatus().isCanceled();
                if (!isCanceled && this.taskScheduler.getParse()) {
                    parseResult = this.parseComponent.parse(page, false, true);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("ParseResult: {} ParseReport: {}", (Object)parseResult, this.parseComponent.getTraceInfo());
                    }
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, page, isCanceled != false, null){
                    int label;
                    final /* synthetic */ FetchLoop this$0;
                    final /* synthetic */ WebPage $page;
                    final /* synthetic */ boolean $isCanceled;
                    {
                        this.this$0 = $receiver;
                        this.$page = $page;
                        this.$isCanceled = $isCanceled;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object3;
                                ResultKt.throwOnFailure((Object)object);
                                Logger logger = FetchLoop.access$getLog$p(this.this$0);
                                boolean bl = false;
                                boolean bl2 = false;
                                Logger it = logger;
                                boolean bl3 = false;
                                Object object4 = object3 = it.isInfoEnabled() ? logger : null;
                                if (object3 != null) {
                                    object3.info(new LoadStatusFormatter(this.$page, null, false, false, false, false, 62, null).toString());
                                }
                                if (!this.$isCanceled) {
                                    object3 = this.$page.getKey();
                                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"page.key");
                                    FetchLoop.access$write(this.this$0, (String)object3, this.$page);
                                    EnumCounterRegistry.inc$default(FetchLoop.access$getEnumCounters$p(this.this$0), CommonCounter.rPersist, 0, 2, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var8_5) goto lbl56
lbl55:
                // 1 sources

                return var8_5;
lbl56:
                // 1 sources

                ** GOTO lbl66
            }
            case 2: {
                this = (FetchLoop)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Throwable e) {
                    this.log.error("Unexpected throwable", e);
                }
lbl66:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void write(String key, WebPage page) {
        try {
            this.context.write(key, page.unbox());
        }
        catch (IOException e) {
            this.log.error("Failed to write to hdfs - {}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted - {}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.log.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
    }

    private final void handleMemoryShortage(int j) {
        Object[] objectArray = new Object[4];
        objectArray[0] = numRunningTasks;
        objectArray[1] = Strings.readableBytes((long)this.getAvailableMemory());
        objectArray[2] = Strings.readableBytes((long)this.instanceRequiredMemory);
        long l = this.getMemoryRemaining();
        boolean bl = false;
        objectArray[3] = Strings.readableBytes((long)Math.abs(l));
        this.log.info(j + ".\tnumRunning: {}, availableMemory: {}, requiredMemory: {}, shortage: {}", objectArray);
        System.gc();
    }

    public static final /* synthetic */ FetchMonitor access$getFetchMonitor$p(FetchLoop $this) {
        return $this.fetchMonitor;
    }

    public static final /* synthetic */ boolean access$isAppActive(FetchLoop $this) {
        return $this.isAppActive();
    }

    public static final /* synthetic */ int access$getFetchConcurrency$p(FetchLoop $this) {
        return $this.fetchConcurrency;
    }

    public static final /* synthetic */ long access$getMemoryRemaining(FetchLoop $this) {
        return $this.getMemoryRemaining();
    }

    public static final /* synthetic */ void access$handleMemoryShortage(FetchLoop $this, int j) {
        $this.handleMemoryShortage(j);
    }

    public static final /* synthetic */ JobFetchTask access$schedule(FetchLoop $this) {
        return $this.schedule();
    }

    public static final /* synthetic */ Logger access$getLog$p(FetchLoop $this) {
        return $this.log;
    }

    public static final /* synthetic */ Object access$fetch(FetchLoop $this, JobFetchTask task, Continuation $completion) {
        return $this.fetch(task, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$write(FetchLoop $this, String key, WebPage page) {
        $this.write(key, page);
    }

    public static final /* synthetic */ EnumCounterRegistry access$getEnumCounters$p(FetchLoop $this) {
        return $this.enumCounters;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FetchLoop$Companion;", "", "()V", "illegalState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getIllegalState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstanceSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numRunningTasks", "getNumRunningTasks", "pendingTasks", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "getPendingTasks", "()Ljava/util/concurrent/ArrayBlockingQueue;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getInstanceSequencer() {
            return instanceSequencer;
        }

        @NotNull
        public final ArrayBlockingQueue<JobFetchTask> getPendingTasks() {
            return pendingTasks;
        }

        @NotNull
        public final AtomicInteger getNumRunningTasks() {
            return numRunningTasks;
        }

        @NotNull
        public final AtomicBoolean getIllegalState() {
            return illegalState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

