/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.FileCommand;
import ai.platon.pulsar.common.ReducerContext;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.options.FetchOptions;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.JobInitialized;
import ai.platon.pulsar.crawl.component.FetchComponent;
import ai.platon.pulsar.crawl.component.ParseComponent;
import ai.platon.pulsar.crawl.fetch.batch.FeedLoop;
import ai.platon.pulsar.crawl.fetch.batch.FetchLoop;
import ai.platon.pulsar.crawl.fetch.batch.IFetchEntry;
import ai.platon.pulsar.crawl.fetch.batch.TaskMonitor;
import ai.platon.pulsar.crawl.fetch.batch.TaskScheduler;
import ai.platon.pulsar.crawl.fetch.batch.TaskSchedulers;
import ai.platon.pulsar.crawl.index.jit.indexer.IndexThread;
import ai.platon.pulsar.crawl.index.jit.indexer.JITIndexer;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.hadoop.io.IntWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 h2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001hB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020KH\u0016J\b\u0010M\u001a\u00020KH\u0002J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020KH\u0002J\b\u0010Q\u001a\u00020KH\u0002J\b\u0010R\u001a\u00020\u001bH\u0002J\u000e\u0010S\u001a\u00020K2\u0006\u0010T\u001a\u00020\u0019J\u000e\u0010U\u001a\u00020K2\u0006\u0010V\u001a\u00020\u001fJ\u0010\u0010W\u001a\u00020K2\u0006\u0010X\u001a\u00020\u000fH\u0016J(\u0010Y\u001a\u00020K2 \u0010Z\u001a\u001c\u0012\u0004\u0012\u00020\\\u0012\u0006\b\u0001\u0012\u00020]\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020^0[J*\u0010_\u001a\u00020K2 \u0010Z\u001a\u001c\u0012\u0004\u0012\u00020\\\u0012\u0006\b\u0001\u0012\u00020]\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020^0[H\u0002J*\u0010`\u001a\u00020K2 \u0010Z\u001a\u001c\u0012\u0004\u0012\u00020\\\u0012\u0006\b\u0001\u0012\u00020]\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020^0[H\u0002J\b\u0010a\u001a\u00020KH\u0002J*\u0010b\u001a\u00020K2 \u0010Z\u001a\u001c\u0012\u0004\u0012\u00020\\\u0012\u0006\b\u0001\u0012\u00020]\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020^0[H\u0002J\u0018\u0010c\u001a\u00020K2\u0006\u0010d\u001a\u00020C2\u0006\u0010e\u001a\u00020\u0012H\u0002J\u000e\u0010f\u001a\u00020K2\u0006\u0010T\u001a\u00020\u0019J\u000e\u0010g\u001a\u00020K2\u0006\u0010V\u001a\u00020\u001fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0014\u0010'\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010&R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n \u001d*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020,X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0016\u00101\u001a\n \u001d*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020;X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\n \u001d*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\n \u001d*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\n \u001d*\u0004\u0018\u00010C0CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\n \u001d*\u0004\u0018\u00010C0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010G\u001a\n \u001d*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010H\u001a\n \u001d*\u0004\u0018\u00010C0CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor;", "Lai/platon/pulsar/common/config/Parameterized;", "Lai/platon/pulsar/crawl/common/JobInitialized;", "Ljava/lang/AutoCloseable;", "fetchComponent", "Lai/platon/pulsar/crawl/component/FetchComponent;", "parseComponent", "Lai/platon/pulsar/crawl/component/ParseComponent;", "taskMonitor", "Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;", "taskSchedulers", "Lai/platon/pulsar/crawl/fetch/batch/TaskSchedulers;", "jitIndexer", "Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/component/FetchComponent;Lai/platon/pulsar/crawl/component/ParseComponent;Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;Lai/platon/pulsar/crawl/fetch/batch/TaskSchedulers;Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "checkInterval", "Ljava/time/Duration;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "feedLoops", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Lai/platon/pulsar/crawl/fetch/batch/FeedLoop;", "fetchConcurrency", "", "fetchJobTimeout", "kotlin.jvm.PlatformType", "fetchLoops", "Lai/platon/pulsar/crawl/fetch/batch/FetchLoop;", "finishScript", "Ljava/nio/file/Path;", "id", "initialized", "isActive", "", "()Z", "isFeederAlive", "isFetchJobTimeout", "isMissionComplete", "jobIdleTimeout", "jobName", "", "getJobName", "()Ljava/lang/String;", "setJobName", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "lowThroughputCount", "maxActiveTabs", "maxLowThroughputCount", "maxTotalLowThroughputCount", "minSuccessPagesPerSecond", "", "numPrivacyContexts", "options", "Lai/platon/pulsar/common/options/FetchOptions;", "getOptions", "()Lai/platon/pulsar/common/options/FetchOptions;", "setOptions", "(Lai/platon/pulsar/common/options/FetchOptions;)V", "poolPendingTimeout", "poolTuneInterval", "poolTuneTime", "Ljava/time/Instant;", "startTime", "taskScheduler", "Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "throughputCheckInterval", "throughputCheckTime", "totalLowThroughputCount", "checkFetchThroughput", "", "close", "generateFinishCommand", "getParams", "Lai/platon/pulsar/common/config/Params;", "handleFewFetchItems", "handleFinishJobCommand", "handleJobTimeout", "registerFeedThread", "feedLoop", "registerFetchLoop", "fetchLoop", "setup", "jobConf", "start", "context", "Lai/platon/pulsar/common/ReducerContext;", "Lorg/apache/hadoop/io/IntWritable;", "Lai/platon/pulsar/crawl/fetch/batch/IFetchEntry;", "Lai/platon/pulsar/persist/gora/generated/GWebPage;", "startFeedLoop", "startFetchLoop", "startIndexThreads", "startWatcherLoop", "tuneFetchQueues", "now", "idleTime", "unregisterFeedThread", "unregisterFetchLoop", "Companion", "pulsar-skeleton"})
public final class FetchMonitor
implements Parameterized,
JobInitialized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FetchComponent fetchComponent;
    @NotNull
    private final ParseComponent parseComponent;
    @NotNull
    private final TaskMonitor taskMonitor;
    @NotNull
    private final TaskSchedulers taskSchedulers;
    @NotNull
    private final JITIndexer jitIndexer;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    private final int id;
    private final Instant startTime;
    @Nullable
    private final CoreMetrics coreMetrics;
    private final int numPrivacyContexts;
    private final int maxActiveTabs;
    private final int fetchConcurrency;
    private final Duration poolTuneInterval;
    private Duration poolPendingTimeout;
    private Instant poolTuneTime;
    private Duration fetchJobTimeout;
    private Duration jobIdleTimeout;
    @NotNull
    private Duration checkInterval;
    private float minSuccessPagesPerSecond;
    private int maxLowThroughputCount;
    private int maxTotalLowThroughputCount;
    private Duration throughputCheckInterval;
    private Instant throughputCheckTime;
    private int lowThroughputCount;
    private int totalLowThroughputCount;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final ConcurrentSkipListSet<FeedLoop> feedLoops;
    @NotNull
    private final ConcurrentSkipListSet<FetchLoop> fetchLoops;
    @NotNull
    private final AtomicBoolean initialized;
    public FetchOptions options;
    public String jobName;
    private Path finishScript;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger(0);

    public FetchMonitor(@NotNull FetchComponent fetchComponent, @NotNull ParseComponent parseComponent, @NotNull TaskMonitor taskMonitor, @NotNull TaskSchedulers taskSchedulers, @NotNull JITIndexer jitIndexer, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)fetchComponent, (String)"fetchComponent");
        Intrinsics.checkNotNullParameter((Object)parseComponent, (String)"parseComponent");
        Intrinsics.checkNotNullParameter((Object)taskMonitor, (String)"taskMonitor");
        Intrinsics.checkNotNullParameter((Object)taskSchedulers, (String)"taskSchedulers");
        Intrinsics.checkNotNullParameter((Object)jitIndexer, (String)"jitIndexer");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.fetchComponent = fetchComponent;
        this.parseComponent = parseComponent;
        this.taskMonitor = taskMonitor;
        this.taskSchedulers = taskSchedulers;
        this.jitIndexer = jitIndexer;
        this.conf = conf;
        this.log = LoggerFactory.getLogger(FetchMonitor.class);
        this.id = instanceSequencer.incrementAndGet();
        this.startTime = Instant.now();
        this.coreMetrics = this.fetchComponent.getCoreMetrics();
        this.numPrivacyContexts = this.conf.getInt("privacy.context.number", 2);
        this.maxActiveTabs = this.conf.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
        this.fetchConcurrency = this.numPrivacyContexts * this.maxActiveTabs;
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(5)");
        this.poolTuneInterval = this.conf.getDuration("fetch.pending.queue.check.time", duration);
        this.poolPendingTimeout = this.taskMonitor.getPoolPendingTimeout();
        this.poolTuneTime = this.startTime;
        duration = Duration.ofHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(1)");
        this.fetchJobTimeout = this.conf.getDuration("fetch.job.timeout", duration);
        this.jobIdleTimeout = this.poolTuneInterval.multipliedBy(3L);
        Duration duration2 = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(10)");
        duration = this.conf.getDuration("fetch.check.interval", duration2);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"conf.getDuration(FETCH_C\u2026, Duration.ofSeconds(10))");
        this.checkInterval = duration;
        this.minSuccessPagesPerSecond = this.conf.getFloat("fetch.throughput.threshold.pages", 0.0f);
        this.maxLowThroughputCount = this.conf.getInt("fetch.throughput.threshold.sequence", 10);
        this.maxTotalLowThroughputCount = this.maxLowThroughputCount * 10;
        duration = Duration.ofSeconds(120L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(120)");
        this.throughputCheckInterval = this.conf.getDuration("fetch.throughput.check.interval", duration);
        this.throughputCheckTime = this.startTime.plus(this.throughputCheckInterval);
        this.taskScheduler = this.taskSchedulers.getFirst();
        this.feedLoops = new ConcurrentSkipListSet();
        this.fetchLoops = new ConcurrentSkipListSet();
        this.initialized = new AtomicBoolean();
        this.closed = new AtomicBoolean();
    }

    private final boolean isFetchJobTimeout() {
        return Duration.between(this.startTime, Instant.now()).compareTo(this.fetchJobTimeout) > 0;
    }

    private final boolean isFeederAlive() {
        return !this.feedLoops.isEmpty();
    }

    public final boolean isMissionComplete() {
        return !this.isFeederAlive() && this.taskMonitor.getNumTasks() == 0;
    }

    @NotNull
    public final FetchOptions getOptions() {
        FetchOptions fetchOptions = this.options;
        if (fetchOptions != null) {
            return fetchOptions;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        return null;
    }

    public final void setOptions(@NotNull FetchOptions fetchOptions) {
        Intrinsics.checkNotNullParameter((Object)fetchOptions, (String)"<set-?>");
        this.options = fetchOptions;
    }

    @NotNull
    public final String getJobName() {
        String string = this.jobName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobName");
        return null;
    }

    public final void setJobName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.jobName = string;
    }

    public final boolean isActive() {
        return !this.closed.get();
    }

    @Override
    public void setup(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        if (this.initialized.compareAndSet(false, true)) {
            this.jitIndexer.setup(jobConf);
            this.taskMonitor.setup(jobConf);
            this.taskScheduler.setup(jobConf);
            this.setOptions(new FetchOptions(jobConf));
            this.setJobName(jobConf.get("pulsar.job.name", "UNNAMED JOB"));
            Path path = AppPaths.INSTANCE.getSCRIPT_DIR().resolve("finish_" + this.getJobName() + ".sh");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"AppPaths.SCRIPT_DIR.resolve(\"finish_$jobName.sh\")");
            this.finishScript = path;
            this.generateFinishCommand();
        }
        this.getParams().withLogger(this.log).info();
    }

    @NotNull
    public Params getParams() {
        Comparable<Instant> comparable;
        String string = this.getClass().getSimpleName();
        Object[] objectArray = new Object[34];
        objectArray[0] = "crawlId";
        objectArray[1] = this.getOptions().getCrawlId();
        objectArray[2] = "batchId";
        objectArray[3] = this.getOptions().getBatchId();
        objectArray[4] = "fetchMode";
        objectArray[5] = this.getOptions().getFetchMode();
        objectArray[6] = "taskSchedulers";
        objectArray[7] = this.taskSchedulers.getName();
        objectArray[8] = "taskScheduler";
        objectArray[9] = this.taskScheduler.getName();
        objectArray[10] = "numPrivacyContexts";
        objectArray[11] = this.numPrivacyContexts;
        objectArray[12] = "fetchConcurrency";
        objectArray[13] = this.fetchConcurrency;
        objectArray[14] = "numPoolThreads";
        objectArray[15] = this.getOptions().getNumPoolThreads();
        objectArray[16] = "fetchJobTimeout";
        objectArray[17] = this.fetchJobTimeout;
        objectArray[18] = "jobIdleTimeout";
        objectArray[19] = this.jobIdleTimeout;
        objectArray[20] = "poolTuneInterval";
        objectArray[21] = this.poolTuneInterval;
        objectArray[22] = "poolTuneTime";
        Comparable<Instant> comparable2 = this.poolTuneTime;
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"poolTuneTime");
        objectArray[23] = DateTimes.INSTANCE.format(comparable2);
        objectArray[24] = "checkInterval";
        objectArray[25] = this.checkInterval;
        objectArray[26] = "minSuccessPagesPerSecond";
        objectArray[27] = Float.valueOf(this.minSuccessPagesPerSecond);
        objectArray[28] = "maxLowThroughputCount";
        objectArray[29] = this.maxLowThroughputCount;
        objectArray[30] = "throughputCheckTime";
        comparable2 = this.throughputCheckTime;
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"throughputCheckTime");
        objectArray[31] = DateTimes.INSTANCE.format(comparable2);
        objectArray[32] = "finishScript";
        comparable2 = this.finishScript;
        if (comparable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finishScript");
            comparable = null;
        } else {
            comparable = comparable2;
        }
        objectArray[33] = "file:" + (Path)comparable;
        Params params = Params.of((String)"className", (Object)string, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026:$finishScript\"\n        )");
        return params;
    }

    public final void start(@NotNull ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.startFeedLoop(context);
        if (this.jitIndexer.isEnabled()) {
            this.startIndexThreads();
        }
        while (this.feedLoops.isEmpty()) {
            Thread.sleep(1000L);
        }
        this.startFetchLoop(context);
        this.startWatcherLoop(context);
    }

    public final void registerFeedThread(@NotNull FeedLoop feedLoop) {
        Intrinsics.checkNotNullParameter((Object)feedLoop, (String)"feedLoop");
        this.log.info("FeedThread {} is registered", (Object)feedLoop);
        this.feedLoops.add(feedLoop);
    }

    public final void unregisterFeedThread(@NotNull FeedLoop feedLoop) {
        Intrinsics.checkNotNullParameter((Object)feedLoop, (String)"feedLoop");
        this.log.info("FeedThread {} is unregistered", (Object)feedLoop);
        this.feedLoops.remove(feedLoop);
    }

    public final void registerFetchLoop(@NotNull FetchLoop fetchLoop) {
        Intrinsics.checkNotNullParameter((Object)fetchLoop, (String)"fetchLoop");
        this.log.info("Fetch loop {} is register", (Object)fetchLoop);
        this.fetchLoops.add(fetchLoop);
    }

    public final void unregisterFetchLoop(@NotNull FetchLoop fetchLoop) {
        Intrinsics.checkNotNullParameter((Object)fetchLoop, (String)"fetchLoop");
        this.log.info("Fetch loop {} is unregistered", (Object)fetchLoop);
        this.fetchLoops.remove(fetchLoop);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                Iterable iterable;
                Throwable it;
                boolean bl;
                boolean bl2;
                Comparable<FeedLoop> comparable;
                Comparable<FeedLoop> it2;
                this.log.info("Closing fetch monitor #" + this.id);
                Iterable $this$forEach$iv = this.feedLoops;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable throwable;
                    Object object;
                    it2 = (FeedLoop)element$iv;
                    boolean bl3 = false;
                    comparable = it2;
                    bl2 = false;
                    try {
                        object = Result.Companion;
                        FeedLoop $this$close_u24lambda_u2d2_u24lambda_u2d0 = comparable;
                        boolean bl4 = false;
                        ((FeedLoop)it2).close();
                        $this$close_u24lambda_u2d2_u24lambda_u2d0 = Unit.INSTANCE;
                        bl4 = false;
                        object = Result.constructor-impl((Object)$this$close_u24lambda_u2d2_u24lambda_u2d0);
                    }
                    catch (Throwable $this$close_u24lambda_u2d2_u24lambda_u2d0) {
                        Result.Companion bl4 = Result.Companion;
                        boolean bl5 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$close_u24lambda_u2d2_u24lambda_u2d0));
                    }
                    comparable = object;
                    bl2 = false;
                    boolean bl6 = false;
                    if (Result.exceptionOrNull-impl((Object)comparable) == null) continue;
                    boolean $this$close_u24lambda_u2d2_u24lambda_u2d0 = false;
                    boolean bl4 = false;
                    Throwable throwable2 = throwable;
                    bl = false;
                    it = throwable2;
                    boolean bl7 = false;
                    this.log.warn(it.getMessage());
                }
                $this$forEach$iv = this.fetchLoops;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable throwable;
                    Object object;
                    it2 = (FetchLoop)element$iv;
                    boolean bl8 = false;
                    comparable = it2;
                    bl2 = false;
                    try {
                        object = Result.Companion;
                        Comparable<FeedLoop> $this$close_u24lambda_u2d5_u24lambda_u2d3 = comparable;
                        boolean bl9 = false;
                        ((FetchLoop)it2).close();
                        Unit unit = Unit.INSTANCE;
                        boolean bl10 = false;
                        object = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable throwable3) {
                        Result.Companion companion = Result.Companion;
                        boolean bl11 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                    }
                    comparable = object;
                    bl2 = false;
                    boolean bl12 = false;
                    if (Result.exceptionOrNull-impl((Object)comparable) == null) continue;
                    boolean bl13 = false;
                    boolean bl14 = false;
                    Throwable throwable4 = throwable;
                    bl = false;
                    it = throwable4;
                    boolean bl15 = false;
                    this.log.warn(it.getMessage());
                }
                $this$forEach$iv = this.finishScript;
                if ($this$forEach$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"finishScript");
                    iterable = null;
                } else {
                    iterable = $this$forEach$iv;
                }
                Files.deleteIfExists((Path)iterable);
            }
            catch (Throwable e) {
                this.log.error("Unexpected exception", e);
            }
        }
    }

    private final void generateFinishCommand() {
        String cmd = "#bin\necho finish-job " + this.getJobName() + " >> " + AppPaths.INSTANCE.getPATH_LOCAL_COMMAND();
        try {
            Object object;
            Path path;
            Object object2 = this.finishScript;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finishScript");
                path = null;
            } else {
                path = object2;
            }
            object2 = cmd;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = object2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(path, byArray, object2);
            object2 = this.finishScript;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finishScript");
                object = null;
            } else {
                object = object2;
            }
            Files.setPosixFilePermissions((Path)object, PosixFilePermissions.fromString("rwxrw-r--"));
        }
        catch (IOException e) {
            this.log.error(e.toString());
        }
    }

    private final void startFeedLoop(ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context) {
        FetchMonitor monitor = this;
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor, this, context, null){
            int label;
            final /* synthetic */ FetchMonitor $monitor;
            final /* synthetic */ FetchMonitor this$0;
            final /* synthetic */ ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> $context;
            {
                this.$monitor = $monitor;
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = new FeedLoop(this.$monitor, FetchMonitor.access$getTaskScheduler$p(this.this$0), FetchMonitor.access$getTaskScheduler$p(this.this$0).getTasksMonitor(), this.$context, FetchMonitor.access$getConf$p(this.this$0)).start((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void startFetchLoop(ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context) {
        FetchMonitor monitor = this;
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor, this, context, null){
            int label;
            final /* synthetic */ FetchMonitor $monitor;
            final /* synthetic */ FetchMonitor this$0;
            final /* synthetic */ ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> $context;
            {
                this.$monitor = $monitor;
                this.this$0 = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = new FetchLoop(this.$monitor, FetchMonitor.access$getFetchComponent$p(this.this$0), FetchMonitor.access$getParseComponent$p(this.this$0), FetchMonitor.access$getTaskScheduler$p(this.this$0), this.$context, FetchMonitor.access$getConf$p(this.this$0)).start((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void startIndexThreads() {
        int n = this.jitIndexer.getIndexThreadCount();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            new IndexThread(this.jitIndexer, this.conf).start();
        }
    }

    private final void startWatcherLoop(ReducerContext<IntWritable, ? extends IFetchEntry, String, GWebPage> context) throws IOException {
        if (this.checkInterval.getSeconds() < 5L) {
            this.log.warn("Check frequency is too high, it might cause a serious performance problem");
        }
        do {
            Object object;
            try {
                TimeUnit.MILLISECONDS.sleep(this.checkInterval.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.taskScheduler.updateCounters();
            Instant now = Instant.now();
            Duration jobTime = Duration.between(this.startTime, now);
            Duration idleTime = Duration.between(this.taskScheduler.getLastTaskFinishTime(), now);
            if (idleTime.compareTo(this.jobIdleTimeout) > 0) {
                object = this.jobIdleTimeout;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobIdleTimeout");
                this.log.info("Idle timeout for {}, exit the job", (Object)DateTimesKt.readable((Duration)object));
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
            Intrinsics.checkNotNullExpressionValue((Object)idleTime, (String)"idleTime");
            this.tuneFetchQueues(now, idleTime);
            if (this.taskMonitor.getNumTasks() <= 5) {
                this.log.info("Totally remains only {} tasks", (Object)this.taskMonitor.getNumTasks());
                this.handleFewFetchItems();
            }
            if (this.coreMetrics != null && now.compareTo(this.throughputCheckTime) > 0 && this.coreMetrics.getSuccessFetchTasksPerSecond() < this.minSuccessPagesPerSecond) {
                object = this;
                int n = ((FetchMonitor)object).lowThroughputCount;
                ((FetchMonitor)object).lowThroughputCount = n + 1;
                this.checkFetchThroughput();
                object = this;
                ((FetchMonitor)object).throughputCheckTime = ((FetchMonitor)object).throughputCheckTime.plus(this.throughputCheckInterval);
            }
            if (!this.isActive()) {
                this.log.info("App is closing, exit the job ...");
                break;
            }
            if (FileCommand.check$default((FileCommand)FileCommand.INSTANCE, (String)("finish-job " + this.getJobName()), null, null, (int)6, null)) {
                this.handleFinishJobCommand();
                this.log.info("Found finish-job command, exit the job ...");
                break;
            }
            if (this.isMissionComplete()) {
                this.log.info("All done, exit the job ...");
                break;
            }
            if (this.isFetchJobTimeout()) {
                this.handleJobTimeout();
                Intrinsics.checkNotNullExpressionValue((Object)jobTime, (String)"jobTime");
                this.log.info("Hit fetch job timeout {}, exit the job ...", (Object)DateTimesKt.readable((Duration)jobTime));
                break;
            }
            if (!this.jitIndexer.isEnabled() || this.jitIndexer.isIndexServerAvailable()) continue;
            this.log.warn("Lost index server, exit the job");
            break;
        } while (this.isActive());
        this.close();
    }

    private final int handleJobTimeout() {
        return this.taskMonitor.clearReadyTasks();
    }

    private final void handleFewFetchItems() {
        this.taskMonitor.dump$pulsar_skeleton(5, false);
    }

    private final void handleFinishJobCommand() {
        this.taskMonitor.clearReadyTasks();
    }

    private final void tuneFetchQueues(Instant now, Duration idleTime) {
        Instant nextTuneTime;
        Instant nextCheckTime;
        if (this.taskMonitor.getNumReadyTasks().get() + this.taskMonitor.getNumPendingTasks().get() < 20) {
            this.poolPendingTimeout = Duration.ofMinutes(3L);
        }
        if (now.compareTo(nextCheckTime = this.poolTuneTime.plus(this.checkInterval.multipliedBy(2L))) > 0 && (now.compareTo(nextTuneTime = this.poolTuneTime.plus(this.poolTuneInterval)) > 0 || idleTime.compareTo(this.poolPendingTimeout) > 0)) {
            this.taskMonitor.tune$pulsar_skeleton(false);
            this.poolTuneTime = now;
        }
    }

    private final void checkFetchThroughput() {
        Object[] objectArray;
        int removedSlowTasks = 0;
        if (this.lowThroughputCount > this.maxLowThroughputCount) {
            removedSlowTasks = this.taskMonitor.tryClearSlowestQueue$pulsar_skeleton();
            objectArray = new Object[]{"lowThroughputCount", this.lowThroughputCount, "maxLowThroughputCount", this.maxLowThroughputCount, "minPageThroughputRate(p/s)", Float.valueOf(this.minSuccessPagesPerSecond), "removedSlowTasks", removedSlowTasks};
            this.log.info(Params.formatAsLine((String)"Unaccepted throughput", (Object)"clearing slowest pool, ", (Object[])objectArray));
            this.lowThroughputCount = 0;
        }
        if (this.totalLowThroughputCount > this.maxTotalLowThroughputCount) {
            removedSlowTasks = this.taskMonitor.clearReadyTasks();
            objectArray = new Object[]{"lowThroughputCount", this.lowThroughputCount, "maxLowThroughputCount", this.maxLowThroughputCount, "minPageThroughputRate(p/s)", Float.valueOf(this.minSuccessPagesPerSecond), "removedSlowTasks", removedSlowTasks};
            this.log.info(Params.formatAsLine((String)"Unaccepted throughput", (Object)"all pools are cleared", (Object[])objectArray));
            this.totalLowThroughputCount = 0;
        }
    }

    public static final /* synthetic */ TaskScheduler access$getTaskScheduler$p(FetchMonitor $this) {
        return $this.taskScheduler;
    }

    public static final /* synthetic */ ImmutableConfig access$getConf$p(FetchMonitor $this) {
        return $this.conf;
    }

    public static final /* synthetic */ FetchComponent access$getFetchComponent$p(FetchMonitor $this) {
        return $this.fetchComponent;
    }

    public static final /* synthetic */ ParseComponent access$getParseComponent$p(FetchMonitor $this) {
        return $this.parseComponent;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/FetchMonitor$Companion;", "", "()V", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

