/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolId;
import ai.platon.pulsar.persist.WebPage;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002+,B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0011\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0000H\u0096\u0002J\b\u0010*\u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000e\u00a8\u0006-"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "", "jobID", "", "priority", "protocol", "", "host", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "Ljava/net/URL;", "(IILjava/lang/String;Ljava/lang/String;Lai/platon/pulsar/persist/WebPage;Ljava/net/URL;)V", "getHost", "()Ljava/lang/String;", "itemId", "getItemId", "()I", "key", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask$Key;", "getKey", "()Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask$Key;", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "pendingStart", "Ljava/time/Instant;", "getPendingStart", "()Ljava/time/Instant;", "setPendingStart", "(Ljava/time/Instant;)V", "poolId", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "getPoolId", "()Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "getPriority", "getProtocol", "getUrl", "()Ljava/net/URL;", "urlString", "getUrlString", "compareTo", "other", "toString", "Companion", "Key", "pulsar-skeleton"})
public final class JobFetchTask
implements Comparable<JobFetchTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int priority;
    @NotNull
    private final String protocol;
    @NotNull
    private final String host;
    @NotNull
    private final WebPage page;
    @NotNull
    private final URL url;
    @NotNull
    private final Key key;
    @NotNull
    private Instant pendingStart;
    @NotNull
    private static final AtomicInteger instanceSequence = new AtomicInteger(0);

    public JobFetchTask(int jobID, int priority, @NotNull String protocol, @NotNull String host, @NotNull WebPage page, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.priority = priority;
        this.protocol = protocol;
        this.host = host;
        this.page = page;
        this.url = url;
        String string = this.url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
        this.key = new Key(jobID, this.priority, this.protocol, this.host, string, 0, 32, null);
        Instant instant = Instant.EPOCH;
        Intrinsics.checkNotNull((Object)instant);
        this.pendingStart = instant;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final WebPage getPage() {
        return this.page;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    @NotNull
    public final Key getKey() {
        return this.key;
    }

    public final int getItemId() {
        return this.key.getItemId();
    }

    @NotNull
    public final String getUrlString() {
        return this.key.getUrl();
    }

    @NotNull
    public final PoolId getPoolId() {
        return new PoolId(this.priority, this.protocol, this.host);
    }

    @NotNull
    public final Instant getPendingStart() {
        return this.pendingStart;
    }

    public final void setPendingStart(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.pendingStart = instant;
    }

    @NotNull
    public String toString() {
        return "{itemId: " + this.key.getItemId() + ", priority: " + this.key.getPriority() + ", url: " + this.key.getUrl() + "}";
    }

    @Override
    public int compareTo(@NotNull JobFetchTask other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.key.compareTo(other.key);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003JE\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000eR\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006)"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask$Key;", "", "jobID", "", "priority", "protocol", "", "host", "url", "itemId", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "getItemId", "()I", "setItemId", "(I)V", "getJobID", "setJobID", "getPriority", "setPriority", "getProtocol", "setProtocol", "getUrl", "setUrl", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "", "hashCode", "toString", "pulsar-skeleton"})
    public static final class Key
    implements Comparable<Key> {
        private int jobID;
        private int priority;
        @NotNull
        private String protocol;
        @NotNull
        private String host;
        @NotNull
        private String url;
        private int itemId;

        public Key(int jobID, int priority, @NotNull String protocol, @NotNull String host, @NotNull String url, int itemId) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.jobID = jobID;
            this.priority = priority;
            this.protocol = protocol;
            this.host = host;
            this.url = url;
            this.itemId = itemId;
        }

        public /* synthetic */ Key(int n, int n2, String string, String string2, String string3, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x20) != 0) {
                n3 = instanceSequence.incrementAndGet();
            }
            this(n, n2, string, string2, string3, n3);
        }

        public final int getJobID() {
            return this.jobID;
        }

        public final void setJobID(int n) {
            this.jobID = n;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final void setPriority(int n) {
            this.priority = n;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.protocol = string;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final void setHost(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.host = string;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.url = string;
        }

        public final int getItemId() {
            return this.itemId;
        }

        public final void setItemId(int n) {
            this.itemId = n;
        }

        @Override
        public int compareTo(@NotNull Key other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.itemId - other.itemId;
        }

        public final int component1() {
            return this.jobID;
        }

        public final int component2() {
            return this.priority;
        }

        @NotNull
        public final String component3() {
            return this.protocol;
        }

        @NotNull
        public final String component4() {
            return this.host;
        }

        @NotNull
        public final String component5() {
            return this.url;
        }

        public final int component6() {
            return this.itemId;
        }

        @NotNull
        public final Key copy(int jobID, int priority, @NotNull String protocol, @NotNull String host, @NotNull String url, int itemId) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Key(jobID, priority, protocol, host, url, itemId);
        }

        public static /* synthetic */ Key copy$default(Key key, int n, int n2, String string, String string2, String string3, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = key.jobID;
            }
            if ((n4 & 2) != 0) {
                n2 = key.priority;
            }
            if ((n4 & 4) != 0) {
                string = key.protocol;
            }
            if ((n4 & 8) != 0) {
                string2 = key.host;
            }
            if ((n4 & 0x10) != 0) {
                string3 = key.url;
            }
            if ((n4 & 0x20) != 0) {
                n3 = key.itemId;
            }
            return key.copy(n, n2, string, string2, string3, n3);
        }

        @NotNull
        public String toString() {
            return "Key(jobID=" + this.jobID + ", priority=" + this.priority + ", protocol=" + this.protocol + ", host=" + this.host + ", url=" + this.url + ", itemId=" + this.itemId + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.jobID);
            result = result * 31 + Integer.hashCode(this.priority);
            result = result * 31 + this.protocol.hashCode();
            result = result * 31 + this.host.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + Integer.hashCode(this.itemId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (this.jobID != key.jobID) {
                return false;
            }
            if (this.priority != key.priority) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.protocol, (Object)key.protocol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)key.host)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)key.url)) {
                return false;
            }
            return this.itemId == key.itemId;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask$Companion;", "", "()V", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "jobId", "", "priority", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final JobFetchTask create(int jobId, int priority, @NotNull String url, @NotNull WebPage page, @NotNull URLUtil.GroupMode groupMode) {
            JobFetchTask jobFetchTask;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
            URL uRL = UrlUtils.getURLOrNull((String)url);
            if (uRL == null) {
                return null;
            }
            URL u = uRL;
            String proto = u.getProtocol();
            String host = URLUtil.INSTANCE.getHost(u, groupMode);
            if (proto != null && host != null) {
                CharSequence charSequence = host;
                boolean bl = false;
                if (!(charSequence.length() == 0)) {
                    charSequence = proto;
                    bl = false;
                    String string = ((String)charSequence).toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                    charSequence = host;
                    bl = false;
                    String string2 = ((String)charSequence).toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    jobFetchTask = new JobFetchTask(jobId, priority, string, string2, page, u);
                    return jobFetchTask;
                }
            }
            jobFetchTask = null;
            return jobFetchTask;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

