/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.options.FetchOptions;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.JobInitialized;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.fetch.batch.JobFetchTask;
import ai.platon.pulsar.crawl.fetch.batch.TaskMonitor;
import ai.platon.pulsar.crawl.fetch.batch.TaskPool;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolId;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolQueue;
import ai.platon.pulsar.persist.WebPage;
import com.google.common.collect.TreeMultimap;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\f\u0018\u0000 k2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001kB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0014H\u0002J\u0006\u0010;\u001a\u00020\u0014J\u0010\u0010;\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0002J\b\u0010<\u001a\u000206H\u0016J\u0014\u0010=\u001a\u0004\u0018\u00010>2\n\b\u0002\u0010?\u001a\u0004\u0018\u000101J\n\u0010@\u001a\u0004\u0018\u00010>H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010>2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010B\u001a\u0002092\u0006\u0010?\u001a\u000201H\u0002J \u0010C\u001a\u0002062\u0006\u0010?\u001a\u0002012\u0006\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020>H\u0002J\u001d\u0010I\u001a\u0002062\u0006\u0010:\u001a\u00020\u00142\u0006\u0010J\u001a\u00020FH\u0000\u00a2\u0006\u0002\bKJ\u0018\u0010L\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u0002012\u0006\u0010M\u001a\u00020\u0014J \u0010L\u001a\u0004\u0018\u00010>2\u0006\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020P2\u0006\u0010M\u001a\u00020\u0014J\u000e\u0010Q\u001a\u0002062\u0006\u0010R\u001a\u00020>J\u000e\u0010S\u001a\u0002062\u0006\u0010R\u001a\u00020>J\b\u0010T\u001a\u00020UH\u0016J\n\u0010V\u001a\u0004\u0018\u000109H\u0002J\u0010\u0010W\u001a\u00020F2\u0006\u00108\u001a\u000209H\u0002J\u0006\u0010X\u001a\u000206J\u0010\u0010X\u001a\u0002092\u0006\u00108\u001a\u000209H\u0002J\u000e\u0010Y\u001a\u0002062\u0006\u0010H\u001a\u00020>J\u0016\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010[\u001a\u00020\\J\u0006\u0010]\u001a\u000206J\b\u0010^\u001a\u000206H\u0002J\u001c\u0010^\u001a\u0002062\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020.0`H\u0002J\b\u0010a\u001a\u000206H\u0002J\u0010\u0010b\u001a\u0002062\u0006\u00108\u001a\u000209H\u0002J\u0006\u0010c\u001a\u000206J\u0010\u0010d\u001a\u0002062\u0006\u0010e\u001a\u00020\tH\u0016J\r\u0010f\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bgJ\u0015\u0010h\u001a\u0002062\u0006\u0010i\u001a\u00020FH\u0000\u00a2\u0006\u0002\bjR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u000f*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0011\u0010$\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010)\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+RN\u0010,\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010.0.\u0012\f\u0012\n \u000f*\u0004\u0018\u00010.0. \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010.0.\u0012\f\u0012\n \u000f*\u0004\u0018\u00010.0.\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;", "Lai/platon/pulsar/common/config/Parameterized;", "Lai/platon/pulsar/crawl/common/JobInitialized;", "Ljava/lang/AutoCloseable;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "metrics", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/CoreMetrics;Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "crawlDelay", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "feederCompleted", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "id", "", "isMaintaining", "lastTaskPriority", "log", "Lorg/slf4j/Logger;", "minCrawlDelay", "minPagesPerSecond", "numFinishedTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumFinishedTasks", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numPendingTasks", "getNumPendingTasks", "numPoolThreads", "numReadyTasks", "getNumReadyTasks", "numTasks", "getNumTasks", "()I", "options", "Lai/platon/pulsar/common/options/FetchOptions;", "poolPendingTimeout", "getPoolPendingTimeout", "()Ljava/time/Duration;", "poolServedThreads", "Lcom/google/common/collect/TreeMultimap;", "", "poolTimeCosts", "Lorg/apache/commons/collections4/bidimap/DualTreeBidiMap;", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "", "taskPools", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolQueue;", "calculateTaskCounter", "", "clearPendingTasksIfFew", "pool", "Lai/platon/pulsar/crawl/fetch/batch/TaskPool;", "limit", "clearReadyTasks", "close", "consume", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "poolId", "consumeFromAnyPool", "consumeUnchecked", "createFetchQueue", "doFinish", "itemId", "asap", "", "doProduce", "task", "dump", "drop", "dump$pulsar_skeleton", "findPendingTask", "itemID", "priority", "url", "Ljava/net/URL;", "finish", "item", "finishAsap", "getParams", "Lai/platon/pulsar/common/config/Params;", "getSlowestPool", "isConsumable", "maintain", "produce", "jobID", "page", "Lai/platon/pulsar/persist/WebPage;", "report", "reportCost", "costRecorder", "", "reportServedThreads", "retire", "setFeederCompleted", "setup", "jobConf", "tryClearSlowestQueue", "tryClearSlowestQueue$pulsar_skeleton", "tune", "force", "tune$pulsar_skeleton", "Companion", "pulsar-skeleton"})
public final class TaskMonitor
implements Parameterized,
JobInitialized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreMetrics coreMetrics;
    @NotNull
    private final MiscMessageWriter metrics;
    private final Logger log;
    private FetchOptions options;
    private final int id;
    @NotNull
    private final AtomicBoolean feederCompleted;
    @NotNull
    private final PoolQueue taskPools;
    private int lastTaskPriority;
    @NotNull
    private final DualTreeBidiMap<PoolId, Double> poolTimeCosts;
    private final TreeMultimap<String, String> poolServedThreads;
    private URLUtil.GroupMode groupMode;
    private int minPagesPerSecond;
    private Duration crawlDelay;
    private Duration minCrawlDelay;
    private int numPoolThreads;
    private final Duration poolPendingTimeout;
    @NotNull
    private final AtomicBoolean isMaintaining;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final AtomicInteger numReadyTasks;
    @NotNull
    private final AtomicInteger numPendingTasks;
    @NotNull
    private final AtomicInteger numFinishedTasks;
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger(0);
    private static final int THREAD_SEQUENCE_POS = 12;

    public TaskMonitor(@NotNull CoreMetrics coreMetrics, @NotNull MiscMessageWriter metrics, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)coreMetrics, (String)"coreMetrics");
        Intrinsics.checkNotNullParameter((Object)((Object)metrics), (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.coreMetrics = coreMetrics;
        this.metrics = metrics;
        this.log = LoggerFactory.getLogger(TaskMonitor.class);
        this.id = instanceSequencer.incrementAndGet();
        this.feederCompleted = new AtomicBoolean(false);
        this.taskPools = new PoolQueue();
        this.lastTaskPriority = Integer.MIN_VALUE;
        this.poolTimeCosts = new DualTreeBidiMap();
        this.poolServedThreads = TreeMultimap.create();
        this.groupMode = (URLUtil.GroupMode)conf.getEnum("fetch.queue.mode", (Enum)URLUtil.GroupMode.BY_HOST);
        this.minPagesPerSecond = conf.getInt("fetch.throughput.threshold.pages", -1);
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        this.crawlDelay = conf.getDuration("fetch.queue.delay", duration);
        duration = Duration.ofSeconds(0L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(0)");
        this.minCrawlDelay = conf.getDuration("fetch.queue.min.delay", duration);
        this.numPoolThreads = 5;
        duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(5)");
        this.poolPendingTimeout = conf.getDuration("fetch.pending.timeout", duration);
        this.isMaintaining = new AtomicBoolean();
        this.closed = new AtomicBoolean();
        this.numReadyTasks = new AtomicInteger(0);
        this.numPendingTasks = new AtomicInteger(0);
        this.numFinishedTasks = new AtomicInteger(0);
    }

    public final Duration getPoolPendingTimeout() {
        return this.poolPendingTimeout;
    }

    @NotNull
    public final AtomicInteger getNumReadyTasks() {
        return this.numReadyTasks;
    }

    @NotNull
    public final AtomicInteger getNumPendingTasks() {
        return this.numPendingTasks;
    }

    @NotNull
    public final AtomicInteger getNumFinishedTasks() {
        return this.numFinishedTasks;
    }

    public final int getNumTasks() {
        return this.numReadyTasks.get() + this.numPendingTasks.get();
    }

    @Override
    public void setup(@NotNull ImmutableConfig jobConf) {
        FetchOptions fetchOptions;
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        FetchOptions fetchOptions2 = this.options = new FetchOptions(jobConf);
        if (fetchOptions2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            fetchOptions = null;
        } else {
            fetchOptions = fetchOptions2;
        }
        this.numPoolThreads = fetchOptions.getNumPoolThreads();
        this.log.info(this.getParams().format());
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"numPoolThreads", this.numPoolThreads, "groupMode", this.groupMode, "crawlDelay", this.crawlDelay, "minCrawlDelay", this.minCrawlDelay, "poolPendingTimeout", this.poolPendingTimeout};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026lPendingTimeout\n        )");
        return params;
    }

    public final void setFeederCompleted() {
        this.feederCompleted.set(true);
    }

    public final synchronized void produce(int jobID, @NotNull WebPage page) {
        FetchOptions fetchOptions;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        FetchOptions fetchOptions2 = this.options;
        if (fetchOptions2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            fetchOptions = null;
        } else {
            fetchOptions = fetchOptions2;
        }
        page.setFetchMode(fetchOptions.getFetchMode());
        int n = page.getFetchPriority();
        Object object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        String string = object;
        object = this.groupMode;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupMode");
        JobFetchTask task = JobFetchTask.Companion.create(jobID, n, string, page, (URLUtil.GroupMode)((Object)object));
        if (task != null) {
            this.produce(task);
        } else {
            this.log.warn("Failed to create FetchTask | {}", (Object)page.getUrl());
        }
    }

    public final synchronized void produce(@NotNull JobFetchTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.doProduce(task);
    }

    @Nullable
    public final synchronized JobFetchTask consume(@Nullable PoolId poolId) {
        if (poolId == null) {
            return this.consumeFromAnyPool();
        }
        Parameterized parameterized = this.taskPools.find(poolId);
        if (parameterized == null) {
            return null;
        }
        TaskPool pool = parameterized;
        TaskMonitor taskMonitor = this;
        boolean bl = false;
        boolean bl2 = false;
        TaskMonitor it = taskMonitor;
        boolean bl3 = false;
        parameterized = this.isConsumable(pool) ? taskMonitor : null;
        return parameterized == null ? null : super.consumeUnchecked(pool);
    }

    public static /* synthetic */ JobFetchTask consume$default(TaskMonitor taskMonitor, PoolId poolId, int n, Object object) {
        if ((n & 1) != 0) {
            poolId = null;
        }
        return taskMonitor.consume(poolId);
    }

    public final synchronized void finish(@NotNull JobFetchTask item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.doFinish(new PoolId(item.getPriority(), item.getProtocol(), item.getHost()), item.getItemId(), false);
    }

    public final synchronized void finishAsap(@NotNull JobFetchTask item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.doFinish(new PoolId(item.getPriority(), item.getProtocol(), item.getHost()), item.getItemId(), true);
    }

    public final void maintain() {
        if (this.isMaintaining.compareAndSet(false, true)) {
            Iterable $this$forEach$iv = this.taskPools;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskPool it = (TaskPool)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.maintain(it);
            }
        }
        this.isMaintaining.set(false);
    }

    private final boolean isConsumable(TaskPool pool) {
        return pool.isActive() && pool.hasReadyTasks() && this.coreMetrics.isReachable(pool.getHost());
    }

    private final TaskPool maintain(TaskPool pool) {
        TaskPool.Status lastStatus = pool.getStatus();
        if (this.coreMetrics.isUnreachable(pool.getHost())) {
            this.retire(pool);
            this.log.info("Retire pool with unreachable host | {}", (Object)pool.getId());
        } else if (this.feederCompleted.get() && !pool.hasTasks()) {
            this.taskPools.disable(pool);
        }
        TaskPool.Status status = pool.getStatus();
        if (status != lastStatus) {
            Object[] objectArray = new Object[]{"status", lastStatus + " -> " + pool.getStatus(), "ready", pool.getNumReadyTasks(), "pending", pool.getNumPendingTasks(), "finished", pool.getNumTotalFinishedTasks()};
            Params.of((String)"fetchQueue", (Object)pool.getId(), (Object[])objectArray).withLogger(this.log).info(true);
        }
        return pool;
    }

    private final JobFetchTask consumeFromAnyPool() {
        Object v1;
        TaskPool pool;
        block5: {
            boolean priorityChanged;
            TaskPool taskPool = this.taskPools.peek();
            if (taskPool == null) {
                return null;
            }
            pool = taskPool;
            int nextPriority = pool.getPriority();
            boolean bl = priorityChanged = nextPriority < this.lastTaskPriority;
            if (priorityChanged && this.taskPools.hasPriorPendingTasks(nextPriority)) {
                return null;
            }
            if (priorityChanged) {
                this.log.info("Fetch priority changed : " + this.lastTaskPriority + " -> " + nextPriority);
            }
            Iterable iterable = this.taskPools;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            boolean bl3 = false;
            for (Object t : iterable2) {
                TaskPool it = (TaskPool)t;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.isConsumable(it)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        TaskPool taskPool = v1;
        if (taskPool == null) {
            return null;
        }
        pool = taskPool;
        return this.consumeUnchecked(pool);
    }

    private final JobFetchTask consumeUnchecked(TaskPool pool) {
        JobFetchTask item = pool.consume();
        if (item != null) {
            this.numReadyTasks.decrementAndGet();
            this.numPendingTasks.incrementAndGet();
            this.lastTaskPriority = pool.getPriority();
        }
        return item;
    }

    private final void doProduce(JobFetchTask task) {
        String url = task.getUrlString();
        String string = URLUtil.INSTANCE.getHostName(url);
        if (string == null) {
            return;
        }
        String host = string;
        if (this.coreMetrics.isUnreachable(host)) {
            this.log.warn("Ignore unreachable url | {}", (Object)url);
            return;
        }
        PoolId poolId = task.getPoolId();
        TaskPool pool = this.taskPools.find(poolId);
        if (pool == null) {
            pool = this.taskPools.findExtend(poolId);
            if (pool != null) {
                this.taskPools.enable(pool);
            } else {
                pool = this.createFetchQueue(poolId);
                this.taskPools.add(pool);
            }
        }
        pool.produce(task);
        this.numReadyTasks.incrementAndGet();
        Map map2 = (Map)this.poolTimeCosts;
        PoolId poolId2 = pool.getId();
        Double d = 0.0;
        boolean bl = false;
        map2.put(poolId2, d);
    }

    private final void doFinish(PoolId poolId, int itemId, boolean asap) {
        TaskPool pool = this.taskPools.findExtend(poolId);
        if (pool == null) {
            this.log.warn("Attempt to finish item from unknown pool " + poolId);
            return;
        }
        if (!pool.pendingTaskExists(itemId)) {
            if (!this.taskPools.isEmpty()) {
                this.log.warn("Attempt to finish unknown item: <{}, {}>", (Object)poolId, (Object)itemId);
            }
            return;
        }
        pool.finish(itemId, asap);
        this.numPendingTasks.decrementAndGet();
        this.numFinishedTasks.incrementAndGet();
        Object object = (Map)this.poolTimeCosts;
        Double d = pool.getAverageRecentTimeCost();
        boolean bl = false;
        object.put(poolId, d);
        String string = poolId.getHost();
        object = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentThread().name");
        int n = 12;
        bl = false;
        String string2 = ((String)object).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        this.poolServedThreads.put((Object)string, (Object)string2);
    }

    private final void retire(TaskPool pool) {
        pool.retire();
        this.taskPools.remove((Object)pool);
    }

    public final synchronized void report() {
        this.dump$pulsar_skeleton(5, false);
        this.reportCost();
        this.reportServedThreads();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void tune$pulsar_skeleton(boolean force) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.taskPools;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TaskPool it = (TaskPool)element$iv$iv;
            boolean bl = false;
            if (!this.coreMetrics.isUnreachable(it.getHost())) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv22;
        boolean $i$f$onEach = false;
        iterable = $this$onEach$iv;
        boolean destination$iv$iv22 = false;
        $i$f$filterTo = false;
        Iterable $this$apply$iv = iterable;
        boolean bl = false;
        for (Object element$iv : $this$apply$iv) {
            TaskPool it = (TaskPool)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.retire(it);
        }
        Iterable iterable2 = iterable;
        boolean bl3 = false;
        boolean bl4 = false;
        List it = (List)iterable2;
        boolean bl5 = false;
        Object object = it;
        boolean bl6 = false;
        List list = (List)(!object.isEmpty() ? iterable2 : null);
        if (list != null) {
            iterable2 = list;
            bl3 = false;
            bl4 = false;
            Iterable pool = iterable2;
            boolean bl7 = false;
            object = CollectionsKt.joinToString$default((Iterable)pool, (CharSequence)", ", (CharSequence)"Unavailable pools: ", null, (int)0, null, (Function1)tune.4.1.INSTANCE, (int)28, null);
            bl6 = false;
            boolean bl8 = false;
            Object it2 = object;
            boolean bl9 = false;
            this.log.info((String)it2);
        }
        this.calculateTaskCounter();
    }

    @Nullable
    public final synchronized JobFetchTask findPendingTask(int priority, @NotNull URL url, int itemID) {
        TaskPool pool;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        TaskPool taskPool = pool = this.taskPools.findExtend(new PoolId(priority, url));
        return taskPool == null ? null : taskPool.getPendingTask(itemID);
    }

    @Nullable
    public final synchronized JobFetchTask findPendingTask(@NotNull PoolId poolId, int itemID) {
        TaskPool pool;
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        TaskPool taskPool = pool = this.taskPools.findExtend(poolId);
        return taskPool == null ? null : taskPool.getPendingTask(itemID);
    }

    public final synchronized void dump$pulsar_skeleton(int limit, boolean drop) {
        this.taskPools.dump(limit, drop);
        this.calculateTaskCounter();
    }

    public final synchronized int tryClearSlowestQueue$pulsar_skeleton() {
        TaskPool taskPool = this.getSlowestPool();
        if (taskPool == null) {
            return 0;
        }
        TaskPool pool = taskPool;
        DecimalFormat df = new DecimalFormat("0.##");
        if (pool.getAverageTps() >= (double)this.minPagesPerSecond) {
            Object[] objectArray = new Object[]{"ReadyTasks", pool.getNumReadyTasks(), "PendingTasks", pool.getNumPendingTasks(), "FinishedTasks", pool.getNumTotalFinishedTasks(), "SlowTasks", pool.getNumSlowTasks(), "Throughput, ", df.format(pool.getAverageTime()) + "s/p, " + df.format(pool.getAverageTps()) + "p/s"};
            Params.of((String)"EfficientQueue", (Object)pool.getId(), (Object[])objectArray).withLogger(this.log).info(true);
            return 0;
        }
        this.retire(pool);
        int minPendingSlowTasks = 2;
        this.clearPendingTasksIfFew(pool, minPendingSlowTasks);
        int deleted = this.clearReadyTasks(pool);
        Object[] objectArray = new Object[]{"ReadyTasks", pool.getNumReadyTasks(), "PendingTasks", pool.getNumPendingTasks(), "FinishedTasks", pool.getNumTotalFinishedTasks(), "SlowTasks", pool.getNumSlowTasks(), "Throughput, ", df.format(pool.getAverageTime()) + "s/p, " + df.format(pool.getAverageTps()) + "p/s", "Deleted", deleted};
        Params.of((String)"SlowestQueue", (Object)pool.getId(), (Object[])objectArray).withLogger(this.log).info(true);
        return deleted;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Closing TasksMonitor #" + this.id);
            this.report();
            this.taskPools.clear();
            this.numReadyTasks.set(0);
        }
    }

    public final synchronized int clearReadyTasks() {
        int count = 0;
        TreeMap costRecorder = new TreeMap(Comparator.reverseOrder());
        for (TaskPool pool : this.taskPools) {
            Map map2 = costRecorder;
            Double d = pool.getAverageRecentTimeCost();
            String string = pool.getId().getHost();
            boolean bl = false;
            map2.put(d, string);
            if (pool.getNumReadyTasks() == 0) continue;
            count += this.clearReadyTasks(pool);
        }
        this.reportCost(costRecorder);
        return count;
    }

    private final int clearPendingTasksIfFew(TaskPool pool, int limit) {
        int deleted = pool.clearPendingTasksIfFew(limit);
        this.numPendingTasks.addAndGet(-deleted);
        return deleted;
    }

    private final int clearReadyTasks(TaskPool pool) {
        int deleted = pool.clearReadyQueue();
        this.numReadyTasks.addAndGet(-deleted);
        if (this.numReadyTasks.get() <= 0 && this.taskPools.size() == 0) {
            this.numReadyTasks.set(0);
        }
        return deleted;
    }

    private final void calculateTaskCounter() {
        int readyCount = 0;
        int pendingCount = 0;
        Iterable $this$forEach$iv = this.taskPools;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskPool it = (TaskPool)element$iv;
            boolean bl = false;
            readyCount += it.getNumReadyTasks();
            pendingCount += it.getNumPendingTasks();
        }
        this.numReadyTasks.set(readyCount);
        this.numPendingTasks.set(pendingCount);
    }

    private final TaskPool createFetchQueue(PoolId poolId) {
        Object object = this.groupMode;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupMode");
        URLUtil.GroupMode groupMode = object;
        object = this.crawlDelay;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"crawlDelay");
        Object object2 = object;
        object = this.minCrawlDelay;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"minCrawlDelay");
        Object object3 = object;
        object = this.poolPendingTimeout;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"poolPendingTimeout");
        TaskPool pool = new TaskPool(poolId, groupMode, this.numPoolThreads, (Duration)object2, (Duration)object3, (Duration)object);
        this.log.info("FetchQueue created : " + pool);
        return pool;
    }

    private final TaskPool getSlowestPool() {
        TaskPool pool = null;
        while (!this.taskPools.isEmpty() && pool == null) {
            Double maxCost = (Double)this.poolTimeCosts.inverseBidiMap().lastKey();
            PoolId id = (PoolId)this.poolTimeCosts.inverseBidiMap().get((Object)maxCost);
            if (id == null) continue;
            this.poolTimeCosts.remove((Object)id);
            pool = this.taskPools.find(id);
        }
        return pool;
    }

    private final void reportServedThreads() {
        String string;
        String it;
        Collection collection;
        String string2;
        Iterable $this$mapTo$iv$iv;
        StringBuilder report2 = new StringBuilder();
        NavigableSet navigableSet = this.poolServedThreads.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)navigableSet, (String)"poolServedThreads.keySet()");
        Iterable $this$map$iv = navigableSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            string = UrlUtils.reverseHost((String)it);
            collection.add(string);
        }
        $this$map$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = UrlUtils.unreverseHost((String)it);
            collection.add(string);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line;
            String poolId = (String)element$iv;
            boolean bl = false;
            String threads = "#" + StringUtils.join((Iterable)this.poolServedThreads.get((Object)poolId), (String)", #");
            string2 = StringCompanionObject.INSTANCE;
            String string3 = "%1$40s -> %2$s\n";
            Object[] objectArray = new Object[]{poolId, threads};
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            report2.append(line);
        }
        this.log.info("Served threads: \n" + report2);
    }

    private final void reportCost(Map<Double, String> costRecorder) {
        StringBuilder sb = new StringBuilder();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object object = "\n%s\n";
        Object[] objectArray = new Object[]{"---------------Queue Cost Report--------------"};
        boolean bl = false;
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        sb.append(string);
        stringCompanionObject = StringCompanionObject.INSTANCE;
        object = "%25s %s\n";
        objectArray = new Object[]{"Ava Time(s)", "Queue Id"};
        bl = false;
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        sb.append(string2);
        object = new int[1];
        object[0] = false;
        Object i = object;
        costRecorder.entrySet().stream().limit(100L).forEach(arg_0 -> TaskMonitor.reportCost$lambda-12(sb, (int[])i, arg_0));
        this.log.info(sb.toString());
    }

    private final void reportCost() {
        String report2 = "Top slow hosts: \n" + this.taskPools.getTimeReport();
        report2 = report2 + "\n";
        this.log.info(report2);
    }

    private static final void reportCost$lambda-12(StringBuilder $sb, int[] $i, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%1$,4d.%2$,20.2f";
        Object[] objectArray = new Object[2];
        int[] nArray = $i;
        nArray[0] = nArray[0] + 1;
        objectArray[0] = nArray[0];
        objectArray[1] = entry.getKey();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        $sb.append(string2);
        $sb.append(" <- ");
        $sb.append((String)entry.getValue());
        $sb.append("\n");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor$Companion;", "", "()V", "THREAD_SEQUENCE_POS", "", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

