/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.fetch.batch.JobFetchTask;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolId;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 p2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002pqB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0006\u0010M\u001a\u00020\bJ\u000e\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\bJ\u0006\u0010P\u001a\u00020\bJ\u0011\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\u0000H\u0096\u0002J\b\u0010S\u001a\u0004\u0018\u000106J\u0006\u0010T\u001a\u00020UJ\u000e\u0010V\u001a\u00020U2\u0006\u0010W\u001a\u00020!J\u0006\u0010X\u001a\u00020UJ\u0013\u0010Y\u001a\u00020!2\b\u0010R\u001a\u0004\u0018\u00010ZH\u0096\u0002J\u0016\u0010[\u001a\u00020!2\u0006\u0010\\\u001a\u0002062\u0006\u0010]\u001a\u00020!J\u0016\u0010[\u001a\u00020!2\u0006\u0010^\u001a\u00020\b2\u0006\u0010]\u001a\u00020!J\b\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u0004\u0018\u0001062\u0006\u0010b\u001a\u00020\bJ\u0018\u0010c\u001a\u00020U2\u0006\u0010\\\u001a\u0002062\u0006\u0010d\u001a\u00020*H\u0002J\u0006\u0010e\u001a\u00020!J\u0006\u0010f\u001a\u00020!J\u0006\u0010g\u001a\u00020!J\b\u0010h\u001a\u00020\bH\u0016J\u000e\u0010%\u001a\u00020!2\u0006\u0010O\u001a\u00020\nJ\u000e\u0010i\u001a\u00020!2\u0006\u0010^\u001a\u00020\bJ\u000e\u0010j\u001a\u00020U2\u0006\u0010k\u001a\u000206J\u0006\u0010l\u001a\u00020UJ\u0018\u0010m\u001a\u00020U2\u0006\u0010n\u001a\u00020*2\u0006\u0010]\u001a\u00020!H\u0002J\b\u0010o\u001a\u00020\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u0011\u0010#\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0016\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n (*\u0004\u0018\u00010*0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0011\u00100\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010-R\u0011\u00102\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010-R\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010-R\u0011\u00109\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001dR\u0014\u0010;\u001a\b\u0012\u0004\u0012\u0002060<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\n (*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\n0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010E\u001a\u00020D2\u0006\u0010C\u001a\u00020D@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u001dR\u000e\u0010J\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskPool;", "", "Lai/platon/pulsar/common/config/Parameterized;", "id", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "groupMode", "Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "allowedThreads", "", "crawlDelay", "Ljava/time/Duration;", "minCrawlDelay", "pendingTimeout", "(Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;ILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "averageRecentTimeCost", "", "getAverageRecentTimeCost", "()D", "averageRecentTps", "getAverageRecentTps", "averageTime", "getAverageTime", "averageTps", "getAverageTps", "getGroupMode", "()Lai/platon/pulsar/crawl/common/URLUtil$GroupMode;", "host", "", "getHost", "()Ljava/lang/String;", "getId", "()Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "isActive", "", "()Z", "isInactive", "isRetired", "isSlow", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nextFetchTime", "Ljava/time/Instant;", "numPendingTasks", "getNumPendingTasks", "()I", "numReadyTasks", "getNumReadyTasks", "numSlowTasks", "getNumSlowTasks", "numTotalFinishedTasks", "getNumTotalFinishedTasks", "pendingTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "priority", "getPriority", "protocol", "getProtocol", "readyTasks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "recentFetchMillis", "", "recentFinishedTasks", "slowTaskThreshold", "slowTasksRecorder", "Lorg/apache/commons/collections4/queue/CircularFifoQueue;", "<set-?>", "Lai/platon/pulsar/crawl/fetch/batch/TaskPool$Status;", "status", "getStatus", "()Lai/platon/pulsar/crawl/fetch/batch/TaskPool$Status;", "timeReport", "getTimeReport", "totalFetchMillis", "totalFinishedTasks", "unreachableTasks", "clearPendingQueue", "clearPendingTasksIfFew", "threshold", "clearReadyQueue", "compareTo", "other", "consume", "disable", "", "dump", "drop", "enable", "equals", "", "finish", "fetchTask", "asap", "itemId", "getParams", "Lai/platon/pulsar/common/config/Params;", "getPendingTask", "itemID", "hangUp", "now", "hasPendingTasks", "hasReadyTasks", "hasTasks", "hashCode", "pendingTaskExists", "produce", "task", "retire", "setNextFetchTime", "finishTime", "toString", "Companion", "Status", "pulsar-skeleton"})
public final class TaskPool
implements Comparable<TaskPool>,
Parameterized {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PoolId id;
    @NotNull
    private final URLUtil.GroupMode groupMode;
    private final int allowedThreads;
    @NotNull
    private final Duration crawlDelay;
    @NotNull
    private final Duration minCrawlDelay;
    @NotNull
    private final Duration pendingTimeout;
    private final Logger log;
    @NotNull
    private final ConcurrentLinkedQueue<JobFetchTask> readyTasks;
    @NotNull
    private final ConcurrentHashMap<Integer, JobFetchTask> pendingTasks;
    private final Duration slowTaskThreshold;
    @NotNull
    private final CircularFifoQueue<Duration> slowTasksRecorder;
    private Instant nextFetchTime;
    private int recentFinishedTasks;
    private long recentFetchMillis;
    private int totalFinishedTasks;
    private long totalFetchMillis;
    private int unreachableTasks;
    @NotNull
    private Status status;
    public static final int RECENT_TASKS_COUNT_LIMIT = 100;

    public TaskPool(@NotNull PoolId id, @NotNull URLUtil.GroupMode groupMode, int allowedThreads, @NotNull Duration crawlDelay, @NotNull Duration minCrawlDelay, @NotNull Duration pendingTimeout) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)groupMode), (String)"groupMode");
        Intrinsics.checkNotNullParameter((Object)crawlDelay, (String)"crawlDelay");
        Intrinsics.checkNotNullParameter((Object)minCrawlDelay, (String)"minCrawlDelay");
        Intrinsics.checkNotNullParameter((Object)pendingTimeout, (String)"pendingTimeout");
        this.id = id;
        this.groupMode = groupMode;
        this.allowedThreads = allowedThreads;
        this.crawlDelay = crawlDelay;
        this.minCrawlDelay = minCrawlDelay;
        this.pendingTimeout = pendingTimeout;
        this.log = LoggerFactory.getLogger(TaskPool.class);
        this.readyTasks = new ConcurrentLinkedQueue();
        this.pendingTasks = new ConcurrentHashMap();
        this.slowTaskThreshold = Duration.ofMinutes(2L);
        this.slowTasksRecorder = new CircularFifoQueue(100);
        this.nextFetchTime = Instant.now();
        this.recentFinishedTasks = 1;
        this.recentFetchMillis = 1L;
        this.totalFinishedTasks = 1;
        this.totalFetchMillis = 1L;
        this.status = Status.ACTIVITY;
    }

    @NotNull
    public final PoolId getId() {
        return this.id;
    }

    @NotNull
    public final URLUtil.GroupMode getGroupMode() {
        return this.groupMode;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final int getPriority() {
        return this.id.getPriority();
    }

    @NotNull
    public final String getProtocol() {
        return this.id.getProtocol();
    }

    @NotNull
    public final String getHost() {
        return this.id.getHost();
    }

    public final boolean isSlow() {
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(1)");
        return this.isSlow(duration);
    }

    public final boolean isActive() {
        return this.status == Status.ACTIVITY;
    }

    public final boolean isInactive() {
        return this.status == Status.INACTIVITY;
    }

    public final boolean isRetired() {
        return this.status == Status.RETIRED;
    }

    public final int getNumReadyTasks() {
        return this.readyTasks.size();
    }

    public final int getNumPendingTasks() {
        return this.pendingTasks.size();
    }

    public final int getNumTotalFinishedTasks() {
        return this.totalFinishedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumSlowTasks() {
        CircularFifoQueue<Duration> circularFifoQueue = this.slowTasksRecorder;
        boolean bl = false;
        int n = 0;
        synchronized (circularFifoQueue) {
            boolean bl2 = false;
            n = this.slowTasksRecorder.size();
        }
        return n;
    }

    public final double getAverageTime() {
        return (double)this.totalFetchMillis / 1000.0 / (double)this.totalFinishedTasks;
    }

    public final double getAverageRecentTimeCost() {
        return (double)this.recentFetchMillis / 1000.0 / (double)this.recentFinishedTasks;
    }

    public final double getAverageTps() {
        return (double)this.totalFinishedTasks / ((double)this.totalFetchMillis / 1000.0);
    }

    public final double getAverageRecentTps() {
        return (double)this.recentFinishedTasks / ((double)this.recentFetchMillis / 1000.0);
    }

    @NotNull
    public final String getTimeReport() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%1$40s -> averageTime : %2$.2fs/p, avaThoRate : %3$.2fp/s";
        Object[] objectArray = new Object[]{this.id, this.getAverageTime(), this.getAverageTps()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public Params getParams() {
        DecimalFormat df = new DecimalFormat("###0.##");
        String string = this.getClass().getSimpleName();
        Object[] objectArray = new Object[28];
        objectArray[0] = "status";
        objectArray[1] = this.status;
        objectArray[2] = "id";
        objectArray[3] = this.id;
        objectArray[4] = "allowedThreads";
        objectArray[5] = this.allowedThreads;
        objectArray[6] = "pendingTasks";
        objectArray[7] = this.pendingTasks.size();
        objectArray[8] = "crawlDelay";
        objectArray[9] = this.crawlDelay;
        objectArray[10] = "minCrawlDelay";
        objectArray[11] = this.minCrawlDelay;
        objectArray[12] = "now";
        objectArray[13] = DateTimes.now();
        objectArray[14] = "nextFetchTime";
        Instant instant = this.nextFetchTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"nextFetchTime");
        objectArray[15] = DateTimes.INSTANCE.format(instant);
        objectArray[16] = "aveTimeCost(s)";
        objectArray[17] = df.format(this.getAverageTime());
        objectArray[18] = "aveThoRate(s)";
        objectArray[19] = df.format(this.getAverageTps());
        objectArray[20] = "readyTasks";
        objectArray[21] = this.getNumReadyTasks();
        objectArray[22] = "pendingTasks";
        objectArray[23] = this.getNumPendingTasks();
        objectArray[24] = "finsihedTasks";
        objectArray[25] = this.getNumTotalFinishedTasks();
        objectArray[26] = "unreachableTasks";
        objectArray[27] = this.unreachableTasks;
        Params params = Params.of((String)"className", (Object)string, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026nreachableTasks\n        )");
        return params;
    }

    public final void produce(@NotNull JobFetchTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.status != Status.ACTIVITY) {
            return;
        }
        if (task.getPriority() != this.id.getPriority() || !Intrinsics.areEqual((Object)task.getHost(), (Object)this.id.getHost())) {
            this.log.error("Queue id mismatches with FetchTask #" + task);
        }
        this.readyTasks.add(task);
    }

    @Nullable
    public final JobFetchTask consume() {
        if (this.status != Status.ACTIVITY) {
            return null;
        }
        if (this.allowedThreads > 0 && this.pendingTasks.size() >= this.allowedThreads) {
            return null;
        }
        Instant now = Instant.now();
        if (now.isBefore(this.nextFetchTime)) {
            return null;
        }
        int size0 = this.readyTasks.size();
        JobFetchTask fetchTask = this.readyTasks.poll();
        if (fetchTask != null) {
            if (size0 == this.readyTasks.size()) {
                this.log.warn("Ready tasks does not reduce it's size");
            }
            Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
            this.hangUp(fetchTask, now);
        }
        return fetchTask;
    }

    public final boolean finish(int itemId, boolean asap) {
        JobFetchTask item = this.pendingTasks.get(itemId);
        return item != null && this.finish(item, asap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean finish(@NotNull JobFetchTask fetchTask, boolean asap) {
        CircularFifoQueue<Duration> circularFifoQueue;
        Intrinsics.checkNotNullParameter((Object)fetchTask, (String)"fetchTask");
        this.pendingTasks.remove(fetchTask.getItemId());
        Instant finishTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)finishTime, (String)"finishTime");
        this.setNextFetchTime(finishTime, asap);
        Duration elapsed = Duration.between(fetchTask.getPendingStart(), finishTime);
        if (elapsed.compareTo(this.slowTaskThreshold) > 0) {
            circularFifoQueue = this.slowTasksRecorder;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (circularFifoQueue) {
                boolean bl3 = false;
                bl2 = this.slowTasksRecorder.add((Object)elapsed);
            }
        }
        circularFifoQueue = this;
        ++circularFifoQueue.recentFinishedTasks;
        int cfr_ignored_0 = circularFifoQueue.recentFinishedTasks;
        circularFifoQueue = this;
        circularFifoQueue.recentFetchMillis += elapsed.toMillis();
        if (this.recentFinishedTasks > 100) {
            this.recentFinishedTasks = 1;
            this.recentFetchMillis = 1L;
        }
        circularFifoQueue = this;
        ++circularFifoQueue.totalFinishedTasks;
        int cfr_ignored_1 = circularFifoQueue.totalFinishedTasks;
        circularFifoQueue = this;
        circularFifoQueue.totalFetchMillis += elapsed.toMillis();
        return true;
    }

    @Nullable
    public final JobFetchTask getPendingTask(int itemID) {
        return this.pendingTasks.get(itemID);
    }

    private final void hangUp(JobFetchTask fetchTask, Instant now) {
        fetchTask.setPendingStart(now);
        Map map2 = this.pendingTasks;
        Integer n = fetchTask.getItemId();
        boolean bl = false;
        map2.put(n, fetchTask);
    }

    public final boolean hasTasks() {
        return this.hasReadyTasks() || this.hasPendingTasks();
    }

    public final boolean hasReadyTasks() {
        return !this.readyTasks.isEmpty();
    }

    public final boolean hasPendingTasks() {
        return !this.pendingTasks.isEmpty();
    }

    public final boolean pendingTaskExists(int itemId) {
        return this.pendingTasks.containsKey(itemId);
    }

    public final boolean isSlow(@NotNull Duration threshold) {
        Intrinsics.checkNotNullParameter((Object)threshold, (String)"threshold");
        return this.getAverageRecentTimeCost() > (double)threshold.getSeconds();
    }

    public final void enable() {
        this.status = Status.ACTIVITY;
    }

    public final void disable() {
        this.status = Status.INACTIVITY;
    }

    public final void retire() {
        this.status = Status.RETIRED;
    }

    public final int clearReadyQueue() {
        int count = this.readyTasks.size();
        this.readyTasks.clear();
        return count;
    }

    public final int clearPendingQueue() {
        int count = this.pendingTasks.size();
        this.pendingTasks.clear();
        return count;
    }

    public final int clearPendingTasksIfFew(int threshold) {
        int count = this.pendingTasks.size();
        if (count > threshold) {
            return 0;
        }
        if (this.pendingTasks.isEmpty()) {
            return 0;
        }
        Instant now = Instant.now();
        Collection<JobFetchTask> collection = this.pendingTasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"pendingTasks.values");
        String report2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)collection, (int)threshold), (CharSequence)"\n", (CharSequence)"Clearing slow pending items : ", null, (int)0, null, (Function1)((Function1)new Function1<JobFetchTask, CharSequence>(now){
            final /* synthetic */ Instant $now;
            {
                this.$now = $now;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull JobFetchTask it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getUrlString() + " : " + Duration.between(it.getPendingStart(), this.$now);
            }
        }), (int)28, null);
        this.log.info(report2);
        this.pendingTasks.clear();
        return count;
    }

    public final void dump(boolean drop) {
        this.log.info("Dump pool | " + this.getParams().formatAsLine());
        if (drop) {
            Collection collection = this.readyTasks;
            boolean bl = false;
            if (!collection.isEmpty()) {
                int i = 0;
                int limit = 20;
                Object report2 = "Drop the following tasks : ";
                JobFetchTask fetchTask = this.readyTasks.poll();
                while (fetchTask != null && ++i <= limit) {
                    report2 = (String)report2 + "  " + i + ". " + fetchTask.getUrlString() + "\t";
                    fetchTask = this.readyTasks.poll();
                }
                this.log.info((String)report2);
            }
        }
    }

    private final void setNextFetchTime(Instant finishTime, boolean asap) {
        this.nextFetchTime = !asap ? finishTime.plus(this.allowedThreads > 1 ? this.minCrawlDelay : this.crawlDelay) : finishTime;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TaskPool && Intrinsics.areEqual((Object)this.id, (Object)((TaskPool)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(@NotNull TaskPool other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.id.compareTo(other.id);
    }

    @NotNull
    public String toString() {
        return this.id.toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskPool$Status;", "", "(Ljava/lang/String;I)V", "ACTIVITY", "INACTIVITY", "RETIRED", "pulsar-skeleton"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status ACTIVITY = new Status();
        public static final /* enum */ Status INACTIVITY = new Status();
        public static final /* enum */ Status RETIRED = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.ACTIVITY, Status.INACTIVITY, Status.RETIRED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskPool$Companion;", "", "()V", "RECENT_TASKS_COUNT_LIMIT", "", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

