/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.measure.ByteUnitConverter;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.CommonCounter;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.common.metrics.EnumCounterUtils;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.JobInitialized;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.fetch.batch.JobFetchTask;
import ai.platon.pulsar.crawl.fetch.batch.TaskMonitor;
import ai.platon.pulsar.crawl.fetch.batch.TaskScheduler;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolId;
import ai.platon.pulsar.crawl.index.jit.indexer.JITIndexer;
import ai.platon.pulsar.crawl.parse.PageParser;
import ai.platon.pulsar.crawl.parse.ParseResult;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 h2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002hiB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010J\u001a\u00020KH\u0016J\u0016\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0012J\u000e\u0010P\u001a\u00020K2\u0006\u0010Q\u001a\u00020RJ\b\u0010S\u001a\u00020TH\u0016J(\u0010U\u001a\u0002032\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u0002032\u0006\u0010Y\u001a\u0002032\u0006\u0010Z\u001a\u00020\u001fH\u0002J\u0018\u0010[\u001a\u00020K2\u0006\u0010Q\u001a\u00020R2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020K2\u0006\u0010_\u001a\u000203H\u0002J\b\u0010`\u001a\u00020KH\u0002J\b\u0010a\u001a\u0004\u0018\u00010RJ\u001e\u0010a\u001a\b\u0012\u0004\u0012\u00020R0b2\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010c\u001a\u00020\u0012J\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020R0b2\u0006\u0010c\u001a\u00020\u0012J\u0010\u0010d\u001a\u00020K2\u0006\u0010e\u001a\u00020\u000fH\u0016J\u0006\u0010f\u001a\u00020KJ\u0010\u0010g\u001a\u00020K2\u0006\u0010V\u001a\u00020WH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001e\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0016\u0010-\u001a\n /*\u0004\u0018\u00010.0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010!\"\u0004\b:\u0010#R\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002030<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010!\"\u0004\b@\u0010#R\u000e\u0010A\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010!\"\u0004\bD\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "Lai/platon/pulsar/common/config/Parameterized;", "Lai/platon/pulsar/crawl/common/JobInitialized;", "Ljava/lang/AutoCloseable;", "tasksMonitor", "Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;", "pageParser", "Lai/platon/pulsar/crawl/parse/PageParser;", "jitIndexer", "Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;Lai/platon/pulsar/crawl/parse/PageParser;Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;Lai/platon/pulsar/crawl/CoreMetrics;Lai/platon/pulsar/common/message/MiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bandwidth", "", "getCoreMetrics", "()Lai/platon/pulsar/crawl/CoreMetrics;", "enumCounters", "Lai/platon/pulsar/common/metrics/EnumCounterRegistry;", "fetchErrors", "Ljava/util/concurrent/atomic/AtomicInteger;", "id", "getId", "()I", "getImmutableConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "indexJIT", "", "getIndexJIT", "()Z", "setIndexJIT", "(Z)V", "getJitIndexer", "()Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;", "<set-?>", "Ljava/time/Instant;", "lastTaskFinishTime", "getLastTaskFinishTime", "()Ljava/time/Instant;", "lastTaskStartTime", "getLastTaskStartTime", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMessageWriter", "()Lai/platon/pulsar/common/message/MiscMessageWriter;", "name", "", "getName", "()Ljava/lang/String;", "getPageParser", "()Lai/platon/pulsar/crawl/parse/PageParser;", "parse", "getParse", "setParse", "reprUrls", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "skipTruncated", "getSkipTruncated", "setSkipTruncated", "startTime", "storeContent", "getStoreContent", "setStoreContent", "getTasksMonitor", "()Lai/platon/pulsar/crawl/fetch/batch/TaskMonitor;", "totalBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "totalPages", "close", "", "finish", "poolId", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "itemId", "finishUnchecked", "fetchTask", "Lai/platon/pulsar/crawl/fetch/batch/JobFetchTask;", "getParams", "Lai/platon/pulsar/common/config/Params;", "handleRedirectUrl", "page", "Lai/platon/pulsar/persist/WebPage;", "url", "newUrl", "temp", "handleResult", "crawlStatus", "Lai/platon/pulsar/persist/CrawlStatus;", "logFetchFailure", "message", "report", "schedule", "", "number", "setup", "jobConf", "updateCounters", "updateStatus", "Companion", "Status", "pulsar-skeleton"})
public final class TaskScheduler
implements Parameterized,
JobInitialized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskMonitor tasksMonitor;
    @NotNull
    private final PageParser pageParser;
    @NotNull
    private final JITIndexer jitIndexer;
    @NotNull
    private final CoreMetrics coreMetrics;
    @NotNull
    private final MiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger log;
    private final int id;
    @NotNull
    private final EnumCounterRegistry enumCounters;
    private int bandwidth;
    private boolean skipTruncated;
    private boolean storeContent;
    private boolean indexJIT;
    private boolean parse;
    @NotNull
    private final Instant startTime;
    @NotNull
    private Instant lastTaskStartTime;
    @NotNull
    private Instant lastTaskFinishTime;
    @NotNull
    private final AtomicLong totalBytes;
    @NotNull
    private final AtomicInteger totalPages;
    @NotNull
    private final AtomicInteger fetchErrors;
    @NotNull
    private final ConcurrentSkipListMap<Long, String> reprUrls;
    @NotNull
    private static final AtomicInteger instanceSequence;

    public TaskScheduler(@NotNull TaskMonitor tasksMonitor, @NotNull PageParser pageParser, @NotNull JITIndexer jitIndexer, @NotNull CoreMetrics coreMetrics, @NotNull MiscMessageWriter messageWriter, @NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)tasksMonitor, (String)"tasksMonitor");
        Intrinsics.checkNotNullParameter((Object)pageParser, (String)"pageParser");
        Intrinsics.checkNotNullParameter((Object)jitIndexer, (String)"jitIndexer");
        Intrinsics.checkNotNullParameter((Object)coreMetrics, (String)"coreMetrics");
        Intrinsics.checkNotNullParameter((Object)((Object)messageWriter), (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.tasksMonitor = tasksMonitor;
        this.pageParser = pageParser;
        this.jitIndexer = jitIndexer;
        this.coreMetrics = coreMetrics;
        this.messageWriter = messageWriter;
        this.immutableConfig = immutableConfig;
        this.log = LoggerFactory.getLogger(TaskScheduler.class);
        this.id = instanceSequence.incrementAndGet();
        this.enumCounters = AppMetrics.Companion.getReg().getEnumCounterRegistry();
        this.bandwidth = 0x100000 * this.immutableConfig.getInt("fetcher.net.bandwidth.m", 10000);
        this.skipTruncated = this.immutableConfig.getBoolean("parser.skip.truncated", true);
        this.storeContent = this.immutableConfig.getBoolean("fetch.store.content", true);
        Instant instant = Instant.now();
        Intrinsics.checkNotNull((Object)instant);
        this.lastTaskStartTime = this.startTime = instant;
        this.lastTaskFinishTime = this.startTime;
        this.totalBytes = new AtomicLong(0L);
        this.totalPages = new AtomicInteger(0);
        this.fetchErrors = new AtomicInteger(0);
        this.reprUrls = new ConcurrentSkipListMap();
    }

    @NotNull
    public final TaskMonitor getTasksMonitor() {
        return this.tasksMonitor;
    }

    @NotNull
    public final PageParser getPageParser() {
        return this.pageParser;
    }

    @NotNull
    public final JITIndexer getJitIndexer() {
        return this.jitIndexer;
    }

    @NotNull
    public final CoreMetrics getCoreMetrics() {
        return this.coreMetrics;
    }

    @NotNull
    public final MiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    @NotNull
    public final ImmutableConfig getImmutableConfig() {
        return this.immutableConfig;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean getSkipTruncated() {
        return this.skipTruncated;
    }

    public final void setSkipTruncated(boolean bl) {
        this.skipTruncated = bl;
    }

    public final boolean getStoreContent() {
        return this.storeContent;
    }

    public final void setStoreContent(boolean bl) {
        this.storeContent = bl;
    }

    public final boolean getIndexJIT() {
        return this.indexJIT;
    }

    public final void setIndexJIT(boolean bl) {
        this.indexJIT = bl;
    }

    public final boolean getParse() {
        return this.parse;
    }

    public final void setParse(boolean bl) {
        this.parse = bl;
    }

    @NotNull
    public final Instant getLastTaskStartTime() {
        return this.lastTaskStartTime;
    }

    @NotNull
    public final Instant getLastTaskFinishTime() {
        return this.lastTaskFinishTime;
    }

    @NotNull
    public final String getName() {
        return this.getClass().getSimpleName() + "-" + this.id;
    }

    @Override
    public void setup(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        this.indexJIT = jobConf.getBoolean("indexer.just.in.time", false);
        this.parse = this.indexJIT || jobConf.getBoolean("parser.parse", false);
        this.log.info(this.getParams().format());
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"id", this.id, "bandwidth", Strings.readableBytes((int)this.bandwidth), "skipTruncated", this.skipTruncated, "parse", this.parse, "storeContent", this.storeContent, "indexJIT", this.indexJIT};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026xJIT\", indexJIT\n        )");
        return params;
    }

    @Nullable
    public final JobFetchTask schedule() {
        JobFetchTask fetchTask = TaskMonitor.consume$default(this.tasksMonitor, null, 1, null);
        if (fetchTask == null) {
            this.tasksMonitor.maintain();
        } else {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            this.lastTaskStartTime = instant;
        }
        return fetchTask;
    }

    @NotNull
    public final List<JobFetchTask> schedule(int number) {
        return this.schedule(null, number);
    }

    @NotNull
    public final List<JobFetchTask> schedule(@Nullable PoolId poolId, int number) {
        int num = number;
        if (num <= 0) {
            this.log.warn("The number must be positive to schedule fetch items");
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        double fifteenMinutePageSizeRate = this.coreMetrics.getMeterContentBytes().getFifteenMinuteRate();
        if ((double)this.tasksMonitor.getNumPendingTasks().get() * fifteenMinutePageSizeRate * 8.0 > (double)(30 * this.bandwidth)) {
            this.log.warn("Bandwidth exhausted, slows down the scheduling");
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ArrayList<JobFetchTask> fetchTasks = new ArrayList<JobFetchTask>(num);
        while (true) {
            int n = num;
            num = n + -1;
            if (n <= 0) break;
            JobFetchTask fetchTask = this.tasksMonitor.consume(poolId);
            if (fetchTask != null) {
                fetchTasks.add(fetchTask);
                continue;
            }
            this.tasksMonitor.maintain();
        }
        Object object = fetchTasks;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now()");
            this.lastTaskStartTime = object;
        }
        return fetchTasks;
    }

    public final void finishUnchecked(@NotNull JobFetchTask fetchTask) {
        Intrinsics.checkNotNullParameter((Object)fetchTask, (String)"fetchTask");
        this.tasksMonitor.finish(fetchTask);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastTaskFinishTime = instant;
        EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.rFinishedTasks, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(@NotNull PoolId poolId, int itemId) {
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        JobFetchTask fetchTask = this.tasksMonitor.findPendingTask(poolId, itemId);
        if (fetchTask == null) {
            this.log.warn("Failed to finish fetch task <{}, {}>", (Object)poolId, (Object)itemId);
            return;
        }
        WebPage page = fetchTask.getPage();
        Object object = page.getProtocolStatus();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.protocolStatus");
        ProtocolStatus protocolStatus = object;
        try {
            this.tasksMonitor.finish(fetchTask);
            this.handleResult(fetchTask, CrawlStatus.Companion.getSTATUS_FETCHED());
            if (protocolStatus.isRetry(RetryScope.JOB)) {
                this.tasksMonitor.produce(fetchTask);
            }
        }
        catch (Throwable e) {
            this.log.error("Unexpected error - {} | {}", (Object)e, (Object)fetchTask.getUrlString());
            this.tasksMonitor.finishAsap(fetchTask);
            this.fetchErrors.incrementAndGet();
            EnumCounterRegistry.inc$default(this.enumCounters, CommonCounter.errors, 0, 2, null);
        }
        finally {
            object = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now()");
            this.lastTaskFinishTime = object;
        }
    }

    public final void updateCounters() {
        int readyFetchTasks = this.tasksMonitor.getNumReadyTasks().get();
        int pendingFetchTasks = this.tasksMonitor.getNumPendingTasks().get();
        this.enumCounters.setValue(Companion.Counter.rReadyTasks, readyFetchTasks);
        this.enumCounters.setValue(Companion.Counter.rPendingTasks, pendingFetchTasks);
        if (this.indexJIT) {
            this.enumCounters.setValue(Companion.Counter.rIndexed, this.jitIndexer.getIndexedPageCount());
            this.enumCounters.setValue(Companion.Counter.rNotIndexed, this.jitIndexer.getIgnoredPageCount());
        }
    }

    @Override
    public void close() {
        this.log.info("Closing TaskScheduler #" + this.id);
        String border = StringUtils.repeat((char)'.', (int)40);
        this.log.info(border);
        this.log.info("[Final Report - " + DateTimes.now() + "]");
        this.report();
        this.log.info("[End Report]");
        this.log.info(border);
    }

    private final void handleResult(JobFetchTask fetchTask, CrawlStatus crawlStatus) {
        WebPage page = fetchTask.getPage();
        this.messageWriter.debugFetchHistory(page);
        if (this.parse && crawlStatus.isFetched()) {
            ParseResult parseResult = this.pageParser.parse(page);
            if (!parseResult.isSuccess()) {
                EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.rParseFailed, 0, 2, null);
                page.getPageCounters().increase((Enum)PageCounters.Self.parseErr);
            }
            if (!page.hasMark(Mark.PARSE)) {
                EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.rNoParse, 0, 2, null);
            }
            if (parseResult.getMinorCode() != 0) {
                this.messageWriter.reportFlawParsedPage(page, false);
            }
            if (this.jitIndexer.isEnabled() && parseResult.isSuccess()) {
                this.jitIndexer.produce(fetchTask);
            }
        }
        if (page.getContent() != null && !this.storeContent) {
            if (!page.isSeed()) {
                page.setContent(new byte[0]);
            } else if (page.getFetchCount() > 2) {
                page.setContent(new byte[0]);
            }
        }
        this.updateStatus(page);
    }

    private final String handleRedirectUrl(WebPage page, String url, String newUrl, boolean temp) {
        long threadId = Thread.currentThread().getId();
        Object object = this.reprUrls.getOrDefault(threadId, url);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reprUrls.getOrDefault(threadId, url)");
        String reprUrl = object;
        reprUrl = URLUtil.chooseRepr(reprUrl, newUrl, temp);
        if (reprUrl.length() < AppConstants.SHORTEST_VALID_URL_LENGTH) {
            this.log.warn("reprUrl is too short");
            return reprUrl;
        }
        page.setReprUrl(reprUrl);
        object = this.reprUrls;
        Long l = threadId;
        boolean bl = false;
        object.put(l, reprUrl);
        return reprUrl;
    }

    private final void updateStatus(WebPage page) {
        EnumCounterRegistry.inc$default(this.enumCounters, CommonCounter.rPersist, 0, 2, null);
        this.enumCounters.inc((Enum)CommonCounter.rLinks, page.getImpreciseLinkCount());
        this.totalPages.incrementAndGet();
        this.totalBytes.addAndGet(page.getContentLength());
        if (page.isSeed()) {
            EnumCounterRegistry.inc$default(this.enumCounters, Companion.Counter.rSeeds, 0, 2, null);
        }
        EnumCounterUtils.INSTANCE.increaseRDepth(page.getDistance(), this.enumCounters);
        this.enumCounters.inc((Enum)Companion.Counter.rMbytes, (int)ByteUnitConverter.INSTANCE.convert(page.getContentLength(), "M"));
    }

    private final void logFetchFailure(String message) {
        CharSequence charSequence = message;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.log.warn("Fetch failed, " + message);
        }
        this.fetchErrors.incrementAndGet();
        EnumCounterRegistry.inc$default(this.enumCounters, CommonCounter.errors, 0, 2, null);
    }

    private final void report() {
        Collection collection = this.pageParser.getUnparsableTypes();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Object report2 = "";
            Iterable $this$sortedBy$iv = this.pageParser.getUnparsableTypes();
            boolean $i$f$sortedBy = false;
            boolean bl2 = false;
            String hosts2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CharSequence it = (CharSequence)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((Object)it).toString());
                    it = (CharSequence)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = ((Object)it).toString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            }), (CharSequence)"\n", null, null, (int)0, null, (Function1)report.hosts.2.INSTANCE, (int)30, null);
            report2 = (String)report2 + hosts2;
            report2 = (String)report2 + "\n";
            this.log.info("Un-parsable types : \n" + (String)report2);
        }
    }

    static {
        AppMetricRegistry.register$default(AppMetrics.Companion.getReg(), Companion.Counter.class, null, false, 6, null);
        instanceSequence = new AtomicInteger(0);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012\u00a8\u0006 "}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler$Status;", "", "pagesThroughputRate", "", "bytesThoRate", "readyFetchItems", "", "pendingFetchItems", "(DDII)V", "getBytesThoRate", "()D", "setBytesThoRate", "(D)V", "getPagesThroughputRate", "setPagesThroughputRate", "getPendingFetchItems", "()I", "setPendingFetchItems", "(I)V", "getReadyFetchItems", "setReadyFetchItems", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "pulsar-skeleton"})
    public static final class Status {
        private double pagesThroughputRate;
        private double bytesThoRate;
        private int readyFetchItems;
        private int pendingFetchItems;

        public Status(double pagesThroughputRate, double bytesThoRate, int readyFetchItems, int pendingFetchItems) {
            this.pagesThroughputRate = pagesThroughputRate;
            this.bytesThoRate = bytesThoRate;
            this.readyFetchItems = readyFetchItems;
            this.pendingFetchItems = pendingFetchItems;
        }

        public final double getPagesThroughputRate() {
            return this.pagesThroughputRate;
        }

        public final void setPagesThroughputRate(double d) {
            this.pagesThroughputRate = d;
        }

        public final double getBytesThoRate() {
            return this.bytesThoRate;
        }

        public final void setBytesThoRate(double d) {
            this.bytesThoRate = d;
        }

        public final int getReadyFetchItems() {
            return this.readyFetchItems;
        }

        public final void setReadyFetchItems(int n) {
            this.readyFetchItems = n;
        }

        public final int getPendingFetchItems() {
            return this.pendingFetchItems;
        }

        public final void setPendingFetchItems(int n) {
            this.pendingFetchItems = n;
        }

        public final double component1() {
            return this.pagesThroughputRate;
        }

        public final double component2() {
            return this.bytesThoRate;
        }

        public final int component3() {
            return this.readyFetchItems;
        }

        public final int component4() {
            return this.pendingFetchItems;
        }

        @NotNull
        public final Status copy(double pagesThroughputRate, double bytesThoRate, int readyFetchItems, int pendingFetchItems) {
            return new Status(pagesThroughputRate, bytesThoRate, readyFetchItems, pendingFetchItems);
        }

        public static /* synthetic */ Status copy$default(Status status, double d, double d2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                d = status.pagesThroughputRate;
            }
            if ((n3 & 2) != 0) {
                d2 = status.bytesThoRate;
            }
            if ((n3 & 4) != 0) {
                n = status.readyFetchItems;
            }
            if ((n3 & 8) != 0) {
                n2 = status.pendingFetchItems;
            }
            return status.copy(d, d2, n, n2);
        }

        @NotNull
        public String toString() {
            return "Status(pagesThroughputRate=" + this.pagesThroughputRate + ", bytesThoRate=" + this.bytesThoRate + ", readyFetchItems=" + this.readyFetchItems + ", pendingFetchItems=" + this.pendingFetchItems + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.pagesThroughputRate);
            result = result * 31 + Double.hashCode(this.bytesThoRate);
            result = result * 31 + Integer.hashCode(this.readyFetchItems);
            result = result * 31 + Integer.hashCode(this.pendingFetchItems);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Status)) {
                return false;
            }
            Status status = (Status)other;
            if (!Intrinsics.areEqual((Object)this.pagesThroughputRate, (Object)status.pagesThroughputRate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bytesThoRate, (Object)status.bytesThoRate)) {
                return false;
            }
            if (this.readyFetchItems != status.readyFetchItems) {
                return false;
            }
            return this.pendingFetchItems == status.pendingFetchItems;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler$Companion;", "", "()V", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "Counter", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler$Companion$Counter;", "", "(Ljava/lang/String;I)V", "rMbytes", "unknowHosts", "rReadyTasks", "rPendingTasks", "rFinishedTasks", "rPgps", "rMbps", "rRedirect", "rSeeds", "rParseFailed", "rNoParse", "rIndexed", "rNotIndexed", "pulsar-skeleton"})
        public static final class Counter
        extends Enum<Counter> {
            public static final /* enum */ Counter rMbytes = new Counter();
            public static final /* enum */ Counter unknowHosts = new Counter();
            public static final /* enum */ Counter rReadyTasks = new Counter();
            public static final /* enum */ Counter rPendingTasks = new Counter();
            public static final /* enum */ Counter rFinishedTasks = new Counter();
            public static final /* enum */ Counter rPgps = new Counter();
            public static final /* enum */ Counter rMbps = new Counter();
            public static final /* enum */ Counter rRedirect = new Counter();
            public static final /* enum */ Counter rSeeds = new Counter();
            public static final /* enum */ Counter rParseFailed = new Counter();
            public static final /* enum */ Counter rNoParse = new Counter();
            public static final /* enum */ Counter rIndexed = new Counter();
            public static final /* enum */ Counter rNotIndexed = new Counter();
            private static final /* synthetic */ Counter[] $VALUES;

            public static Counter[] values() {
                return (Counter[])$VALUES.clone();
            }

            public static Counter valueOf(String value) {
                return Enum.valueOf(Counter.class, value);
            }

            static {
                $VALUES = counterArray = new Counter[]{Counter.rMbytes, Counter.unknowHosts, Counter.rReadyTasks, Counter.rPendingTasks, Counter.rFinishedTasks, Counter.rPgps, Counter.rMbps, Counter.rRedirect, Counter.rSeeds, Counter.rParseFailed, Counter.rNoParse, Counter.rIndexed, Counter.rNotIndexed};
            }
        }
    }
}

