/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.fetch.batch.TaskScheduler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u000bH\u0086\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003J\b\u0010!\u001a\u00020\u0013H\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\r\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004 \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskSchedulers;", "Ljava/lang/AutoCloseable;", "taskSchedulers", "", "Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "fetchSchedulerIds", "Ljava/util/LinkedList;", "", "kotlin.jvm.PlatformType", "fetchSchedulers", "Ljava/util/TreeMap;", "first", "getFirst", "()Lai/platon/pulsar/crawl/fetch/batch/TaskScheduler;", "name", "", "getName", "()Ljava/lang/String;", "__toString", "clear", "", "close", "get", "id", "peek", "put", "taskScheduler", "remove", "schedulerIds", "toString", "Companion", "pulsar-skeleton"})
public final class TaskSchedulers
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final TreeMap<Integer, TaskScheduler> fetchSchedulers;
    private final LinkedList<Integer> fetchSchedulerIds;
    private static final Logger LOG = LoggerFactory.getLogger(TaskSchedulers.class);

    public TaskSchedulers(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.name = this.getClass().getSimpleName() + "-" + DateTimes.INSTANCE.now("d.Hms");
        this.fetchSchedulers = Maps.newTreeMap();
        this.fetchSchedulerIds = Lists.newLinkedList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final synchronized TaskScheduler getFirst() {
        TaskScheduler taskScheduler = this.fetchSchedulers.values().iterator().next();
        Intrinsics.checkNotNullExpressionValue((Object)taskScheduler, (String)"fetchSchedulers.values.iterator().next()");
        return taskScheduler;
    }

    public TaskSchedulers(@NotNull List<TaskScheduler> taskSchedulers, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(taskSchedulers, (String)"taskSchedulers");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf);
        Iterable $this$forEach$iv = taskSchedulers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskScheduler t = (TaskScheduler)element$iv;
            boolean bl = false;
            this.put(t.getId(), t);
        }
    }

    public final synchronized void put(int id, @NotNull TaskScheduler taskScheduler) {
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Map<Integer, TaskScheduler> map2 = this.fetchSchedulers;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"fetchSchedulers");
        map2 = map2;
        Integer n = id;
        boolean bl = false;
        map2.put(n, taskScheduler);
        this.fetchSchedulerIds.add(id);
        LOG.info("Add task scheduler #" + id);
        LOG.info("status: " + this.__toString());
    }

    @NotNull
    public final synchronized List<Integer> schedulerIds() {
        return new ArrayList(this.fetchSchedulerIds);
    }

    @Nullable
    public final synchronized TaskScheduler get(int id) {
        return this.fetchSchedulers.get(id);
    }

    @Nullable
    public final synchronized TaskScheduler peek() {
        Integer n = this.fetchSchedulerIds.peek();
        if (n == null) {
            return null;
        }
        int id = n;
        return this.fetchSchedulers.get(id);
    }

    public final synchronized void remove(int id) {
        this.fetchSchedulerIds.remove((Object)id);
        this.fetchSchedulers.remove(id);
        LOG.info("Remove FetchScheduler #" + id + " from pool #" + this.name);
        LOG.info("status: " + this.__toString());
    }

    public final synchronized void remove(@Nullable TaskScheduler taskScheduler) {
        if (taskScheduler == null) {
            return;
        }
        this.remove(taskScheduler.getId());
    }

    public final synchronized void clear() {
        this.fetchSchedulerIds.clear();
        this.fetchSchedulers.clear();
    }

    @NotNull
    public synchronized String toString() {
        return this.__toString();
    }

    private final String __toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Job IDs : ").append(StringUtils.join((Iterable)this.fetchSchedulerIds, (String)", ")).append("\tQueue Size : ").append(this.fetchSchedulers.size());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public void close() throws Exception {
        LOG.info("[Destruction] Closing TaskSchedulers");
        this.fetchSchedulerIds.clear();
        this.fetchSchedulers.clear();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/TaskSchedulers$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

