/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch.data;

import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "", "priority", "", "url", "Ljava/net/URL;", "(ILjava/net/URL;)V", "protocol", "", "host", "(ILjava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPriority", "()I", "getProtocol", "compareTo", "other", "equals", "", "", "hashCode", "toString", "pulsar-skeleton"})
public final class PoolId
implements Comparable<PoolId> {
    private final int priority;
    @NotNull
    private final String protocol;
    @NotNull
    private final String host;

    public PoolId(int priority, @NotNull String protocol, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.priority = priority;
        this.protocol = protocol;
        this.host = host;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public PoolId(int priority, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.protocol");
        String string2 = string;
        string = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.host");
        this(priority, string2, string);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PoolId && this.priority == ((PoolId)other).priority && Intrinsics.areEqual((Object)this.protocol, (Object)((PoolId)other).protocol) && Intrinsics.areEqual((Object)this.host, (Object)((PoolId)other).host);
    }

    @Override
    public int compareTo(@NotNull PoolId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int c = this.priority - other.priority;
        if (c == 0 && (c = this.protocol.compareTo(other.protocol)) == 0) {
            c = this.host.compareTo(other.host);
        }
        return c;
    }

    public int hashCode() {
        return this.priority * 31 ^ 2 + this.protocol.hashCode() * 31 + this.host.hashCode();
    }

    @NotNull
    public String toString() {
        return "<" + this.priority + ", " + this.protocol + "://" + this.host + ">";
    }
}

