/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.batch.data;

import ai.platon.pulsar.crawl.fetch.batch.TaskPool;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolId;
import ai.platon.pulsar.crawl.fetch.batch.data.PoolQueue;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\t\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\fJ\b\u0010$\u001a\u00020\u0014H\u0016J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0096\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0002H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\u00022\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/data/PoolQueue;", "Ljava/util/AbstractQueue;", "Lai/platon/pulsar/crawl/fetch/batch/TaskPool;", "()V", "activeQueues", "Ljava/util/HashMap;", "Lai/platon/pulsar/crawl/fetch/batch/data/PoolId;", "inactiveQueues", "priorityActiveQueues", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "size", "", "getSize", "()I", "timeReport", "", "getTimeReport", "()Ljava/lang/String;", "add", "", "element", "clear", "", "disable", "pool", "dump", "limit", "drop", "enable", "queue", "find", "id", "findExtend", "hasPriorPendingTasks", "priority", "isEmpty", "iterator", "", "offer", "taskPool", "peek", "poll", "remove", "search", "searchInactive", "Companion", "pulsar-skeleton"})
public final class PoolQueue
extends AbstractQueue<TaskPool> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PriorityQueue<TaskPool> priorityActiveQueues = new PriorityQueue(Comparator.reverseOrder());
    @NotNull
    private final HashMap<PoolId, TaskPool> activeQueues = new HashMap();
    @NotNull
    private final HashMap<PoolId, TaskPool> inactiveQueues = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(PoolQueue.class);

    public synchronized int getSize() {
        return this.priorityActiveQueues.size();
    }

    @NotNull
    public final synchronized String getTimeReport() {
        Collection<TaskPool> collection = this.activeQueues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeQueues.values");
        Iterable $this$sortedByDescending$iv = collection;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskPool it = (TaskPool)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getAverageTime());
                it = (TaskPool)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getAverageTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        }), (int)50), (CharSequence)"\n", null, null, (int)0, null, (Function1)timeReport.2.INSTANCE, (int)30, null);
    }

    @Override
    public synchronized boolean add(@NotNull TaskPool element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.priorityActiveQueues.add(element);
        Map map2 = this.activeQueues;
        PoolId poolId = element.getId();
        boolean bl = false;
        map2.put(poolId, element);
        if (this.priorityActiveQueues.size() != this.activeQueues.size()) {
            LOG.error("(Add)Inconsistent status : size of activeQueues (" + this.priorityActiveQueues.size() + ") and priorityActiveQueues (" + this.activeQueues.size() + ") do not match");
        }
        return true;
    }

    @Override
    public synchronized boolean offer(@NotNull TaskPool taskPool) {
        Intrinsics.checkNotNullParameter((Object)taskPool, (String)"taskPool");
        return this.add(taskPool);
    }

    @Override
    @Nullable
    public synchronized TaskPool poll() {
        TaskPool queue = this.priorityActiveQueues.poll();
        if (queue != null) {
            this.activeQueues.remove(queue.getId());
        }
        if (this.priorityActiveQueues.size() != this.activeQueues.size()) {
            LOG.error("(Poll)Inconsistent status : size of activeQueues (" + this.priorityActiveQueues.size() + ") and priorityActiveQueues (" + this.activeQueues.size() + ") do not match");
        }
        return queue;
    }

    @Override
    @Nullable
    public synchronized TaskPool peek() {
        return this.priorityActiveQueues.peek();
    }

    public synchronized boolean remove(@NotNull TaskPool element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.priorityActiveQueues.remove(element);
        this.activeQueues.remove(element.getId());
        this.inactiveQueues.remove(element.getId());
        return true;
    }

    @Override
    @NotNull
    public Iterator<TaskPool> iterator() {
        Iterator<TaskPool> iterator = this.priorityActiveQueues.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"priorityActiveQueues.iterator()");
        return iterator;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.priorityActiveQueues.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.priorityActiveQueues.clear();
        this.activeQueues.clear();
        this.inactiveQueues.clear();
    }

    public final synchronized void enable(@NotNull TaskPool queue) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        queue.enable();
        this.priorityActiveQueues.add(queue);
        Map map2 = this.activeQueues;
        PoolId poolId = queue.getId();
        boolean bl = false;
        map2.put(poolId, queue);
        this.inactiveQueues.remove(queue.getId());
    }

    public final synchronized void disable(@NotNull TaskPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.priorityActiveQueues.remove(pool);
        this.activeQueues.remove(pool.getId());
        pool.disable();
        Map map2 = this.inactiveQueues;
        PoolId poolId = pool.getId();
        boolean bl = false;
        map2.put(poolId, pool);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized boolean hasPriorPendingTasks(int priority) {
        boolean bl;
        boolean hasPrior = false;
        for (TaskPool queue : this.priorityActiveQueues) {
            if (queue.getPriority() < priority) break;
            hasPrior = queue.hasPendingTasks();
        }
        if (hasPrior) return true;
        Collection<TaskPool> collection = this.inactiveQueues.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"inactiveQueues.values");
        Iterable $this$any$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            TaskPool it = (TaskPool)element$iv;
            boolean bl2 = false;
            if (it.getPriority() >= priority && it.hasPendingTasks()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Nullable
    public final synchronized TaskPool find(@NotNull PoolId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.search(id, false);
    }

    @Nullable
    public final synchronized TaskPool findExtend(@NotNull PoolId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.search(id, true);
    }

    @Nullable
    public final synchronized TaskPool search(@Nullable PoolId id, boolean searchInactive) {
        TaskPool queue = null;
        if (id != null && (queue = this.activeQueues.get(id)) == null && searchInactive) {
            queue = this.inactiveQueues.get(id);
        }
        return queue;
    }

    public final synchronized void dump(int limit, boolean drop) {
        TaskPool it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        LOG.info("Fetch queue status | active: {}, inactive: {}", (Object)this.activeQueues.size(), (Object)this.inactiveQueues.size());
        Collection<TaskPool> collection = this.activeQueues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeQueues.values");
        Iterable $this$filter$iv = CollectionsKt.take((Iterable)collection, (int)limit);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (TaskPool)element$iv$iv;
            boolean bl = false;
            if (!it.hasTasks()) continue;
            collection2.add(element$iv$iv);
        }
        Iterable<TaskPool> $this$forEach$iv = (List)collection2;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            TaskPool it2 = (TaskPool)t;
            boolean bl = false;
            it2.dump(drop);
        }
        $this$forEach$iv = this.inactiveQueues.values();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"inactiveQueues.values");
        $this$filter$iv = CollectionsKt.take((Iterable)$this$forEach$iv, (int)limit);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection3 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (TaskPool)element$iv$iv;
            boolean bl2 = false;
            if (!it.hasPendingTasks()) continue;
            collection3.add(element$iv$iv);
        }
        $this$forEach$iv = (List)collection3;
        $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            TaskPool it3 = (TaskPool)e;
            boolean bl3 = false;
            it3.dump(drop);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/fetch/batch/data/PoolQueue$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

