/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.driver;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.browser.common.ScriptConfuser;
import ai.platon.pulsar.browser.common.ScriptLoader;
import ai.platon.pulsar.common.event.AbstractEventEmitter;
import ai.platon.pulsar.crawl.fetch.driver.Browser;
import ai.platon.pulsar.crawl.fetch.driver.BrowserEvents;
import ai.platon.pulsar.crawl.fetch.driver.NavigateEntry;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.BrowserId;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020>H\u0016J\b\u0010@\u001a\u00020>H\u0002J\n\u0010A\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020\u0010H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR8\u0010\u000e\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00120\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0019\u0010%\u001a\n \u0011*\u0004\u0018\u00010&0&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010+R\u0014\u0010,\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010+R\"\u0010-\u001a\n \u0011*\u0004\u0018\u00010.0.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0014R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0016\u00109\u001a\u0004\u0018\u00010:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006D"}, d2={"Lai/platon/pulsar/crawl/fetch/driver/AbstractBrowser;", "Lai/platon/pulsar/crawl/fetch/driver/Browser;", "Lai/platon/pulsar/common/event/AbstractEventEmitter;", "Lai/platon/pulsar/crawl/fetch/driver/BrowserEvents;", "id", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "browserSettings", "Lai/platon/pulsar/browser/common/BrowserSettings;", "(Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;Lai/platon/pulsar/browser/common/BrowserSettings;)V", "_drivers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "get_drivers", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "_navigateHistory", "", "Lai/platon/pulsar/crawl/fetch/driver/NavigateEntry;", "kotlin.jvm.PlatformType", "", "get_navigateHistory", "()Ljava/util/List;", "getBrowserSettings", "()Lai/platon/pulsar/browser/common/BrowserSettings;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "confuser", "Lai/platon/pulsar/browser/common/ScriptConfuser;", "getConfuser", "()Lai/platon/pulsar/browser/common/ScriptConfuser;", "drivers", "Ljava/util/Queue;", "getDrivers", "()Ljava/util/Queue;", "getId", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "idleTimeout", "Ljava/time/Duration;", "getIdleTimeout", "()Ljava/time/Duration;", "isGUI", "", "()Z", "isIdle", "lastActiveTime", "Ljava/time/Instant;", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "navigateHistory", "getNavigateHistory", "scriptLoader", "Lai/platon/pulsar/browser/common/ScriptLoader;", "getScriptLoader", "()Lai/platon/pulsar/browser/common/ScriptLoader;", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "attach", "", "close", "detach", "getRandomUserAgentOrNull", "onWillNavigate", "entry", "pulsar-skeleton"})
public abstract class AbstractBrowser
extends AbstractEventEmitter<BrowserEvents>
implements Browser {
    @NotNull
    private final BrowserId id;
    @NotNull
    private final BrowserSettings browserSettings;
    private final List<NavigateEntry> _navigateHistory;
    @NotNull
    private final ConcurrentLinkedQueue<WebDriver> _drivers;
    @NotNull
    private final AtomicBoolean closed;
    private Instant lastActiveTime;
    @Nullable
    private final String userAgent;
    @NotNull
    private final ScriptConfuser confuser;
    @NotNull
    private final ScriptLoader scriptLoader;
    private final Duration idleTimeout;

    public AbstractBrowser(@NotNull BrowserId id, @NotNull BrowserSettings browserSettings) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)browserSettings, (String)"browserSettings");
        this.id = id;
        this.browserSettings = browserSettings;
        boolean bl = false;
        this._navigateHistory = Collections.synchronizedList(new ArrayList());
        this._drivers = new ConcurrentLinkedQueue();
        this.closed = new AtomicBoolean();
        this.lastActiveTime = Instant.now();
        this.userAgent = this.getRandomUserAgentOrNull();
        this.confuser = new ScriptConfuser();
        this.scriptLoader = new ScriptLoader(this.confuser, this.browserSettings.getConf());
        this.idleTimeout = Duration.ofMinutes(10L);
        this.attach();
    }

    @Override
    @NotNull
    public BrowserId getId() {
        return this.id;
    }

    @NotNull
    public final BrowserSettings getBrowserSettings() {
        return this.browserSettings;
    }

    protected final List<NavigateEntry> get_navigateHistory() {
        return this._navigateHistory;
    }

    @NotNull
    protected final ConcurrentLinkedQueue<WebDriver> get_drivers() {
        return this._drivers;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    protected final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    protected final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    @Override
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @NotNull
    public List<NavigateEntry> getNavigateHistory() {
        List<NavigateEntry> list = this._navigateHistory;
        Intrinsics.checkNotNullExpressionValue(list, (String)"_navigateHistory");
        return list;
    }

    @Override
    @NotNull
    public Queue<WebDriver> getDrivers() {
        return this._drivers;
    }

    @Override
    public boolean isIdle() {
        return Duration.between(this.lastActiveTime, Instant.now()).compareTo(this.idleTimeout) > 0;
    }

    @NotNull
    public final ScriptConfuser getConfuser() {
        return this.confuser;
    }

    @NotNull
    public final ScriptLoader getScriptLoader() {
        return this.scriptLoader;
    }

    public final boolean isGUI() {
        return this.browserSettings.isGUI();
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void close() {
        this.detach();
        this._drivers.clear();
    }

    @Override
    public void onWillNavigate(@NotNull NavigateEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this._navigateHistory.add(entry);
    }

    private final String getRandomUserAgentOrNull() {
        return this.browserSettings.isUserAgentOverridingEnabled() ? this.browserSettings.getUserAgent().getRandomUserAgent() : null;
    }

    private final void attach() {
        this.on((Object)BrowserEvents.willNavigate, (Function1)new Function1<NavigateEntry, Unit>(this){
            final /* synthetic */ AbstractBrowser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull NavigateEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                this.this$0.onWillNavigate(entry);
            }
        });
    }

    private final void detach() {
        this.off((Object)BrowserEvents.willNavigate);
    }
}

