/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.privacy;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0019\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\r\u00a8\u0006'"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "", "contextDir", "Ljava/nio/file/Path;", "browserType", "Lai/platon/pulsar/common/browser/BrowserType;", "(Ljava/nio/file/Path;Lai/platon/pulsar/common/browser/BrowserType;)V", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "(Ljava/nio/file/Path;Lai/platon/pulsar/common/browser/Fingerprint;)V", "getBrowserType", "()Lai/platon/pulsar/common/browser/BrowserType;", "getContextDir", "()Ljava/nio/file/Path;", "display", "", "getDisplay", "()Ljava/lang/String;", "getFingerprint", "()Lai/platon/pulsar/common/browser/Fingerprint;", "ident", "getIdent", "proxyServer", "getProxyServer", "userDataDir", "kotlin.jvm.PlatformType", "getUserDataDir", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "Companion", "pulsar-skeleton"})
public final class BrowserId
implements Comparable<BrowserId> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path contextDir;
    @NotNull
    private final Fingerprint fingerprint;
    @NotNull
    private static final BrowserId DEFAULT;

    public BrowserId(@NotNull Path contextDir, @NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.contextDir = contextDir;
        this.fingerprint = fingerprint;
    }

    @NotNull
    public final Path getContextDir() {
        return this.contextDir;
    }

    @NotNull
    public final Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    @NotNull
    public final BrowserType getBrowserType() {
        return this.fingerprint.getBrowserType();
    }

    @Nullable
    public final String getProxyServer() {
        return this.fingerprint.getProxyServer();
    }

    public final Path getUserDataDir() {
        String string = this.getBrowserType().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return this.contextDir.resolve(string3);
    }

    @NotNull
    public final String getIdent() {
        return "" + CollectionsKt.last((Iterable)this.contextDir) + this.getBrowserType().ordinal();
    }

    @NotNull
    public final String getDisplay() {
        return StringsKt.substringAfter$default((String)this.getIdent(), (String)PrivacyContext.Companion.getIDENT_PREFIX(), null, (int)2, null);
    }

    public BrowserId(@NotNull Path contextDir, @NotNull BrowserType browserType) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)browserType, (String)"browserType");
        this(contextDir, new Fingerprint(browserType, null, null, null, null, 30, null));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BrowserId && Intrinsics.areEqual((Object)((BrowserId)other).contextDir, (Object)this.contextDir) && Intrinsics.areEqual((Object)((BrowserId)other).fingerprint.toString(), (Object)this.fingerprint.toString());
    }

    public int hashCode() {
        return 31 * ((Object)this.contextDir).hashCode() + this.fingerprint.toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull BrowserId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int r = this.contextDir.compareTo(other.contextDir);
        if (r != 0) {
            return r;
        }
        return this.fingerprint.toString().compareTo(other.fingerprint.toString());
    }

    @NotNull
    public String toString() {
        return "{" + this.fingerprint + " | " + this.contextDir + "}";
    }

    @NotNull
    public final Path component1() {
        return this.contextDir;
    }

    @NotNull
    public final Fingerprint component2() {
        return this.fingerprint;
    }

    @NotNull
    public final BrowserId copy(@NotNull Path contextDir, @NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        return new BrowserId(contextDir, fingerprint);
    }

    public static /* synthetic */ BrowserId copy$default(BrowserId browserId, Path path, Fingerprint fingerprint, int n, Object object) {
        if ((n & 1) != 0) {
            path = browserId.contextDir;
        }
        if ((n & 2) != 0) {
            fingerprint = browserId.fingerprint;
        }
        return browserId.copy(path, fingerprint);
    }

    static {
        Path path = AppPaths.INSTANCE.getBROWSER_TMP_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"AppPaths.BROWSER_TMP_DIR");
        DEFAULT = new BrowserId(path, new Fingerprint(BrowserType.PULSAR_CHROME, null, null, null, null, 30, null));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/BrowserId$Companion;", "", "()V", "DEFAULT", "Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "getDEFAULT", "()Lai/platon/pulsar/crawl/fetch/privacy/BrowserId;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BrowserId getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

