/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.privacy;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyRetiredException;
import ai.platon.pulsar.crawl.fetch.FetchResult;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContextId;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContextMetrics;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import com.codahale.metrics.Meter;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\b&\u0018\u0000 h2\u00020\u0001:\u0001hB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0004J\u0010\u0010W\u001a\u00020T2\u0006\u0010X\u001a\u00020YH\u0004JC\u0010Z\u001a\u00020V2\u0006\u0010X\u001a\u00020Y2(\u0010[\u001a$\b\u0001\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020]\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0^\u0012\u0006\u0012\u0004\u0018\u00010_0\\H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010`J\u0006\u0010a\u001a\u00020-J\u0006\u0010b\u001a\u00020TJ\u0006\u0010c\u001a\u00020TJ\u0006\u0010d\u001a\u00020TJ\u000e\u0010d\u001a\u00020T2\u0006\u0010e\u001a\u00020-J\b\u0010f\u001a\u00020TH\u0016JC\u0010g\u001a\u00020V2\u0006\u0010X\u001a\u00020Y2(\u0010[\u001a$\b\u0001\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020]\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0^\u0012\u0006\u0012\u0004\u0018\u00010_0\\H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010`R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0011\u0010!\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0011\u0010#\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\"\u0010$\u001a\n \u0013*\u0004\u0018\u00010%0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0016\u0010*\u001a\n \u0013*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00103R\u0011\u00106\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u0011\u00108\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00103R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010/R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010CR\u0011\u0010F\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010CR\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010/R\u0011\u0010L\u001a\u00020M8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u000e\u0010P\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010Q\u001a\n \u0013*\u0004\u0018\u00010%0%\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006i"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContext;", "Ljava/lang/AutoCloseable;", "id", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "display", "", "getDisplay", "()Ljava/lang/String;", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "historyUrl", "", "getHistoryUrl", "()Ljava/util/Set;", "getId", "()Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "idleTimeout", "getIdleTimeout", "isActive", "", "()Z", "isGood", "isIdle", "isLeaked", "lastActiveTime", "Ljava/time/Instant;", "getLastActiveTime", "()Ljava/time/Instant;", "setLastActiveTime", "(Ljava/time/Instant;)V", "logger", "Lorg/slf4j/Logger;", "maximumWarnings", "", "getMaximumWarnings", "()I", "meterFinishes", "Lcom/codahale/metrics/Meter;", "getMeterFinishes", "()Lcom/codahale/metrics/Meter;", "meterSmallPages", "getMeterSmallPages", "meterSuccesses", "getMeterSuccesses", "meterTasks", "getMeterTasks", "minimumThroughput", "", "getMinimumThroughput", "()F", "minorWarningFactor", "getMinorWarningFactor", "numRunningTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumRunningTasks", "()Ljava/util/concurrent/atomic/AtomicInteger;", "privacyLeakMinorWarnings", "getPrivacyLeakMinorWarnings", "privacyLeakWarnings", "getPrivacyLeakWarnings", "registry", "Lai/platon/pulsar/common/metrics/AppMetricRegistry;", "sequence", "getSequence", "smallPageRate", "", "getSmallPageRate", "()D", "sms", "startTime", "getStartTime", "afterRun", "", "result", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "beforeRun", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "doRun", "browseFun", "Lkotlin/Function3;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markLeaked", "markMinorWarning", "markSuccess", "markWarning", "n", "report", "run", "Companion", "pulsar-skeleton"})
public abstract class PrivacyContext
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivacyContextId id;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final int sequence;
    private final float minimumThroughput;
    private final int maximumWarnings;
    private final int minorWarningFactor;
    @NotNull
    private final AtomicInteger privacyLeakWarnings;
    @NotNull
    private final AtomicInteger privacyLeakMinorWarnings;
    @NotNull
    private final AppMetricRegistry registry;
    @NotNull
    private final String sms;
    @NotNull
    private final Meter meterTasks;
    @NotNull
    private final Meter meterSuccesses;
    @NotNull
    private final Meter meterFinishes;
    @NotNull
    private final Meter meterSmallPages;
    private final Instant startTime;
    private Instant lastActiveTime;
    private final Duration idleTimeout;
    @NotNull
    private final AtomicInteger numRunningTasks;
    @NotNull
    private final Set<String> historyUrl;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();
    @NotNull
    private static final String IDENT_PREFIX = "cx.";
    private static final Path DEFAULT_DIR = AppPaths.INSTANCE.getCONTEXT_TMP_DIR().resolve("default");
    private static final Path PROTOTYPE_DIR = AppPaths.INSTANCE.getCHROME_DATA_DIR_PROTOTYPE();
    @NotNull
    private static final Lazy<PrivacyContextMetrics> globalMetrics$delegate = LazyKt.lazy((Function0)Companion.globalMetrics.2.INSTANCE);

    public PrivacyContext(@NotNull PrivacyContextId id, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.id = id;
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(PrivacyContext.class);
        this.sequence = instanceSequencer.incrementAndGet();
        this.minimumThroughput = this.conf.getFloat("privacy.context.min.throughput", 0.3f);
        this.maximumWarnings = this.conf.getInt("privacy.max.warnings", 8);
        this.minorWarningFactor = this.conf.getInt("privacy.minor.warning.factor", 5);
        this.privacyLeakWarnings = new AtomicInteger();
        this.privacyLeakMinorWarnings = new AtomicInteger();
        this.registry = AppMetrics.Companion.getDefaultMetricRegistry();
        this.sms = "._.";
        this.meterTasks = this.registry.meter(this, this.sequence + this.sms, "tasks");
        this.meterSuccesses = this.registry.meter(this, this.sequence + this.sms, "successes");
        this.meterFinishes = this.registry.meter(this, this.sequence + this.sms, "finishes");
        this.meterSmallPages = this.registry.meter(this, this.sequence + this.sms, "smallPages");
        this.lastActiveTime = this.startTime = Instant.now();
        this.idleTimeout = Duration.ofMinutes(20L);
        this.numRunningTasks = new AtomicInteger();
        boolean bl = false;
        this.historyUrl = new LinkedHashSet();
        this.closed = new AtomicBoolean();
        Companion.getGlobalMetrics().getContexts().mark();
    }

    @NotNull
    public final PrivacyContextId getId() {
        return this.id;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final int getSequence() {
        return this.sequence;
    }

    @NotNull
    public final String getDisplay() {
        return this.id.getDisplay();
    }

    public final float getMinimumThroughput() {
        return this.minimumThroughput;
    }

    public final int getMaximumWarnings() {
        return this.maximumWarnings;
    }

    public final int getMinorWarningFactor() {
        return this.minorWarningFactor;
    }

    @NotNull
    public final AtomicInteger getPrivacyLeakWarnings() {
        return this.privacyLeakWarnings;
    }

    @NotNull
    public final AtomicInteger getPrivacyLeakMinorWarnings() {
        return this.privacyLeakMinorWarnings;
    }

    @NotNull
    public final Meter getMeterTasks() {
        return this.meterTasks;
    }

    @NotNull
    public final Meter getMeterSuccesses() {
        return this.meterSuccesses;
    }

    @NotNull
    public final Meter getMeterFinishes() {
        return this.meterFinishes;
    }

    @NotNull
    public final Meter getMeterSmallPages() {
        return this.meterSmallPages;
    }

    public final double getSmallPageRate() {
        return 1.0 * (double)this.meterSmallPages.getCount() / (double)RangesKt.coerceAtLeast((long)this.meterTasks.getCount(), (long)1L);
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final boolean isIdle() {
        return Duration.between(this.lastActiveTime, Instant.now()).compareTo(this.idleTimeout) > 0;
    }

    @NotNull
    public final AtomicInteger getNumRunningTasks() {
        return this.numRunningTasks;
    }

    @NotNull
    public final Set<String> getHistoryUrl() {
        return this.historyUrl;
    }

    @NotNull
    public final AtomicBoolean getClosed() {
        return this.closed;
    }

    public final boolean isGood() {
        return this.meterSuccesses.getMeanRate() >= (double)this.minimumThroughput;
    }

    public final boolean isLeaked() {
        return this.privacyLeakWarnings.get() >= this.maximumWarnings;
    }

    public final boolean isActive() {
        return !this.isLeaked() && !this.closed.get();
    }

    public final void markSuccess() {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2 = this.privacyLeakWarnings;
        boolean bl = false;
        boolean bl2 = false;
        AtomicInteger it = atomicInteger2;
        boolean bl3 = false;
        AtomicInteger atomicInteger3 = atomicInteger = it.get() > 0 ? atomicInteger2 : null;
        if (atomicInteger != null) {
            atomicInteger.decrementAndGet();
        }
        this.meterSuccesses.mark();
        Companion.getGlobalMetrics().getSuccesses().mark();
    }

    public final void markWarning() {
        this.privacyLeakWarnings.incrementAndGet();
        Companion.getGlobalMetrics().getLeakWarnings().mark();
    }

    public final void markWarning(int n) {
        this.privacyLeakWarnings.addAndGet(n);
        Companion.getGlobalMetrics().getLeakWarnings().inc((long)n);
    }

    public final void markMinorWarning() {
        this.privacyLeakMinorWarnings.incrementAndGet();
        Companion.getGlobalMetrics().getMinorLeakWarnings().mark();
        if (this.privacyLeakMinorWarnings.get() > this.minorWarningFactor) {
            this.privacyLeakMinorWarnings.set(0);
            this.markWarning();
        }
    }

    public final int markLeaked() {
        return this.privacyLeakWarnings.addAndGet(this.maximumWarnings);
    }

    @Nullable
    public Object run(@NotNull FetchTask task, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> browseFun, @NotNull Continuation<? super FetchResult> $completion) throws ProxyException {
        return PrivacyContext.run$suspendImpl(this, task, browseFun, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object run$suspendImpl(PrivacyContext var0, FetchTask var1_1, Function3 var2_2, Continuation var3_3) throws ProxyException {
        if (!(var3_3 instanceof run.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super run.1>)var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PrivacyContext this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrivacyContext.run$suspendImpl(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.beforeRun((FetchTask)task);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.doRun((FetchTask)task, (Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object>)browseFun, (Continuation<? super FetchResult>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (PrivacyContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                result = (FetchResult)v0;
                this.afterRun(result);
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public abstract Object doRun(@NotNull FetchTask var1, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2, @NotNull Continuation<? super FetchResult> var3) throws ProxyException;

    protected final void beforeRun(@NotNull FetchTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.lastActiveTime = Instant.now();
        this.meterTasks.mark();
        Companion.getGlobalMetrics().getTasks().mark();
        this.numRunningTasks.incrementAndGet();
    }

    protected final void afterRun(@NotNull FetchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.numRunningTasks.decrementAndGet();
        this.historyUrl.add(result.getTask().getUrl());
        this.lastActiveTime = Instant.now();
        this.meterFinishes.mark();
        Companion.getGlobalMetrics().getFinishes().mark();
        ProtocolStatus status = result.getStatus();
        if (status.isRetry(RetryScope.PRIVACY, (Object)new ProxyRetiredException(""))) {
            this.markLeaked();
        } else if (status.isRetry(RetryScope.PRIVACY, (Object)HtmlIntegrity.FORBIDDEN)) {
            this.markLeaked();
        } else if (status.isRetry(RetryScope.PRIVACY, (Object)HtmlIntegrity.ROBOT_CHECK)) {
            this.markWarning();
        } else if (status.isRetry(RetryScope.PRIVACY, (Object)HtmlIntegrity.ROBOT_CHECK_2)) {
            this.markWarning(2);
        } else if (status.isRetry(RetryScope.PRIVACY, (Object)HtmlIntegrity.ROBOT_CHECK_3)) {
            this.markWarning(3);
        } else if (status.isRetry(RetryScope.PRIVACY)) {
            this.markWarning();
        } else if (status.isRetry(RetryScope.CRAWL)) {
            this.markMinorWarning();
        } else if (status.isSuccess()) {
            this.markSuccess();
        }
        if (result.isSmall()) {
            this.meterSmallPages.mark();
            Companion.getGlobalMetrics().getSmallPages().mark();
        }
        if (this.isLeaked()) {
            Companion.getGlobalMetrics().getContextLeaks().mark();
        }
    }

    public void report() {
        Integer n = this.sequence;
        Duration duration = this.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"elapsedTime");
        this.logger.info("Privacy context #{} has lived for {}", (Object)n, (Object)DateTimesKt.readable((Duration)duration));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContext$Companion;", "", "()V", "DEFAULT_DIR", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getDEFAULT_DIR", "()Ljava/nio/file/Path;", "IDENT_PREFIX", "", "getIDENT_PREFIX", "()Ljava/lang/String;", "PROTOTYPE_DIR", "getPROTOTYPE_DIR", "globalMetrics", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextMetrics;", "getGlobalMetrics", "()Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextMetrics;", "globalMetrics$delegate", "Lkotlin/Lazy;", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getIDENT_PREFIX() {
            return IDENT_PREFIX;
        }

        public final Path getDEFAULT_DIR() {
            return DEFAULT_DIR;
        }

        public final Path getPROTOTYPE_DIR() {
            return PROTOTYPE_DIR;
        }

        @NotNull
        public final PrivacyContextMetrics getGlobalMetrics() {
            Lazy lazy = globalMetrics$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (PrivacyContextMetrics)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

