/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.privacy;

import ai.platon.pulsar.common.browser.BrowserType;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u001bH\u0016J\t\u0010#\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006%"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "", "contextDir", "Ljava/nio/file/Path;", "browserType", "Lai/platon/pulsar/common/browser/BrowserType;", "(Ljava/nio/file/Path;Lai/platon/pulsar/common/browser/BrowserType;)V", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "(Ljava/nio/file/Path;Lai/platon/pulsar/common/browser/Fingerprint;)V", "getContextDir", "()Ljava/nio/file/Path;", "display", "", "getDisplay", "()Ljava/lang/String;", "getFingerprint", "()Lai/platon/pulsar/common/browser/Fingerprint;", "setFingerprint", "(Lai/platon/pulsar/common/browser/Fingerprint;)V", "ident", "getIdent", "isDefault", "", "()Z", "isPrototype", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "Companion", "pulsar-skeleton"})
public final class PrivacyContextId
implements Comparable<PrivacyContextId> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path contextDir;
    @NotNull
    private Fingerprint fingerprint;
    @NotNull
    private final String ident;
    @NotNull
    private final String display;
    @NotNull
    private static final PrivacyContextId DEFAULT;
    @NotNull
    private static final PrivacyContextId PROTOTYPE;

    public PrivacyContextId(@NotNull Path contextDir, @NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        this.contextDir = contextDir;
        this.fingerprint = fingerprint;
        this.ident = CollectionsKt.last((Iterable)this.contextDir).toString();
        this.display = StringsKt.substringAfter$default((String)this.ident, (String)PrivacyContext.Companion.getIDENT_PREFIX(), null, (int)2, null);
    }

    @NotNull
    public final Path getContextDir() {
        return this.contextDir;
    }

    @NotNull
    public final Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public final void setFingerprint(@NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"<set-?>");
        this.fingerprint = fingerprint;
    }

    @NotNull
    public final String getIdent() {
        return this.ident;
    }

    @NotNull
    public final String getDisplay() {
        return this.display;
    }

    public final boolean isDefault() {
        return Intrinsics.areEqual((Object)this, (Object)DEFAULT);
    }

    public final boolean isPrototype() {
        return Intrinsics.areEqual((Object)this, (Object)PROTOTYPE);
    }

    public PrivacyContextId(@NotNull Path contextDir, @NotNull BrowserType browserType) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)browserType, (String)"browserType");
        this(contextDir, new Fingerprint(browserType, null, null, null, null, 30, null));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PrivacyContextId && Intrinsics.areEqual((Object)((PrivacyContextId)other).contextDir, (Object)this.contextDir) && Intrinsics.areEqual((Object)((PrivacyContextId)other).fingerprint.getBrowserType().toString(), (Object)this.fingerprint.getBrowserType().toString());
    }

    public int hashCode() {
        return 31 * ((Object)this.contextDir).hashCode() + this.fingerprint.getBrowserType().toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull PrivacyContextId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int r = this.contextDir.compareTo(other.contextDir);
        if (r != 0) {
            return r;
        }
        return this.fingerprint.getBrowserType().toString().compareTo(other.fingerprint.getBrowserType().toString());
    }

    @NotNull
    public final Path component1() {
        return this.contextDir;
    }

    @NotNull
    public final Fingerprint component2() {
        return this.fingerprint;
    }

    @NotNull
    public final PrivacyContextId copy(@NotNull Path contextDir, @NotNull Fingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)contextDir, (String)"contextDir");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        return new PrivacyContextId(contextDir, fingerprint);
    }

    public static /* synthetic */ PrivacyContextId copy$default(PrivacyContextId privacyContextId, Path path, Fingerprint fingerprint, int n, Object object) {
        if ((n & 1) != 0) {
            path = privacyContextId.contextDir;
        }
        if ((n & 2) != 0) {
            fingerprint = privacyContextId.fingerprint;
        }
        return privacyContextId.copy(path, fingerprint);
    }

    @NotNull
    public String toString() {
        return "PrivacyContextId(contextDir=" + this.contextDir + ", fingerprint=" + this.fingerprint + ")";
    }

    static {
        Path path = PrivacyContext.Companion.getDEFAULT_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PrivacyContext.DEFAULT_DIR");
        DEFAULT = new PrivacyContextId(path, BrowserType.PULSAR_CHROME);
        path = PrivacyContext.Companion.getPROTOTYPE_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PrivacyContext.PROTOTYPE_DIR");
        PROTOTYPE = new PrivacyContextId(path, BrowserType.PULSAR_CHROME);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId$Companion;", "", "()V", "DEFAULT", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "getDEFAULT", "()Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "PROTOTYPE", "getPROTOTYPE", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivacyContextId getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final PrivacyContextId getPROTOTYPE() {
            return PROTOTYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

